#ifndef _TLSUTIL_H_
#define _TLSUTIL_H_

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

extern char	*tls_hostname;
extern int	tls_on_ctrl;
extern int 	tls_on_data;

int	tls_init(void);
void	tls_cleanup(void);
int	tls_recv(int s, void *buf, size_t len, int flags);
int	tls_send(int s, const void *msg, size_t len, int flags);
ssize_t	tls_read(int fd, void *buf, size_t count);
ssize_t	tls_write(int fd, const void *buf, size_t count);
int	tls_fgetc(FILE *stream);
int	tls_fputc(int c, FILE *stream);
int	tls_fputs(const char *s, FILE *stream);
int	tls_fflush(FILE *stream);
int	tls_fclose( FILE *stream);
int	tls_close(int fd);
#define tls_set_defaults() 1
int	tls_optarg(char *optarg);
char	*tls_get_cipher_info_string(int s);
int	tls_connect_ctrl(int in, int out);
int	tls_connect_data(int s);
int	tls_shutdown(int s, int how);
void	tls_free_ssls(void);
int	tls_vfprintf(FILE *stream, const char *format, va_list ap);
int	tls_active(int s);
#ifdef __STDC__
int	tls_fprintf(FILE *stream, const char *fmt, ...);
#else
int	tls_fprintf(stream, fmt, va_alist);
    FILE *stream;
    char *fmt;
    va_dcl
#endif /* !__STDC__ */

#endif /* !_TLSUTIL_H_ */
