@comment   GNU Mailutils -- a suite of utilities for electronic mail
@comment   Copyright (C) 1999, 2000, 2001, 2002, 2003,
@comment   2004 Free Software Foundation, Inc.
@comment
@comment   GNU Mailutils is free software; you can redistribute it and/or modify
@comment   it under the terms of the GNU General Public License as published by
@comment   the Free Software Foundation; either version 2, or (at your option)
@comment   any later version.
@comment
@comment   GNU Mailutils is distributed in the hope that it will be useful,
@comment   but WITHOUT ANY WARRANTY; without even the implied warranty of
@comment   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@comment   GNU General Public License for more details.
@comment
@comment   You should have received a copy of the GNU General Public License
@comment   along with GNU Mailutils; if not, write to the Free Software
@comment   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
@comment   MA 02110-1301 USA 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <mailutils/mailutils.h>

int
main (int argc, const char **argv)
@{
  char *from;
  char *subject;
  mailbox_t mbox;
  size_t msgno, total = 0;
  int status;

  /* Register the formats. */
  mu_register_all_mbox_formats ();

  status = mailbox_create_default (&mbox, argv[1]);
  if (status != 0)
    @{
      mu_error ("mailbox_create: %s", mu_strerror (status));
      exit (EXIT_FAILURE);
    @}

  status = mailbox_open (mbox, MU_STREAM_READ);
  if (status != 0)
    @{
      mu_error ("mailbox_open: %s", mu_strerror (status));
      exit (EXIT_FAILURE);
    @}

  mailbox_messages_count (mbox, &total);

  for (msgno = 1; msgno <= total; msgno++)
    @{
      message_t msg;
      header_t hdr;

      if ((status = mailbox_get_message (mbox, msgno, &msg)) != 0
          || (status = message_get_header (msg, &hdr)) != 0)
        @{
          mu_error ("Error message: %s", mu_strerror (status));
          exit (EXIT_FAILURE);
        @}

      if (header_aget_value (hdr, MU_HEADER_FROM, &from))
        from = strdup ("(NO FROM)");

      if (header_aget_value (hdr, MU_HEADER_SUBJECT, &subject))
        subject = strdup ("(NO SUBJECT)");

      printf ("%s\t%s\n", from, subject);
      free (from);
      free (subject);
    @}

  status = mailbox_close (mbox);
  if (status != 0)
    @{
      mu_error ("mailbox_close: %s", mu_strerror (status));
      exit (EXIT_FAILURE);
    @}

  mailbox_destroy (&mbox);
  return 0;
@}
