package lib;

# THIS FILE IS AUTOMATICALLY GENERATED FROM lib_pm.PL.
# ANY CHANGES TO THIS FILE WILL BE OVERWRITTEN BY THE NEXT PERL BUILD.

use Config;

use strict;

my $archname         = $Config{archname};
my $version          = $Config{version};
my @inc_version_list = reverse split / /, $Config{inc_version_list};

our @ORIG_INC = @INC;	# take a handy copy of 'original' value
our $VERSION = '0.5564';
my $Is_MacOS = $^O eq 'MacOS';
my $Mac_FS;
if ($Is_MacOS) {
	require File::Spec;
	$Mac_FS = eval { require Mac::FileSpec::Unixish };
}

sub import {
    shift;
    my @args = @_;
    my %names;
    foreach (reverse @args) {
	if ($_ eq '') {
	    require Carp;
	    Carp::carp("Empty compile time value given to use lib");
	}

	local $_ = _nativize($_);

	if (-e && ! -d _) {
	    require Carp;
	    Carp::carp("Parameter to use lib must be directory, not file");
	}
	unshift(@INC, $_);
	# Add any previous version directories we found at configure time
	foreach my $incver (@inc_version_list)
	{
	    my $dir = $Is_MacOS
		? File::Spec->catdir( $_, $incver )
		: "$_/$incver";
	    unshift(@INC, $dir) if -d $dir;
	}
	# Put a corresponding archlib directory in front of $_ if it
	# looks like $_ has an archlib directory below it.
	my($arch_auto_dir, $arch_dir, $version_dir, $version_arch_dir)
	    = _get_dirs($_);
	unshift(@INC, $arch_dir)         if -d $arch_auto_dir;
	unshift(@INC, $version_dir)      if -d $version_dir;
	unshift(@INC, $version_arch_dir) if -d $version_arch_dir;
    }

    # remove trailing duplicates
    @INC = grep { ++$names{$_} == 1 } @INC;
    return;
}

sub unimport {
    shift;
    my @args = @_;
    my %names;
    foreach (@args) {
	local $_ = _nativize($_);

	my($arch_auto_dir, $arch_dir, $version_dir, $version_arch_dir)
	    = _get_dirs($_);
	++$names{$_};
	++$names{$arch_dir}         if -d $arch_auto_dir;
	++$names{$version_dir}      if -d $version_dir;
	++$names{$version_arch_dir} if -d $version_arch_dir;
    }

    # Remove ALL instances of each named directory.
    @INC = grep { !exists $names{$_} } @INC;
    return;
}

sub _get_dirs {
    my($dir) = @_;
    my($arch_auto_dir, $arch_dir, $version_dir, $version_arch_dir);

    # we could use this for all platforms in the future, but leave it
    # Mac-only for now, until there is more time for testing it.
    if ($Is_MacOS) {
	$arch_auto_dir    = File::Spec->catdir( $_, $archname, 'auto' );
	$arch_dir         = File::Spec->catdir( $_, $archname, );
	$version_dir      = File::Spec->catdir( $_, $version );
	$version_arch_dir = File::Spec->catdir( $_, $version, $archname );
    } else {
	$arch_auto_dir    = "$_/$archname/auto";
	$arch_dir         = "$_/$archname";
	$version_dir      = "$_/$version";
	$version_arch_dir = "$_/$version/$archname";
    }
    return($arch_auto_dir, $arch_dir, $version_dir, $version_arch_dir);
}

sub _nativize {
    my($dir) = @_;

    if ($Is_MacOS && $Mac_FS && ! -d $dir) {
	$dir = Mac::FileSpec::Unixish::nativize($dir);
	$dir .= ":" unless $dir =~ /:$/;
    }

    return $dir;
}

1;
__END__

