/***************************************************************************
                           tableeditor.h  -  table editor dialog
    begin              : Thu 15 Apr 2004
    copyright          : (C) 2004 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; version 2 of the License.
 *
 ***************************************************************************/

#ifndef TABLEEDITOR_H
#define TABLEEDITOR_H

#include <kurl.h>
#include <tqvaluelist.h>

#include "tableeditors.h"
#include "document.h"

class TQSpinBox;
class TQTable;
class TDEPopupMenu;
class Tag;
struct DTDStruct;
class Node;

class TableNode 
{   
public:
  Node *node; 
  bool merged; 
  int mergedRow; 
  int mergedCol; 
  TableNode()    {node = 0;}
};



struct NestedTable { Node *node; int row; int col; int bLine; int bCol; int eLine; int eCol; TQString nestedData;};
class Parser;


class TableEditor : public TableEditorS
{
  TQ_OBJECT
  

public:
  TableEditor( TQWidget* parent = 0, const char* name = 0 );
  ~TableEditor();

  virtual bool setTableArea( int bLine, int bCol, int eLine, int eCol, Parser * docParser );
  virtual void setBaseURL( const KURL & url );
  virtual TQString readModifiedTable();
  virtual void createNewTable( Document * write, const DTDStruct * dtd );
  // Set defaults for table: enable word wrap, fit content, allow swapping col/rows with D&D
  virtual void configureTable( TQTable * table );
  virtual void setCellText( TQTable * table, int row, int col, const TQString & text );
  // Configure TableItem from tag attributes
  virtual void configureCell( int row, int col, Node * node );

public slots:
  virtual void slotContextMenuRequested( int row, int col, const TQPoint & pos );
  virtual void slotEditCell();
  // Wrapper for setText to use TableItem instead of TQTableItem
  virtual void slotEditCellText( int r, int );
  virtual void slotEditRow();
  virtual void slotEditCol();
  virtual void slotEditTable();
  virtual void slotEditTableBody();
  virtual void slotEditTableHeader();
  virtual void slotEditTableFooter();
  virtual void slotTabChanged( TQWidget * w );
  virtual void slotInsertRow();
  virtual void slotInsertCol();
  virtual void slotAddRemoveRow( int num );
  virtual void slotAddRemoveCol( int num );
  virtual void slotRemoveRow();
  virtual void slotRemoveCol();
  virtual void slotMergeCells();
  virtual void slotUnmergeCells();
  virtual void slotEditChildTable();
  virtual void slotHelpInvoked();

protected:
  TQValueList<Tag*> m_colTags;
  int m_unmergeCellsId;
  int m_mergeSeparatorId;
  int m_mergeCellsId;
  bool m_createNodes;
  TQValueList<TQValueList<TableNode> > *m_tableTags;
  TQValueList<TQValueList<TableNode> > *m_tableFooterTags;
  TQValueList<TQValueList<TableNode> > *m_tableHeaderTags;
  TQValueList<TableNode> *m_tableFooterRows;
  TQValueList<TableNode> *m_tableHeaderRows;
  TQValueList<TableNode> *m_tableRows;
  Document* m_write;
  Tag *m_table;
  Tag *m_tfoot;
  Tag *m_thead;
  int newVariable;
  Tag *m_tbody;
  int m_colEditId;
  int m_rowEditId;
  int m_cellEditId;
  int m_col;
  int m_row;
  TDEPopupMenu *m_popup;
  KURL m_baseURL;
  const DTDStruct *m_dtd;
  TQValueList<TQValueList<TableNode> > *m_tableDataTags;
  TQValueList<TableNode> *m_tableDataRows;
  TQTable *m_dataTable;
  TQSpinBox *m_rowSpin;
  TQSpinBox *m_colSpin;
  int m_bLine, m_bCol, m_eLine, m_eCol;
  TQValueList<NestedTable> m_nestedTables;
  int m_editChildId;

  virtual TQString indent( int n );
  virtual TQString cellValue( int row, int col );
  virtual TQString tableToString();
  virtual TQString tagContent( Node * node );
  virtual void deleteList( TQValueList<TableNode> * table );
  virtual void deleteMatrix( TQValueList<TQValueList<TableNode> > * matrix );

};

#endif 
