/***************************************************************************
                          instance.h  -  description
                             -------------------
    begin                : Tue Aug 13 2002
    copyright            : (C) 2002 by Marc Britton <consume@optushome.com.au>
                           (C) 2004 by Andras Mantia <amantia@kde.org>
                           (C) 2004 by Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INSTANCE_H
#define INSTANCE_H

/* QT INCLUDES */
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqobject.h>
#include <tqmap.h>
#include <tqguardedptr.h>

/* KDE INCLUDES */
#include <kurl.h>

/* OTHER INCLUDES */
#include "dcopkommanderif.h"

/* FORWARD DECLARATIONS */
class TQWidget;
class TQDialog;
class TQFile;
class KommanderWidget;



class Instance : public TQObject, virtual public DCOPKommanderIf
{
  TQ_OBJECT
  

public: 
  Instance();
  Instance(TQWidget*);
  ~Instance();
  /* passing global variables: two forms are accepted.
     tdmr-executor file.kmdr COUNT=45 PATH=/tmp     - this adds global variables 45 and PATH
     kmdr-executor file.kmdr 45 /tmp                - this adds global variables ARG1 and ARG2
     ARGS holds space-separated list of all second-type variables (like Bash $@)
     ARGCOUNT holds number of second-type arguments
  */
  virtual void addCmdlineArguments(const TQStringList& args);

  //DCOP methods. The documentation is in the widgets/specials.cpp file.
  virtual void setEnabled(const TQString& widgetName, bool enable);  
  virtual void enableWidget(const TQString& widgetName, bool enable);    /* DEPRECATED */
  virtual void setVisible(const TQString& widgetName, bool enable);  
  virtual void setText(const TQString& widgetName, const TQString& text); 
  virtual void changeWidgetText(const TQString& widgetName, const TQString& text); /* DEPRECATED */
  virtual TQString text(const TQString& widgetName);
  virtual void setSelection(const TQString& widgetName, const TQString& text);
  virtual void setCurrentListItem(const TQString& widgetName, const TQString& text); /* DEPRECATED */
  virtual TQString selection(const TQString& widgetName);
  virtual int currentItem(const TQString &widgetName);  
  virtual TQString item(const TQString &widgetName, int index);  
  virtual int itemDepth(const TQString &widgetName, int index);  
  virtual TQString itemPath(const TQString &widgetName, int index);  
  virtual void removeItem(const TQString &widgetName, int index);
  virtual void removeListItem(const TQString &widgetName, int index); /* DEPRECATED */
  virtual void insertItem(const TQString &widgetName, const TQString &item, int index);
  virtual void addListItem(const TQString &widgetName, const TQString &item, int index); /* DEPRECATED */
  virtual void setPixmap(const TQString &widgetName, const TQString &iconName, int index);
  virtual void insertItems(const TQString &widgetName, const TQStringList &items, int index);
  virtual void addListItems(const TQString &widgetName, const TQStringList &items, int index);/*DEPRECATED*/
  virtual void addUniqueItem(const TQString &widgetName, const TQString &item);
  virtual int findItem(const TQString &widgetName, const TQString &item);
  virtual void clear(const TQString &widgetName);
  virtual void clearList(const TQString &widgetName); /* DEPRECATED */
  virtual void setCurrentItem(const TQString &widgetName, int index);
  virtual void setCurrentTab(const TQString &widgetName, int index); /* DEPRECATED */
  virtual void insertTab(const TQString &widgetName, const TQString &label, int index);
  virtual void setChecked(const TQString &widgetName, bool checked);
  virtual bool checked(const TQString &widgetName);
  virtual void setAssociatedText(const TQString &widgetName, const TQString &text);
  virtual TQStringList associatedText(const TQString &widgetName);
  virtual TQString type(const TQString& widget);
  virtual TQStringList children(const TQString& parent, bool recursive);
  virtual TQString global(const TQString& variableName);
  virtual void setGlobal(const TQString& variableName, const TQString& value);
  virtual void setMaximum(const TQString &widgetName, int value);
  virtual TQString execute(const TQString &widgetName);
  virtual void cancel(const TQString &widgetName);
  virtual int count(const TQString &widgetName);
  virtual int currentColumn(const TQString &widgetName);
  virtual int currentRow(const TQString &widgetName);
  virtual void insertRow(const TQString &widgetName, int row, int count);
  virtual void insertColumn(const TQString &widgetName, int column, int count);
  virtual void setCellText(const TQString &widgetName, int row, int column, const TQString& text);
  virtual TQString cellText(const TQString &widgetName, int row, int column);
  virtual void removeRow(const TQString &widgetName, int row, int count);
  virtual void removeColumn(const TQString &widgetName, int column, int count);
  virtual void setRowCaption(const TQString &widgetName, int row, const TQString& text);
  virtual void setColumnCaption(const TQString &widgetName, int column, const TQString& text);
  virtual int getWinID();
  virtual void setBusyCursor(bool busy);
  TQWidget *widget() { return m_instance;}  

public slots:
  /** Sets the instance's parent */
  void setParent(TQWidget*);
  /** Returns whether the instance is built */
  bool isBuilt() const;
  /** Builds the instance. Uses stdin if no filename is given */
  bool build(const KURL& fname);
  /** Executes the instance which was built before */
  bool run();
private:
  /** Check if the file exists, has correct extension and is not in a temporary (insecure) directory */
  bool isFileValid(const KURL& fname) const;
  /* Dialog Instance */
  TQGuardedPtr<TQWidget> m_instance;
  /* Associated Text Instance */
  KommanderWidget *m_textInstance;
  /** The parent widget */
  TQWidget *m_parent;
  /* Get object by name */
  TQObject* stringToWidget(const TQString& name);
  /* Cast to Kommander widget if possible */
  KommanderWidget* kommanderWidget(TQObject* object);
};

#endif
