/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef WIDGETDATABASE_H
#define WIDGETDATABASE_H

#include <tqiconset.h>
#include <tqstring.h>
#ifndef KOMMANDER
#include "widgetinterface.h" // up here for GCC 2.7.* compatibility
#include <tqpluginmanager_p.h>


extern TQPluginManager<WidgetInterface> *widgetManager();
#endif

struct WidgetDatabaseRecord
{
    WidgetDatabaseRecord();
    ~WidgetDatabaseRecord();
    TQString iconName, name, group, toolTip, whatsThis, includeFile;
    uint isContainer : 1;
    uint isForm : 1;
    TQIconSet *iconSet;
    int nameCounter;
};

class WidgetDatabase : public TQt
{
public:
    WidgetDatabase();
    static void setupDataBase( int id );
    static void setupPlugins();

    static int count();
    static int startCustom();

    static TQIconSet iconSet( int id );
    static TQString className( int id );
    static TQString group( int id );
    static TQString toolTip( int id );
    static TQString whatsThis( int id );
    static TQString includeFile( int id );
    static bool isForm( int id );
    static bool isContainer( int id );

    static int idFromClassName( const TQString &name );
    static TQString createWidgetName( int id );

    static WidgetDatabaseRecord *at( int index );
    static void insert( int index, WidgetDatabaseRecord *r );
    static void append( WidgetDatabaseRecord *r );

    static TQString widgetGroup( const TQString &g );
    static TQString widgetGroup( int i );
    static int numWidgetGroups();
    static bool isGroupVisible( const TQString &g );
    static bool isGroupEmpty( const TQString &grp );

    static int addCustomWidget( WidgetDatabaseRecord *r );
    static bool isCustomWidget( int id );

    static bool isWhatsThisLoaded();
    static void loadWhatsThis( const TQString &docPath );

    static bool hasWidget( const TQString &name );

};

#endif
