/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "subversionintegrator.h"

#include <kdevgenericfactory.h>
#include <kdevplugininfo.h>

#include "svnintegratordlg.h"

static const KDevPluginInfo data("kdevsubversionintegrator");
typedef KDevGenericFactory<SubversionIntegrator> SubversionIntegratorFactory;
K_EXPORT_COMPONENT_FACTORY( libsubversionintegrator, SubversionIntegratorFactory(data) )

SubversionIntegrator::SubversionIntegrator(TQObject* parent, const char* name,
    const TQStringList // args
                                           )
    :KDevVCSIntegrator(parent, name)
{
}

SubversionIntegrator::~SubversionIntegrator()
{
}

VCSDialog* SubversionIntegrator::fetcher(TQWidget* // parent
                                         )
{
    return 0;
}

VCSDialog* SubversionIntegrator::integrator(TQWidget* parent)
{
    SvnIntegratorDlg *dlg = new SvnIntegratorDlg(parent);
    return dlg;
}

#include "subversionintegrator.moc"
