%{CPP_TEMPLATE}

#include "%{APPNAMELC}.h"
#include "settings.h"
#include "prefs.h"

#include <tqdragobject.h>
#include <kprinter.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>

#include <tdeconfigdialog.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeversion.h>
#include <tdemenubar.h>
#include <kstatusbar.h>
#include <kkeydialog.h>

#include <kedittoolbar.h>

#include <tdestdaccel.h>
#include <tdeaction.h>
#include <kstdaction.h>

%{APPNAMELC}::%{APPNAMELC}()
    : TDEMainWindow( 0, "%{APPNAMELC}" ),
      m_view(new %{APPNAMELC}View(this)),
      m_printer(0)
{
    // accept dnd
    setAcceptDrops(true);

    // tell the TDEMainWindow that this is indeed the main widget
    setCentralWidget(m_view);

    // then, setup our actions
    setupActions();

    // and a status bar
    statusBar()->show();

    // apply the saved mainwindow settings, if any, and ask the mainwindow
    // to automatically save settings if changed: window size, toolbar
    // position, icon size, etc.
    setAutoSaveSettings();

    // allow the view to change the statusbar and caption
    connect(m_view, TQ_SIGNAL(signalChangeStatusbar(const TQString&)),
            this,   TQ_SLOT(changeStatusbar(const TQString&)));
    connect(m_view, TQ_SIGNAL(signalChangeCaption(const TQString&)),
            this,   TQ_SLOT(changeCaption(const TQString&)));

}

%{APPNAMELC}::~%{APPNAMELC}()
{
}

void %{APPNAMELC}::setupActions()
{
    KStdAction::openNew(this, TQ_SLOT(fileNew()), actionCollection());
    KStdAction::quit(kapp, TQ_SLOT(quit()), actionCollection());

    m_toolbarAction = KStdAction::showToolbar(this, TQ_SLOT(optionsShowToolbar()), actionCollection());
    m_statusbarAction = KStdAction::showStatusbar(this, TQ_SLOT(optionsShowStatusbar()), actionCollection());

    KStdAction::keyBindings(this, TQ_SLOT(optionsConfigureKeys()), actionCollection());
    KStdAction::configureToolbars(this, TQ_SLOT(optionsConfigureToolbars()), actionCollection());
    KStdAction::preferences(this, TQ_SLOT(optionsPreferences()), actionCollection());

    // custom menu and menu item - the slot is in the class %{APPNAMELC}View
    TDEAction *custom = new TDEAction(i18n("Swi&tch Colors"), 0,
                                  m_view, TQ_SLOT(switchColors()),
                                  actionCollection(), "switch_action");

    createGUI();
}

void %{APPNAMELC}::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

    // create a new window
    (new %{APPNAMELC})->show();
}

void %{APPNAMELC}::optionsShowToolbar()
{
    // this is all very cut and paste code for showing/hiding the
    // toolbar
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void %{APPNAMELC}::optionsShowStatusbar()
{
    // show/hide the statusbar
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void %{APPNAMELC}::optionsConfigureKeys()
{
    KKeyDialog::configure(actionCollection());
}

void %{APPNAMELC}::optionsConfigureToolbars()
{
    // use the standard toolbar editor
    saveMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
}

void %{APPNAMELC}::newToolbarConfig()
{
    // this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
    // recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
    createGUI();

    applyMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
}

void %{APPNAMELC}::optionsPreferences()
{
	// The preference dialog is derived from prefs-base.ui which is subclassed into Prefs
	//
	// compare the names of the widgets in the .ui file 
	// to the names of the variables in the .kcfg file
        TDEConfigDialog *dialog = new TDEConfigDialog(this, "settings", Settings::self(), KDialogBase::Swallow);
        dialog->addPage(new Prefs(), i18n("General"), "package_settings");
        connect(dialog, TQ_SIGNAL(settingsChanged()), m_view, TQ_SLOT(settingsChanged()));
        dialog->show();
}

void %{APPNAMELC}::changeStatusbar(const TQString& text)
{
    // display the text on the statusbar
    statusBar()->message(text, 2000);
}

void %{APPNAMELC}::changeCaption(const TQString& text)
{
    // display the text on the caption
    setCaption(text);
}
#include "%{APPNAMELC}.moc"

