/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2002-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

#include "umlnamespace.h"
#include "tqregexp.h"

namespace Uml {

bool tagEq (const TQString& inTag, const TQString& inPattern) {
    TQString tag = inTag;
    TQString pattern = inPattern;
    tag.remove( TQRegExp("^\\w+:") );  // remove leading "UML:" or other
    int patSections = pattern.contains( '.' ) + 1;
    TQString tagEnd = tag.section( '.', -patSections );
    return (tagEnd.lower() == pattern.lower());
}

TQString Visibility::toString(Value value, bool mnemonic) {
    switch (value) {
    case Protected:
        return (mnemonic ? "#" : "protected");
        break;
    case Private:
        return (mnemonic ? "-" : "private");
        break;
    case Implementation:
        return (mnemonic ? "~" : "implementation");
        break;
    case Public:
    default:
        return (mnemonic ? "+" : "public");
        break;
    }
}

Visibility Visibility::fromString(const TQString& vis) {
    if (vis == "public" || vis == "+")
        return Visibility(Public);
    else if (vis == "protected" || vis == "#")
        return Visibility(Protected);
    else if (vis == "private" || vis == "-")
        return Visibility(Private);
    else if (vis == "~")
        return Visibility(Implementation);
    else if (vis == "signals")
        return Visibility(Protected);
    else if (vis == "class")
        return Visibility(Private);
    else
        return Visibility(Public);
}

Visibility::Visibility(): _v(Public) {
}

Visibility::Visibility(Value v): _v(v) {
}

TQString Visibility::toString(bool mnemonic) const {
    return toString(_v, mnemonic);
}

Visibility::operator Visibility::Value() const {
    return _v;
}

}  // end namespace Uml

