/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Jun 30 2003
 */

// own header
#include "javacodeclassfield.h"

// qt/kde includes
#include <tqregexp.h>
#include <kdebug.h>

// local includes
#include "javacodecomment.h"
#include "javacodegenerator.h"

#include "../attribute.h"
#include "../umlobject.h"
#include "../umlrole.h"
#include "../uml.h"

// #include "javacodeaccessormethod.h"
#include "javaclassifiercodedocument.h"

// Constructors/Destructors
//

JavaCodeClassField::JavaCodeClassField (ClassifierCodeDocument * parentDoc, UMLRole * role)
        : CodeClassField(parentDoc, role)
{

}

JavaCodeClassField::JavaCodeClassField (ClassifierCodeDocument * parentDoc, UMLAttribute * attrib)
        : CodeClassField(parentDoc, attrib)
{

}

JavaCodeClassField::~JavaCodeClassField ( ) { }

//
// Methods
//

// Other methods
//

TQString JavaCodeClassField::getFieldName() {
    if (parentIsAttribute())
    {
        UMLAttribute * at = (UMLAttribute*) getParentObject();
        return cleanName(at->getName());
    }
    else
    {
        UMLRole * role = (UMLRole*) getParentObject();
        TQString roleName = role->getName();
        if(fieldIsSingleValue()) {
            return roleName.replace(0, 1, roleName.left(1).lower());
        } else {
            return roleName.lower() + "Vector";
        }
    }
}


TQString JavaCodeClassField::getInitialValue() {

    if (parentIsAttribute())
    {
        UMLAttribute * at = dynamic_cast<UMLAttribute*>( getParentObject() );
        if (at) {
            return fixInitialStringDeclValue(at->getInitialValue(), getTypeName());
        } else {
            kError() << "JavaodeClassField::getInitialValue: parent object is not a UMLAttribute"
            << endl;
            return "";
        }
        return fixInitialStringDeclValue(at->getInitialValue(), getTypeName());
    }
    else
    {
        if(fieldIsSingleValue()) {
            // FIX : IF the multiplicity is "1" then we should init a new object here, if its 0 or 1,
            //       then we can just return 'empty' string (minor problem).
            return TQString("");
        } else {
            return " new "+JavaCodeGenerator::getListFieldClassName()+"( )";
        }
    }

}

TQString JavaCodeClassField::getTypeName ( )
{
    return JavaCodeGenerator::fixTypeName(CodeClassField::getTypeName());
}

#include "javacodeclassfield.moc"
