/*
    packagelvi.cpp  -  Custom TQListViewItem that holds a Package object
    
    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "packagelvi.h"

PackageLVI::PackageLVI( TQListView *parent , const Package &pkg, const TQString &component )
: TQListViewItem( parent, pkg.name(), pkg.description() )
{
    m_package = pkg;
    m_component = component;
}

PackageLVI::PackageLVI( TQListViewItem *parent , const Package &pkg, const TQString &component )
: TQListViewItem( parent, component )
{
    m_package = pkg;
    m_component = component;
}

PackageLVI::~PackageLVI()
{
}
