/* 
 *  Copyright (c) 2003 Christian Loose <christian.loose@hamburg.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef LOGPLAINVIEW_H
#define LOGPLAINVIEW_H

#include <ktextbrowser.h>

class TDEConfig;
class KFind;

namespace Cervisia
{
struct LogInfo;
}


class LogPlainView : public KTextBrowser
{   
    TQ_OBJECT
  

public:
    explicit LogPlainView(TQWidget* parent = 0, const char* name = 0);
    ~LogPlainView();

    void addRevision(const Cervisia::LogInfo& logInfo);

    void searchText(int options, const TQString& pattern);

signals:
    void revisionClicked(TQString rev, bool rmb);

public slots:
    void scrollToTop();
    void findNext();
    void searchHighlight(const TQString& text, int index, int length);

protected:                     
    virtual void setSource(const TQString& name);
    
private:
    KFind* m_find;
    int    m_findPos;
};

#endif
