/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PAGE_COLORS_H
#define PAGE_COLORS_H

#include "page_colorsbase.h"
#include "ksopts.h"

#include <tqlistbox.h>
#include <tqstringlist.h>
#include <tqdict.h>

class PageColors : public PageColorsBase
{
TQ_OBJECT
  

public:
	PageColors( TQWidget *parent = 0, const char *name = 0 );
	~PageColors();

    void saveConfig();
    void defaultConfig();
    void readConfig( const KSOColors * = ksopts );

protected slots:
    void changed();

public slots:
    virtual void theme_clicked(TQListBoxItem*);
    virtual void themeNewPB_clicked();
    virtual void themeAddPB_clicked();
    virtual void themeDelPB_clicked();
    virtual void theme_sel();

signals:
    void modified();

private:
    void coloursSetEnable();

private:
    int changing;
    TQDict<KSOColors> m_dcol;
};

#endif
