/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "page_autoconnect.h"


#include <tqregexp.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <knuminput.h>

#define NAME 0
#define PK   1
#define PASS 2
#define SSL  3

PageAutoConnect::PageAutoConnect( TQWidget *parent, const char *name ) : PageAutoConnectBase( parent, name)
{
    KLVAutoConnect->setSorting( 0 );
    //KLVAutoConnect->header()->hide();

    AddPB->setEnabled(false);
    DeletePB->setEnabled(false);
    PortKI->setValue(6667);
}

PageAutoConnect::~PageAutoConnect()
{
}

void PageAutoConnect::saveConfig()
{

    TDEConfig *conf = kapp->config();
    conf->setGroup("AutoConnect");

    TQStringList servers;

    for(TQListViewItem *it = KLVAutoConnect->firstChild();
        it != 0;
        it = it->nextSibling()){

	TQString server = it->text(NAME);

	if(it->text(PK).length() > 0)
	    server += ":" + it->text(1);
	if(it->text(SSL).length() > 0)
            server += " (SSL)";
	if(it->text(PASS).length() > 0)
	    server += TQString(" (pass: %1)").arg(it->text(PASS));

        servers << server;

        TQStringList channels;

        for(TQListViewItem *ch = it->firstChild();
            ch != 0;
	    ch = ch->nextSibling()){
	    TQString channel;

	    channel = ch->text(NAME);

	    if(ch->text(PK).length() > 0)
		channel += TQString(" (key: %1)").arg(ch->text(PK));

	    channels << channel;

        }

        channels.sort();
        conf->writeEntry(server, channels);

    }

    servers.sort();

    conf->writeEntry("Servers", servers);

}

void PageAutoConnect::readConfig()
{
    TDEConfig *conf = kapp->config();
    conf->setGroup("AutoConnect");
    TQStringList servers = conf->readListEntry("Servers");
    servers.sort();
    TQStringList::ConstIterator ser = servers.begin();
    for( ; ser != servers.end(); ser++){
        TQStringList channels = conf->readListEntry(*ser);
	TQString server = *ser;
	TQString port = "6667";
	TQString ssl = TQString();
	TQString pass = TQString();

	TQRegExp rx("(.+) \\(SSL\\)(.*)");
	if(rx.search(server) >= 0){
            server = rx.cap(1) + rx.cap(3);
            ssl = i18n("SSL");
	}
	rx.setPattern("(.+) \\(pass: (\\S+)\\)(.*)");
	if(rx.search(server) >= 0){
            server = rx.cap(1) + rx.cap(3);
            pass = rx.cap(2);
	}
	rx.setPattern("([^: ]+):(\\d+)");
	if(rx.search(server) >= 0){
            kdDebug(5008) << server << ": Has port:" << rx.cap(2)  << endl;
            server = rx.cap(1);
            port = rx.cap(2);
	}
	kdDebug(5008) << server << ": Done " << port << " " << ssl << " " << pass << endl;
        TQListViewItem *s = new TQListViewItem(KLVAutoConnect, server, port, pass, ssl);
        s->setOpen(true);
        channels.sort();
        TQStringList::ConstIterator chan = channels.begin();
	for(; chan != channels.end(); chan++){
            TQString channel = *chan;
            TQString key = TQString();
            TQRegExp crx("(.+) \\(key: (\\S+)\\)");
            if(crx.search(channel) >= 0){
		channel = crx.cap(1);
		key = crx.cap(2);
            }
            new TQListViewItem(s, channel, key);
        }
    }
}

void PageAutoConnect::defaultConfig()
{
    KLVAutoConnect->clear();
    readConfig( );
}

void PageAutoConnect::changed()
{
    emit modified();
}

void PageAutoConnect::add_pressed()
{
    int fnd = 0;
    TQListViewItem *s = 0;

    s = KLVAutoConnect->selectedItem();
    if(!s){ /* new item */
	TQString server = ServerLE->text();
	TQString ssl = TQString();
	TQString port;

	port.setNum(PortKI->value());
	if(sslCB->isChecked())
	    ssl = i18n("SSL");

	s = new TQListViewItem(KLVAutoConnect, server, port, PassLE->text(), ssl);
	s->setOpen(true);
	s = new TQListViewItem(s, ChannelLE->text(), KeyLE->text());
        KLVAutoConnect->setCurrentItem(s);
    }
    else { /* update the existing one */
	TQListViewItem *parent;
	TQListViewItem *child;

	if(s->parent()){
	    parent = s->parent();
            child = s;
	}
	else {
	    parent = s;
            child = 0x0;
	}

	parent->setText(NAME, ServerLE->text());
	parent->setText(PK, TQString("%1").arg(PortKI->value()));
	parent->setText(PASS, PassLE->text());
	if(sslCB->isChecked())
	    parent->setText(SSL, i18n("SSL"));
	else
	    parent->setText(SSL, TQString());

	if(child){
	    child->setText(NAME, ChannelLE->text());
	    child->setText(PK, KeyLE->text());
	}
	else {
	    if(ChannelLE->text().length() > 0){
                fnd = 0;
		TQListViewItem *c = parent->firstChild();
		for( ; c != 0 && fnd == 0; c = c->nextSibling()){
		    if(c->text(NAME) == ChannelLE->text()){
			c->setText(PK, KeyLE->text());
			fnd = 1;
		    }
		}
		if(fnd == 0){
		    new TQListViewItem(parent, ChannelLE->text(), KeyLE->text());
		}
	    }
	}

    }
    changed();
}

void PageAutoConnect::new_pressed()
{
    AddPB->setText(i18n("&Add"));
    ServerLE->clear();
    ChannelLE->clear();
    sslCB->setChecked(false);
    PassLE->clear();
    KeyLE->clear();
    KLVAutoConnect->clearSelection();
    PortKI->setValue(6667) ;
}

void PageAutoConnect::delete_pressed()
{
    for(TQListViewItem *it = KLVAutoConnect->firstChild();
        it != 0;
        it = it->nextSibling()){

        if(it->text(NAME) == ServerLE->text()){
            if(!ChannelLE->text().isEmpty()){
                for(TQListViewItem *ch = it->firstChild();
                    ch != 0;
                    ch = ch->nextSibling()){
                    if(ch->text(NAME) == ChannelLE->text()){
                        delete ch;
                        changed();
                        ChannelLE->clear();
                        ServerLE->clear();
                        return;
                    }
                }
            }
            else {
                delete it;
                changed();
                ServerLE->clear();
                return;
            }
        }
    }
    changed();
}

void PageAutoConnect::kvl_clicked(TQListViewItem *it)
{
    if(it != 0){
	if(it->parent() != 0){
	    ChannelLE->setText(it->text(NAME));
	    KeyLE->setText(it->text(PK));
	    AddPB->setText(i18n("&Update"));
	    /*
	     * Move it to the parent to setup parent/server
	     * values.  This save writing this code
	     * in two places.
	     */
	    it = it->parent();
	}
	else {
	    AddPB->setText(i18n("&Update/Add"));
	    ChannelLE->clear();
	    KeyLE->clear();
	}

	if(it->parent() == 0){
	    ServerLE->setText(it->text(NAME));
	    PortKI->setValue(it->text(PK).toInt());
            PassLE->setText(it->text(PASS));
	    if(it->text(SSL).length() > 0)
		sslCB->setChecked(true);
	    else
		sslCB->setChecked(false);
	}
	/*
	 * Make sure to do this after changing all the fields
         */
	AddPB->setEnabled(false);
        DeletePB->setEnabled(true);


    }
    else {
	AddPB->setEnabled(false);
	DeletePB->setEnabled(false);
    }
    changed();
}

void PageAutoConnect::item_changed() {
    AddPB->setEnabled(true);
}

#include "page_autoconnect.moc"

