// This file is part of Kig, a KDE program for Interactive Geometry...
// Copyright (C)  2002  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#ifndef KIG_FILTERS_KGEO_FILTER_H
#define KIG_FILTERS_KGEO_FILTER_H

#include "filter.h"

class KSimpleConfig;

/**
 * This is an import filter for files generated by the program KGeo,
 * which was an interactive geometry program in tdeedu.  Kig is
 * supposed to be its successor, and this import filter is part of my
 * attempt to achieve that :)
 *
 * Status: a significant part of KGeo's format is supported, not all
 * yet, though..
 */
class KigFilterKGeo
  : public KigFilter
{
public:
  static KigFilterKGeo* instance();
  bool supportMime ( const TQString& mime );
  KigDocument* load ( const TQString& from );
protected:
  KigFilterKGeo();
  ~KigFilterKGeo();

  void loadMetrics ( KSimpleConfig* );
  KigDocument* loadObjects ( const TQString& file, KSimpleConfig* );

  int xMax;
  int yMax;
  bool grid;
  bool axes;
};

#endif
