//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQCloseEvent;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQWidget;

/**

 This class does all initialization stuff for progress,
 like connecting signals to slots.
 All slots are implemented as pure methods.
 All custom IO progress dialog should inherit this class.
 Add your GUI code to the constructor and implemement those virtual
 methods which you need in order to display progress.
 E.g. StatusbarProgress only implements slotTotalSize(),
 slotPercent() and slotSpeed().
 Custom progress dialog will be used like this :
 <pre>
 // create job
 CopyJob job = TDEIO.copy(...);
 // create a dialog
 MyCustomProgress customProgress;
 customProgress = new MyCustomProgress();
 // connect progress with job
 customProgress.setJob( job );
 ...
 </pre>
 There is a special method setStopOnClose() that controls the behavior of
 the dialog.
 See {@link ProgressBaseSignals} for signals emitted by ProgressBase
		@author Matej Koss <koss@miesto.sk>

		@short Base class for IO progress dialogs.

*/
public class ProgressBase extends TQWidget  {
	protected ProgressBase(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Creates a new progress dialog.
			@param parent the parent of this dialog window, or 0
		   		@short    Creates a new progress dialog.
	*/
	public ProgressBase(TQWidget parent) {
		super((Class) null);
		newProgressBase(parent);
	}
	private native void newProgressBase(TQWidget parent);
	/**
		 Assign a TDEIO.Job to this progress dialog.
			@param job the job to assign
		   		@short    Assign a TDEIO.Job to this progress dialog.
	*/
	public native void setJob(Job job);
	/**
		 Assign a TDEIO.Job to this progress dialog.
			@param job the job to assign
		   		@short    Assign a TDEIO.Job to this progress dialog.
	*/
	public native void setJob(CopyJob job);
	/**
		 Assign a TDEIO.Job to this progress dialog.
			@param job the job to assign
		   		@short    Assign a TDEIO.Job to this progress dialog.
	*/
	public native void setJob(DeleteJob job);
	public native void setStopOnClose(boolean stopOnClose);
	public native boolean stopOnClose();
	/**
		 This controls whether the dialog should be deleted or only cleaned when
		 the TDEIO.Job is finished (or canceled).
			 If your dialog is an embedded widget and not a separate window, you should
		 setOnlyClean(true) in the constructor of your custom dialog.
			@param onlyClean If true the dialog will only call method slotClean.
		 If false the dialog will be deleted.
				@short    This controls whether the dialog should be deleted or only cleaned when  the TDEIO.Job is finished (or canceled).
		@see #onlyClean
	*/
	public native void setOnlyClean(boolean onlyClean);
	/**
		 Checks whether the dialog should be deleted or cleaned.
				@return true if the dialog only calls slotClean, false if it will be
         deleted

		@short    Checks whether the dialog should be deleted or cleaned.
		@see #setOnlyClean
	*/
	public native boolean onlyClean();
	/**
		 Call when the operation finished.
				@short    Call when the operation finished.
	*/
	public native void finished();
	/**
		 This method should be called for correct cancellation of IO operation
		 Connect this to the progress widgets buttons etc.
		   		@short    This method should be called for correct cancellation of IO operation  Connect this to the progress widgets buttons etc.
	*/
	public native void slotStop();
	/**
		 This method is called when the widget should be cleaned (after job is finished).
		 redefine this for custom behavior.
		   		@short    This method is called when the widget should be cleaned (after job is finished).
	*/
	public native void slotClean();
	/**
		 Called to set the total size.
			@param job the TDEIO.Job
			@param size the total size in bytes
		   		@short    Called to set the total size.
	*/
	public native void slotTotalSize(Job job, long size);
	/**
		 Called to set the total number of files.
			@param job the TDEIO.Job
			@param files the number of files
		   		@short    Called to set the total number of files.
	*/
	public native void slotTotalFiles(Job job, long files);
	/**
		 Called to set the total number of directories.
			@param job the TDEIO.Job
			@param dirs the number of directories
		   		@short    Called to set the total number of directories.
	*/
	public native void slotTotalDirs(Job job, long dirs);
	/**
		 Called to set the processed size.
			@param job the TDEIO.Job
			@param bytes the processed size in bytes
		   		@short    Called to set the processed size.
	*/
	public native void slotProcessedSize(Job job, long bytes);
	/**
		 Called to set the number of processed files.
			@param job the TDEIO.Job
			@param files the number of files
		   		@short    Called to set the number of processed files.
	*/
	public native void slotProcessedFiles(Job job, long files);
	/**
		 Called to set the number of processed directories.
			@param job the TDEIO.Job
			@param dirs the number of directories
		   		@short    Called to set the number of processed directories.
	*/
	public native void slotProcessedDirs(Job job, long dirs);
	/**
		 Called to set the speed.
			@param job the TDEIO.Job
			@param speed the speed in bytes/second
		   		@short    Called to set the speed.
	*/
	public native void slotSpeed(Job job, long speed);
	/**
		 Called to set the percentage.
			@param job the TDEIO.Job
			@param percent the percentage
		   		@short    Called to set the percentage.
	*/
	public native void slotPercent(Job job, long percent);
	/**
		 Called when the job is copying.
			@param job the TDEIO.Job
			@param src the source of the operation
			@param dest the destination of the operation
		   		@short    Called when the job is copying.
	*/
	public native void slotCopying(Job job, KURL src, KURL dest);
	/**
		 Called when the job is moving.
			@param job the TDEIO.Job
			@param src the source of the operation
			@param dest the destination of the operation
		   		@short    Called when the job is moving.
	*/
	public native void slotMoving(Job job, KURL src, KURL dest);
	/**
		 Called when the job is deleting.
			@param job the TDEIO.Job
			@param url the URL to delete
		   		@short    Called when the job is deleting.
	*/
	public native void slotDeleting(Job job, KURL url);
	/**
		 Called when the job is creating a directory.
			@param job the TDEIO.Job
			@param dir the URL of the directory to create
		   		@short    Called when the job is creating a directory.
	*/
	public native void slotCreatingDir(Job job, KURL dir);
	/**
		 Called when the job is resuming..
			@param job the TDEIO.Job
			@param from the position to resume from in bytes
		   		@short    Called when the job is resuming.
	*/
	public native void slotCanResume(Job job, long from);
	protected native void closeEvent(TQCloseEvent arg1);
	protected native void slotFinished(Job arg1);
}
