require 'Qt'

class LCDRange < TQt::VBox
    signals 'valueChanged(int)'
    slots 'setValue(int)', 'setRange(int, int)', 'setText(const char *)'

    def initialize(s, parent, name)
        super(parent, name)
        init()
        setText(s)
    end
    
    def init()
        lcd = TQt::LCDNumber.new(2, self, 'lcd')
        @slider = TQt::Slider.new(TQt::VBox::Horizontal, self, 'slider')
        @slider.setRange(0, 99)
        @slider.setValue(0)
        @label = TQt::Label.new( ' ', self, 'label'  )
        @label.setAlignment( TQt::AlignCenter )    
        connect(@slider, TQ_SIGNAL('valueChanged(int)'), lcd, TQ_SLOT('display(int)'))
        connect(@slider, TQ_SIGNAL('valueChanged(int)'), TQ_SIGNAL('valueChanged(int)'))
        setFocusProxy(@slider)
    end

    def value()
        @slider.value()
    end

    def setValue( value )
        @slider.setValue( value )
    end
    
    def setRange( minVal, maxVal )
		if minVal < 0 || maxVal > 99 || minVal > maxVal
      		tqWarning( "LCDRange::setRange(#{minVal},#{maxVal})\n" +
               		"\tRange must be 0..99\n" +
               		"\tand minVal must not be greater than maxVal" )
			return
		end
        @slider.setRange( minVal, maxVal )
    end
    
    def setText( s )
        @label.setText( s )
    end

end
