import org.trinitydesktop.qt.*;

public class CannonField extends TQWidget {
	private int ang;
	
	public CannonField(TQWidget parent, String name) {
		super(parent, name);
		ang = 45;
		setPalette(new TQPalette(new TQColor(250, 250, 200)));
	}

	public int angle() {
		return ang;
	}

	public void setAngle(int degrees) {
		if (degrees < 5)
			degrees = 5;
		if (degrees > 70)
			degrees = 70;
		if (ang == degrees)
			return;
		ang = degrees;
		repaint();
		emit("angleChanged", ang);
	}

	public void paintEvent(TQPaintEvent e) {
		String s = "Angle = " + ang;
		TQPainter p = new TQPainter(this);
		p.drawText(200, 200, s);
	}

	public TQSizePolicy sizePolicy() {
		return new TQSizePolicy(TQSizePolicy.Expanding, TQSizePolicy.Expanding);
	}
}
