/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;



class ListBoxDemo extends TQWidget
{

private    TQListBox  l;
private    TQSpinBox  columns;
private    TQSpinBox  rows;
private    TQButtonGroup  bg;


ListBoxDemo()
{
    super( null, null );
    TQGridLayout  g = new TQGridLayout( this, 2, 2, 6 );

    g.addWidget( new TQLabel( "<b>Configuration:</b>", this ), 0, 0 );
    g.addWidget( new TQLabel( "<b>Result:</b>", this ), 0, 1 );

    l = new TQListBox( this );
    g.addWidget( l, 1, 1 );
    l.setFocusPolicy( TQWidget.StrongFocus );

    TQVBoxLayout  v = new TQVBoxLayout();
    g.addLayout( v, 1, 0 );

    TQRadioButton  b = null;
    bg = new TQButtonGroup( (TQWidget) null );

    b = new TQRadioButton( "Fixed number of columns,\n"
                          + "as many rows as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    b.setChecked( true );
    connect( b, TQ_SIGNAL("clicked()"), this, TQ_SLOT("setNumCols()") );
    TQHBoxLayout  h = new TQHBoxLayout();
    v.addLayout( h );
    h.addSpacing( 30 );
    h.addSpacing( 100 );
    h.addWidget( new TQLabel( "Columns:", this ) );
    columns = new TQSpinBox( this );
    h.addWidget( columns );

    v.addSpacing( 12 );

    b = new TQRadioButton( "As many columns as fit on-screen,\n"
                          + "as many rows as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    connect( b, TQ_SIGNAL("clicked()"), this, TQ_SLOT("setColsByWidth()") );

    v.addSpacing( 12 );

    b = new TQRadioButton( "Fixed number of rows,\n"
                          + "as many columns as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    connect( b, TQ_SIGNAL("clicked()"), this, TQ_SLOT("setNumRows()") );
    h = new TQHBoxLayout();
    v.addLayout( h );
    h.addSpacing( 30 );
    h.addSpacing( 100 );
    h.addWidget( new TQLabel( "Rows:", this ) );
    rows = new TQSpinBox( this );
    rows.setEnabled( false );
    h.addWidget( rows );

    v.addSpacing( 12 );

    b = new TQRadioButton( "As many rows as fit on-screen,\n"
                          + "as many columns as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    connect( b, TQ_SIGNAL("clicked()"), this, TQ_SLOT("setRowsByHeight()") );

    v.addSpacing( 12 );

    TQCheckBox  cb = new TQCheckBox( "Variable-height rows", this );
    cb.setChecked( true );
    connect( cb, TQ_SIGNAL("toggled(boolean)"), this, TQ_SLOT("setVariableHeight(boolean)") );
    v.addWidget( cb );
    v.addSpacing( 6 );

    cb = new TQCheckBox( "Variable-width columns", this );
    connect( cb, TQ_SIGNAL("toggled(boolean)"), this, TQ_SLOT("setVariableWidth(boolean)") );
    v.addWidget( cb );

    cb = new TQCheckBox( "Extended-Selection", this );
    connect( cb, TQ_SIGNAL("toggled(boolean)"), this, TQ_SLOT("setMultiSelection(boolean)") );
    v.addWidget( cb );

    TQPushButton pb = new TQPushButton( "Sort ascending", this );
    connect( pb, TQ_SIGNAL(" clicked()"), this, TQ_SLOT(" sortAscending()") );
    v.addWidget( pb );

    pb = new TQPushButton( "Sort descending", this );
    connect( pb, TQ_SIGNAL(" clicked()"), this, TQ_SLOT(" sortDescending()") );
    v.addWidget( pb );

    v.addStretch( 100 );

    int i = 0;
    while( ++i <= 2560 )
        l.insertItem( "Item " + i,
                       i );
    columns.setRange( 1, 256 );
    columns.setValue( 1 );
    rows.setRange( 1, 256 );
    rows.setValue( 256 );

    connect( columns, TQ_SIGNAL("valueChanged(int)"), this, TQ_SLOT("setNumCols()") );
    connect( rows, TQ_SIGNAL("valueChanged(int)"), this, TQ_SLOT("setNumRows()") );
}


void setNumRows()
{
    columns.setEnabled( false );
    rows.setEnabled( true );
    l.setRowMode( rows.value() );
}


void setNumCols()
{
    columns.setEnabled( true );
    rows.setEnabled( false );
    l.setColumnMode( columns.value() );
}


void setRowsByHeight()
{
    columns.setEnabled( false );
    rows.setEnabled( false );
    l.setRowMode( TQListBox.FitToHeight );
}


void setColsByWidth()
{
    columns.setEnabled( false );
    rows.setEnabled( false );
    l.setColumnMode( TQListBox.FitToWidth );
}


void setVariableWidth( boolean b )
{
    l.setVariableWidth( b );
}


void setVariableHeight( boolean b )
{
    l.setVariableHeight( b );
}

void setMultiSelection( boolean b )
{
    l.clearSelection();
    l.setSelectionMode( b ? TQListBox.Extended : TQListBox.Single );
}

void sortAscending()
{
    l.sort( true );
}

void sortDescending()
{
    l.sort( false );
}
}
