/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/
// KSysV Config Object

#include <tdeapplication.h>
#include <tdeglobal.h>
#include <tdeglobalsettings.h>
#include <tdemainwindow.h>
#include <tdeconfig.h>

#include "ksv_core.h"
#include "ksv_conf.h"

KSVConfig::KSVConfig ()
  : mConfig (TDEGlobal::config())
{
  readSettings();
}

void KSVConfig::setPanningFactor (int val)
{
  mPanningFactor = val > 100 ? 100 : val;
  mPanningFactor = mPanningFactor < 0 ? 0 : mPanningFactor;
}

void KSVConfig::readSettings()
{
  mConfig->setGroup("Path Settings"); 
  mScriptPath = mConfig->readEntry("ScriptPath", "/etc/rc.d/init.d");
  mRunlevelPath = mConfig->readEntry("RunlevelPath", "/etc/rc.d");

  mConfig->setGroup("Other Settings");
  mShowLog = mConfig->readBoolEntry("ShowLog", true);
  mConfigured = mConfig->readBoolEntry("Configured", false);
  mPanningFactor = mConfig->readNumEntry("PanningFactor", 80);
  mShowDescription = mConfig->readBoolEntry("ShowDescription", true);

  mConfig->setGroup("Colors");
  mNewNormalColor = mConfig->readColorEntry ("New Text", &TQt::blue);
  mNewSelectedColor = mConfig->readColorEntry ("New Selected Text", &TQt::blue);
  mChangedNormalColor = mConfig->readColorEntry ("Changed Text", &TQt::red);
  mChangedSelectedColor = mConfig->readColorEntry ("Changed Selected Text", &TQt::red); 

  mConfig->setGroup("Fonts");
  TQFont tmp = TDEGlobalSettings::generalFont();
  mServiceFont = mConfig->readFontEntry ("Service Font", &tmp);
  tmp = TDEGlobalSettings::fixedFont();
  mNumberFont = mConfig->readFontEntry ("Number Font", &tmp);

  readRunlevels();
}

void KSVConfig::readLegacySettings ()
{
  mConfig->setGroup("Path Settings");
  
  mScriptPath = mConfig->readEntry("ScriptPath", "/etc/rc.d/init.d");
  mRunlevelPath = mConfig->readEntry("RunlevelPath", "/etc/rc.d");

  mConfig->setGroup("Other Settings");

  mShowLog = mConfig->readBoolEntry("ShowLog", true);
  mConfigured = mConfig->readBoolEntry("Configured", false);
  mPanningFactor = mConfig->readNumEntry("PanningFactor", 80);
  mShowDescription = mConfig->readBoolEntry("ShowDescription", true);
  mConfig->setGroup("Colors");
  mNewNormalColor = mConfig->readColorEntry("New", &TQt::blue);
  mChangedNormalColor = mConfig->readColorEntry("Changed", &TQt::red);
}

void KSVConfig::writeSettings() {
  mConfig->setGroup("Path Settings");	
  mConfig->writeEntry("ScriptPath", mScriptPath);
  mConfig->writeEntry("RunlevelPath", mRunlevelPath);

  mConfig->setGroup("Other Settings");
  mConfig->writeEntry("ShowLog", mShowLog);
  mConfig->writeEntry("Configured", mConfigured);
  mConfig->writeEntry("PanningFactor", mPanningFactor);
  mConfig->writeEntry("ShowDescription", mShowDescription);

  mConfig->setGroup("Colors");
  mConfig->writeEntry("New Text", mNewNormalColor);
  mConfig->writeEntry("New Selected Text", mNewSelectedColor);
  mConfig->writeEntry("Changed Text", mChangedNormalColor);
  mConfig->writeEntry("Changed Selected Text", mChangedSelectedColor);

  mConfig->setGroup("Fonts");
  mConfig->writeEntry("Service Font", mServiceFont);
  mConfig->writeEntry("Number Font", mNumberFont);

  // save screen geometry
  TDEMainWindow* mw = static_cast<TDEMainWindow*>(kapp->mainWidget());

  if (mw)
    {
      mConfig->setGroup("Geometry");
      mConfig->writeEntry("X-Position", mw->x());
      mConfig->writeEntry("Y-Position", mw->y());
    }
  
  writeRunlevels();
  
  // flush everything
  mConfig->sync();
}

bool KSVConfig::showRunlevel (int index) const 
{
  if (mShowRunlevel.contains (index))
	return mShowRunlevel[index];
  else
	return false;
}

void KSVConfig::readRunlevels ()
{
  mConfig->setGroup ("Runlevels");
  
  TQValueList<int> list = mConfig->readIntListEntry ("Show Runlevels");

  for (TQValueList<int>::Iterator it = list.begin(); it != list.end(); ++it)
	mShowRunlevel[*it] = true;

  if (mShowRunlevel.isEmpty())
	for (int i = 0; i < ksv::runlevelNumber; ++i)
	  mShowRunlevel[i] = true;
}

void KSVConfig::writeRunlevels ()
{
  TQValueList<int> list;

  for (TQMap<int,bool>::Iterator it = mShowRunlevel.begin(); it != mShowRunlevel.end(); ++it)
	if (it.data())
	  list.append (it.key());
  
  mConfig->setGroup ("Runlevels");
  mConfig->writeEntry ("Show Runlevels", list);
}

void KSVConfig::setShowRunlevel (int index, bool state)
{
  mShowRunlevel[index] = state;
}

TQPoint KSVConfig::position() const
{
  mConfig->setGroup("Geometry");
  
  return TQPoint(mConfig->readNumEntry("X-Position", 0),
				mConfig->readNumEntry("Y-Position", 0));
}

void KSVConfig::setScriptPath (const TQString& path)
{
  mScriptPath = path;
}

void KSVConfig::setRunlevelPath (const TQString& path)
{
  mRunlevelPath = path;
}

KSVConfig* KSVConfig::self()
{
  static KSVConfig conf;
  
  return &conf;
}

void KSVConfig::setNewNormalColor (const TQColor& col)
{
  mNewNormalColor = col;
}

void KSVConfig::setNewSelectedColor (const TQColor& col)
{
  mNewSelectedColor = col;
}

void KSVConfig::setChangedNormalColor (const TQColor& col)
{
  mChangedNormalColor = col;
}

void KSVConfig::setChangedSelectedColor (const TQColor& col)
{
  mChangedSelectedColor = col;
}

void KSVConfig::setNumberFont (const TQFont& font)
{
  mNumberFont = font;
}

void KSVConfig::setServiceFont (const TQFont& font)
{
  mServiceFont = font;
}

void KSVConfig::setShowMessage (ksv::Messages msg, bool on)
{
  mConfig->setGroup("Notification Messages");
  mConfig->writeEntry (ksv::notifications[msg], on);
}

bool KSVConfig::showMessage (ksv::Messages msg) const
{
  mConfig->setGroup("Notification Messages");
  return mConfig->readBoolEntry (ksv::notifications[msg], true);
}

