/***************************************************************************
                          ksv::IO.h  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_IOCORE_H
#define KSV_IOCORE_H

#include <tqdir.h>
#include <tqstring.h>

#include <ktrader.h>
#include <kservice.h>

template<class T> class TQValueList;
class TQFileInfo;
class TQDataStream;

class KSVDragList;
class KSVData;

namespace ksv
{
  namespace IO
  {
    void removeFile (const TQFileInfo& info, TQDir& dir,
                     TQString& rich, TQString& plain);

    TQString relToAbs (const TQString& dir, const TQString& rel);

    void makeSymlink (const KSVData& data, int runlevel, bool start,
                      TQString& rich, TQString& plain);

    void dissectFilename (const TQString& file, TQString& name, int& nr);

    TQString makeRelativePath (const TQString& from, const TQString& to);

    bool saveConfiguration (TQDataStream&,
                            KSVDragList** start,
                            KSVDragList** stop);

    bool loadSavedConfiguration (TQDataStream&,
                                 TQValueList<KSVData>* start,
                                 TQValueList<KSVData>* stop);

    TDETrader::OfferList servicesForFile (const TQString& filename);
    KService::Ptr preferredServiceForFile (const TQString& filename);

  } // namespace IO
} // namespace ksv

#endif

