/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#ifndef RPM_IFACE_H
#define RPM_IFACE_H

#include "../config.h"


#include <tqptrlist.h>

#include "packageInfo.h"
#include "pkgInterface.h"

class KDir;
class cacheObj;

class RPM : public pkgInterface
{
 TQ_OBJECT
  

public:
  RPM();
  ~RPM();

  bool isType(char *buf, const TQString &fname);

  packageInfo *getPackageInfo(char mode, const TQString &name, const TQString &version);
  TQStringList getFileList(packageInfo *p);
  TQStringList getChangeLog(packageInfo *p);

  bool filesTab(packageInfo *p);
  // If files tab is to be enabled

  bool changeTab(packageInfo *p);
  // If change log tab is to be enabled

  TQStringList depends(const TQString &name, int src);
  TQStringList verify(packageInfo *p, const TQStringList &files);

  TQString uninstall(int uninstallFlags, TQPtrList<packageInfo> *p, bool &test);
  TQString uninstall(int uninstallFlags, packageInfo *p, bool &test);
  TQString doUninst(int uninstallFlags, const TQStringList &files, bool &test);
  TQString doUninstP(int uninstallFlags, const TQStringList &files, bool &test);

  TQString install(int installFlags, TQPtrList<packageInfo> *p, bool &test);
  TQString install(int installFlags, packageInfo *p, bool &test);
  TQString doinst(int installFlags, const TQStringList &files, bool &test);
  TQString doinstP(int installFlags, const TQStringList &files, bool &test);

  TQStringList FindFile(const TQString &name, bool seachAll=false);
  void collectDepends(packageInfo *p, const TQString &name, int src);
  bool parseName(const TQString &name, TQString *n, TQString *v);

  TQString provMap(const TQString &p);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(TQStringList &ln);

  void listInstalledPackages(TQPtrList<packageInfo> *pki);

  TQDict<TQString> provides;
  bool rpmSetup;
  TQStringList infoList;

  TQString packageQuery();
  
  TQStringList getIFileList( packageInfo *p );
  TQStringList getUFileList( const TQString &fn );

  TQStringList getIChangeLog( packageInfo *p );
  TQStringList getUChangeLog( const TQString &fn );

  packageInfo *getIPackageInfo( const TQString &name);
  packageInfo *getUPackageInfo( const TQString &name);

  TQString quotePath( const TQString &path);

 };

#endif



