/* This file is part of the KDE project
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KWQtSqlSerialDataSource.h"
#include "KWQtSqlSerialDataSource.moc"
#include "KWQtSqlEasyFilter.h"

#include <tdelocale.h>
#include <tqlayout.h>
#include <tqsqlcursor.h>
#include <tqdatatable.h>
#include <tqcheckbox.h>
#include <tqsqlrecord.h>
#include <tqsqlquery.h>
#include <kdebug.h>

#define KWQtSqlBarIcon( x ) BarIcon( x, db->KWInstance() )

/******************************************************************
 *
 * Class: KWQtSqlSerialDataSource
 *
 ******************************************************************/

KWQtSqlSerialDataSource::KWQtSqlSerialDataSource(TDEInstance *inst,TQObject *parent)
	: KWQtSqlSerialDataSourceBase(inst,parent)
{
  myquery=0;
}

KWQtSqlSerialDataSource::~KWQtSqlSerialDataSource()
{
        delete myquery;
        TQSqlDatabase::removeDatabase("KWTQTSQLPOWER");
}


TQString KWQtSqlSerialDataSource::getValue( const TQString &name, int record ) const
{
        int num=record;

        if (!myquery) return name;
        if ( num < 0 || num > (int)myquery->size() )
                return name;
        if (!myquery->seek(num,false)) return i18n(">>>Illegal position within datasource<<<");
        if (!myquery->contains(name)) return i18n(">>>Field %1 is unknown in the current database query<<<").arg(name);
        return (myquery->value(name)).toString();
}

void KWQtSqlSerialDataSource::save( TQDomDocument & /*doc*/, TQDomElement & /*parent*/)
{
/*
	TQDomElement def=doc.createElement(TQString::fromLatin1("DEFINITION"));
	parent.appendChild(def);
	for (DbRecord::Iterator it=sampleRecord.begin();it!=sampleRecord.end();++it)
	{
		TQDomElement defEnt=doc.createElement(TQString::fromLatin1("FIELD"));
		defEnt.setAttribute(TQString::fromLatin1("name"),it.key());
		def.appendChild(defEnt);
	}
	TQDomElement cont=doc.createElement(TQString::fromLatin1("CONTENT"));
	parent.appendChild(cont);
	for (Db::Iterator dbI=db.begin();dbI!=db.end();++dbI)
	{
		TQDomElement rec=doc.createElement(TQString::fromLatin1("RECORD"));
		cont.appendChild(rec);
		for (DbRecord::Iterator it=sampleRecord.begin();it!=sampleRecord.end();++it)
		{
			TQDomElement recEnt=doc.createElement(TQString::fromLatin1("ITEM"));
			recEnt.setAttribute(TQString::fromLatin1("name"),it.key());
			recEnt.setAttribute(TQString::fromLatin1("data"),(*dbI)[it.key()]);
			rec.appendChild(recEnt);
		}
	}
*/
}

void KWQtSqlSerialDataSource::load( TQDomElement& /*parentElem*/ )
{
/*
	db.clear();
	sampleRecord.clear();
	TQDomNode defNd=parentElem.namedItem("DEFINITION");
	if (defNd.isNull()) return;
	TQDomElement def=defNd.toElement();
	for (TQDomElement defEnt=def.firstChild().toElement();!defEnt.isNull();defEnt=defEnt.nextSibling().toElement())
	{
		sampleRecord[defEnt.attribute(TQString::fromLatin1("name"))]=defEnt.attribute(TQString::fromLatin1("name"));//i18n( "No Value" );
	}
	TQDomNode contNd=parentElem.namedItem("CONTENT");
	if (contNd.isNull()) return;
	for (TQDomNode rec=contNd.firstChild();!rec.isNull();rec=rec.nextSibling())
	{
		appendRecord();
		for (TQDomElement recEnt=rec.firstChild().toElement();!recEnt.isNull();recEnt=recEnt.nextSibling().toElement())
		{
			setValue(recEnt.attribute(TQString::fromLatin1("name")),
				recEnt.attribute(TQString::fromLatin1("data")),db.count()-1);
		}
	}
*/
}

bool KWQtSqlSerialDataSource::showConfigDialog(TQWidget *par,int action)
{
	bool ret=false;
	if (action==KWSLEdit)
	{
		KWQtSqlDataSourceEditor *dia=new KWQtSqlDataSourceEditor(par,this);
		ret=dia->exec();
		delete dia;
	}
	else ret=KWQtSqlSerialDataSourceBase::showConfigDialog(par,action);

	return ret;
}

void KWQtSqlSerialDataSource::refresh(bool force)
{
        if ((force) || (myquery==0))
        {
                if (myquery)
                {
                        delete myquery;
                        myquery=0;
                }
                if ((!database) || (!database->isOpen())) openDatabase();
		if ((!database) || (!database->isOpen())) return;
                myquery=new TQSqlCursor(tableName,true,database);
                myquery->setMode(TQSqlCursor::ReadOnly);
		myquery->select(filter);
        }
        kdDebug()<<TQString("There were %1 rows in the query").arg(myquery->size())<<endl;

}





/******************************************************************
 *
 * Class: KWQtSqlDataSourceEditor
 *
 ******************************************************************/



KWQtSqlDataSourceEditor::KWQtSqlDataSourceEditor( TQWidget *parent, KWQtSqlSerialDataSource *db_ )
        :KDialogBase( Plain, i18n( "Mail Merge - Editor" ), Ok | Cancel, Ok, parent, "", true ), db( db_ )
{
	tableName=db->tableName;
	filter=db->filter;
        (new TQVBoxLayout(plainPage()))->setAutoAdd(true);
        setMainWidget(widget=new QtSqlDataSourceEditor(plainPage()));
	connect(widget->tableCombo,TQ_SIGNAL(activated(int)),this,TQ_SLOT(tableChanged(int)));
	connect(widget->editFilter,TQ_SIGNAL(clicked()),this,TQ_SLOT(editFilter()));
	updateTableCombo();

//        connect(this,TQ_SIGNAL(okClicked()),this,TQ_SLOT(slotSetQuery()));
}

void KWQtSqlDataSourceEditor::tableChanged(int item)
{
	tableName=widget->tableCombo->text(item);
	TQSqlCursor *tmpCursor=new TQSqlCursor(tableName,true,db->database);
	tmpCursor->setMode(TQSqlCursor::ReadOnly);

	if (widget->filterCheckBox->isChecked()) tmpCursor->select(filter);

	widget->DataTable->setSqlCursor(tmpCursor,true,true);
	widget->DataTable->refresh(TQDataTable::RefreshAll);
}

void KWQtSqlDataSourceEditor::updateTableCombo()
{
	widget->tableCombo->clear();
        if (!db->database) return;
	widget->tableCombo->insertItem("");
        widget->tableCombo->insertStringList(db->database->tables());
}

void KWQtSqlDataSourceEditor::slotSetQuery()
{
        db->tableName=tableName;
	db->filter=filter;
        db->refresh(true);
}


void KWQtSqlDataSourceEditor::editFilter()
{
	KWQtSqlEasyFilter *f=new KWQtSqlEasyFilter(static_cast<TQWidget*>(parent()));
	f->exec();
}

extern "C" {
        KWORD_MAILMERGE_EXPORT KWMailMergeDataSource *create_kwmailmerge_qtsqldb(TDEInstance *inst,TQObject *parent)
        {
                return new KWQtSqlSerialDataSource(inst,parent);
        }
}
