/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
   Copyright (C) 2000 Michael Johnson <mikej@xnet.com>
   Copyright (C) 2001, 2002 Nicolas GOUTTE <goutte@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef ASCIIIMPORT_H
#define ASCIIIMPORT_H

#include <KoFilter.h>

class TQString;
class TQTextStream;
class TQDomDocument;
class TQDomElement;

#define MAXLINES  1000
#define MAXCOLUMNS 15

 const double ptsperline = 15.0;
 const double ptsperchar = 6.0;
 const int spacespertab = 6;
 const double leftmargin = 56.0;

 const uint shortline = 40;  // max length of a "short" line

 struct Tabs
    {
    int columns;
    int indent;
    TQString field[MAXCOLUMNS];
    int width[MAXCOLUMNS];
    };

 struct Position
    {
    double top;
    double left;
    double bottom;
    double right;
    };

class ASCIIImport : public KoFilter {

    TQ_OBJECT
  

public:
    ASCIIImport(KoFilter *parent, const char *name, const TQStringList &);
    ASCIIImport();
    virtual ~ASCIIImport() {}

    virtual KoFilter::ConversionStatus convert( const TQCString& from, const TQCString& to );
private: // not yet changed
#if 0
    void WriteOutTableCell( int table_no, int row, int col, Position *pos,
                          TQString &str);

    bool Table( TQString *Line, int *linecount, int no_lines,
            int table_no, TQString &tbl, TQString &str );



    bool ListItem( TQString *Line, int no_lines,
             TQString &str );
#endif
    bool IsListItem( TQString FirstLine, TQChar mark );

private:
    void prepareDocument(TQDomDocument& mainDocument, TQDomElement& mainFramesetElement);
    void processParagraph(TQDomDocument& mainDocument,
        TQDomElement& mainFramesetElement, const TQStringList& paragraph);
    void writeOutParagraph(TQDomDocument& mainDocument,
        TQDomElement& mainFramesetElement,  const TQString& name,
        const TQString& text, const int firstindent, const int secondindent);
    int Indent(const TQString& line) const;
    int MultSpaces(const TQString& text, const int index) const;
    bool IsWhiteSpace(const TQChar& c) const;
    TQString readLine(TQTextStream& textstream, bool& lastCharWasCr);
private: // converting functions
    void oldWayConvert(TQTextStream& stream, TQDomDocument& mainDocument,
        TQDomElement& mainFramesetElement);
    void asIsConvert(TQTextStream& stream, TQDomDocument& mainDocument,
        TQDomElement& mainFramesetElement);
    void sentenceConvert(TQTextStream& stream, TQDomDocument& mainDocument,
        TQDomElement& mainFramesetElement);
};
#endif // ASCIIIMPORT_H
