#ifndef _KVI_USERIDENTITY_H_
#define _KVI_USERIDENTITY_H_
//=============================================================================
//
//   File : kvi_useridentity.h
//   Created on Sun 21 Jan 2007 04:31:47 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2007 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_heapobject.h"
#include "kvi_pixmap.h"
#include "kvi_config.h"
#include "kvi_pointerhashtable.h"

class KVILIB_API KviUserIdentity : public KviHeapObject
{
	friend class KviUserIdentityManager;
public:
	KviUserIdentity()
	: KviHeapObject()
	{
	}
	~KviUserIdentity()
	{
	}
protected:
	TQString m_szId; // the identity set name

	TQString m_szNickName;
	
	TQString m_szAltNickName1;
	TQString m_szAltNickName2;
	TQString m_szAltNickName3;
	
	TQString m_szUserName;
	TQString m_szRealName;
	TQString m_szPassword;
	
	KviPixmap m_pixAvatar;
	
	TQString m_szPartMessage;
	TQString m_szQuitMessage;
	
	TQString m_szAge;
	TQString m_szGender;
	TQString m_szLocation;
	TQString m_szLanguages;
	TQString m_szOtherInfo;
	
	TQString m_szUserMode;
	
	TQString m_szOnConnectCommand;
	TQString m_szOnLoginCommand;
public:
	const TQString & id() const { return m_szId; };
	const TQString & nickName() const { return m_szNickName; };
	const TQString & altNickName1() const { return m_szAltNickName1; };
	const TQString & altNickName2() const { return m_szAltNickName2; };
	const TQString & altNickName3() const { return m_szAltNickName3; };
	const TQString & userName() const { return m_szUserName; };
	const TQString & password() const { return m_szPassword; };
	const KviPixmap & avatar() const { return m_pixAvatar; };
	const TQString & partMessage() const { return m_szPartMessage; };
	const TQString & quitMessage() const { return m_szQuitMessage; };
	const TQString & age() const { return m_szAge; };
	const TQString & gender() const { return m_szGender; };
	const TQString & location() const { return m_szLocation; };
	const TQString & languages() const { return m_szLanguages; };
	const TQString & otherInfo() const { return m_szOtherInfo; };
	const TQString & userMode() const { return m_szUserMode; };
	const TQString & onConnectCommand() const { return m_szOnConnectCommand; };
	const TQString & onLoginCommand() const { return m_szOnLoginCommand; };
	void setId(const TQString &szId){ m_szId = szId; };
	void setNickName(const TQString &szNickName){ m_szNickName = szNickName; };
	void setAltNickName1(const TQString &szNickName){ m_szAltNickName1 = szNickName; };
	void setAltNickName2(const TQString &szNickName){ m_szAltNickName2 = szNickName; };
	void setAltNickName3(const TQString &szNickName){ m_szAltNickName3 = szNickName; };
	void setUserName(const TQString &szUserName){ m_szUserName = szUserName; };
	void setRealName(const TQString &szRealName){ m_szRealName = szRealName; };
	void setPassword(const TQString &szPassword){ m_szPassword = szPassword; };
	void setAvatar(const KviPixmap &pix){ m_pixAvatar = pix; };
	void setPartMessage(const TQString &szMsg){ m_szPartMessage = szMsg; };
	void setQuitMessage(const TQString &szMsg){ m_szQuitMessage = szMsg; };
	void setAge(const TQString &szAge){ m_szAge = szAge; };
	void setGender(const TQString &szGender){ m_szGender = szGender; };
	void setLocation(const TQString &szLocation){ m_szLocation = szLocation; };
	void setLanguages(const TQString &szLanguages){ m_szLanguages = szLanguages; };
	void setOtherInfo(const TQString &szOtherInfo){ m_szOtherInfo = szOtherInfo; };
	void setUserMode(const TQString &szUserMode){ m_szUserMode = szUserMode; };
	void setOnConnectCommand(const TQString &szOnConnectCommand){ m_szOnConnectCommand = szOnConnectCommand; };
	void setOnLoginCommand(const TQString &szOnLoginCommand){ m_szOnLoginCommand = szOnLoginCommand; };
protected:
	void copyFrom(const KviUserIdentity &src);
	bool save(KviConfig &cfg);
	bool load(KviConfig &cfg);
};

class KVILIB_API KviUserIdentityManager : public KviHeapObject
{
protected:
	KviUserIdentityManager();
	~KviUserIdentityManager();
protected:
	static KviUserIdentityManager * m_pInstance;
	KviPointerHashTable<TQString,KviUserIdentity> * m_pIdentityDict;
	TQString m_szDefaultIdentity;
public:
	static void init();
	static void done();
	static KviUserIdentityManager * instance(){ return m_pInstance; };

	KviPointerHashTable<TQString,KviUserIdentity> * identityDict(){ return m_pIdentityDict; };
	const KviUserIdentity * findIdentity(const TQString &szId){ return m_pIdentityDict->find(szId); };
	// NEVER NULL
	const KviUserIdentity * defaultIdentity();

	void setDefaultIdentity(const TQString &szIdentityId){ m_szDefaultIdentity = szIdentityId; };
	
	KviUserIdentityManager * createWorkingCopy();
	void copyFrom(KviUserIdentityManager * pWorkingCopy);
	void releaseWorkingCopy(KviUserIdentityManager * pWorkingCopy);

	void save(const TQString &szFileName);
	void load(const TQString &szFileName);
};

#endif //!_KVI_USERIDENTITY_H_
