/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the TQtCore module of the TQt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef TQFLAGS_H
#define TQFLAGS_H

#include <tqglobal.h>

class TQFlag
{
    int i;
public:
    inline TQFlag(int i);
    inline operator int() const { return i; }
};

inline TQFlag::TQFlag(int ai) : i(ai) {}

template<typename Enum>
class TQFlags
{
    typedef void **Zero;
    int i;
public:
    typedef Enum enum_type;
    inline TQFlags(const TQFlags &f) : i(f.i) {}
    inline TQFlags(Enum f) : i(f) {}
    inline TQFlags(Zero = 0) : i(0) {}
    inline TQFlags(TQFlag f) : i(f) {}

    inline TQFlags &operator=(const TQFlags &f) { i = f.i; return *this; }
    inline TQFlags &operator&=(int mask) {  i &= mask; return *this; }
    inline TQFlags &operator&=(uint mask) {  i &= mask; return *this; }
    inline TQFlags &operator|=(TQFlags f) {  i |= f.i; return *this; }
    inline TQFlags &operator|=(Enum f) {  i |= f; return *this; }
    inline TQFlags &operator^=(TQFlags f) {  i ^= f.i; return *this; }
    inline TQFlags &operator^=(Enum f) {  i ^= f; return *this; }


    inline operator int() const { return i;}

    inline TQFlags operator|(TQFlags f) const { TQFlags g; g.i = i | f.i; return g; }
    inline TQFlags operator|(Enum f) const { TQFlags g; g.i = i | f; return g; }
    inline TQFlags operator^(TQFlags f) const { TQFlags g; g.i = i ^ f.i; return g; }
    inline TQFlags operator^(Enum f) const { TQFlags g; g.i = i ^ f; return g; }
    inline TQFlags operator&(int mask) const { TQFlags g; g.i = i & mask; return g; }
    inline TQFlags operator&(uint mask) const { TQFlags g; g.i = i & mask; return g; }
    inline TQFlags operator&(Enum f) const { TQFlags g; g.i = i & f; return g; }
    inline TQFlags operator~() const { TQFlags g; g.i = ~i; return g; }

    inline bool operator!() const { return !i; }
};

#define TQ_DECLARE_FLAGS(Flags, Enum)\
typedef TQFlags<Enum> Flags;
#define TQ_DECLARE_OPERATORS_FOR_FLAGS(Flags) \
inline TQFlags<Flags::enum_type> operator|(Flags::enum_type f1, Flags::enum_type f2) \
{ return TQFlags<Flags::enum_type>(f1) | f2; } \
inline TQFlags<Flags::enum_type> operator|(Flags::enum_type f1, TQFlags<Flags::enum_type> f2) \
{ return f2 | f1; }

#endif
