###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for libusb

pkg_search_module( LIBUSB libusb )
if( NOT LIBUSB_FOUND )
  tde_message_fatal( "libusb is required but was not found on your system" )
endif( NOT LIBUSB_FOUND )
set( HAVE_USB 1 )


##### check for parport header

message( STATUS "Performing parport support test" )
check_c_source_compiles( "
  #include <sys/ioctl.h>
  #include <linux/ppdev.h>
  int main() {
    ioctl(1,PPCLAIM,0);
    return 0;
  }"
  HAVE_PPDEV
)


##### check for ppbus header

message( STATUS "Performing ppbus header test" )
check_c_source_compiles( "
  #include <sys/ioctl.h>
  #include <dev/ppbus/ppi.h>
  int main() {
    ioctl(1,PPIGCTRL,0);
    return 0;
  }"
  HAVE_PPBUS
)


##### check for readline

pkg_search_module( READLINE readline )
if( NOT READLINE_FOUND )
  find_path( READLINE_INCLUDE_DIR
             NAMES "readline/readline.h" "readline/history.h"
             HINTS "/usr/include" "/usr/local/include"
             DOC "Looking for readline header's path"
  )
  find_library( READLINE_LIBRARY
                NAMES readline history
                DOC "Looking for readline libraries"
  )
  if( ( READLINE_INCLUDE_DIR ) AND ( READLINE_LIBRARY ) )
    set( READLINE_LIBRARIES ${READLINE_LIBRARY}        )
    set( READLINE_INCLUDE_DIRS ${READLINE_INCLUDE_DIR} )
  else()
    tde_message_fatal( "readline is required but was not found on your system" )
  endif()
endif( NOT READLINE_FOUND )
set( HAVE_READLINE 1 )

##### check for curses if required

tde_save_and_set( CMAKE_REQUIRED_INCLUDES ${READLINE_INCLUDE_DIRS} )
tde_save_and_set( CMAKE_REQUIRED_LIBRARIES ${READLINE_LIBRARIES} )
check_c_source_compiles("
  #include <readline/readline.h>
  int main(void)
  {
    char *result = readline(\"prompt\");
    return 0;
  }"
  BUILD_READLINE_STANDALONE
)
if( NOT BUILD_READLINE_STANDALONE )
  find_package( Curses )
  if( NOT CURSES_FOUND )
    tde_message_fatal( "(n)curses is required but was not found on your system" )
  endif()
  list( APPEND READLINE_LIBRARIES ${CURSES_LIBRARIES} )
endif()
tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
