/***************************************************************************
                           kxeconfiguration.cpp
                           --------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxeconfiguration.h"
#include "kxetreeviewsettings.h"
#include "kxetextviewsettings.h"
#include "kxenewfilesettings.h"
#include "kxeprintsettings.h"
#include "kxearchiveextssettings.h"

#include <tdeglobal.h>
#include <tdelocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>

#include <tqlayout.h>


KXEConfiguration::KXEConfiguration()
 : TQObject( 0, "KXMLEditor's configuration (KXEConfiguration)" ),
   m_pDialog( 0 )
{
	// initialize all setting group objects
	m_pTreeView = new KXETreeViewSettings( this, "tree view config. settings" );
	m_pTextView = new KXETextViewSettings( this, "text view config. settings" );
	m_pNewFile = new KXENewFileSettings( this, "new file config. settings" );
	m_pPrint = new KXEPrintSettings( this, "printing config. settings" );
	m_pArcExts = new KXEArchiveExtsSettings( this, "archive extension config. settings" );

	// restore the settings from our config file
	restore();
}

KXEConfiguration::~KXEConfiguration()
{
	if ( m_pDialog )
		delete m_pDialog;
}

void KXEConfiguration::store( TDEConfig * pConfig ) const
{
	if ( ! pConfig )
		pConfig = TDEGlobal::config();

	m_pTreeView->store( pConfig );
	m_pTextView->store( pConfig );
	m_pNewFile->store( pConfig );
	m_pPrint->store( pConfig );
	m_pArcExts->store( pConfig );
}


void KXEConfiguration::restore( TDEConfig * pConfig )
{
	if ( ! pConfig )
		pConfig = TDEGlobal::config();

	m_pTreeView->restore( pConfig );
	m_pTextView->restore( pConfig );
	m_pNewFile->restore( pConfig );
	m_pPrint->restore( pConfig );
	m_pArcExts->restore( pConfig );
}


void KXEConfiguration::showDialog()
{
	if ( ! m_pDialog ) // if there is no dialog yet,
	{
		// create one
		m_pDialog = new KDialogBase( KDialogBase::IconList,        // dialog face
		                             i18n("Configure KXMLEditor"), // caption
		                             KDialogBase::Apply | KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Help,   // buttons
		                             KDialogBase::Ok,              // default button
		                             0,                            // parent
		                             "configuration dialog",       // name
		                             false,                        // not modal
		                             true );                       // show separator
		connect( m_pDialog, TQ_SIGNAL(applyClicked()), this, TQ_SLOT(slotDlgApplied()) );
		connect( m_pDialog, TQ_SIGNAL(okClicked()), this, TQ_SLOT(slotDlgApplied()) );

		// and add the pages
		TQFrame * pFrame;
		TQWidget * pPage;
		TQVBoxLayout * pLayout;

		// - tree view properties page
		pFrame = m_pDialog->addPage( m_pTreeView->dialogPageName(),
		                             m_pTreeView->dialogPageHeader(),
		                             TDEGlobal::instance()->iconLoader()->loadIcon( m_pTreeView->dialogPageIcon(), TDEIcon::NoGroup, TDEIcon::SizeMedium ) );
		pLayout = new TQVBoxLayout( pFrame );
		pPage = m_pTreeView->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pTreeView, TQ_SIGNAL(sigDialogPageChanged()), this, TQ_SLOT(slotDlgChanged()) );

		// - text view properties page
		pFrame = m_pDialog->addPage( m_pTextView->dialogPageName(),
		                             m_pTextView->dialogPageHeader(),
		                             TDEGlobal::instance()->iconLoader()->loadIcon( m_pTextView->dialogPageIcon(), TDEIcon::NoGroup, TDEIcon::SizeMedium ) );
		pLayout = new TQVBoxLayout( pFrame );
		pPage = m_pTextView->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pTextView, TQ_SIGNAL(sigDialogPageChanged()), this, TQ_SLOT(slotDlgChanged()) );

		// - new file settings page
		pFrame = m_pDialog->addPage( m_pNewFile->dialogPageName(),
		                             m_pNewFile->dialogPageHeader(),
		                             TDEGlobal::instance()->iconLoader()->loadIcon( m_pNewFile->dialogPageIcon(), TDEIcon::NoGroup, TDEIcon::SizeMedium ) );
		pLayout = new TQVBoxLayout( pFrame );
		pPage = m_pNewFile->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pNewFile, TQ_SIGNAL(sigDialogPageChanged()), this, TQ_SLOT(slotDlgChanged()) );

		// - printing's settings page
		pFrame = m_pDialog->addPage( m_pPrint->dialogPageName(),
		                             m_pPrint->dialogPageHeader(),
		                             TDEGlobal::instance()->iconLoader()->loadIcon( m_pPrint->dialogPageIcon(), TDEIcon::NoGroup, TDEIcon::SizeMedium ) );
		pLayout = new TQVBoxLayout( pFrame );
		pPage = m_pPrint->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pPrint, TQ_SIGNAL(sigDialogPageChanged()), this, TQ_SLOT(slotDlgChanged()) );

		// - archive extensions page
		pFrame = m_pDialog->addPage( m_pArcExts->dialogPageName(),
		                             m_pArcExts->dialogPageHeader(),
		                             TDEGlobal::instance()->iconLoader()->loadIcon( m_pArcExts->dialogPageIcon(), TDEIcon::NoGroup, TDEIcon::SizeMedium ) );
		pLayout = new TQVBoxLayout( pFrame );
		pPage = m_pArcExts->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pArcExts, TQ_SIGNAL(sigDialogPageChanged()), this, TQ_SLOT(slotDlgChanged()) );
	}

	if ( m_pDialog->isVisible() ) // If the dialog is visible (probably opened by
	{                             // another part), it has to be hidden to make
		m_pDialog->hide();         // it appear on the current desktop by the later
	}                             // call of show.
	else                                      // If the dialog is not visible, it's
	{                                         // Apply- and Ok-buttons have to be
		m_pDialog->enableButtonApply( false ); // disabled (until something is changed
		m_pDialog->enableButtonOK( false );    // within the dialog).
	}

	m_pDialog->show();   // show our configuration dialog
}

void KXEConfiguration::slotDlgApplied()
{
	// reset configuration dialog
	m_pDialog->enableButtonApply( false );
	m_pDialog->enableButtonOK( false );

	// apply the page's data to the corresponding setting groups
	m_pTreeView->apply();
	m_pTextView->apply();
	m_pNewFile->apply();
	m_pPrint->apply();
	m_pArcExts->apply();

	// store the applied data to our config file
	store();
}

void KXEConfiguration::slotDlgChanged()
{
	m_pDialog->enableButtonApply( true );
	m_pDialog->enableButtonOK( true );
}

#include "kxeconfiguration.moc"
