/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "UiGuiErrorMessage.h"

#include <tqobjectdefs.h>
#include <tqcheckbox.h>

/*
    \class UiGuiErrorMessage
    \brief UiGuiErrorMessage is a child of TQErrorMessage. But TQErrorMessages
    "Do not show again" didn't work with my strings, so this is my own, working
    implementation of it.
*/


/*
    \brief Initializes the dialog.
    Retrieves the object pointer to the \a m_showAgainCheckBox check box, sets the dialogs
    modality and for a working translation sets the check box text.
 */
UiGuiErrorMessage::UiGuiErrorMessage(TQWidget *parent) :
        TQErrorMessage(parent)
{
	m_showAgainCheckBox = Q_CHILD(this, TQCheckBox, "again");
	setModal(true);
	m_showAgainCheckBox->setText(tr("Show this message again"));
}

/*
    \brief Just a lazy nothin doin destructive destructor.
 */
UiGuiErrorMessage::~UiGuiErrorMessage(void)
{
}

/*
    \brief Shows an error \a message in a dialog box with \a title.
    The shown \a message is added to a list, if not already in there. If it is
    already in that list and "Show this message again" is not checked, that
    message will not be shown.
 */
void UiGuiErrorMessage::showMessage(const TQString &title, const TQString &message)
{
	bool showAgain = true;

	if (m_showAgainCheckBox)
	{
		showAgain = m_showAgainCheckBox->isChecked();
	}

	setCaption(title);

	if (!m_errorMessageList.contains(message))
	{
		m_errorMessageList << message;
		if (m_showAgainCheckBox)
		{
			m_showAgainCheckBox->setChecked(true);
		}
		TQErrorMessage::message(message);
	}
	else if (showAgain)
	{
		TQErrorMessage::message(message);
	}
}

/*
    \brief For convinience, for showing a dialog box with the default title "UniversalIndentGUI".
 */
void UiGuiErrorMessage::showMessage(const TQString &message)
{
	showMessage("UniversalIndentGUI", message);
}

#include "UiGuiErrorMessage.moc"
