/**********************************************************************
** Copyright (C) 2005-2008 Trolltech ASA.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
** Alternatively you may (at your option) use any later version
** of the GNU General Public License if such license has been
** publicly approved by Trolltech ASA (or its successors, if any)
** and the KDE Free TQt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/.
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** Licensees holding valid TQt Commercial licenses may use this file in
** accordance with the TQt Commercial License Agreement provided with
** the Software.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef OUTPUTWINDOW_H
#define OUTPUTWINDOW_H

#include <tqtabwidget.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <tqlistview.h>

struct DesignerOutputDock;
class TQTextEdit;
class TQListView;

class ErrorItem : public TQListViewItem
{
public:
    enum Type { Error, Warning };

    ErrorItem( TQListView *parent, TQListViewItem *after, const TQString &message, int line,
	       const TQString &locationString, TQObject *locationObject );

    void paintCell( TQPainter *, const TQColorGroup & cg,
		    int column, int width, int alignment );

    void setRead( bool b ) { read = b; repaint(); }

    TQObject *location() const { return object; }
    int line() const { return text( 2 ).toInt(); }

private:
    TQObject *object;
    Type type;
    bool read;

};

class OutputWindow : public TQTabWidget
{
    TQ_OBJECT

public:
    OutputWindow( TQWidget *parent );
    ~OutputWindow();

    void setErrorMessages( const TQStringList &errors, const TQValueList<uint> &lines,
			   bool clear, const TQStringList &locations,
			   const TQObjectList &locationObjects );
    void appendDebug( const TQString& );
    void clearErrorMessages();
    void clearDebug();
    void showDebugTab();

    DesignerOutputDock *iFace();

    void shuttingDown();

    static TQtMsgHandler oldMsgHandler;

private slots:
    void currentErrorChanged( TQListViewItem *i );

private:
    void setupError();
    void setupDebug();

    TQTextEdit *debugView;
    TQListView *errorView;

    DesignerOutputDock *iface;

};

#endif
