/****************************************************************************
**
** ???
**
** Copyright (C) 2002-2008 Trolltech ASA.  All rights reserved.
**
** This file is part of the kernel module of the TQt GUI Toolkit.
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
** Alternatively you may (at your option) use any later version
** of the GNU General Public License if such license has been
** publicly approved by Trolltech ASA (or its successors, if any)
** and the KDE Free TQt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/.
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** This file may be used under the terms of the Q Public License as
** defined by Trolltech ASA and appearing in the file LICENSE.TQPL
** included in the packaging of this file.  Licensees holding valid TQt
** Commercial licenses may use this file in accordance with the TQt
** Commercial License Agreement provided with the Software.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#include "tqunicodetables_p.h"

/* -------------------------------------------------------------------------
 * unicode information
 * these tables are generated from the unicode reference file
 * ftp://ftp.unicode.org/Public/3.2-Update/UnicodeData.txt
 *
 * Lars
 * -------------------------------------------------------------------------
 */

/* -------------------------------------------------------------------------
2021-04-12

Data between

// START OF GENERATED DATA
and
// END OF GENERATED DATA

regenerated by adding new character data to UnicodeData-3.2.0.txt[*]
with unedited ArabicShaping-3.2.0.txt and LineBreak-3.2.0.txt
and using perl-5.10

[*] https://unicode.org/Public/3.2-Update/
 * -------------------------------------------------------------------------
 */

/* Perl script to generate (run perl -x tools/tqunicodetables.cpp)

#!perl

sub numberize
{
    my(%r, $n, $id);
    for $id ( @_ ) {
      $i = $id;
	$i="" if $i eq "EMPTY";
	$r{$i}=$n++;
    }
    return %r;
}


sub readUnicodeDataLine {
    $code = shift @_;
    for $n (qw{
	    name category combining_class bidi_category
	    character_decomposition decimal_digit_value digit_value
	    numeric_value mirrored oldname comment
	    uppercase lowercase titlecase})
    {
	$id = shift @_;
	$codes = "${n}_code";
	if ( defined %$codes && defined $$codes{$id} ) {
	    $id = $$codes{$id};
	}
	${$n}{$code}=$id;
    }
    $decomp = $character_decomposition{$code};
    if ( length $decomp == 0 ) {
	$decomp = "<single>";
    }
    if (substr($decomp, 0, 1) ne '<') {
	$decomp = "<canonical> " . $decomp;
    }
    @_ = split(" ", $decomp);
    $tag = shift @_;
    $tag = $character_decomposition_tag{$tag};
    $decomp = join( ", 0x", @_ );
    $decomp = "0x".$decomp;
    $decomposition{$code} = $decomp;
    $decomposition_tag{$code} = $tag;
    $decomposition_pos{$code} = $position;
    $len = scalar(@_);
    $decomposition_len{$code} = $len;

#   we use canonical decompositions longer than 1 char
#   we exlude Arabic ligatures from the table
    if($len > 1 and $tag == 1) {
#      ligature to add...
	$start = shift @_;
	$ligature{$start} = $ligature{$start}." ".$code;
    }

#   adjust position
    if($len != 0) {
	$position += $len + 3;
    }
}


# Code to integer mappings...
#
%category_code = numberize(qw{
      EMPTY
      Mn Mc Me
      Nd Nl No
      Zs Zl Zp
      Cc Cf Cs Co Cn

      Lu Ll Lt Lm Lo
      Pc Pd Ps Pe Pi Pf Po
      Sm Sc Sk So
});
%bidi_category_code = numberize(qw{
      L R EN ES ET AN CS B S WS ON LRE LRO AL RLE RLO PDF NSM BN});
%character_decomposition_tag = numberize(qw{
      <single> <canonical> <font> <noBreak> <initial> <medial>
      <final> <isolated> <circle> <super> <sub> <vertical>
      <wide> <narrow> <small> <square> <compat> <fraction>
});
%mirrored_code = numberize(qw{N Y});

%joining_code = numberize(qw{U D R C});

# we map AI and XX to AL for now, as we can't handle them any better
%line_break_code = numberize(qw{OP CL QU GL NS EX SY
				IS PR PO NU AL ID IN HY
				BA BB B2
				ZW CM
				SA
				BK CR LF SG CB SP
});

# Read data into hashes...
#
open IN, "UnicodeData-3.2.0.txt";
$position = 1;
while (<IN>) {
    @fields = split /;/;
    if ( length($fields[0]) < 5 ) {
      if ( $fields[1] =~ /, First>/ ) {
	$codeRangeBegin = $fields[0];
      } elsif ( $fields[1] =~ /, Last>/ ) {
	for ( $i=hex($codeRangeBegin); $i<=hex($fields[0]); $i+=1 ) {
	  @fields2 = @fields;
	  $fields2[0] = sprintf "%lX", $i;
	  readUnicodeDataLine @fields2;
	}
      } else {
	readUnicodeDataLine @fields;
      }
    }
}

open IN2, "ArabicShaping-3.2.0.txt";
$position = 1;
while (<IN2>) {
    @fields = split /;/;
    $code = shift @fields;
    $dummy = shift @fields;
    $join = shift @fields;
    $join =~ s/ //g;
    $join = $joining_code{$join};
    $joining{$code}=$join;
}

open IN3, "LineBreak-3.2.0.txt";
$position = 1;
while (<IN3>) {
    @fields = split /;/;
    $code = shift @fields;
    $break = shift @fields;
    if (length($break) > 0) {
      chomp $break;
      $break =~ s/ .*$//;

      $from = $code;
      $to = $code;
      if ( length($code) > 5 ) {
	$from =~ s,\.\..*,,;
	$to =~ s/......//;
#      print "$from..$to = $break\n";
      }
      if($break eq "AI") {
	$break = "AL";
      }
      if($break eq "XX") {
	$break = "AL";
      }
      for ( $i=hex($from); $i<=hex($to); $i+=1 ) {
	$breaks{sprintf("%04X",$i)}=$line_break_code{$break};
      }
    }
}

# Build pages...
#
$rowtable_txt = "";
$row_txt = "";
$pos = 1;
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $category{$code};
	$info = 0 if !defined $info;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$row{$txt}=$therow;
	$pos += 1;
	$size += 256;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

print "// START OF GENERATED DATA\n\n";
print "#ifndef TQT_NO_UNICODETABLES\n\n";

# Print pages...
#

print "const TQ_UINT8 TQUnicodeTables::unicode_info[] = {";
print $rowtable_txt;
$size += 256;
print "\n\n";
print $row_txt;
print "};\n\n";
print "// $size bytes\n\n";

# Build decomposition tables
#
$rowtable_txt = "";
$row_txt = "";
$table_txt =
    "const TQ_UINT16 TQUnicodeTables::decomposition_map[] = {\n    0,\n";
$pos = 1;
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( $decomposition_tag{$code} != 0 ) {
	    $txt .= " $decomposition_pos{$code},";
	    $table_txt .= "    $decomposition_tag{$code},";
	    $table_txt .= " 0x$code,";
	    $table_txt .= " $decomposition{$code}, 0,\n";
	    $size += 2 * $decomposition_len{$code} + 6;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$row{$txt}=$therow;
	$pos += 1;
	$size += 512;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print decomposition tables
#
print "$table_txt\n};\n\n";

print "const TQ_UINT16 TQUnicodeTables::decomposition_info[] = {";
print "$rowtable_txt\n";
$size += 512;
print $row_txt;
print "};\n\n";
print "// $size bytes\n\n";


# build ligature tables
#
$size = 0;
$position = 1;
$pos = 1;
$rowtable_txt = "";
$row_txt = "";
$table_txt =
    "const TQ_UINT16 TQUnicodeTables::ligature_map[] = {\n    0,\n";
for $lig_row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$lig_row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( defined $ligature{$code} ) {
	    $txt .= " $position,";
	    @ligature = split(" ", $ligature{$code});
#           we need to sort ligatures according to their length.
#           long ones have to come first!
	    @ligature_sort = sort { $decomposition_len{$b} <=>  $decomposition_len{$a} } @ligature;
#           now replace each code by its position in
#           the decomposition map.
	    undef(@lig_pos);
	    for $n (@ligature_sort) {
		push(@lig_pos, $decomposition_pos{$n});
	    }
#           debug info
	    if( 0 ) {
		print "ligatures: $ligature{$code}\n";
		$sort = join(" ", @ligature_sort);
		print "sorted   : $sort\n";
	    }
	    $lig = join(", ", @lig_pos);
	    $table_txt .= "    $lig, 0,\n";
	    $size += 2 * scalar(@ligature) + 2;
	    $position += scalar(@ligature) + 1;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $lig_row{$txt};
    if ( !defined $therow ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$lig_row{$txt}=$therow;
	$pos += 1;
	$size += 512;
    }
    $rowtable_txt .= "\n    " if $lig_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print ligature tables
#
print "$table_txt\n};\n\n";
print "const TQ_UINT16 TQUnicodeTables::ligature_info[] = {";
print "$rowtable_txt\n\n";
$size+=512;
print $row_txt;
print "};\n\n";
print "// $size bytes\n\n";



# Build direction/joining/mirrored pages...
#
$rowtable_txt = "";
$row_txt = "";
$pos = 1;
for $dir_row ( 0..255 ) {
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$dir_row,$cell);
	$dir = $bidi_category{$code};
	$dir = 0 if !defined $dir;
	$join = $joining{$code};
	$join = 0 if !defined $join;
	$mirr = $mirrored{$code};
	$mirr = 0 if !defined $mirr;
	$info = $dir + 32*$join + 128*$mirr;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $dir_row{$txt};
    if ( !defined $therow ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$dir_row{$txt}=$therow;
	$pos += 1;
	$size+=256;
    }
    $rowtable_txt .= "\n    " if $dir_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print pages...
#
print "const TQ_UINT8 TQUnicodeTables::direction_info[] = {";
print "$rowtable_txt\n\n";
$size+=256;
print $row_txt;
print "};\n\n";
print "// $size bytes\n\n";

# Build table of combining classes
#
$rowtable_txt = "";
$row_txt = "";
$pos = 1;
for $combining_row ( 0..255 ) {
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$combining_row,$cell);
	$info = $combining_class{$code};
	$info = 0 if !defined $info;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $combining_row{$txt};
    if ( !defined $therow ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$combining_row{$txt}=$therow;
	$pos += 1;
	$size += 256;
    }
    $rowtable_txt .= "\n    " if $combining_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print pages...
#
print "const TQ_UINT8 TQUnicodeTables::combining_info[] = {";
print "$rowtable_txt\n\n";
$size+=256;
print $row_txt;
print "};\n\n";
print "// $size bytes\n\n";

# Build case info
#
$rowtable_txt = "";
$row_txt = "";
$pos = 1;
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $uppercase{$code};
	if ( length( $info ) eq 0 ) {
	  $info = $lowercase{$code};
	}
	$info =~ s/^0+//;
	if ( length( $info ) eq 0 ) {
	  $info = "0";
	} else {
	  $info = "0x".lc($info);
	}
	if ( length( $info ) ne 1 ) {
	  $nonzero = 1;
	}
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $case_row{$txt};
    if ( !defined $therow && $nonzero ne 0 ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$case_row{$txt}=$therow;
	$pos += 1;
	$size += 512;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    if ( $nonzero ne 0 ) {
      $rowtable_txt .= "$therow, ";
    } else {
      $rowtable_txt .= "0, ";
    }
}

# Print pages...
#
print "const TQ_UINT16 TQUnicodeTables::case_info[] = {";
print "$rowtable_txt\n\n";
$size+=512;
print $row_txt;
print "};\n";
print "// $size bytes\n\n";

# Build decimal info
#
$rowtable_txt = "";
$row_txt = "";
$pos = 1;
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $digit_value{$code};
	if ( length( $info ) eq 0 ) {
	  $info = -1;
	} else {
	  $nonzero = 1;
	}
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $decimal_row{$txt};
    if ( !defined $therow && $nonzero ne 0 ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$decimal_row{$txt}=$therow;
	$pos += 1;
	$size += 256;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    if ( $nonzero ne 0 ) {
      $rowtable_txt .= "$therow, ";
    } else {
      $rowtable_txt .= "0, ";
    }
}

# Print pages...
#
print "const TQ_INT8 TQUnicodeTables::decimal_info[] = {";
print "$rowtable_txt\n\n";
$size+=512;
print $row_txt;
print "};\n";
print "// $size bytes\n\n";


# Build line break info
#
$rowtable_txt = "";
$row_txt = "";
$pos = 1;
for $row ( 0..255 ) {
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $breaks{$code};
	if ( length( $info ) eq 0 ) {
	  $info = $line_break_code{"AL"};
	}
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $lb_row{$txt};
    if ( !defined $therow ) {
	$therow = sprintf("%d",$pos);
	$row_txt = $row_txt."$txt\n";
	$lb_row{$txt}=$therow;
	$pos += 1;
	$size += 256;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print pages...
#
print "const TQ_UINT8 TQUnicodeTables::line_break_info[] = {";
print "$rowtable_txt\n\n";
$size+=512;
print $row_txt;
print "};\n";
print "// $size bytes\n\n";



print "#endif\n\n";
print "// END OF GENERATED DATA\n\n";


__END__

*/

// START OF GENERATED DATA

#ifndef TQT_NO_UNICODETABLES

const TQ_UINT8 TQUnicodeTables::unicode_info[] = {
    1, 2, 3, 4, 5, 6, 7, 8,
    9, 10, 11, 12, 13, 14, 15, 16,
    17, 18, 19, 20, 21, 22, 23, 24,
    25, 9, 9, 9, 9, 9, 26, 27,
    28, 29, 30, 31, 32, 33, 34, 35,
    36, 37, 30, 9, 9, 9, 38, 39,
    40, 41, 42, 43, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 44, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 45,
    22, 22, 22, 22, 46, 9, 9, 9,
    9, 9, 9, 9, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 47,
    48, 48, 48, 48, 48, 48, 48, 48,
    49, 49, 49, 49, 49, 49, 49, 49,
    49, 49, 49, 49, 49, 49, 49, 49,
    49, 49, 49, 49, 49, 49, 49, 49,
    49, 22, 50, 51, 22, 52, 53, 54,


    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 28, 28, 28, 28, 30, 30,
    29, 30, 16, 24, 27, 21, 30, 29,
    30, 27, 6, 6, 29, 16, 30, 26,
    29, 6, 16, 25, 6, 6, 6, 26,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 27,
    15, 15, 15, 15, 15, 15, 15, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 27,
    16, 16, 16, 16, 16, 16, 16, 16,

    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 15, 16, 16,
    16, 15, 15, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 16, 15, 15,
    15, 15, 16, 15, 15, 16, 15, 15,
    15, 16, 16, 16, 15, 15, 16, 15,
    15, 16, 15, 16, 15, 16, 15, 15,
    16, 15, 16, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 15, 16, 15,
    15, 16, 16, 19, 15, 16, 16, 16,
    19, 19, 19, 19, 15, 17, 16, 15,
    17, 16, 15, 17, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 17, 16, 15, 16, 15, 15,
    15, 16, 15, 16, 15, 16, 15, 16,

    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 0, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 29, 29, 18, 18, 18, 18, 18,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 18, 18, 18, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 29, 29, 0, 0,
    0, 0, 18, 0, 0, 0, 26, 0,
    0, 0, 0, 0, 29, 29, 15, 26,
    15, 15, 15, 0, 15, 0, 15, 15,
    16, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 0, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 0,
    16, 16, 15, 15, 15, 16, 16, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 16, 16, 16, 15, 16, 27, 0,
    0, 15, 15, 16, 0, 0, 0, 0,

    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 30, 1, 1, 1, 1, 0,
    3, 3, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 0, 0,
    15, 16, 0, 0, 0, 0, 0, 0,

    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 0,
    0, 18, 26, 26, 26, 26, 26, 26,
    0, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 26, 21, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 26, 1,
    26, 1, 1, 26, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 26, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 26, 0, 0, 0, 26,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 19, 19,
    1, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 26, 19, 1, 1,
    1, 1, 1, 1, 1, 11, 3, 1,
    1, 1, 1, 1, 1, 18, 18, 1,
    1, 30, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 19, 19, 19, 30, 30, 0,

    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 0, 11,
    19, 1, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 1, 0, 0,
    19, 1, 1, 1, 1, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 26, 26, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    26, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 0, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 1, 1, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 1, 1, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    19, 19, 28, 28, 6, 6, 6, 6,
    6, 6, 30, 0, 0, 0, 0, 0,

    0, 0, 1, 0, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 0,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 0, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 19, 19, 0, 19, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    1, 1, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 0, 1,
    1, 2, 0, 2, 2, 1, 0, 0,
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 1,
    2, 1, 1, 1, 0, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 19, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 0, 0,
    0, 19, 19, 0, 19, 0, 19, 19,
    0, 0, 0, 19, 19, 0, 0, 0,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    1, 2, 2, 0, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    6, 6, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 2, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 1, 1,
    1, 2, 2, 2, 2, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 1,
    2, 2, 2, 2, 2, 0, 1, 2,
    2, 0, 2, 2, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 19, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    2, 1, 1, 1, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 1, 0, 0, 0, 0, 2,
    2, 2, 1, 1, 1, 0, 1, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 28,
    19, 19, 19, 19, 19, 19, 18, 1,
    1, 1, 1, 1, 1, 1, 1, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 0, 19, 0, 0, 19,
    19, 0, 19, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 0, 19, 0, 19,
    0, 0, 19, 19, 0, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 19, 0, 0,
    19, 19, 19, 19, 19, 0, 18, 0,
    1, 1, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    19, 30, 30, 30, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 30, 30, 30, 30, 30,
    1, 1, 30, 30, 30, 30, 30, 30,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 1, 30, 1,
    30, 1, 22, 23, 22, 23, 2, 2,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2,
    1, 1, 1, 1, 1, 26, 1, 1,
    19, 19, 19, 19, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 30, 30,
    30, 30, 30, 30, 30, 30, 1, 30,
    30, 30, 30, 30, 30, 0, 0, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    0, 19, 19, 0, 2, 1, 1, 1,
    1, 2, 1, 0, 0, 0, 1, 1,
    2, 1, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 26, 26,
    19, 19, 19, 19, 19, 19, 2, 2,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 0, 26, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 26, 26, 26, 26, 26, 26, 26,
    26, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 26, 26, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 22, 23, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 26, 26, 26, 5, 5,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 19, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 1, 26, 26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 2, 2, 2, 1,
    1, 1, 1, 1, 1, 1, 2, 2,
    2, 2, 2, 2, 2, 2, 1, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 26, 26, 26, 18,
    26, 26, 26, 28, 19, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    26, 26, 26, 26, 26, 26, 21, 26,
    26, 26, 26, 1, 1, 1, 11, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 18, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 16, 16,
    16, 16, 16, 16, 0, 0, 15, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 0, 0, 0, 0, 0, 0,

    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 15, 0, 15, 0, 15, 0, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 16, 29,
    29, 29, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 29, 29,
    16, 16, 16, 16, 0, 0, 16, 16,
    15, 15, 15, 15, 0, 29, 29, 29,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 29, 29, 29,
    0, 0, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 29, 0,

    7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 11, 11, 11, 11,
    21, 21, 21, 21, 21, 21, 26, 26,
    24, 25, 22, 24, 24, 25, 22, 24,
    26, 26, 26, 26, 26, 26, 26, 26,
    8, 9, 11, 11, 11, 11, 11, 7,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 24, 25, 26, 26, 26, 26, 20,
    20, 26, 26, 26, 27, 22, 23, 26,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 27, 0, 0, 0, 0, 26,
    0, 0, 0, 0, 0, 0, 0, 7,
    11, 11, 11, 11, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 11,
    6, 16, 0, 0, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 16,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 3, 3, 3,
    3, 1, 3, 3, 3, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    30, 30, 15, 30, 30, 30, 30, 15,
    30, 30, 16, 15, 15, 15, 16, 16,
    15, 15, 15, 16, 30, 15, 30, 30,
    30, 15, 15, 15, 15, 15, 30, 30,
    30, 30, 30, 30, 15, 30, 15, 30,
    15, 30, 15, 15, 15, 15, 30, 16,
    15, 15, 30, 15, 16, 19, 19, 19,
    19, 16, 30, 0, 0, 16, 15, 15,
    27, 27, 27, 27, 27, 15, 16, 16,
    16, 16, 30, 27, 0, 0, 0, 0,
    0, 0, 0, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 30, 30, 30,
    30, 30, 27, 27, 30, 30, 30, 30,
    27, 30, 30, 27, 30, 30, 27, 30,
    30, 30, 30, 30, 30, 30, 27, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 27, 27,
    30, 30, 27, 30, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,

    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,

    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 27, 27, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 30, 30, 30, 30, 30, 30,
    30, 22, 23, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 22, 23, 26, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 0,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 27,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 27, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 27, 27, 27, 27, 27, 27,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 27,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 30, 30, 30, 30, 0, 30, 30,
    30, 30, 0, 0, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 30, 0, 30,
    30, 30, 30, 0, 0, 0, 30, 0,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 30, 30, 30, 30, 30, 30, 30,
    22, 23, 22, 23, 22, 23, 22, 23,
    22, 23, 22, 23, 22, 23, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 22, 23,
    22, 23, 22, 23, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,

    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    22, 23, 22, 23, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 22, 23, 27, 27,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,

    7, 26, 26, 26, 30, 18, 19, 5,
    22, 23, 22, 23, 22, 23, 22, 23,
    22, 23, 30, 30, 22, 23, 22, 23,
    22, 23, 22, 23, 21, 22, 23, 23,
    30, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 1, 1, 1, 1, 1, 1,
    21, 18, 18, 18, 18, 18, 30, 30,
    5, 5, 5, 18, 19, 26, 30, 30,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 1, 1, 29, 29, 18, 18, 19,
    21, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 20, 18, 18, 18, 19,

    0, 0, 0, 0, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    30, 30, 6, 6, 6, 6, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 30,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,

    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,

    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    16, 16, 16, 16, 16, 16, 16, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 16, 16, 16, 16, 16,
    0, 0, 0, 0, 0, 19, 1, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 27, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 0, 19, 0,
    19, 19, 0, 19, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 22, 23,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 28, 0, 0, 0,

    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    26, 21, 21, 20, 20, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 26, 26, 0,
    0, 26, 26, 26, 26, 20, 20, 20,
    26, 26, 26, 0, 26, 26, 26, 26,
    21, 22, 23, 22, 23, 22, 23, 26,
    26, 26, 27, 21, 27, 27, 27, 0,
    26, 28, 26, 26, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 11,

    0, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 22,
    23, 26, 22, 23, 26, 20, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 18, 18,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 0, 0, 0,
    28, 28, 27, 29, 30, 28, 28, 0,
    30, 27, 27, 27, 27, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 11, 11, 11, 30, 30, 0, 0,
};

// 14080 bytes

const TQ_UINT16 TQUnicodeTables::decomposition_map[] = {
    0,
    3, 0x00A0, 0x0020, 0,
    16, 0x00A8, 0x0020, 0x0308, 0,
    9, 0x00AA, 0x0061, 0,
    16, 0x00AF, 0x0020, 0x0304, 0,
    9, 0x00B2, 0x0032, 0,
    9, 0x00B3, 0x0033, 0,
    16, 0x00B4, 0x0020, 0x0301, 0,
    16, 0x00B5, 0x03BC, 0,
    16, 0x00B8, 0x0020, 0x0327, 0,
    9, 0x00B9, 0x0031, 0,
    9, 0x00BA, 0x006F, 0,
    17, 0x00BC, 0x0031, 0x2044, 0x0034, 0,
    17, 0x00BD, 0x0031, 0x2044, 0x0032, 0,
    17, 0x00BE, 0x0033, 0x2044, 0x0034, 0,
    1, 0x00C0, 0x0041, 0x0300, 0,
    1, 0x00C1, 0x0041, 0x0301, 0,
    1, 0x00C2, 0x0041, 0x0302, 0,
    1, 0x00C3, 0x0041, 0x0303, 0,
    1, 0x00C4, 0x0041, 0x0308, 0,
    1, 0x00C5, 0x0041, 0x030A, 0,
    1, 0x00C7, 0x0043, 0x0327, 0,
    1, 0x00C8, 0x0045, 0x0300, 0,
    1, 0x00C9, 0x0045, 0x0301, 0,
    1, 0x00CA, 0x0045, 0x0302, 0,
    1, 0x00CB, 0x0045, 0x0308, 0,
    1, 0x00CC, 0x0049, 0x0300, 0,
    1, 0x00CD, 0x0049, 0x0301, 0,
    1, 0x00CE, 0x0049, 0x0302, 0,
    1, 0x00CF, 0x0049, 0x0308, 0,
    1, 0x00D1, 0x004E, 0x0303, 0,
    1, 0x00D2, 0x004F, 0x0300, 0,
    1, 0x00D3, 0x004F, 0x0301, 0,
    1, 0x00D4, 0x004F, 0x0302, 0,
    1, 0x00D5, 0x004F, 0x0303, 0,
    1, 0x00D6, 0x004F, 0x0308, 0,
    1, 0x00D9, 0x0055, 0x0300, 0,
    1, 0x00DA, 0x0055, 0x0301, 0,
    1, 0x00DB, 0x0055, 0x0302, 0,
    1, 0x00DC, 0x0055, 0x0308, 0,
    1, 0x00DD, 0x0059, 0x0301, 0,
    1, 0x00E0, 0x0061, 0x0300, 0,
    1, 0x00E1, 0x0061, 0x0301, 0,
    1, 0x00E2, 0x0061, 0x0302, 0,
    1, 0x00E3, 0x0061, 0x0303, 0,
    1, 0x00E4, 0x0061, 0x0308, 0,
    1, 0x00E5, 0x0061, 0x030A, 0,
    1, 0x00E7, 0x0063, 0x0327, 0,
    1, 0x00E8, 0x0065, 0x0300, 0,
    1, 0x00E9, 0x0065, 0x0301, 0,
    1, 0x00EA, 0x0065, 0x0302, 0,
    1, 0x00EB, 0x0065, 0x0308, 0,
    1, 0x00EC, 0x0069, 0x0300, 0,
    1, 0x00ED, 0x0069, 0x0301, 0,
    1, 0x00EE, 0x0069, 0x0302, 0,
    1, 0x00EF, 0x0069, 0x0308, 0,
    1, 0x00F1, 0x006E, 0x0303, 0,
    1, 0x00F2, 0x006F, 0x0300, 0,
    1, 0x00F3, 0x006F, 0x0301, 0,
    1, 0x00F4, 0x006F, 0x0302, 0,
    1, 0x00F5, 0x006F, 0x0303, 0,
    1, 0x00F6, 0x006F, 0x0308, 0,
    1, 0x00F9, 0x0075, 0x0300, 0,
    1, 0x00FA, 0x0075, 0x0301, 0,
    1, 0x00FB, 0x0075, 0x0302, 0,
    1, 0x00FC, 0x0075, 0x0308, 0,
    1, 0x00FD, 0x0079, 0x0301, 0,
    1, 0x00FF, 0x0079, 0x0308, 0,
    1, 0x0100, 0x0041, 0x0304, 0,
    1, 0x0101, 0x0061, 0x0304, 0,
    1, 0x0102, 0x0041, 0x0306, 0,
    1, 0x0103, 0x0061, 0x0306, 0,
    1, 0x0104, 0x0041, 0x0328, 0,
    1, 0x0105, 0x0061, 0x0328, 0,
    1, 0x0106, 0x0043, 0x0301, 0,
    1, 0x0107, 0x0063, 0x0301, 0,
    1, 0x0108, 0x0043, 0x0302, 0,
    1, 0x0109, 0x0063, 0x0302, 0,
    1, 0x010A, 0x0043, 0x0307, 0,
    1, 0x010B, 0x0063, 0x0307, 0,
    1, 0x010C, 0x0043, 0x030C, 0,
    1, 0x010D, 0x0063, 0x030C, 0,
    1, 0x010E, 0x0044, 0x030C, 0,
    1, 0x010F, 0x0064, 0x030C, 0,
    1, 0x0112, 0x0045, 0x0304, 0,
    1, 0x0113, 0x0065, 0x0304, 0,
    1, 0x0114, 0x0045, 0x0306, 0,
    1, 0x0115, 0x0065, 0x0306, 0,
    1, 0x0116, 0x0045, 0x0307, 0,
    1, 0x0117, 0x0065, 0x0307, 0,
    1, 0x0118, 0x0045, 0x0328, 0,
    1, 0x0119, 0x0065, 0x0328, 0,
    1, 0x011A, 0x0045, 0x030C, 0,
    1, 0x011B, 0x0065, 0x030C, 0,
    1, 0x011C, 0x0047, 0x0302, 0,
    1, 0x011D, 0x0067, 0x0302, 0,
    1, 0x011E, 0x0047, 0x0306, 0,
    1, 0x011F, 0x0067, 0x0306, 0,
    1, 0x0120, 0x0047, 0x0307, 0,
    1, 0x0121, 0x0067, 0x0307, 0,
    1, 0x0122, 0x0047, 0x0327, 0,
    1, 0x0123, 0x0067, 0x0327, 0,
    1, 0x0124, 0x0048, 0x0302, 0,
    1, 0x0125, 0x0068, 0x0302, 0,
    1, 0x0128, 0x0049, 0x0303, 0,
    1, 0x0129, 0x0069, 0x0303, 0,
    1, 0x012A, 0x0049, 0x0304, 0,
    1, 0x012B, 0x0069, 0x0304, 0,
    1, 0x012C, 0x0049, 0x0306, 0,
    1, 0x012D, 0x0069, 0x0306, 0,
    1, 0x012E, 0x0049, 0x0328, 0,
    1, 0x012F, 0x0069, 0x0328, 0,
    1, 0x0130, 0x0049, 0x0307, 0,
    16, 0x0132, 0x0049, 0x004A, 0,
    16, 0x0133, 0x0069, 0x006A, 0,
    1, 0x0134, 0x004A, 0x0302, 0,
    1, 0x0135, 0x006A, 0x0302, 0,
    1, 0x0136, 0x004B, 0x0327, 0,
    1, 0x0137, 0x006B, 0x0327, 0,
    1, 0x0139, 0x004C, 0x0301, 0,
    1, 0x013A, 0x006C, 0x0301, 0,
    1, 0x013B, 0x004C, 0x0327, 0,
    1, 0x013C, 0x006C, 0x0327, 0,
    1, 0x013D, 0x004C, 0x030C, 0,
    1, 0x013E, 0x006C, 0x030C, 0,
    16, 0x013F, 0x004C, 0x00B7, 0,
    16, 0x0140, 0x006C, 0x00B7, 0,
    1, 0x0143, 0x004E, 0x0301, 0,
    1, 0x0144, 0x006E, 0x0301, 0,
    1, 0x0145, 0x004E, 0x0327, 0,
    1, 0x0146, 0x006E, 0x0327, 0,
    1, 0x0147, 0x004E, 0x030C, 0,
    1, 0x0148, 0x006E, 0x030C, 0,
    16, 0x0149, 0x02BC, 0x006E, 0,
    1, 0x014C, 0x004F, 0x0304, 0,
    1, 0x014D, 0x006F, 0x0304, 0,
    1, 0x014E, 0x004F, 0x0306, 0,
    1, 0x014F, 0x006F, 0x0306, 0,
    1, 0x0150, 0x004F, 0x030B, 0,
    1, 0x0151, 0x006F, 0x030B, 0,
    1, 0x0154, 0x0052, 0x0301, 0,
    1, 0x0155, 0x0072, 0x0301, 0,
    1, 0x0156, 0x0052, 0x0327, 0,
    1, 0x0157, 0x0072, 0x0327, 0,
    1, 0x0158, 0x0052, 0x030C, 0,
    1, 0x0159, 0x0072, 0x030C, 0,
    1, 0x015A, 0x0053, 0x0301, 0,
    1, 0x015B, 0x0073, 0x0301, 0,
    1, 0x015C, 0x0053, 0x0302, 0,
    1, 0x015D, 0x0073, 0x0302, 0,
    1, 0x015E, 0x0053, 0x0327, 0,
    1, 0x015F, 0x0073, 0x0327, 0,
    1, 0x0160, 0x0053, 0x030C, 0,
    1, 0x0161, 0x0073, 0x030C, 0,
    1, 0x0162, 0x0054, 0x0327, 0,
    1, 0x0163, 0x0074, 0x0327, 0,
    1, 0x0164, 0x0054, 0x030C, 0,
    1, 0x0165, 0x0074, 0x030C, 0,
    1, 0x0168, 0x0055, 0x0303, 0,
    1, 0x0169, 0x0075, 0x0303, 0,
    1, 0x016A, 0x0055, 0x0304, 0,
    1, 0x016B, 0x0075, 0x0304, 0,
    1, 0x016C, 0x0055, 0x0306, 0,
    1, 0x016D, 0x0075, 0x0306, 0,
    1, 0x016E, 0x0055, 0x030A, 0,
    1, 0x016F, 0x0075, 0x030A, 0,
    1, 0x0170, 0x0055, 0x030B, 0,
    1, 0x0171, 0x0075, 0x030B, 0,
    1, 0x0172, 0x0055, 0x0328, 0,
    1, 0x0173, 0x0075, 0x0328, 0,
    1, 0x0174, 0x0057, 0x0302, 0,
    1, 0x0175, 0x0077, 0x0302, 0,
    1, 0x0176, 0x0059, 0x0302, 0,
    1, 0x0177, 0x0079, 0x0302, 0,
    1, 0x0178, 0x0059, 0x0308, 0,
    1, 0x0179, 0x005A, 0x0301, 0,
    1, 0x017A, 0x007A, 0x0301, 0,
    1, 0x017B, 0x005A, 0x0307, 0,
    1, 0x017C, 0x007A, 0x0307, 0,
    1, 0x017D, 0x005A, 0x030C, 0,
    1, 0x017E, 0x007A, 0x030C, 0,
    16, 0x017F, 0x0073, 0,
    1, 0x01A0, 0x004F, 0x031B, 0,
    1, 0x01A1, 0x006F, 0x031B, 0,
    1, 0x01AF, 0x0055, 0x031B, 0,
    1, 0x01B0, 0x0075, 0x031B, 0,
    16, 0x01C4, 0x0044, 0x017D, 0,
    16, 0x01C5, 0x0044, 0x017E, 0,
    16, 0x01C6, 0x0064, 0x017E, 0,
    16, 0x01C7, 0x004C, 0x004A, 0,
    16, 0x01C8, 0x004C, 0x006A, 0,
    16, 0x01C9, 0x006C, 0x006A, 0,
    16, 0x01CA, 0x004E, 0x004A, 0,
    16, 0x01CB, 0x004E, 0x006A, 0,
    16, 0x01CC, 0x006E, 0x006A, 0,
    1, 0x01CD, 0x0041, 0x030C, 0,
    1, 0x01CE, 0x0061, 0x030C, 0,
    1, 0x01CF, 0x0049, 0x030C, 0,
    1, 0x01D0, 0x0069, 0x030C, 0,
    1, 0x01D1, 0x004F, 0x030C, 0,
    1, 0x01D2, 0x006F, 0x030C, 0,
    1, 0x01D3, 0x0055, 0x030C, 0,
    1, 0x01D4, 0x0075, 0x030C, 0,
    1, 0x01D5, 0x00DC, 0x0304, 0,
    1, 0x01D6, 0x00FC, 0x0304, 0,
    1, 0x01D7, 0x00DC, 0x0301, 0,
    1, 0x01D8, 0x00FC, 0x0301, 0,
    1, 0x01D9, 0x00DC, 0x030C, 0,
    1, 0x01DA, 0x00FC, 0x030C, 0,
    1, 0x01DB, 0x00DC, 0x0300, 0,
    1, 0x01DC, 0x00FC, 0x0300, 0,
    1, 0x01DE, 0x00C4, 0x0304, 0,
    1, 0x01DF, 0x00E4, 0x0304, 0,
    1, 0x01E0, 0x0226, 0x0304, 0,
    1, 0x01E1, 0x0227, 0x0304, 0,
    1, 0x01E2, 0x00C6, 0x0304, 0,
    1, 0x01E3, 0x00E6, 0x0304, 0,
    1, 0x01E6, 0x0047, 0x030C, 0,
    1, 0x01E7, 0x0067, 0x030C, 0,
    1, 0x01E8, 0x004B, 0x030C, 0,
    1, 0x01E9, 0x006B, 0x030C, 0,
    1, 0x01EA, 0x004F, 0x0328, 0,
    1, 0x01EB, 0x006F, 0x0328, 0,
    1, 0x01EC, 0x01EA, 0x0304, 0,
    1, 0x01ED, 0x01EB, 0x0304, 0,
    1, 0x01EE, 0x01B7, 0x030C, 0,
    1, 0x01EF, 0x0292, 0x030C, 0,
    1, 0x01F0, 0x006A, 0x030C, 0,
    16, 0x01F1, 0x0044, 0x005A, 0,
    16, 0x01F2, 0x0044, 0x007A, 0,
    16, 0x01F3, 0x0064, 0x007A, 0,
    1, 0x01F4, 0x0047, 0x0301, 0,
    1, 0x01F5, 0x0067, 0x0301, 0,
    1, 0x01F8, 0x004E, 0x0300, 0,
    1, 0x01F9, 0x006E, 0x0300, 0,
    1, 0x01FA, 0x00C5, 0x0301, 0,
    1, 0x01FB, 0x00E5, 0x0301, 0,
    1, 0x01FC, 0x00C6, 0x0301, 0,
    1, 0x01FD, 0x00E6, 0x0301, 0,
    1, 0x01FE, 0x00D8, 0x0301, 0,
    1, 0x01FF, 0x00F8, 0x0301, 0,
    1, 0x0200, 0x0041, 0x030F, 0,
    1, 0x0201, 0x0061, 0x030F, 0,
    1, 0x0202, 0x0041, 0x0311, 0,
    1, 0x0203, 0x0061, 0x0311, 0,
    1, 0x0204, 0x0045, 0x030F, 0,
    1, 0x0205, 0x0065, 0x030F, 0,
    1, 0x0206, 0x0045, 0x0311, 0,
    1, 0x0207, 0x0065, 0x0311, 0,
    1, 0x0208, 0x0049, 0x030F, 0,
    1, 0x0209, 0x0069, 0x030F, 0,
    1, 0x020A, 0x0049, 0x0311, 0,
    1, 0x020B, 0x0069, 0x0311, 0,
    1, 0x020C, 0x004F, 0x030F, 0,
    1, 0x020D, 0x006F, 0x030F, 0,
    1, 0x020E, 0x004F, 0x0311, 0,
    1, 0x020F, 0x006F, 0x0311, 0,
    1, 0x0210, 0x0052, 0x030F, 0,
    1, 0x0211, 0x0072, 0x030F, 0,
    1, 0x0212, 0x0052, 0x0311, 0,
    1, 0x0213, 0x0072, 0x0311, 0,
    1, 0x0214, 0x0055, 0x030F, 0,
    1, 0x0215, 0x0075, 0x030F, 0,
    1, 0x0216, 0x0055, 0x0311, 0,
    1, 0x0217, 0x0075, 0x0311, 0,
    1, 0x0218, 0x0053, 0x0326, 0,
    1, 0x0219, 0x0073, 0x0326, 0,
    1, 0x021A, 0x0054, 0x0326, 0,
    1, 0x021B, 0x0074, 0x0326, 0,
    1, 0x021E, 0x0048, 0x030C, 0,
    1, 0x021F, 0x0068, 0x030C, 0,
    1, 0x0226, 0x0041, 0x0307, 0,
    1, 0x0227, 0x0061, 0x0307, 0,
    1, 0x0228, 0x0045, 0x0327, 0,
    1, 0x0229, 0x0065, 0x0327, 0,
    1, 0x022A, 0x00D6, 0x0304, 0,
    1, 0x022B, 0x00F6, 0x0304, 0,
    1, 0x022C, 0x00D5, 0x0304, 0,
    1, 0x022D, 0x00F5, 0x0304, 0,
    1, 0x022E, 0x004F, 0x0307, 0,
    1, 0x022F, 0x006F, 0x0307, 0,
    1, 0x0230, 0x022E, 0x0304, 0,
    1, 0x0231, 0x022F, 0x0304, 0,
    1, 0x0232, 0x0059, 0x0304, 0,
    1, 0x0233, 0x0079, 0x0304, 0,
    9, 0x02B0, 0x0068, 0,
    9, 0x02B1, 0x0266, 0,
    9, 0x02B2, 0x006A, 0,
    9, 0x02B3, 0x0072, 0,
    9, 0x02B4, 0x0279, 0,
    9, 0x02B5, 0x027B, 0,
    9, 0x02B6, 0x0281, 0,
    9, 0x02B7, 0x0077, 0,
    9, 0x02B8, 0x0079, 0,
    16, 0x02D8, 0x0020, 0x0306, 0,
    16, 0x02D9, 0x0020, 0x0307, 0,
    16, 0x02DA, 0x0020, 0x030A, 0,
    16, 0x02DB, 0x0020, 0x0328, 0,
    16, 0x02DC, 0x0020, 0x0303, 0,
    16, 0x02DD, 0x0020, 0x030B, 0,
    9, 0x02E0, 0x0263, 0,
    9, 0x02E1, 0x006C, 0,
    9, 0x02E2, 0x0073, 0,
    9, 0x02E3, 0x0078, 0,
    9, 0x02E4, 0x0295, 0,
    1, 0x0340, 0x0300, 0,
    1, 0x0341, 0x0301, 0,
    1, 0x0343, 0x0313, 0,
    1, 0x0344, 0x0308, 0x0301, 0,
    1, 0x0374, 0x02B9, 0,
    16, 0x037A, 0x0020, 0x0345, 0,
    1, 0x037E, 0x003B, 0,
    16, 0x0384, 0x0020, 0x0301, 0,
    1, 0x0385, 0x00A8, 0x0301, 0,
    1, 0x0386, 0x0391, 0x0301, 0,
    1, 0x0387, 0x00B7, 0,
    1, 0x0388, 0x0395, 0x0301, 0,
    1, 0x0389, 0x0397, 0x0301, 0,
    1, 0x038A, 0x0399, 0x0301, 0,
    1, 0x038C, 0x039F, 0x0301, 0,
    1, 0x038E, 0x03A5, 0x0301, 0,
    1, 0x038F, 0x03A9, 0x0301, 0,
    1, 0x0390, 0x03CA, 0x0301, 0,
    1, 0x03AA, 0x0399, 0x0308, 0,
    1, 0x03AB, 0x03A5, 0x0308, 0,
    1, 0x03AC, 0x03B1, 0x0301, 0,
    1, 0x03AD, 0x03B5, 0x0301, 0,
    1, 0x03AE, 0x03B7, 0x0301, 0,
    1, 0x03AF, 0x03B9, 0x0301, 0,
    1, 0x03B0, 0x03CB, 0x0301, 0,
    1, 0x03CA, 0x03B9, 0x0308, 0,
    1, 0x03CB, 0x03C5, 0x0308, 0,
    1, 0x03CC, 0x03BF, 0x0301, 0,
    1, 0x03CD, 0x03C5, 0x0301, 0,
    1, 0x03CE, 0x03C9, 0x0301, 0,
    16, 0x03D0, 0x03B2, 0,
    16, 0x03D1, 0x03B8, 0,
    16, 0x03D2, 0x03A5, 0,
    1, 0x03D3, 0x03D2, 0x0301, 0,
    1, 0x03D4, 0x03D2, 0x0308, 0,
    16, 0x03D5, 0x03C6, 0,
    16, 0x03D6, 0x03C0, 0,
    16, 0x03F0, 0x03BA, 0,
    16, 0x03F1, 0x03C1, 0,
    16, 0x03F4, 0x0398, 0,
    16, 0x03F5, 0x03B5, 0,
    1, 0x0400, 0x0415, 0x0300, 0,
    1, 0x0401, 0x0415, 0x0308, 0,
    1, 0x0403, 0x0413, 0x0301, 0,
    1, 0x0407, 0x0406, 0x0308, 0,
    1, 0x040C, 0x041A, 0x0301, 0,
    1, 0x040D, 0x0418, 0x0300, 0,
    1, 0x040E, 0x0423, 0x0306, 0,
    1, 0x0419, 0x0418, 0x0306, 0,
    1, 0x0439, 0x0438, 0x0306, 0,
    1, 0x0450, 0x0435, 0x0300, 0,
    1, 0x0451, 0x0435, 0x0308, 0,
    1, 0x0453, 0x0433, 0x0301, 0,
    1, 0x0457, 0x0456, 0x0308, 0,
    1, 0x045C, 0x043A, 0x0301, 0,
    1, 0x045D, 0x0438, 0x0300, 0,
    1, 0x045E, 0x0443, 0x0306, 0,
    1, 0x0476, 0x0474, 0x030F, 0,
    1, 0x0477, 0x0475, 0x030F, 0,
    1, 0x04C1, 0x0416, 0x0306, 0,
    1, 0x04C2, 0x0436, 0x0306, 0,
    1, 0x04D0, 0x0410, 0x0306, 0,
    1, 0x04D1, 0x0430, 0x0306, 0,
    1, 0x04D2, 0x0410, 0x0308, 0,
    1, 0x04D3, 0x0430, 0x0308, 0,
    1, 0x04D6, 0x0415, 0x0306, 0,
    1, 0x04D7, 0x0435, 0x0306, 0,
    1, 0x04DA, 0x04D8, 0x0308, 0,
    1, 0x04DB, 0x04D9, 0x0308, 0,
    1, 0x04DC, 0x0416, 0x0308, 0,
    1, 0x04DD, 0x0436, 0x0308, 0,
    1, 0x04DE, 0x0417, 0x0308, 0,
    1, 0x04DF, 0x0437, 0x0308, 0,
    1, 0x04E2, 0x0418, 0x0304, 0,
    1, 0x04E3, 0x0438, 0x0304, 0,
    1, 0x04E4, 0x0418, 0x0308, 0,
    1, 0x04E5, 0x0438, 0x0308, 0,
    1, 0x04E6, 0x041E, 0x0308, 0,
    1, 0x04E7, 0x043E, 0x0308, 0,
    1, 0x04EA, 0x04E8, 0x0308, 0,
    1, 0x04EB, 0x04E9, 0x0308, 0,
    1, 0x04EC, 0x042D, 0x0308, 0,
    1, 0x04ED, 0x044D, 0x0308, 0,
    1, 0x04EE, 0x0423, 0x0304, 0,
    1, 0x04EF, 0x0443, 0x0304, 0,
    1, 0x04F0, 0x0423, 0x0308, 0,
    1, 0x04F1, 0x0443, 0x0308, 0,
    1, 0x04F2, 0x0423, 0x030B, 0,
    1, 0x04F3, 0x0443, 0x030B, 0,
    1, 0x04F4, 0x0427, 0x0308, 0,
    1, 0x04F5, 0x0447, 0x0308, 0,
    1, 0x04F8, 0x042B, 0x0308, 0,
    1, 0x04F9, 0x044B, 0x0308, 0,
    16, 0x0587, 0x0565, 0x0582, 0,
    1, 0x0622, 0x0627, 0x0653, 0,
    1, 0x0623, 0x0627, 0x0654, 0,
    1, 0x0624, 0x0648, 0x0654, 0,
    1, 0x0625, 0x0627, 0x0655, 0,
    1, 0x0626, 0x064A, 0x0654, 0,
    16, 0x0675, 0x0627, 0x0674, 0,
    16, 0x0676, 0x0648, 0x0674, 0,
    16, 0x0677, 0x06C7, 0x0674, 0,
    16, 0x0678, 0x064A, 0x0674, 0,
    1, 0x06C0, 0x06D5, 0x0654, 0,
    1, 0x06C2, 0x06C1, 0x0654, 0,
    1, 0x06D3, 0x06D2, 0x0654, 0,
    1, 0x0929, 0x0928, 0x093C, 0,
    1, 0x0931, 0x0930, 0x093C, 0,
    1, 0x0934, 0x0933, 0x093C, 0,
    1, 0x0958, 0x0915, 0x093C, 0,
    1, 0x0959, 0x0916, 0x093C, 0,
    1, 0x095A, 0x0917, 0x093C, 0,
    1, 0x095B, 0x091C, 0x093C, 0,
    1, 0x095C, 0x0921, 0x093C, 0,
    1, 0x095D, 0x0922, 0x093C, 0,
    1, 0x095E, 0x092B, 0x093C, 0,
    1, 0x095F, 0x092F, 0x093C, 0,
    1, 0x09CB, 0x09C7, 0x09BE, 0,
    1, 0x09CC, 0x09C7, 0x09D7, 0,
    1, 0x09DC, 0x09A1, 0x09BC, 0,
    1, 0x09DD, 0x09A2, 0x09BC, 0,
    1, 0x09DF, 0x09AF, 0x09BC, 0,
    1, 0x0A33, 0x0A32, 0x0A3C, 0,
    1, 0x0A36, 0x0A38, 0x0A3C, 0,
    1, 0x0A59, 0x0A16, 0x0A3C, 0,
    1, 0x0A5A, 0x0A17, 0x0A3C, 0,
    1, 0x0A5B, 0x0A1C, 0x0A3C, 0,
    1, 0x0A5E, 0x0A2B, 0x0A3C, 0,
    1, 0x0B48, 0x0B47, 0x0B56, 0,
    1, 0x0B4B, 0x0B47, 0x0B3E, 0,
    1, 0x0B4C, 0x0B47, 0x0B57, 0,
    1, 0x0B5C, 0x0B21, 0x0B3C, 0,
    1, 0x0B5D, 0x0B22, 0x0B3C, 0,
    1, 0x0B94, 0x0B92, 0x0BD7, 0,
    1, 0x0BCA, 0x0BC6, 0x0BBE, 0,
    1, 0x0BCB, 0x0BC7, 0x0BBE, 0,
    1, 0x0BCC, 0x0BC6, 0x0BD7, 0,
    1, 0x0C48, 0x0C46, 0x0C56, 0,
    1, 0x0CC0, 0x0CBF, 0x0CD5, 0,
    1, 0x0CC7, 0x0CC6, 0x0CD5, 0,
    1, 0x0CC8, 0x0CC6, 0x0CD6, 0,
    1, 0x0CCA, 0x0CC6, 0x0CC2, 0,
    1, 0x0CCB, 0x0CCA, 0x0CD5, 0,
    1, 0x0D4A, 0x0D46, 0x0D3E, 0,
    1, 0x0D4B, 0x0D47, 0x0D3E, 0,
    1, 0x0D4C, 0x0D46, 0x0D57, 0,
    1, 0x0DDA, 0x0DD9, 0x0DCA, 0,
    1, 0x0DDC, 0x0DD9, 0x0DCF, 0,
    1, 0x0DDD, 0x0DDC, 0x0DCA, 0,
    1, 0x0DDE, 0x0DD9, 0x0DDF, 0,
    16, 0x0E33, 0x0E4D, 0x0E32, 0,
    16, 0x0EB3, 0x0ECD, 0x0EB2, 0,
    16, 0x0EDC, 0x0EAB, 0x0E99, 0,
    16, 0x0EDD, 0x0EAB, 0x0EA1, 0,
    3, 0x0F0C, 0x0F0B, 0,
    1, 0x0F43, 0x0F42, 0x0FB7, 0,
    1, 0x0F4D, 0x0F4C, 0x0FB7, 0,
    1, 0x0F52, 0x0F51, 0x0FB7, 0,
    1, 0x0F57, 0x0F56, 0x0FB7, 0,
    1, 0x0F5C, 0x0F5B, 0x0FB7, 0,
    1, 0x0F69, 0x0F40, 0x0FB5, 0,
    1, 0x0F73, 0x0F71, 0x0F72, 0,
    1, 0x0F75, 0x0F71, 0x0F74, 0,
    1, 0x0F76, 0x0FB2, 0x0F80, 0,
    16, 0x0F77, 0x0FB2, 0x0F81, 0,
    1, 0x0F78, 0x0FB3, 0x0F80, 0,
    16, 0x0F79, 0x0FB3, 0x0F81, 0,
    1, 0x0F81, 0x0F71, 0x0F80, 0,
    1, 0x0F93, 0x0F92, 0x0FB7, 0,
    1, 0x0F9D, 0x0F9C, 0x0FB7, 0,
    1, 0x0FA2, 0x0FA1, 0x0FB7, 0,
    1, 0x0FA7, 0x0FA6, 0x0FB7, 0,
    1, 0x0FAC, 0x0FAB, 0x0FB7, 0,
    1, 0x0FB9, 0x0F90, 0x0FB5, 0,
    1, 0x1026, 0x1025, 0x102E, 0,
    1, 0x1E00, 0x0041, 0x0325, 0,
    1, 0x1E01, 0x0061, 0x0325, 0,
    1, 0x1E02, 0x0042, 0x0307, 0,
    1, 0x1E03, 0x0062, 0x0307, 0,
    1, 0x1E04, 0x0042, 0x0323, 0,
    1, 0x1E05, 0x0062, 0x0323, 0,
    1, 0x1E06, 0x0042, 0x0331, 0,
    1, 0x1E07, 0x0062, 0x0331, 0,
    1, 0x1E08, 0x00C7, 0x0301, 0,
    1, 0x1E09, 0x00E7, 0x0301, 0,
    1, 0x1E0A, 0x0044, 0x0307, 0,
    1, 0x1E0B, 0x0064, 0x0307, 0,
    1, 0x1E0C, 0x0044, 0x0323, 0,
    1, 0x1E0D, 0x0064, 0x0323, 0,
    1, 0x1E0E, 0x0044, 0x0331, 0,
    1, 0x1E0F, 0x0064, 0x0331, 0,
    1, 0x1E10, 0x0044, 0x0327, 0,
    1, 0x1E11, 0x0064, 0x0327, 0,
    1, 0x1E12, 0x0044, 0x032D, 0,
    1, 0x1E13, 0x0064, 0x032D, 0,
    1, 0x1E14, 0x0112, 0x0300, 0,
    1, 0x1E15, 0x0113, 0x0300, 0,
    1, 0x1E16, 0x0112, 0x0301, 0,
    1, 0x1E17, 0x0113, 0x0301, 0,
    1, 0x1E18, 0x0045, 0x032D, 0,
    1, 0x1E19, 0x0065, 0x032D, 0,
    1, 0x1E1A, 0x0045, 0x0330, 0,
    1, 0x1E1B, 0x0065, 0x0330, 0,
    1, 0x1E1C, 0x0228, 0x0306, 0,
    1, 0x1E1D, 0x0229, 0x0306, 0,
    1, 0x1E1E, 0x0046, 0x0307, 0,
    1, 0x1E1F, 0x0066, 0x0307, 0,
    1, 0x1E20, 0x0047, 0x0304, 0,
    1, 0x1E21, 0x0067, 0x0304, 0,
    1, 0x1E22, 0x0048, 0x0307, 0,
    1, 0x1E23, 0x0068, 0x0307, 0,
    1, 0x1E24, 0x0048, 0x0323, 0,
    1, 0x1E25, 0x0068, 0x0323, 0,
    1, 0x1E26, 0x0048, 0x0308, 0,
    1, 0x1E27, 0x0068, 0x0308, 0,
    1, 0x1E28, 0x0048, 0x0327, 0,
    1, 0x1E29, 0x0068, 0x0327, 0,
    1, 0x1E2A, 0x0048, 0x032E, 0,
    1, 0x1E2B, 0x0068, 0x032E, 0,
    1, 0x1E2C, 0x0049, 0x0330, 0,
    1, 0x1E2D, 0x0069, 0x0330, 0,
    1, 0x1E2E, 0x00CF, 0x0301, 0,
    1, 0x1E2F, 0x00EF, 0x0301, 0,
    1, 0x1E30, 0x004B, 0x0301, 0,
    1, 0x1E31, 0x006B, 0x0301, 0,
    1, 0x1E32, 0x004B, 0x0323, 0,
    1, 0x1E33, 0x006B, 0x0323, 0,
    1, 0x1E34, 0x004B, 0x0331, 0,
    1, 0x1E35, 0x006B, 0x0331, 0,
    1, 0x1E36, 0x004C, 0x0323, 0,
    1, 0x1E37, 0x006C, 0x0323, 0,
    1, 0x1E38, 0x1E36, 0x0304, 0,
    1, 0x1E39, 0x1E37, 0x0304, 0,
    1, 0x1E3A, 0x004C, 0x0331, 0,
    1, 0x1E3B, 0x006C, 0x0331, 0,
    1, 0x1E3C, 0x004C, 0x032D, 0,
    1, 0x1E3D, 0x006C, 0x032D, 0,
    1, 0x1E3E, 0x004D, 0x0301, 0,
    1, 0x1E3F, 0x006D, 0x0301, 0,
    1, 0x1E40, 0x004D, 0x0307, 0,
    1, 0x1E41, 0x006D, 0x0307, 0,
    1, 0x1E42, 0x004D, 0x0323, 0,
    1, 0x1E43, 0x006D, 0x0323, 0,
    1, 0x1E44, 0x004E, 0x0307, 0,
    1, 0x1E45, 0x006E, 0x0307, 0,
    1, 0x1E46, 0x004E, 0x0323, 0,
    1, 0x1E47, 0x006E, 0x0323, 0,
    1, 0x1E48, 0x004E, 0x0331, 0,
    1, 0x1E49, 0x006E, 0x0331, 0,
    1, 0x1E4A, 0x004E, 0x032D, 0,
    1, 0x1E4B, 0x006E, 0x032D, 0,
    1, 0x1E4C, 0x00D5, 0x0301, 0,
    1, 0x1E4D, 0x00F5, 0x0301, 0,
    1, 0x1E4E, 0x00D5, 0x0308, 0,
    1, 0x1E4F, 0x00F5, 0x0308, 0,
    1, 0x1E50, 0x014C, 0x0300, 0,
    1, 0x1E51, 0x014D, 0x0300, 0,
    1, 0x1E52, 0x014C, 0x0301, 0,
    1, 0x1E53, 0x014D, 0x0301, 0,
    1, 0x1E54, 0x0050, 0x0301, 0,
    1, 0x1E55, 0x0070, 0x0301, 0,
    1, 0x1E56, 0x0050, 0x0307, 0,
    1, 0x1E57, 0x0070, 0x0307, 0,
    1, 0x1E58, 0x0052, 0x0307, 0,
    1, 0x1E59, 0x0072, 0x0307, 0,
    1, 0x1E5A, 0x0052, 0x0323, 0,
    1, 0x1E5B, 0x0072, 0x0323, 0,
    1, 0x1E5C, 0x1E5A, 0x0304, 0,
    1, 0x1E5D, 0x1E5B, 0x0304, 0,
    1, 0x1E5E, 0x0052, 0x0331, 0,
    1, 0x1E5F, 0x0072, 0x0331, 0,
    1, 0x1E60, 0x0053, 0x0307, 0,
    1, 0x1E61, 0x0073, 0x0307, 0,
    1, 0x1E62, 0x0053, 0x0323, 0,
    1, 0x1E63, 0x0073, 0x0323, 0,
    1, 0x1E64, 0x015A, 0x0307, 0,
    1, 0x1E65, 0x015B, 0x0307, 0,
    1, 0x1E66, 0x0160, 0x0307, 0,
    1, 0x1E67, 0x0161, 0x0307, 0,
    1, 0x1E68, 0x1E62, 0x0307, 0,
    1, 0x1E69, 0x1E63, 0x0307, 0,
    1, 0x1E6A, 0x0054, 0x0307, 0,
    1, 0x1E6B, 0x0074, 0x0307, 0,
    1, 0x1E6C, 0x0054, 0x0323, 0,
    1, 0x1E6D, 0x0074, 0x0323, 0,
    1, 0x1E6E, 0x0054, 0x0331, 0,
    1, 0x1E6F, 0x0074, 0x0331, 0,
    1, 0x1E70, 0x0054, 0x032D, 0,
    1, 0x1E71, 0x0074, 0x032D, 0,
    1, 0x1E72, 0x0055, 0x0324, 0,
    1, 0x1E73, 0x0075, 0x0324, 0,
    1, 0x1E74, 0x0055, 0x0330, 0,
    1, 0x1E75, 0x0075, 0x0330, 0,
    1, 0x1E76, 0x0055, 0x032D, 0,
    1, 0x1E77, 0x0075, 0x032D, 0,
    1, 0x1E78, 0x0168, 0x0301, 0,
    1, 0x1E79, 0x0169, 0x0301, 0,
    1, 0x1E7A, 0x016A, 0x0308, 0,
    1, 0x1E7B, 0x016B, 0x0308, 0,
    1, 0x1E7C, 0x0056, 0x0303, 0,
    1, 0x1E7D, 0x0076, 0x0303, 0,
    1, 0x1E7E, 0x0056, 0x0323, 0,
    1, 0x1E7F, 0x0076, 0x0323, 0,
    1, 0x1E80, 0x0057, 0x0300, 0,
    1, 0x1E81, 0x0077, 0x0300, 0,
    1, 0x1E82, 0x0057, 0x0301, 0,
    1, 0x1E83, 0x0077, 0x0301, 0,
    1, 0x1E84, 0x0057, 0x0308, 0,
    1, 0x1E85, 0x0077, 0x0308, 0,
    1, 0x1E86, 0x0057, 0x0307, 0,
    1, 0x1E87, 0x0077, 0x0307, 0,
    1, 0x1E88, 0x0057, 0x0323, 0,
    1, 0x1E89, 0x0077, 0x0323, 0,
    1, 0x1E8A, 0x0058, 0x0307, 0,
    1, 0x1E8B, 0x0078, 0x0307, 0,
    1, 0x1E8C, 0x0058, 0x0308, 0,
    1, 0x1E8D, 0x0078, 0x0308, 0,
    1, 0x1E8E, 0x0059, 0x0307, 0,
    1, 0x1E8F, 0x0079, 0x0307, 0,
    1, 0x1E90, 0x005A, 0x0302, 0,
    1, 0x1E91, 0x007A, 0x0302, 0,
    1, 0x1E92, 0x005A, 0x0323, 0,
    1, 0x1E93, 0x007A, 0x0323, 0,
    1, 0x1E94, 0x005A, 0x0331, 0,
    1, 0x1E95, 0x007A, 0x0331, 0,
    1, 0x1E96, 0x0068, 0x0331, 0,
    1, 0x1E97, 0x0074, 0x0308, 0,
    1, 0x1E98, 0x0077, 0x030A, 0,
    1, 0x1E99, 0x0079, 0x030A, 0,
    16, 0x1E9A, 0x0061, 0x02BE, 0,
    1, 0x1E9B, 0x017F, 0x0307, 0,
    1, 0x1EA0, 0x0041, 0x0323, 0,
    1, 0x1EA1, 0x0061, 0x0323, 0,
    1, 0x1EA2, 0x0041, 0x0309, 0,
    1, 0x1EA3, 0x0061, 0x0309, 0,
    1, 0x1EA4, 0x00C2, 0x0301, 0,
    1, 0x1EA5, 0x00E2, 0x0301, 0,
    1, 0x1EA6, 0x00C2, 0x0300, 0,
    1, 0x1EA7, 0x00E2, 0x0300, 0,
    1, 0x1EA8, 0x00C2, 0x0309, 0,
    1, 0x1EA9, 0x00E2, 0x0309, 0,
    1, 0x1EAA, 0x00C2, 0x0303, 0,
    1, 0x1EAB, 0x00E2, 0x0303, 0,
    1, 0x1EAC, 0x1EA0, 0x0302, 0,
    1, 0x1EAD, 0x1EA1, 0x0302, 0,
    1, 0x1EAE, 0x0102, 0x0301, 0,
    1, 0x1EAF, 0x0103, 0x0301, 0,
    1, 0x1EB0, 0x0102, 0x0300, 0,
    1, 0x1EB1, 0x0103, 0x0300, 0,
    1, 0x1EB2, 0x0102, 0x0309, 0,
    1, 0x1EB3, 0x0103, 0x0309, 0,
    1, 0x1EB4, 0x0102, 0x0303, 0,
    1, 0x1EB5, 0x0103, 0x0303, 0,
    1, 0x1EB6, 0x1EA0, 0x0306, 0,
    1, 0x1EB7, 0x1EA1, 0x0306, 0,
    1, 0x1EB8, 0x0045, 0x0323, 0,
    1, 0x1EB9, 0x0065, 0x0323, 0,
    1, 0x1EBA, 0x0045, 0x0309, 0,
    1, 0x1EBB, 0x0065, 0x0309, 0,
    1, 0x1EBC, 0x0045, 0x0303, 0,
    1, 0x1EBD, 0x0065, 0x0303, 0,
    1, 0x1EBE, 0x00CA, 0x0301, 0,
    1, 0x1EBF, 0x00EA, 0x0301, 0,
    1, 0x1EC0, 0x00CA, 0x0300, 0,
    1, 0x1EC1, 0x00EA, 0x0300, 0,
    1, 0x1EC2, 0x00CA, 0x0309, 0,
    1, 0x1EC3, 0x00EA, 0x0309, 0,
    1, 0x1EC4, 0x00CA, 0x0303, 0,
    1, 0x1EC5, 0x00EA, 0x0303, 0,
    1, 0x1EC6, 0x1EB8, 0x0302, 0,
    1, 0x1EC7, 0x1EB9, 0x0302, 0,
    1, 0x1EC8, 0x0049, 0x0309, 0,
    1, 0x1EC9, 0x0069, 0x0309, 0,
    1, 0x1ECA, 0x0049, 0x0323, 0,
    1, 0x1ECB, 0x0069, 0x0323, 0,
    1, 0x1ECC, 0x004F, 0x0323, 0,
    1, 0x1ECD, 0x006F, 0x0323, 0,
    1, 0x1ECE, 0x004F, 0x0309, 0,
    1, 0x1ECF, 0x006F, 0x0309, 0,
    1, 0x1ED0, 0x00D4, 0x0301, 0,
    1, 0x1ED1, 0x00F4, 0x0301, 0,
    1, 0x1ED2, 0x00D4, 0x0300, 0,
    1, 0x1ED3, 0x00F4, 0x0300, 0,
    1, 0x1ED4, 0x00D4, 0x0309, 0,
    1, 0x1ED5, 0x00F4, 0x0309, 0,
    1, 0x1ED6, 0x00D4, 0x0303, 0,
    1, 0x1ED7, 0x00F4, 0x0303, 0,
    1, 0x1ED8, 0x1ECC, 0x0302, 0,
    1, 0x1ED9, 0x1ECD, 0x0302, 0,
    1, 0x1EDA, 0x01A0, 0x0301, 0,
    1, 0x1EDB, 0x01A1, 0x0301, 0,
    1, 0x1EDC, 0x01A0, 0x0300, 0,
    1, 0x1EDD, 0x01A1, 0x0300, 0,
    1, 0x1EDE, 0x01A0, 0x0309, 0,
    1, 0x1EDF, 0x01A1, 0x0309, 0,
    1, 0x1EE0, 0x01A0, 0x0303, 0,
    1, 0x1EE1, 0x01A1, 0x0303, 0,
    1, 0x1EE2, 0x01A0, 0x0323, 0,
    1, 0x1EE3, 0x01A1, 0x0323, 0,
    1, 0x1EE4, 0x0055, 0x0323, 0,
    1, 0x1EE5, 0x0075, 0x0323, 0,
    1, 0x1EE6, 0x0055, 0x0309, 0,
    1, 0x1EE7, 0x0075, 0x0309, 0,
    1, 0x1EE8, 0x01AF, 0x0301, 0,
    1, 0x1EE9, 0x01B0, 0x0301, 0,
    1, 0x1EEA, 0x01AF, 0x0300, 0,
    1, 0x1EEB, 0x01B0, 0x0300, 0,
    1, 0x1EEC, 0x01AF, 0x0309, 0,
    1, 0x1EED, 0x01B0, 0x0309, 0,
    1, 0x1EEE, 0x01AF, 0x0303, 0,
    1, 0x1EEF, 0x01B0, 0x0303, 0,
    1, 0x1EF0, 0x01AF, 0x0323, 0,
    1, 0x1EF1, 0x01B0, 0x0323, 0,
    1, 0x1EF2, 0x0059, 0x0300, 0,
    1, 0x1EF3, 0x0079, 0x0300, 0,
    1, 0x1EF4, 0x0059, 0x0323, 0,
    1, 0x1EF5, 0x0079, 0x0323, 0,
    1, 0x1EF6, 0x0059, 0x0309, 0,
    1, 0x1EF7, 0x0079, 0x0309, 0,
    1, 0x1EF8, 0x0059, 0x0303, 0,
    1, 0x1EF9, 0x0079, 0x0303, 0,
    1, 0x1F00, 0x03B1, 0x0313, 0,
    1, 0x1F01, 0x03B1, 0x0314, 0,
    1, 0x1F02, 0x1F00, 0x0300, 0,
    1, 0x1F03, 0x1F01, 0x0300, 0,
    1, 0x1F04, 0x1F00, 0x0301, 0,
    1, 0x1F05, 0x1F01, 0x0301, 0,
    1, 0x1F06, 0x1F00, 0x0342, 0,
    1, 0x1F07, 0x1F01, 0x0342, 0,
    1, 0x1F08, 0x0391, 0x0313, 0,
    1, 0x1F09, 0x0391, 0x0314, 0,
    1, 0x1F0A, 0x1F08, 0x0300, 0,
    1, 0x1F0B, 0x1F09, 0x0300, 0,
    1, 0x1F0C, 0x1F08, 0x0301, 0,
    1, 0x1F0D, 0x1F09, 0x0301, 0,
    1, 0x1F0E, 0x1F08, 0x0342, 0,
    1, 0x1F0F, 0x1F09, 0x0342, 0,
    1, 0x1F10, 0x03B5, 0x0313, 0,
    1, 0x1F11, 0x03B5, 0x0314, 0,
    1, 0x1F12, 0x1F10, 0x0300, 0,
    1, 0x1F13, 0x1F11, 0x0300, 0,
    1, 0x1F14, 0x1F10, 0x0301, 0,
    1, 0x1F15, 0x1F11, 0x0301, 0,
    1, 0x1F18, 0x0395, 0x0313, 0,
    1, 0x1F19, 0x0395, 0x0314, 0,
    1, 0x1F1A, 0x1F18, 0x0300, 0,
    1, 0x1F1B, 0x1F19, 0x0300, 0,
    1, 0x1F1C, 0x1F18, 0x0301, 0,
    1, 0x1F1D, 0x1F19, 0x0301, 0,
    1, 0x1F20, 0x03B7, 0x0313, 0,
    1, 0x1F21, 0x03B7, 0x0314, 0,
    1, 0x1F22, 0x1F20, 0x0300, 0,
    1, 0x1F23, 0x1F21, 0x0300, 0,
    1, 0x1F24, 0x1F20, 0x0301, 0,
    1, 0x1F25, 0x1F21, 0x0301, 0,
    1, 0x1F26, 0x1F20, 0x0342, 0,
    1, 0x1F27, 0x1F21, 0x0342, 0,
    1, 0x1F28, 0x0397, 0x0313, 0,
    1, 0x1F29, 0x0397, 0x0314, 0,
    1, 0x1F2A, 0x1F28, 0x0300, 0,
    1, 0x1F2B, 0x1F29, 0x0300, 0,
    1, 0x1F2C, 0x1F28, 0x0301, 0,
    1, 0x1F2D, 0x1F29, 0x0301, 0,
    1, 0x1F2E, 0x1F28, 0x0342, 0,
    1, 0x1F2F, 0x1F29, 0x0342, 0,
    1, 0x1F30, 0x03B9, 0x0313, 0,
    1, 0x1F31, 0x03B9, 0x0314, 0,
    1, 0x1F32, 0x1F30, 0x0300, 0,
    1, 0x1F33, 0x1F31, 0x0300, 0,
    1, 0x1F34, 0x1F30, 0x0301, 0,
    1, 0x1F35, 0x1F31, 0x0301, 0,
    1, 0x1F36, 0x1F30, 0x0342, 0,
    1, 0x1F37, 0x1F31, 0x0342, 0,
    1, 0x1F38, 0x0399, 0x0313, 0,
    1, 0x1F39, 0x0399, 0x0314, 0,
    1, 0x1F3A, 0x1F38, 0x0300, 0,
    1, 0x1F3B, 0x1F39, 0x0300, 0,
    1, 0x1F3C, 0x1F38, 0x0301, 0,
    1, 0x1F3D, 0x1F39, 0x0301, 0,
    1, 0x1F3E, 0x1F38, 0x0342, 0,
    1, 0x1F3F, 0x1F39, 0x0342, 0,
    1, 0x1F40, 0x03BF, 0x0313, 0,
    1, 0x1F41, 0x03BF, 0x0314, 0,
    1, 0x1F42, 0x1F40, 0x0300, 0,
    1, 0x1F43, 0x1F41, 0x0300, 0,
    1, 0x1F44, 0x1F40, 0x0301, 0,
    1, 0x1F45, 0x1F41, 0x0301, 0,
    1, 0x1F48, 0x039F, 0x0313, 0,
    1, 0x1F49, 0x039F, 0x0314, 0,
    1, 0x1F4A, 0x1F48, 0x0300, 0,
    1, 0x1F4B, 0x1F49, 0x0300, 0,
    1, 0x1F4C, 0x1F48, 0x0301, 0,
    1, 0x1F4D, 0x1F49, 0x0301, 0,
    1, 0x1F50, 0x03C5, 0x0313, 0,
    1, 0x1F51, 0x03C5, 0x0314, 0,
    1, 0x1F52, 0x1F50, 0x0300, 0,
    1, 0x1F53, 0x1F51, 0x0300, 0,
    1, 0x1F54, 0x1F50, 0x0301, 0,
    1, 0x1F55, 0x1F51, 0x0301, 0,
    1, 0x1F56, 0x1F50, 0x0342, 0,
    1, 0x1F57, 0x1F51, 0x0342, 0,
    1, 0x1F59, 0x03A5, 0x0314, 0,
    1, 0x1F5B, 0x1F59, 0x0300, 0,
    1, 0x1F5D, 0x1F59, 0x0301, 0,
    1, 0x1F5F, 0x1F59, 0x0342, 0,
    1, 0x1F60, 0x03C9, 0x0313, 0,
    1, 0x1F61, 0x03C9, 0x0314, 0,
    1, 0x1F62, 0x1F60, 0x0300, 0,
    1, 0x1F63, 0x1F61, 0x0300, 0,
    1, 0x1F64, 0x1F60, 0x0301, 0,
    1, 0x1F65, 0x1F61, 0x0301, 0,
    1, 0x1F66, 0x1F60, 0x0342, 0,
    1, 0x1F67, 0x1F61, 0x0342, 0,
    1, 0x1F68, 0x03A9, 0x0313, 0,
    1, 0x1F69, 0x03A9, 0x0314, 0,
    1, 0x1F6A, 0x1F68, 0x0300, 0,
    1, 0x1F6B, 0x1F69, 0x0300, 0,
    1, 0x1F6C, 0x1F68, 0x0301, 0,
    1, 0x1F6D, 0x1F69, 0x0301, 0,
    1, 0x1F6E, 0x1F68, 0x0342, 0,
    1, 0x1F6F, 0x1F69, 0x0342, 0,
    1, 0x1F70, 0x03B1, 0x0300, 0,
    1, 0x1F71, 0x03AC, 0,
    1, 0x1F72, 0x03B5, 0x0300, 0,
    1, 0x1F73, 0x03AD, 0,
    1, 0x1F74, 0x03B7, 0x0300, 0,
    1, 0x1F75, 0x03AE, 0,
    1, 0x1F76, 0x03B9, 0x0300, 0,
    1, 0x1F77, 0x03AF, 0,
    1, 0x1F78, 0x03BF, 0x0300, 0,
    1, 0x1F79, 0x03CC, 0,
    1, 0x1F7A, 0x03C5, 0x0300, 0,
    1, 0x1F7B, 0x03CD, 0,
    1, 0x1F7C, 0x03C9, 0x0300, 0,
    1, 0x1F7D, 0x03CE, 0,
    1, 0x1F80, 0x1F00, 0x0345, 0,
    1, 0x1F81, 0x1F01, 0x0345, 0,
    1, 0x1F82, 0x1F02, 0x0345, 0,
    1, 0x1F83, 0x1F03, 0x0345, 0,
    1, 0x1F84, 0x1F04, 0x0345, 0,
    1, 0x1F85, 0x1F05, 0x0345, 0,
    1, 0x1F86, 0x1F06, 0x0345, 0,
    1, 0x1F87, 0x1F07, 0x0345, 0,
    1, 0x1F88, 0x1F08, 0x0345, 0,
    1, 0x1F89, 0x1F09, 0x0345, 0,
    1, 0x1F8A, 0x1F0A, 0x0345, 0,
    1, 0x1F8B, 0x1F0B, 0x0345, 0,
    1, 0x1F8C, 0x1F0C, 0x0345, 0,
    1, 0x1F8D, 0x1F0D, 0x0345, 0,
    1, 0x1F8E, 0x1F0E, 0x0345, 0,
    1, 0x1F8F, 0x1F0F, 0x0345, 0,
    1, 0x1F90, 0x1F20, 0x0345, 0,
    1, 0x1F91, 0x1F21, 0x0345, 0,
    1, 0x1F92, 0x1F22, 0x0345, 0,
    1, 0x1F93, 0x1F23, 0x0345, 0,
    1, 0x1F94, 0x1F24, 0x0345, 0,
    1, 0x1F95, 0x1F25, 0x0345, 0,
    1, 0x1F96, 0x1F26, 0x0345, 0,
    1, 0x1F97, 0x1F27, 0x0345, 0,
    1, 0x1F98, 0x1F28, 0x0345, 0,
    1, 0x1F99, 0x1F29, 0x0345, 0,
    1, 0x1F9A, 0x1F2A, 0x0345, 0,
    1, 0x1F9B, 0x1F2B, 0x0345, 0,
    1, 0x1F9C, 0x1F2C, 0x0345, 0,
    1, 0x1F9D, 0x1F2D, 0x0345, 0,
    1, 0x1F9E, 0x1F2E, 0x0345, 0,
    1, 0x1F9F, 0x1F2F, 0x0345, 0,
    1, 0x1FA0, 0x1F60, 0x0345, 0,
    1, 0x1FA1, 0x1F61, 0x0345, 0,
    1, 0x1FA2, 0x1F62, 0x0345, 0,
    1, 0x1FA3, 0x1F63, 0x0345, 0,
    1, 0x1FA4, 0x1F64, 0x0345, 0,
    1, 0x1FA5, 0x1F65, 0x0345, 0,
    1, 0x1FA6, 0x1F66, 0x0345, 0,
    1, 0x1FA7, 0x1F67, 0x0345, 0,
    1, 0x1FA8, 0x1F68, 0x0345, 0,
    1, 0x1FA9, 0x1F69, 0x0345, 0,
    1, 0x1FAA, 0x1F6A, 0x0345, 0,
    1, 0x1FAB, 0x1F6B, 0x0345, 0,
    1, 0x1FAC, 0x1F6C, 0x0345, 0,
    1, 0x1FAD, 0x1F6D, 0x0345, 0,
    1, 0x1FAE, 0x1F6E, 0x0345, 0,
    1, 0x1FAF, 0x1F6F, 0x0345, 0,
    1, 0x1FB0, 0x03B1, 0x0306, 0,
    1, 0x1FB1, 0x03B1, 0x0304, 0,
    1, 0x1FB2, 0x1F70, 0x0345, 0,
    1, 0x1FB3, 0x03B1, 0x0345, 0,
    1, 0x1FB4, 0x03AC, 0x0345, 0,
    1, 0x1FB6, 0x03B1, 0x0342, 0,
    1, 0x1FB7, 0x1FB6, 0x0345, 0,
    1, 0x1FB8, 0x0391, 0x0306, 0,
    1, 0x1FB9, 0x0391, 0x0304, 0,
    1, 0x1FBA, 0x0391, 0x0300, 0,
    1, 0x1FBB, 0x0386, 0,
    1, 0x1FBC, 0x0391, 0x0345, 0,
    16, 0x1FBD, 0x0020, 0x0313, 0,
    1, 0x1FBE, 0x03B9, 0,
    16, 0x1FBF, 0x0020, 0x0313, 0,
    16, 0x1FC0, 0x0020, 0x0342, 0,
    1, 0x1FC1, 0x00A8, 0x0342, 0,
    1, 0x1FC2, 0x1F74, 0x0345, 0,
    1, 0x1FC3, 0x03B7, 0x0345, 0,
    1, 0x1FC4, 0x03AE, 0x0345, 0,
    1, 0x1FC6, 0x03B7, 0x0342, 0,
    1, 0x1FC7, 0x1FC6, 0x0345, 0,
    1, 0x1FC8, 0x0395, 0x0300, 0,
    1, 0x1FC9, 0x0388, 0,
    1, 0x1FCA, 0x0397, 0x0300, 0,
    1, 0x1FCB, 0x0389, 0,
    1, 0x1FCC, 0x0397, 0x0345, 0,
    1, 0x1FCD, 0x1FBF, 0x0300, 0,
    1, 0x1FCE, 0x1FBF, 0x0301, 0,
    1, 0x1FCF, 0x1FBF, 0x0342, 0,
    1, 0x1FD0, 0x03B9, 0x0306, 0,
    1, 0x1FD1, 0x03B9, 0x0304, 0,
    1, 0x1FD2, 0x03CA, 0x0300, 0,
    1, 0x1FD3, 0x0390, 0,
    1, 0x1FD6, 0x03B9, 0x0342, 0,
    1, 0x1FD7, 0x03CA, 0x0342, 0,
    1, 0x1FD8, 0x0399, 0x0306, 0,
    1, 0x1FD9, 0x0399, 0x0304, 0,
    1, 0x1FDA, 0x0399, 0x0300, 0,
    1, 0x1FDB, 0x038A, 0,
    1, 0x1FDD, 0x1FFE, 0x0300, 0,
    1, 0x1FDE, 0x1FFE, 0x0301, 0,
    1, 0x1FDF, 0x1FFE, 0x0342, 0,
    1, 0x1FE0, 0x03C5, 0x0306, 0,
    1, 0x1FE1, 0x03C5, 0x0304, 0,
    1, 0x1FE2, 0x03CB, 0x0300, 0,
    1, 0x1FE3, 0x03B0, 0,
    1, 0x1FE4, 0x03C1, 0x0313, 0,
    1, 0x1FE5, 0x03C1, 0x0314, 0,
    1, 0x1FE6, 0x03C5, 0x0342, 0,
    1, 0x1FE7, 0x03CB, 0x0342, 0,
    1, 0x1FE8, 0x03A5, 0x0306, 0,
    1, 0x1FE9, 0x03A5, 0x0304, 0,
    1, 0x1FEA, 0x03A5, 0x0300, 0,
    1, 0x1FEB, 0x038E, 0,
    1, 0x1FEC, 0x03A1, 0x0314, 0,
    1, 0x1FED, 0x00A8, 0x0300, 0,
    1, 0x1FEE, 0x0385, 0,
    1, 0x1FEF, 0x0060, 0,
    1, 0x1FF2, 0x1F7C, 0x0345, 0,
    1, 0x1FF3, 0x03C9, 0x0345, 0,
    1, 0x1FF4, 0x03CE, 0x0345, 0,
    1, 0x1FF6, 0x03C9, 0x0342, 0,
    1, 0x1FF7, 0x1FF6, 0x0345, 0,
    1, 0x1FF8, 0x039F, 0x0300, 0,
    1, 0x1FF9, 0x038C, 0,
    1, 0x1FFA, 0x03A9, 0x0300, 0,
    1, 0x1FFB, 0x038F, 0,
    1, 0x1FFC, 0x03A9, 0x0345, 0,
    1, 0x1FFD, 0x00B4, 0,
    16, 0x1FFE, 0x0020, 0x0314, 0,
    1, 0x2000, 0x2002, 0,
    1, 0x2001, 0x2003, 0,
    16, 0x2002, 0x0020, 0,
    16, 0x2003, 0x0020, 0,
    16, 0x2004, 0x0020, 0,
    16, 0x2005, 0x0020, 0,
    16, 0x2006, 0x0020, 0,
    3, 0x2007, 0x0020, 0,
    16, 0x2008, 0x0020, 0,
    16, 0x2009, 0x0020, 0,
    16, 0x200A, 0x0020, 0,
    3, 0x2011, 0x2010, 0,
    16, 0x2017, 0x0020, 0x0333, 0,
    16, 0x2024, 0x002E, 0,
    16, 0x2025, 0x002E, 0x002E, 0,
    16, 0x2026, 0x002E, 0x002E, 0x002E, 0,
    3, 0x202F, 0x0020, 0,
    16, 0x2033, 0x2032, 0x2032, 0,
    16, 0x2034, 0x2032, 0x2032, 0x2032, 0,
    16, 0x2036, 0x2035, 0x2035, 0,
    16, 0x2037, 0x2035, 0x2035, 0x2035, 0,
    16, 0x203C, 0x0021, 0x0021, 0,
    16, 0x203E, 0x0020, 0x0305, 0,
    16, 0x2047, 0x003F, 0x003F, 0,
    16, 0x2048, 0x003F, 0x0021, 0,
    16, 0x2049, 0x0021, 0x003F, 0,
    16, 0x2057, 0x2032, 0x2032, 0x2032, 0x2032, 0,
    16, 0x205F, 0x0020, 0,
    9, 0x2070, 0x0030, 0,
    9, 0x2071, 0x0069, 0,
    9, 0x2074, 0x0034, 0,
    9, 0x2075, 0x0035, 0,
    9, 0x2076, 0x0036, 0,
    9, 0x2077, 0x0037, 0,
    9, 0x2078, 0x0038, 0,
    9, 0x2079, 0x0039, 0,
    9, 0x207A, 0x002B, 0,
    9, 0x207B, 0x2212, 0,
    9, 0x207C, 0x003D, 0,
    9, 0x207D, 0x0028, 0,
    9, 0x207E, 0x0029, 0,
    9, 0x207F, 0x006E, 0,
    10, 0x2080, 0x0030, 0,
    10, 0x2081, 0x0031, 0,
    10, 0x2082, 0x0032, 0,
    10, 0x2083, 0x0033, 0,
    10, 0x2084, 0x0034, 0,
    10, 0x2085, 0x0035, 0,
    10, 0x2086, 0x0036, 0,
    10, 0x2087, 0x0037, 0,
    10, 0x2088, 0x0038, 0,
    10, 0x2089, 0x0039, 0,
    10, 0x208A, 0x002B, 0,
    10, 0x208B, 0x2212, 0,
    10, 0x208C, 0x003D, 0,
    10, 0x208D, 0x0028, 0,
    10, 0x208E, 0x0029, 0,
    16, 0x20A8, 0x0052, 0x0073, 0,
    16, 0x2100, 0x0061, 0x002F, 0x0063, 0,
    16, 0x2101, 0x0061, 0x002F, 0x0073, 0,
    2, 0x2102, 0x0043, 0,
    16, 0x2103, 0x00B0, 0x0043, 0,
    16, 0x2105, 0x0063, 0x002F, 0x006F, 0,
    16, 0x2106, 0x0063, 0x002F, 0x0075, 0,
    16, 0x2107, 0x0190, 0,
    16, 0x2109, 0x00B0, 0x0046, 0,
    2, 0x210A, 0x0067, 0,
    2, 0x210B, 0x0048, 0,
    2, 0x210C, 0x0048, 0,
    2, 0x210D, 0x0048, 0,
    2, 0x210E, 0x0068, 0,
    2, 0x210F, 0x0127, 0,
    2, 0x2110, 0x0049, 0,
    2, 0x2111, 0x0049, 0,
    2, 0x2112, 0x004C, 0,
    2, 0x2113, 0x006C, 0,
    2, 0x2115, 0x004E, 0,
    16, 0x2116, 0x004E, 0x006F, 0,
    2, 0x2119, 0x0050, 0,
    2, 0x211A, 0x0051, 0,
    2, 0x211B, 0x0052, 0,
    2, 0x211C, 0x0052, 0,
    2, 0x211D, 0x0052, 0,
    9, 0x2120, 0x0053, 0x004D, 0,
    16, 0x2121, 0x0054, 0x0045, 0x004C, 0,
    9, 0x2122, 0x0054, 0x004D, 0,
    2, 0x2124, 0x005A, 0,
    1, 0x2126, 0x03A9, 0,
    2, 0x2128, 0x005A, 0,
    1, 0x212A, 0x004B, 0,
    1, 0x212B, 0x00C5, 0,
    2, 0x212C, 0x0042, 0,
    2, 0x212D, 0x0043, 0,
    2, 0x212F, 0x0065, 0,
    2, 0x2130, 0x0045, 0,
    2, 0x2131, 0x0046, 0,
    2, 0x2133, 0x004D, 0,
    2, 0x2134, 0x006F, 0,
    16, 0x2135, 0x05D0, 0,
    16, 0x2136, 0x05D1, 0,
    16, 0x2137, 0x05D2, 0,
    16, 0x2138, 0x05D3, 0,
    2, 0x2139, 0x0069, 0,
    2, 0x213D, 0x03B3, 0,
    2, 0x213E, 0x0393, 0,
    2, 0x213F, 0x03A0, 0,
    2, 0x2140, 0x2211, 0,
    2, 0x2145, 0x0044, 0,
    2, 0x2146, 0x0064, 0,
    2, 0x2147, 0x0065, 0,
    2, 0x2148, 0x0069, 0,
    2, 0x2149, 0x006A, 0,
    17, 0x2153, 0x0031, 0x2044, 0x0033, 0,
    17, 0x2154, 0x0032, 0x2044, 0x0033, 0,
    17, 0x2155, 0x0031, 0x2044, 0x0035, 0,
    17, 0x2156, 0x0032, 0x2044, 0x0035, 0,
    17, 0x2157, 0x0033, 0x2044, 0x0035, 0,
    17, 0x2158, 0x0034, 0x2044, 0x0035, 0,
    17, 0x2159, 0x0031, 0x2044, 0x0036, 0,
    17, 0x215A, 0x0035, 0x2044, 0x0036, 0,
    17, 0x215B, 0x0031, 0x2044, 0x0038, 0,
    17, 0x215C, 0x0033, 0x2044, 0x0038, 0,
    17, 0x215D, 0x0035, 0x2044, 0x0038, 0,
    17, 0x215E, 0x0037, 0x2044, 0x0038, 0,
    17, 0x215F, 0x0031, 0x2044, 0,
    16, 0x2160, 0x0049, 0,
    16, 0x2161, 0x0049, 0x0049, 0,
    16, 0x2162, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2163, 0x0049, 0x0056, 0,
    16, 0x2164, 0x0056, 0,
    16, 0x2165, 0x0056, 0x0049, 0,
    16, 0x2166, 0x0056, 0x0049, 0x0049, 0,
    16, 0x2167, 0x0056, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2168, 0x0049, 0x0058, 0,
    16, 0x2169, 0x0058, 0,
    16, 0x216A, 0x0058, 0x0049, 0,
    16, 0x216B, 0x0058, 0x0049, 0x0049, 0,
    16, 0x216C, 0x004C, 0,
    16, 0x216D, 0x0043, 0,
    16, 0x216E, 0x0044, 0,
    16, 0x216F, 0x004D, 0,
    16, 0x2170, 0x0069, 0,
    16, 0x2171, 0x0069, 0x0069, 0,
    16, 0x2172, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2173, 0x0069, 0x0076, 0,
    16, 0x2174, 0x0076, 0,
    16, 0x2175, 0x0076, 0x0069, 0,
    16, 0x2176, 0x0076, 0x0069, 0x0069, 0,
    16, 0x2177, 0x0076, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2178, 0x0069, 0x0078, 0,
    16, 0x2179, 0x0078, 0,
    16, 0x217A, 0x0078, 0x0069, 0,
    16, 0x217B, 0x0078, 0x0069, 0x0069, 0,
    16, 0x217C, 0x006C, 0,
    16, 0x217D, 0x0063, 0,
    16, 0x217E, 0x0064, 0,
    16, 0x217F, 0x006D, 0,
    1, 0x219A, 0x2190, 0x0338, 0,
    1, 0x219B, 0x2192, 0x0338, 0,
    1, 0x21AE, 0x2194, 0x0338, 0,
    1, 0x21CD, 0x21D0, 0x0338, 0,
    1, 0x21CE, 0x21D4, 0x0338, 0,
    1, 0x21CF, 0x21D2, 0x0338, 0,
    1, 0x2204, 0x2203, 0x0338, 0,
    1, 0x2209, 0x2208, 0x0338, 0,
    1, 0x220C, 0x220B, 0x0338, 0,
    1, 0x2224, 0x2223, 0x0338, 0,
    1, 0x2226, 0x2225, 0x0338, 0,
    16, 0x222C, 0x222B, 0x222B, 0,
    16, 0x222D, 0x222B, 0x222B, 0x222B, 0,
    16, 0x222F, 0x222E, 0x222E, 0,
    16, 0x2230, 0x222E, 0x222E, 0x222E, 0,
    1, 0x2241, 0x223C, 0x0338, 0,
    1, 0x2244, 0x2243, 0x0338, 0,
    1, 0x2247, 0x2245, 0x0338, 0,
    1, 0x2249, 0x2248, 0x0338, 0,
    1, 0x2260, 0x003D, 0x0338, 0,
    1, 0x2262, 0x2261, 0x0338, 0,
    1, 0x226D, 0x224D, 0x0338, 0,
    1, 0x226E, 0x003C, 0x0338, 0,
    1, 0x226F, 0x003E, 0x0338, 0,
    1, 0x2270, 0x2264, 0x0338, 0,
    1, 0x2271, 0x2265, 0x0338, 0,
    1, 0x2274, 0x2272, 0x0338, 0,
    1, 0x2275, 0x2273, 0x0338, 0,
    1, 0x2278, 0x2276, 0x0338, 0,
    1, 0x2279, 0x2277, 0x0338, 0,
    1, 0x2280, 0x227A, 0x0338, 0,
    1, 0x2281, 0x227B, 0x0338, 0,
    1, 0x2284, 0x2282, 0x0338, 0,
    1, 0x2285, 0x2283, 0x0338, 0,
    1, 0x2288, 0x2286, 0x0338, 0,
    1, 0x2289, 0x2287, 0x0338, 0,
    1, 0x22AC, 0x22A2, 0x0338, 0,
    1, 0x22AD, 0x22A8, 0x0338, 0,
    1, 0x22AE, 0x22A9, 0x0338, 0,
    1, 0x22AF, 0x22AB, 0x0338, 0,
    1, 0x22E0, 0x227C, 0x0338, 0,
    1, 0x22E1, 0x227D, 0x0338, 0,
    1, 0x22E2, 0x2291, 0x0338, 0,
    1, 0x22E3, 0x2292, 0x0338, 0,
    1, 0x22EA, 0x22B2, 0x0338, 0,
    1, 0x22EB, 0x22B3, 0x0338, 0,
    1, 0x22EC, 0x22B4, 0x0338, 0,
    1, 0x22ED, 0x22B5, 0x0338, 0,
    1, 0x2329, 0x3008, 0,
    1, 0x232A, 0x3009, 0,
    8, 0x2460, 0x0031, 0,
    8, 0x2461, 0x0032, 0,
    8, 0x2462, 0x0033, 0,
    8, 0x2463, 0x0034, 0,
    8, 0x2464, 0x0035, 0,
    8, 0x2465, 0x0036, 0,
    8, 0x2466, 0x0037, 0,
    8, 0x2467, 0x0038, 0,
    8, 0x2468, 0x0039, 0,
    8, 0x2469, 0x0031, 0x0030, 0,
    8, 0x246A, 0x0031, 0x0031, 0,
    8, 0x246B, 0x0031, 0x0032, 0,
    8, 0x246C, 0x0031, 0x0033, 0,
    8, 0x246D, 0x0031, 0x0034, 0,
    8, 0x246E, 0x0031, 0x0035, 0,
    8, 0x246F, 0x0031, 0x0036, 0,
    8, 0x2470, 0x0031, 0x0037, 0,
    8, 0x2471, 0x0031, 0x0038, 0,
    8, 0x2472, 0x0031, 0x0039, 0,
    8, 0x2473, 0x0032, 0x0030, 0,
    16, 0x2474, 0x0028, 0x0031, 0x0029, 0,
    16, 0x2475, 0x0028, 0x0032, 0x0029, 0,
    16, 0x2476, 0x0028, 0x0033, 0x0029, 0,
    16, 0x2477, 0x0028, 0x0034, 0x0029, 0,
    16, 0x2478, 0x0028, 0x0035, 0x0029, 0,
    16, 0x2479, 0x0028, 0x0036, 0x0029, 0,
    16, 0x247A, 0x0028, 0x0037, 0x0029, 0,
    16, 0x247B, 0x0028, 0x0038, 0x0029, 0,
    16, 0x247C, 0x0028, 0x0039, 0x0029, 0,
    16, 0x247D, 0x0028, 0x0031, 0x0030, 0x0029, 0,
    16, 0x247E, 0x0028, 0x0031, 0x0031, 0x0029, 0,
    16, 0x247F, 0x0028, 0x0031, 0x0032, 0x0029, 0,
    16, 0x2480, 0x0028, 0x0031, 0x0033, 0x0029, 0,
    16, 0x2481, 0x0028, 0x0031, 0x0034, 0x0029, 0,
    16, 0x2482, 0x0028, 0x0031, 0x0035, 0x0029, 0,
    16, 0x2483, 0x0028, 0x0031, 0x0036, 0x0029, 0,
    16, 0x2484, 0x0028, 0x0031, 0x0037, 0x0029, 0,
    16, 0x2485, 0x0028, 0x0031, 0x0038, 0x0029, 0,
    16, 0x2486, 0x0028, 0x0031, 0x0039, 0x0029, 0,
    16, 0x2487, 0x0028, 0x0032, 0x0030, 0x0029, 0,
    16, 0x2488, 0x0031, 0x002E, 0,
    16, 0x2489, 0x0032, 0x002E, 0,
    16, 0x248A, 0x0033, 0x002E, 0,
    16, 0x248B, 0x0034, 0x002E, 0,
    16, 0x248C, 0x0035, 0x002E, 0,
    16, 0x248D, 0x0036, 0x002E, 0,
    16, 0x248E, 0x0037, 0x002E, 0,
    16, 0x248F, 0x0038, 0x002E, 0,
    16, 0x2490, 0x0039, 0x002E, 0,
    16, 0x2491, 0x0031, 0x0030, 0x002E, 0,
    16, 0x2492, 0x0031, 0x0031, 0x002E, 0,
    16, 0x2493, 0x0031, 0x0032, 0x002E, 0,
    16, 0x2494, 0x0031, 0x0033, 0x002E, 0,
    16, 0x2495, 0x0031, 0x0034, 0x002E, 0,
    16, 0x2496, 0x0031, 0x0035, 0x002E, 0,
    16, 0x2497, 0x0031, 0x0036, 0x002E, 0,
    16, 0x2498, 0x0031, 0x0037, 0x002E, 0,
    16, 0x2499, 0x0031, 0x0038, 0x002E, 0,
    16, 0x249A, 0x0031, 0x0039, 0x002E, 0,
    16, 0x249B, 0x0032, 0x0030, 0x002E, 0,
    16, 0x249C, 0x0028, 0x0061, 0x0029, 0,
    16, 0x249D, 0x0028, 0x0062, 0x0029, 0,
    16, 0x249E, 0x0028, 0x0063, 0x0029, 0,
    16, 0x249F, 0x0028, 0x0064, 0x0029, 0,
    16, 0x24A0, 0x0028, 0x0065, 0x0029, 0,
    16, 0x24A1, 0x0028, 0x0066, 0x0029, 0,
    16, 0x24A2, 0x0028, 0x0067, 0x0029, 0,
    16, 0x24A3, 0x0028, 0x0068, 0x0029, 0,
    16, 0x24A4, 0x0028, 0x0069, 0x0029, 0,
    16, 0x24A5, 0x0028, 0x006A, 0x0029, 0,
    16, 0x24A6, 0x0028, 0x006B, 0x0029, 0,
    16, 0x24A7, 0x0028, 0x006C, 0x0029, 0,
    16, 0x24A8, 0x0028, 0x006D, 0x0029, 0,
    16, 0x24A9, 0x0028, 0x006E, 0x0029, 0,
    16, 0x24AA, 0x0028, 0x006F, 0x0029, 0,
    16, 0x24AB, 0x0028, 0x0070, 0x0029, 0,
    16, 0x24AC, 0x0028, 0x0071, 0x0029, 0,
    16, 0x24AD, 0x0028, 0x0072, 0x0029, 0,
    16, 0x24AE, 0x0028, 0x0073, 0x0029, 0,
    16, 0x24AF, 0x0028, 0x0074, 0x0029, 0,
    16, 0x24B0, 0x0028, 0x0075, 0x0029, 0,
    16, 0x24B1, 0x0028, 0x0076, 0x0029, 0,
    16, 0x24B2, 0x0028, 0x0077, 0x0029, 0,
    16, 0x24B3, 0x0028, 0x0078, 0x0029, 0,
    16, 0x24B4, 0x0028, 0x0079, 0x0029, 0,
    16, 0x24B5, 0x0028, 0x007A, 0x0029, 0,
    8, 0x24B6, 0x0041, 0,
    8, 0x24B7, 0x0042, 0,
    8, 0x24B8, 0x0043, 0,
    8, 0x24B9, 0x0044, 0,
    8, 0x24BA, 0x0045, 0,
    8, 0x24BB, 0x0046, 0,
    8, 0x24BC, 0x0047, 0,
    8, 0x24BD, 0x0048, 0,
    8, 0x24BE, 0x0049, 0,
    8, 0x24BF, 0x004A, 0,
    8, 0x24C0, 0x004B, 0,
    8, 0x24C1, 0x004C, 0,
    8, 0x24C2, 0x004D, 0,
    8, 0x24C3, 0x004E, 0,
    8, 0x24C4, 0x004F, 0,
    8, 0x24C5, 0x0050, 0,
    8, 0x24C6, 0x0051, 0,
    8, 0x24C7, 0x0052, 0,
    8, 0x24C8, 0x0053, 0,
    8, 0x24C9, 0x0054, 0,
    8, 0x24CA, 0x0055, 0,
    8, 0x24CB, 0x0056, 0,
    8, 0x24CC, 0x0057, 0,
    8, 0x24CD, 0x0058, 0,
    8, 0x24CE, 0x0059, 0,
    8, 0x24CF, 0x005A, 0,
    8, 0x24D0, 0x0061, 0,
    8, 0x24D1, 0x0062, 0,
    8, 0x24D2, 0x0063, 0,
    8, 0x24D3, 0x0064, 0,
    8, 0x24D4, 0x0065, 0,
    8, 0x24D5, 0x0066, 0,
    8, 0x24D6, 0x0067, 0,
    8, 0x24D7, 0x0068, 0,
    8, 0x24D8, 0x0069, 0,
    8, 0x24D9, 0x006A, 0,
    8, 0x24DA, 0x006B, 0,
    8, 0x24DB, 0x006C, 0,
    8, 0x24DC, 0x006D, 0,
    8, 0x24DD, 0x006E, 0,
    8, 0x24DE, 0x006F, 0,
    8, 0x24DF, 0x0070, 0,
    8, 0x24E0, 0x0071, 0,
    8, 0x24E1, 0x0072, 0,
    8, 0x24E2, 0x0073, 0,
    8, 0x24E3, 0x0074, 0,
    8, 0x24E4, 0x0075, 0,
    8, 0x24E5, 0x0076, 0,
    8, 0x24E6, 0x0077, 0,
    8, 0x24E7, 0x0078, 0,
    8, 0x24E8, 0x0079, 0,
    8, 0x24E9, 0x007A, 0,
    8, 0x24EA, 0x0030, 0,
    16, 0x2A0C, 0x222B, 0x222B, 0x222B, 0x222B, 0,
    16, 0x2A74, 0x003A, 0x003A, 0x003D, 0,
    16, 0x2A75, 0x003D, 0x003D, 0,
    16, 0x2A76, 0x003D, 0x003D, 0x003D, 0,
    1, 0x2ADC, 0x2ADD, 0x0338, 0,
    16, 0x2E9F, 0x6BCD, 0,
    16, 0x2EF3, 0x9F9F, 0,
    16, 0x2F00, 0x4E00, 0,
    16, 0x2F01, 0x4E28, 0,
    16, 0x2F02, 0x4E36, 0,
    16, 0x2F03, 0x4E3F, 0,
    16, 0x2F04, 0x4E59, 0,
    16, 0x2F05, 0x4E85, 0,
    16, 0x2F06, 0x4E8C, 0,
    16, 0x2F07, 0x4EA0, 0,
    16, 0x2F08, 0x4EBA, 0,
    16, 0x2F09, 0x513F, 0,
    16, 0x2F0A, 0x5165, 0,
    16, 0x2F0B, 0x516B, 0,
    16, 0x2F0C, 0x5182, 0,
    16, 0x2F0D, 0x5196, 0,
    16, 0x2F0E, 0x51AB, 0,
    16, 0x2F0F, 0x51E0, 0,
    16, 0x2F10, 0x51F5, 0,
    16, 0x2F11, 0x5200, 0,
    16, 0x2F12, 0x529B, 0,
    16, 0x2F13, 0x52F9, 0,
    16, 0x2F14, 0x5315, 0,
    16, 0x2F15, 0x531A, 0,
    16, 0x2F16, 0x5338, 0,
    16, 0x2F17, 0x5341, 0,
    16, 0x2F18, 0x535C, 0,
    16, 0x2F19, 0x5369, 0,
    16, 0x2F1A, 0x5382, 0,
    16, 0x2F1B, 0x53B6, 0,
    16, 0x2F1C, 0x53C8, 0,
    16, 0x2F1D, 0x53E3, 0,
    16, 0x2F1E, 0x56D7, 0,
    16, 0x2F1F, 0x571F, 0,
    16, 0x2F20, 0x58EB, 0,
    16, 0x2F21, 0x5902, 0,
    16, 0x2F22, 0x590A, 0,
    16, 0x2F23, 0x5915, 0,
    16, 0x2F24, 0x5927, 0,
    16, 0x2F25, 0x5973, 0,
    16, 0x2F26, 0x5B50, 0,
    16, 0x2F27, 0x5B80, 0,
    16, 0x2F28, 0x5BF8, 0,
    16, 0x2F29, 0x5C0F, 0,
    16, 0x2F2A, 0x5C22, 0,
    16, 0x2F2B, 0x5C38, 0,
    16, 0x2F2C, 0x5C6E, 0,
    16, 0x2F2D, 0x5C71, 0,
    16, 0x2F2E, 0x5DDB, 0,
    16, 0x2F2F, 0x5DE5, 0,
    16, 0x2F30, 0x5DF1, 0,
    16, 0x2F31, 0x5DFE, 0,
    16, 0x2F32, 0x5E72, 0,
    16, 0x2F33, 0x5E7A, 0,
    16, 0x2F34, 0x5E7F, 0,
    16, 0x2F35, 0x5EF4, 0,
    16, 0x2F36, 0x5EFE, 0,
    16, 0x2F37, 0x5F0B, 0,
    16, 0x2F38, 0x5F13, 0,
    16, 0x2F39, 0x5F50, 0,
    16, 0x2F3A, 0x5F61, 0,
    16, 0x2F3B, 0x5F73, 0,
    16, 0x2F3C, 0x5FC3, 0,
    16, 0x2F3D, 0x6208, 0,
    16, 0x2F3E, 0x6236, 0,
    16, 0x2F3F, 0x624B, 0,
    16, 0x2F40, 0x652F, 0,
    16, 0x2F41, 0x6534, 0,
    16, 0x2F42, 0x6587, 0,
    16, 0x2F43, 0x6597, 0,
    16, 0x2F44, 0x65A4, 0,
    16, 0x2F45, 0x65B9, 0,
    16, 0x2F46, 0x65E0, 0,
    16, 0x2F47, 0x65E5, 0,
    16, 0x2F48, 0x66F0, 0,
    16, 0x2F49, 0x6708, 0,
    16, 0x2F4A, 0x6728, 0,
    16, 0x2F4B, 0x6B20, 0,
    16, 0x2F4C, 0x6B62, 0,
    16, 0x2F4D, 0x6B79, 0,
    16, 0x2F4E, 0x6BB3, 0,
    16, 0x2F4F, 0x6BCB, 0,
    16, 0x2F50, 0x6BD4, 0,
    16, 0x2F51, 0x6BDB, 0,
    16, 0x2F52, 0x6C0F, 0,
    16, 0x2F53, 0x6C14, 0,
    16, 0x2F54, 0x6C34, 0,
    16, 0x2F55, 0x706B, 0,
    16, 0x2F56, 0x722A, 0,
    16, 0x2F57, 0x7236, 0,
    16, 0x2F58, 0x723B, 0,
    16, 0x2F59, 0x723F, 0,
    16, 0x2F5A, 0x7247, 0,
    16, 0x2F5B, 0x7259, 0,
    16, 0x2F5C, 0x725B, 0,
    16, 0x2F5D, 0x72AC, 0,
    16, 0x2F5E, 0x7384, 0,
    16, 0x2F5F, 0x7389, 0,
    16, 0x2F60, 0x74DC, 0,
    16, 0x2F61, 0x74E6, 0,
    16, 0x2F62, 0x7518, 0,
    16, 0x2F63, 0x751F, 0,
    16, 0x2F64, 0x7528, 0,
    16, 0x2F65, 0x7530, 0,
    16, 0x2F66, 0x758B, 0,
    16, 0x2F67, 0x7592, 0,
    16, 0x2F68, 0x7676, 0,
    16, 0x2F69, 0x767D, 0,
    16, 0x2F6A, 0x76AE, 0,
    16, 0x2F6B, 0x76BF, 0,
    16, 0x2F6C, 0x76EE, 0,
    16, 0x2F6D, 0x77DB, 0,
    16, 0x2F6E, 0x77E2, 0,
    16, 0x2F6F, 0x77F3, 0,
    16, 0x2F70, 0x793A, 0,
    16, 0x2F71, 0x79B8, 0,
    16, 0x2F72, 0x79BE, 0,
    16, 0x2F73, 0x7A74, 0,
    16, 0x2F74, 0x7ACB, 0,
    16, 0x2F75, 0x7AF9, 0,
    16, 0x2F76, 0x7C73, 0,
    16, 0x2F77, 0x7CF8, 0,
    16, 0x2F78, 0x7F36, 0,
    16, 0x2F79, 0x7F51, 0,
    16, 0x2F7A, 0x7F8A, 0,
    16, 0x2F7B, 0x7FBD, 0,
    16, 0x2F7C, 0x8001, 0,
    16, 0x2F7D, 0x800C, 0,
    16, 0x2F7E, 0x8012, 0,
    16, 0x2F7F, 0x8033, 0,
    16, 0x2F80, 0x807F, 0,
    16, 0x2F81, 0x8089, 0,
    16, 0x2F82, 0x81E3, 0,
    16, 0x2F83, 0x81EA, 0,
    16, 0x2F84, 0x81F3, 0,
    16, 0x2F85, 0x81FC, 0,
    16, 0x2F86, 0x820C, 0,
    16, 0x2F87, 0x821B, 0,
    16, 0x2F88, 0x821F, 0,
    16, 0x2F89, 0x826E, 0,
    16, 0x2F8A, 0x8272, 0,
    16, 0x2F8B, 0x8278, 0,
    16, 0x2F8C, 0x864D, 0,
    16, 0x2F8D, 0x866B, 0,
    16, 0x2F8E, 0x8840, 0,
    16, 0x2F8F, 0x884C, 0,
    16, 0x2F90, 0x8863, 0,
    16, 0x2F91, 0x897E, 0,
    16, 0x2F92, 0x898B, 0,
    16, 0x2F93, 0x89D2, 0,
    16, 0x2F94, 0x8A00, 0,
    16, 0x2F95, 0x8C37, 0,
    16, 0x2F96, 0x8C46, 0,
    16, 0x2F97, 0x8C55, 0,
    16, 0x2F98, 0x8C78, 0,
    16, 0x2F99, 0x8C9D, 0,
    16, 0x2F9A, 0x8D64, 0,
    16, 0x2F9B, 0x8D70, 0,
    16, 0x2F9C, 0x8DB3, 0,
    16, 0x2F9D, 0x8EAB, 0,
    16, 0x2F9E, 0x8ECA, 0,
    16, 0x2F9F, 0x8F9B, 0,
    16, 0x2FA0, 0x8FB0, 0,
    16, 0x2FA1, 0x8FB5, 0,
    16, 0x2FA2, 0x9091, 0,
    16, 0x2FA3, 0x9149, 0,
    16, 0x2FA4, 0x91C6, 0,
    16, 0x2FA5, 0x91CC, 0,
    16, 0x2FA6, 0x91D1, 0,
    16, 0x2FA7, 0x9577, 0,
    16, 0x2FA8, 0x9580, 0,
    16, 0x2FA9, 0x961C, 0,
    16, 0x2FAA, 0x96B6, 0,
    16, 0x2FAB, 0x96B9, 0,
    16, 0x2FAC, 0x96E8, 0,
    16, 0x2FAD, 0x9751, 0,
    16, 0x2FAE, 0x975E, 0,
    16, 0x2FAF, 0x9762, 0,
    16, 0x2FB0, 0x9769, 0,
    16, 0x2FB1, 0x97CB, 0,
    16, 0x2FB2, 0x97ED, 0,
    16, 0x2FB3, 0x97F3, 0,
    16, 0x2FB4, 0x9801, 0,
    16, 0x2FB5, 0x98A8, 0,
    16, 0x2FB6, 0x98DB, 0,
    16, 0x2FB7, 0x98DF, 0,
    16, 0x2FB8, 0x9996, 0,
    16, 0x2FB9, 0x9999, 0,
    16, 0x2FBA, 0x99AC, 0,
    16, 0x2FBB, 0x9AA8, 0,
    16, 0x2FBC, 0x9AD8, 0,
    16, 0x2FBD, 0x9ADF, 0,
    16, 0x2FBE, 0x9B25, 0,
    16, 0x2FBF, 0x9B2F, 0,
    16, 0x2FC0, 0x9B32, 0,
    16, 0x2FC1, 0x9B3C, 0,
    16, 0x2FC2, 0x9B5A, 0,
    16, 0x2FC3, 0x9CE5, 0,
    16, 0x2FC4, 0x9E75, 0,
    16, 0x2FC5, 0x9E7F, 0,
    16, 0x2FC6, 0x9EA5, 0,
    16, 0x2FC7, 0x9EBB, 0,
    16, 0x2FC8, 0x9EC3, 0,
    16, 0x2FC9, 0x9ECD, 0,
    16, 0x2FCA, 0x9ED1, 0,
    16, 0x2FCB, 0x9EF9, 0,
    16, 0x2FCC, 0x9EFD, 0,
    16, 0x2FCD, 0x9F0E, 0,
    16, 0x2FCE, 0x9F13, 0,
    16, 0x2FCF, 0x9F20, 0,
    16, 0x2FD0, 0x9F3B, 0,
    16, 0x2FD1, 0x9F4A, 0,
    16, 0x2FD2, 0x9F52, 0,
    16, 0x2FD3, 0x9F8D, 0,
    16, 0x2FD4, 0x9F9C, 0,
    16, 0x2FD5, 0x9FA0, 0,
    12, 0x3000, 0x0020, 0,
    16, 0x3036, 0x3012, 0,
    16, 0x3038, 0x5341, 0,
    16, 0x3039, 0x5344, 0,
    16, 0x303A, 0x5345, 0,
    1, 0x304C, 0x304B, 0x3099, 0,
    1, 0x304E, 0x304D, 0x3099, 0,
    1, 0x3050, 0x304F, 0x3099, 0,
    1, 0x3052, 0x3051, 0x3099, 0,
    1, 0x3054, 0x3053, 0x3099, 0,
    1, 0x3056, 0x3055, 0x3099, 0,
    1, 0x3058, 0x3057, 0x3099, 0,
    1, 0x305A, 0x3059, 0x3099, 0,
    1, 0x305C, 0x305B, 0x3099, 0,
    1, 0x305E, 0x305D, 0x3099, 0,
    1, 0x3060, 0x305F, 0x3099, 0,
    1, 0x3062, 0x3061, 0x3099, 0,
    1, 0x3065, 0x3064, 0x3099, 0,
    1, 0x3067, 0x3066, 0x3099, 0,
    1, 0x3069, 0x3068, 0x3099, 0,
    1, 0x3070, 0x306F, 0x3099, 0,
    1, 0x3071, 0x306F, 0x309A, 0,
    1, 0x3073, 0x3072, 0x3099, 0,
    1, 0x3074, 0x3072, 0x309A, 0,
    1, 0x3076, 0x3075, 0x3099, 0,
    1, 0x3077, 0x3075, 0x309A, 0,
    1, 0x3079, 0x3078, 0x3099, 0,
    1, 0x307A, 0x3078, 0x309A, 0,
    1, 0x307C, 0x307B, 0x3099, 0,
    1, 0x307D, 0x307B, 0x309A, 0,
    1, 0x3094, 0x3046, 0x3099, 0,
    16, 0x309B, 0x0020, 0x3099, 0,
    16, 0x309C, 0x0020, 0x309A, 0,
    1, 0x309E, 0x309D, 0x3099, 0,
    11, 0x309F, 0x3088, 0x308A, 0,
    1, 0x30AC, 0x30AB, 0x3099, 0,
    1, 0x30AE, 0x30AD, 0x3099, 0,
    1, 0x30B0, 0x30AF, 0x3099, 0,
    1, 0x30B2, 0x30B1, 0x3099, 0,
    1, 0x30B4, 0x30B3, 0x3099, 0,
    1, 0x30B6, 0x30B5, 0x3099, 0,
    1, 0x30B8, 0x30B7, 0x3099, 0,
    1, 0x30BA, 0x30B9, 0x3099, 0,
    1, 0x30BC, 0x30BB, 0x3099, 0,
    1, 0x30BE, 0x30BD, 0x3099, 0,
    1, 0x30C0, 0x30BF, 0x3099, 0,
    1, 0x30C2, 0x30C1, 0x3099, 0,
    1, 0x30C5, 0x30C4, 0x3099, 0,
    1, 0x30C7, 0x30C6, 0x3099, 0,
    1, 0x30C9, 0x30C8, 0x3099, 0,
    1, 0x30D0, 0x30CF, 0x3099, 0,
    1, 0x30D1, 0x30CF, 0x309A, 0,
    1, 0x30D3, 0x30D2, 0x3099, 0,
    1, 0x30D4, 0x30D2, 0x309A, 0,
    1, 0x30D6, 0x30D5, 0x3099, 0,
    1, 0x30D7, 0x30D5, 0x309A, 0,
    1, 0x30D9, 0x30D8, 0x3099, 0,
    1, 0x30DA, 0x30D8, 0x309A, 0,
    1, 0x30DC, 0x30DB, 0x3099, 0,
    1, 0x30DD, 0x30DB, 0x309A, 0,
    1, 0x30F4, 0x30A6, 0x3099, 0,
    1, 0x30F7, 0x30EF, 0x3099, 0,
    1, 0x30F8, 0x30F0, 0x3099, 0,
    1, 0x30F9, 0x30F1, 0x3099, 0,
    1, 0x30FA, 0x30F2, 0x3099, 0,
    1, 0x30FE, 0x30FD, 0x3099, 0,
    11, 0x30FF, 0x30B3, 0x30C8, 0,
    16, 0x3131, 0x1100, 0,
    16, 0x3132, 0x1101, 0,
    16, 0x3133, 0x11AA, 0,
    16, 0x3134, 0x1102, 0,
    16, 0x3135, 0x11AC, 0,
    16, 0x3136, 0x11AD, 0,
    16, 0x3137, 0x1103, 0,
    16, 0x3138, 0x1104, 0,
    16, 0x3139, 0x1105, 0,
    16, 0x313A, 0x11B0, 0,
    16, 0x313B, 0x11B1, 0,
    16, 0x313C, 0x11B2, 0,
    16, 0x313D, 0x11B3, 0,
    16, 0x313E, 0x11B4, 0,
    16, 0x313F, 0x11B5, 0,
    16, 0x3140, 0x111A, 0,
    16, 0x3141, 0x1106, 0,
    16, 0x3142, 0x1107, 0,
    16, 0x3143, 0x1108, 0,
    16, 0x3144, 0x1121, 0,
    16, 0x3145, 0x1109, 0,
    16, 0x3146, 0x110A, 0,
    16, 0x3147, 0x110B, 0,
    16, 0x3148, 0x110C, 0,
    16, 0x3149, 0x110D, 0,
    16, 0x314A, 0x110E, 0,
    16, 0x314B, 0x110F, 0,
    16, 0x314C, 0x1110, 0,
    16, 0x314D, 0x1111, 0,
    16, 0x314E, 0x1112, 0,
    16, 0x314F, 0x1161, 0,
    16, 0x3150, 0x1162, 0,
    16, 0x3151, 0x1163, 0,
    16, 0x3152, 0x1164, 0,
    16, 0x3153, 0x1165, 0,
    16, 0x3154, 0x1166, 0,
    16, 0x3155, 0x1167, 0,
    16, 0x3156, 0x1168, 0,
    16, 0x3157, 0x1169, 0,
    16, 0x3158, 0x116A, 0,
    16, 0x3159, 0x116B, 0,
    16, 0x315A, 0x116C, 0,
    16, 0x315B, 0x116D, 0,
    16, 0x315C, 0x116E, 0,
    16, 0x315D, 0x116F, 0,
    16, 0x315E, 0x1170, 0,
    16, 0x315F, 0x1171, 0,
    16, 0x3160, 0x1172, 0,
    16, 0x3161, 0x1173, 0,
    16, 0x3162, 0x1174, 0,
    16, 0x3163, 0x1175, 0,
    16, 0x3164, 0x1160, 0,
    16, 0x3165, 0x1114, 0,
    16, 0x3166, 0x1115, 0,
    16, 0x3167, 0x11C7, 0,
    16, 0x3168, 0x11C8, 0,
    16, 0x3169, 0x11CC, 0,
    16, 0x316A, 0x11CE, 0,
    16, 0x316B, 0x11D3, 0,
    16, 0x316C, 0x11D7, 0,
    16, 0x316D, 0x11D9, 0,
    16, 0x316E, 0x111C, 0,
    16, 0x316F, 0x11DD, 0,
    16, 0x3170, 0x11DF, 0,
    16, 0x3171, 0x111D, 0,
    16, 0x3172, 0x111E, 0,
    16, 0x3173, 0x1120, 0,
    16, 0x3174, 0x1122, 0,
    16, 0x3175, 0x1123, 0,
    16, 0x3176, 0x1127, 0,
    16, 0x3177, 0x1129, 0,
    16, 0x3178, 0x112B, 0,
    16, 0x3179, 0x112C, 0,
    16, 0x317A, 0x112D, 0,
    16, 0x317B, 0x112E, 0,
    16, 0x317C, 0x112F, 0,
    16, 0x317D, 0x1132, 0,
    16, 0x317E, 0x1136, 0,
    16, 0x317F, 0x1140, 0,
    16, 0x3180, 0x1147, 0,
    16, 0x3181, 0x114C, 0,
    16, 0x3182, 0x11F1, 0,
    16, 0x3183, 0x11F2, 0,
    16, 0x3184, 0x1157, 0,
    16, 0x3185, 0x1158, 0,
    16, 0x3186, 0x1159, 0,
    16, 0x3187, 0x1184, 0,
    16, 0x3188, 0x1185, 0,
    16, 0x3189, 0x1188, 0,
    16, 0x318A, 0x1191, 0,
    16, 0x318B, 0x1192, 0,
    16, 0x318C, 0x1194, 0,
    16, 0x318D, 0x119E, 0,
    16, 0x318E, 0x11A1, 0,
    9, 0x3192, 0x4E00, 0,
    9, 0x3193, 0x4E8C, 0,
    9, 0x3194, 0x4E09, 0,
    9, 0x3195, 0x56DB, 0,
    9, 0x3196, 0x4E0A, 0,
    9, 0x3197, 0x4E2D, 0,
    9, 0x3198, 0x4E0B, 0,
    9, 0x3199, 0x7532, 0,
    9, 0x319A, 0x4E59, 0,
    9, 0x319B, 0x4E19, 0,
    9, 0x319C, 0x4E01, 0,
    9, 0x319D, 0x5929, 0,
    9, 0x319E, 0x5730, 0,
    9, 0x319F, 0x4EBA, 0,
    16, 0x3200, 0x0028, 0x1100, 0x0029, 0,
    16, 0x3201, 0x0028, 0x1102, 0x0029, 0,
    16, 0x3202, 0x0028, 0x1103, 0x0029, 0,
    16, 0x3203, 0x0028, 0x1105, 0x0029, 0,
    16, 0x3204, 0x0028, 0x1106, 0x0029, 0,
    16, 0x3205, 0x0028, 0x1107, 0x0029, 0,
    16, 0x3206, 0x0028, 0x1109, 0x0029, 0,
    16, 0x3207, 0x0028, 0x110B, 0x0029, 0,
    16, 0x3208, 0x0028, 0x110C, 0x0029, 0,
    16, 0x3209, 0x0028, 0x110E, 0x0029, 0,
    16, 0x320A, 0x0028, 0x110F, 0x0029, 0,
    16, 0x320B, 0x0028, 0x1110, 0x0029, 0,
    16, 0x320C, 0x0028, 0x1111, 0x0029, 0,
    16, 0x320D, 0x0028, 0x1112, 0x0029, 0,
    16, 0x320E, 0x0028, 0x1100, 0x1161, 0x0029, 0,
    16, 0x320F, 0x0028, 0x1102, 0x1161, 0x0029, 0,
    16, 0x3210, 0x0028, 0x1103, 0x1161, 0x0029, 0,
    16, 0x3211, 0x0028, 0x1105, 0x1161, 0x0029, 0,
    16, 0x3212, 0x0028, 0x1106, 0x1161, 0x0029, 0,
    16, 0x3213, 0x0028, 0x1107, 0x1161, 0x0029, 0,
    16, 0x3214, 0x0028, 0x1109, 0x1161, 0x0029, 0,
    16, 0x3215, 0x0028, 0x110B, 0x1161, 0x0029, 0,
    16, 0x3216, 0x0028, 0x110C, 0x1161, 0x0029, 0,
    16, 0x3217, 0x0028, 0x110E, 0x1161, 0x0029, 0,
    16, 0x3218, 0x0028, 0x110F, 0x1161, 0x0029, 0,
    16, 0x3219, 0x0028, 0x1110, 0x1161, 0x0029, 0,
    16, 0x321A, 0x0028, 0x1111, 0x1161, 0x0029, 0,
    16, 0x321B, 0x0028, 0x1112, 0x1161, 0x0029, 0,
    16, 0x321C, 0x0028, 0x110C, 0x116E, 0x0029, 0,
    16, 0x3220, 0x0028, 0x4E00, 0x0029, 0,
    16, 0x3221, 0x0028, 0x4E8C, 0x0029, 0,
    16, 0x3222, 0x0028, 0x4E09, 0x0029, 0,
    16, 0x3223, 0x0028, 0x56DB, 0x0029, 0,
    16, 0x3224, 0x0028, 0x4E94, 0x0029, 0,
    16, 0x3225, 0x0028, 0x516D, 0x0029, 0,
    16, 0x3226, 0x0028, 0x4E03, 0x0029, 0,
    16, 0x3227, 0x0028, 0x516B, 0x0029, 0,
    16, 0x3228, 0x0028, 0x4E5D, 0x0029, 0,
    16, 0x3229, 0x0028, 0x5341, 0x0029, 0,
    16, 0x322A, 0x0028, 0x6708, 0x0029, 0,
    16, 0x322B, 0x0028, 0x706B, 0x0029, 0,
    16, 0x322C, 0x0028, 0x6C34, 0x0029, 0,
    16, 0x322D, 0x0028, 0x6728, 0x0029, 0,
    16, 0x322E, 0x0028, 0x91D1, 0x0029, 0,
    16, 0x322F, 0x0028, 0x571F, 0x0029, 0,
    16, 0x3230, 0x0028, 0x65E5, 0x0029, 0,
    16, 0x3231, 0x0028, 0x682A, 0x0029, 0,
    16, 0x3232, 0x0028, 0x6709, 0x0029, 0,
    16, 0x3233, 0x0028, 0x793E, 0x0029, 0,
    16, 0x3234, 0x0028, 0x540D, 0x0029, 0,
    16, 0x3235, 0x0028, 0x7279, 0x0029, 0,
    16, 0x3236, 0x0028, 0x8CA1, 0x0029, 0,
    16, 0x3237, 0x0028, 0x795D, 0x0029, 0,
    16, 0x3238, 0x0028, 0x52B4, 0x0029, 0,
    16, 0x3239, 0x0028, 0x4EE3, 0x0029, 0,
    16, 0x323A, 0x0028, 0x547C, 0x0029, 0,
    16, 0x323B, 0x0028, 0x5B66, 0x0029, 0,
    16, 0x323C, 0x0028, 0x76E3, 0x0029, 0,
    16, 0x323D, 0x0028, 0x4F01, 0x0029, 0,
    16, 0x323E, 0x0028, 0x8CC7, 0x0029, 0,
    16, 0x323F, 0x0028, 0x5354, 0x0029, 0,
    16, 0x3240, 0x0028, 0x796D, 0x0029, 0,
    16, 0x3241, 0x0028, 0x4F11, 0x0029, 0,
    16, 0x3242, 0x0028, 0x81EA, 0x0029, 0,
    16, 0x3243, 0x0028, 0x81F3, 0x0029, 0,
    8, 0x3251, 0x0032, 0x0031, 0,
    8, 0x3252, 0x0032, 0x0032, 0,
    8, 0x3253, 0x0032, 0x0033, 0,
    8, 0x3254, 0x0032, 0x0034, 0,
    8, 0x3255, 0x0032, 0x0035, 0,
    8, 0x3256, 0x0032, 0x0036, 0,
    8, 0x3257, 0x0032, 0x0037, 0,
    8, 0x3258, 0x0032, 0x0038, 0,
    8, 0x3259, 0x0032, 0x0039, 0,
    8, 0x325A, 0x0033, 0x0030, 0,
    8, 0x325B, 0x0033, 0x0031, 0,
    8, 0x325C, 0x0033, 0x0032, 0,
    8, 0x325D, 0x0033, 0x0033, 0,
    8, 0x325E, 0x0033, 0x0034, 0,
    8, 0x325F, 0x0033, 0x0035, 0,
    8, 0x3260, 0x1100, 0,
    8, 0x3261, 0x1102, 0,
    8, 0x3262, 0x1103, 0,
    8, 0x3263, 0x1105, 0,
    8, 0x3264, 0x1106, 0,
    8, 0x3265, 0x1107, 0,
    8, 0x3266, 0x1109, 0,
    8, 0x3267, 0x110B, 0,
    8, 0x3268, 0x110C, 0,
    8, 0x3269, 0x110E, 0,
    8, 0x326A, 0x110F, 0,
    8, 0x326B, 0x1110, 0,
    8, 0x326C, 0x1111, 0,
    8, 0x326D, 0x1112, 0,
    8, 0x326E, 0x1100, 0x1161, 0,
    8, 0x326F, 0x1102, 0x1161, 0,
    8, 0x3270, 0x1103, 0x1161, 0,
    8, 0x3271, 0x1105, 0x1161, 0,
    8, 0x3272, 0x1106, 0x1161, 0,
    8, 0x3273, 0x1107, 0x1161, 0,
    8, 0x3274, 0x1109, 0x1161, 0,
    8, 0x3275, 0x110B, 0x1161, 0,
    8, 0x3276, 0x110C, 0x1161, 0,
    8, 0x3277, 0x110E, 0x1161, 0,
    8, 0x3278, 0x110F, 0x1161, 0,
    8, 0x3279, 0x1110, 0x1161, 0,
    8, 0x327A, 0x1111, 0x1161, 0,
    8, 0x327B, 0x1112, 0x1161, 0,
    8, 0x3280, 0x4E00, 0,
    8, 0x3281, 0x4E8C, 0,
    8, 0x3282, 0x4E09, 0,
    8, 0x3283, 0x56DB, 0,
    8, 0x3284, 0x4E94, 0,
    8, 0x3285, 0x516D, 0,
    8, 0x3286, 0x4E03, 0,
    8, 0x3287, 0x516B, 0,
    8, 0x3288, 0x4E5D, 0,
    8, 0x3289, 0x5341, 0,
    8, 0x328A, 0x6708, 0,
    8, 0x328B, 0x706B, 0,
    8, 0x328C, 0x6C34, 0,
    8, 0x328D, 0x6728, 0,
    8, 0x328E, 0x91D1, 0,
    8, 0x328F, 0x571F, 0,
    8, 0x3290, 0x65E5, 0,
    8, 0x3291, 0x682A, 0,
    8, 0x3292, 0x6709, 0,
    8, 0x3293, 0x793E, 0,
    8, 0x3294, 0x540D, 0,
    8, 0x3295, 0x7279, 0,
    8, 0x3296, 0x8CA1, 0,
    8, 0x3297, 0x795D, 0,
    8, 0x3298, 0x52B4, 0,
    8, 0x3299, 0x79D8, 0,
    8, 0x329A, 0x7537, 0,
    8, 0x329B, 0x5973, 0,
    8, 0x329C, 0x9069, 0,
    8, 0x329D, 0x512A, 0,
    8, 0x329E, 0x5370, 0,
    8, 0x329F, 0x6CE8, 0,
    8, 0x32A0, 0x9805, 0,
    8, 0x32A1, 0x4F11, 0,
    8, 0x32A2, 0x5199, 0,
    8, 0x32A3, 0x6B63, 0,
    8, 0x32A4, 0x4E0A, 0,
    8, 0x32A5, 0x4E2D, 0,
    8, 0x32A6, 0x4E0B, 0,
    8, 0x32A7, 0x5DE6, 0,
    8, 0x32A8, 0x53F3, 0,
    8, 0x32A9, 0x533B, 0,
    8, 0x32AA, 0x5B97, 0,
    8, 0x32AB, 0x5B66, 0,
    8, 0x32AC, 0x76E3, 0,
    8, 0x32AD, 0x4F01, 0,
    8, 0x32AE, 0x8CC7, 0,
    8, 0x32AF, 0x5354, 0,
    8, 0x32B0, 0x591C, 0,
    8, 0x32B1, 0x0033, 0x0036, 0,
    8, 0x32B2, 0x0033, 0x0037, 0,
    8, 0x32B3, 0x0033, 0x0038, 0,
    8, 0x32B4, 0x0033, 0x0039, 0,
    8, 0x32B5, 0x0034, 0x0030, 0,
    8, 0x32B6, 0x0034, 0x0031, 0,
    8, 0x32B7, 0x0034, 0x0032, 0,
    8, 0x32B8, 0x0034, 0x0033, 0,
    8, 0x32B9, 0x0034, 0x0034, 0,
    8, 0x32BA, 0x0034, 0x0035, 0,
    8, 0x32BB, 0x0034, 0x0036, 0,
    8, 0x32BC, 0x0034, 0x0037, 0,
    8, 0x32BD, 0x0034, 0x0038, 0,
    8, 0x32BE, 0x0034, 0x0039, 0,
    8, 0x32BF, 0x0035, 0x0030, 0,
    16, 0x32C0, 0x0031, 0x6708, 0,
    16, 0x32C1, 0x0032, 0x6708, 0,
    16, 0x32C2, 0x0033, 0x6708, 0,
    16, 0x32C3, 0x0034, 0x6708, 0,
    16, 0x32C4, 0x0035, 0x6708, 0,
    16, 0x32C5, 0x0036, 0x6708, 0,
    16, 0x32C6, 0x0037, 0x6708, 0,
    16, 0x32C7, 0x0038, 0x6708, 0,
    16, 0x32C8, 0x0039, 0x6708, 0,
    16, 0x32C9, 0x0031, 0x0030, 0x6708, 0,
    16, 0x32CA, 0x0031, 0x0031, 0x6708, 0,
    16, 0x32CB, 0x0031, 0x0032, 0x6708, 0,
    8, 0x32D0, 0x30A2, 0,
    8, 0x32D1, 0x30A4, 0,
    8, 0x32D2, 0x30A6, 0,
    8, 0x32D3, 0x30A8, 0,
    8, 0x32D4, 0x30AA, 0,
    8, 0x32D5, 0x30AB, 0,
    8, 0x32D6, 0x30AD, 0,
    8, 0x32D7, 0x30AF, 0,
    8, 0x32D8, 0x30B1, 0,
    8, 0x32D9, 0x30B3, 0,
    8, 0x32DA, 0x30B5, 0,
    8, 0x32DB, 0x30B7, 0,
    8, 0x32DC, 0x30B9, 0,
    8, 0x32DD, 0x30BB, 0,
    8, 0x32DE, 0x30BD, 0,
    8, 0x32DF, 0x30BF, 0,
    8, 0x32E0, 0x30C1, 0,
    8, 0x32E1, 0x30C4, 0,
    8, 0x32E2, 0x30C6, 0,
    8, 0x32E3, 0x30C8, 0,
    8, 0x32E4, 0x30CA, 0,
    8, 0x32E5, 0x30CB, 0,
    8, 0x32E6, 0x30CC, 0,
    8, 0x32E7, 0x30CD, 0,
    8, 0x32E8, 0x30CE, 0,
    8, 0x32E9, 0x30CF, 0,
    8, 0x32EA, 0x30D2, 0,
    8, 0x32EB, 0x30D5, 0,
    8, 0x32EC, 0x30D8, 0,
    8, 0x32ED, 0x30DB, 0,
    8, 0x32EE, 0x30DE, 0,
    8, 0x32EF, 0x30DF, 0,
    8, 0x32F0, 0x30E0, 0,
    8, 0x32F1, 0x30E1, 0,
    8, 0x32F2, 0x30E2, 0,
    8, 0x32F3, 0x30E4, 0,
    8, 0x32F4, 0x30E6, 0,
    8, 0x32F5, 0x30E8, 0,
    8, 0x32F6, 0x30E9, 0,
    8, 0x32F7, 0x30EA, 0,
    8, 0x32F8, 0x30EB, 0,
    8, 0x32F9, 0x30EC, 0,
    8, 0x32FA, 0x30ED, 0,
    8, 0x32FB, 0x30EF, 0,
    8, 0x32FC, 0x30F0, 0,
    8, 0x32FD, 0x30F1, 0,
    8, 0x32FE, 0x30F2, 0,
    15, 0x3300, 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0,
    15, 0x3301, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0,
    15, 0x3302, 0x30A2, 0x30F3, 0x30DA, 0x30A2, 0,
    15, 0x3303, 0x30A2, 0x30FC, 0x30EB, 0,
    15, 0x3304, 0x30A4, 0x30CB, 0x30F3, 0x30B0, 0,
    15, 0x3305, 0x30A4, 0x30F3, 0x30C1, 0,
    15, 0x3306, 0x30A6, 0x30A9, 0x30F3, 0,
    15, 0x3307, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0,
    15, 0x3308, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0,
    15, 0x3309, 0x30AA, 0x30F3, 0x30B9, 0,
    15, 0x330A, 0x30AA, 0x30FC, 0x30E0, 0,
    15, 0x330B, 0x30AB, 0x30A4, 0x30EA, 0,
    15, 0x330C, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0,
    15, 0x330D, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0,
    15, 0x330E, 0x30AC, 0x30ED, 0x30F3, 0,
    15, 0x330F, 0x30AC, 0x30F3, 0x30DE, 0,
    15, 0x3310, 0x30AE, 0x30AC, 0,
    15, 0x3311, 0x30AE, 0x30CB, 0x30FC, 0,
    15, 0x3312, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0,
    15, 0x3313, 0x30AE, 0x30EB, 0x30C0, 0x30FC, 0,
    15, 0x3314, 0x30AD, 0x30ED, 0,
    15, 0x3315, 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3316, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x3317, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0,
    15, 0x3318, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3319, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0,
    15, 0x331A, 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0,
    15, 0x331B, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0,
    15, 0x331C, 0x30B1, 0x30FC, 0x30B9, 0,
    15, 0x331D, 0x30B3, 0x30EB, 0x30CA, 0,
    15, 0x331E, 0x30B3, 0x30FC, 0x30DD, 0,
    15, 0x331F, 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0,
    15, 0x3320, 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0,
    15, 0x3321, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0,
    15, 0x3322, 0x30BB, 0x30F3, 0x30C1, 0,
    15, 0x3323, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x3324, 0x30C0, 0x30FC, 0x30B9, 0,
    15, 0x3325, 0x30C7, 0x30B7, 0,
    15, 0x3326, 0x30C9, 0x30EB, 0,
    15, 0x3327, 0x30C8, 0x30F3, 0,
    15, 0x3328, 0x30CA, 0x30CE, 0,
    15, 0x3329, 0x30CE, 0x30C3, 0x30C8, 0,
    15, 0x332A, 0x30CF, 0x30A4, 0x30C4, 0,
    15, 0x332B, 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x332C, 0x30D1, 0x30FC, 0x30C4, 0,
    15, 0x332D, 0x30D0, 0x30FC, 0x30EC, 0x30EB, 0,
    15, 0x332E, 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0,
    15, 0x332F, 0x30D4, 0x30AF, 0x30EB, 0,
    15, 0x3330, 0x30D4, 0x30B3, 0,
    15, 0x3331, 0x30D3, 0x30EB, 0,
    15, 0x3332, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0,
    15, 0x3333, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0,
    15, 0x3334, 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0,
    15, 0x3335, 0x30D5, 0x30E9, 0x30F3, 0,
    15, 0x3336, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0,
    15, 0x3337, 0x30DA, 0x30BD, 0,
    15, 0x3338, 0x30DA, 0x30CB, 0x30D2, 0,
    15, 0x3339, 0x30D8, 0x30EB, 0x30C4, 0,
    15, 0x333A, 0x30DA, 0x30F3, 0x30B9, 0,
    15, 0x333B, 0x30DA, 0x30FC, 0x30B8, 0,
    15, 0x333C, 0x30D9, 0x30FC, 0x30BF, 0,
    15, 0x333D, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0,
    15, 0x333E, 0x30DC, 0x30EB, 0x30C8, 0,
    15, 0x333F, 0x30DB, 0x30F3, 0,
    15, 0x3340, 0x30DD, 0x30F3, 0x30C9, 0,
    15, 0x3341, 0x30DB, 0x30FC, 0x30EB, 0,
    15, 0x3342, 0x30DB, 0x30FC, 0x30F3, 0,
    15, 0x3343, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0,
    15, 0x3344, 0x30DE, 0x30A4, 0x30EB, 0,
    15, 0x3345, 0x30DE, 0x30C3, 0x30CF, 0,
    15, 0x3346, 0x30DE, 0x30EB, 0x30AF, 0,
    15, 0x3347, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0,
    15, 0x3348, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0,
    15, 0x3349, 0x30DF, 0x30EA, 0,
    15, 0x334A, 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0,
    15, 0x334B, 0x30E1, 0x30AC, 0,
    15, 0x334C, 0x30E1, 0x30AC, 0x30C8, 0x30F3, 0,
    15, 0x334D, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x334E, 0x30E4, 0x30FC, 0x30C9, 0,
    15, 0x334F, 0x30E4, 0x30FC, 0x30EB, 0,
    15, 0x3350, 0x30E6, 0x30A2, 0x30F3, 0,
    15, 0x3351, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0,
    15, 0x3352, 0x30EA, 0x30E9, 0,
    15, 0x3353, 0x30EB, 0x30D4, 0x30FC, 0,
    15, 0x3354, 0x30EB, 0x30FC, 0x30D6, 0x30EB, 0,
    15, 0x3355, 0x30EC, 0x30E0, 0,
    15, 0x3356, 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0,
    15, 0x3357, 0x30EF, 0x30C3, 0x30C8, 0,
    16, 0x3358, 0x0030, 0x70B9, 0,
    16, 0x3359, 0x0031, 0x70B9, 0,
    16, 0x335A, 0x0032, 0x70B9, 0,
    16, 0x335B, 0x0033, 0x70B9, 0,
    16, 0x335C, 0x0034, 0x70B9, 0,
    16, 0x335D, 0x0035, 0x70B9, 0,
    16, 0x335E, 0x0036, 0x70B9, 0,
    16, 0x335F, 0x0037, 0x70B9, 0,
    16, 0x3360, 0x0038, 0x70B9, 0,
    16, 0x3361, 0x0039, 0x70B9, 0,
    16, 0x3362, 0x0031, 0x0030, 0x70B9, 0,
    16, 0x3363, 0x0031, 0x0031, 0x70B9, 0,
    16, 0x3364, 0x0031, 0x0032, 0x70B9, 0,
    16, 0x3365, 0x0031, 0x0033, 0x70B9, 0,
    16, 0x3366, 0x0031, 0x0034, 0x70B9, 0,
    16, 0x3367, 0x0031, 0x0035, 0x70B9, 0,
    16, 0x3368, 0x0031, 0x0036, 0x70B9, 0,
    16, 0x3369, 0x0031, 0x0037, 0x70B9, 0,
    16, 0x336A, 0x0031, 0x0038, 0x70B9, 0,
    16, 0x336B, 0x0031, 0x0039, 0x70B9, 0,
    16, 0x336C, 0x0032, 0x0030, 0x70B9, 0,
    16, 0x336D, 0x0032, 0x0031, 0x70B9, 0,
    16, 0x336E, 0x0032, 0x0032, 0x70B9, 0,
    16, 0x336F, 0x0032, 0x0033, 0x70B9, 0,
    16, 0x3370, 0x0032, 0x0034, 0x70B9, 0,
    15, 0x3371, 0x0068, 0x0050, 0x0061, 0,
    15, 0x3372, 0x0064, 0x0061, 0,
    15, 0x3373, 0x0041, 0x0055, 0,
    15, 0x3374, 0x0062, 0x0061, 0x0072, 0,
    15, 0x3375, 0x006F, 0x0056, 0,
    15, 0x3376, 0x0070, 0x0063, 0,
    15, 0x337B, 0x5E73, 0x6210, 0,
    15, 0x337C, 0x662D, 0x548C, 0,
    15, 0x337D, 0x5927, 0x6B63, 0,
    15, 0x337E, 0x660E, 0x6CBB, 0,
    15, 0x337F, 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0,
    15, 0x3380, 0x0070, 0x0041, 0,
    15, 0x3381, 0x006E, 0x0041, 0,
    15, 0x3382, 0x03BC, 0x0041, 0,
    15, 0x3383, 0x006D, 0x0041, 0,
    15, 0x3384, 0x006B, 0x0041, 0,
    15, 0x3385, 0x004B, 0x0042, 0,
    15, 0x3386, 0x004D, 0x0042, 0,
    15, 0x3387, 0x0047, 0x0042, 0,
    15, 0x3388, 0x0063, 0x0061, 0x006C, 0,
    15, 0x3389, 0x006B, 0x0063, 0x0061, 0x006C, 0,
    15, 0x338A, 0x0070, 0x0046, 0,
    15, 0x338B, 0x006E, 0x0046, 0,
    15, 0x338C, 0x03BC, 0x0046, 0,
    15, 0x338D, 0x03BC, 0x0067, 0,
    15, 0x338E, 0x006D, 0x0067, 0,
    15, 0x338F, 0x006B, 0x0067, 0,
    15, 0x3390, 0x0048, 0x007A, 0,
    15, 0x3391, 0x006B, 0x0048, 0x007A, 0,
    15, 0x3392, 0x004D, 0x0048, 0x007A, 0,
    15, 0x3393, 0x0047, 0x0048, 0x007A, 0,
    15, 0x3394, 0x0054, 0x0048, 0x007A, 0,
    15, 0x3395, 0x03BC, 0x2113, 0,
    15, 0x3396, 0x006D, 0x2113, 0,
    15, 0x3397, 0x0064, 0x2113, 0,
    15, 0x3398, 0x006B, 0x2113, 0,
    15, 0x3399, 0x0066, 0x006D, 0,
    15, 0x339A, 0x006E, 0x006D, 0,
    15, 0x339B, 0x03BC, 0x006D, 0,
    15, 0x339C, 0x006D, 0x006D, 0,
    15, 0x339D, 0x0063, 0x006D, 0,
    15, 0x339E, 0x006B, 0x006D, 0,
    15, 0x339F, 0x006D, 0x006D, 0x00B2, 0,
    15, 0x33A0, 0x0063, 0x006D, 0x00B2, 0,
    15, 0x33A1, 0x006D, 0x00B2, 0,
    15, 0x33A2, 0x006B, 0x006D, 0x00B2, 0,
    15, 0x33A3, 0x006D, 0x006D, 0x00B3, 0,
    15, 0x33A4, 0x0063, 0x006D, 0x00B3, 0,
    15, 0x33A5, 0x006D, 0x00B3, 0,
    15, 0x33A6, 0x006B, 0x006D, 0x00B3, 0,
    15, 0x33A7, 0x006D, 0x2215, 0x0073, 0,
    15, 0x33A8, 0x006D, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33A9, 0x0050, 0x0061, 0,
    15, 0x33AA, 0x006B, 0x0050, 0x0061, 0,
    15, 0x33AB, 0x004D, 0x0050, 0x0061, 0,
    15, 0x33AC, 0x0047, 0x0050, 0x0061, 0,
    15, 0x33AD, 0x0072, 0x0061, 0x0064, 0,
    15, 0x33AE, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0,
    15, 0x33AF, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33B0, 0x0070, 0x0073, 0,
    15, 0x33B1, 0x006E, 0x0073, 0,
    15, 0x33B2, 0x03BC, 0x0073, 0,
    15, 0x33B3, 0x006D, 0x0073, 0,
    15, 0x33B4, 0x0070, 0x0056, 0,
    15, 0x33B5, 0x006E, 0x0056, 0,
    15, 0x33B6, 0x03BC, 0x0056, 0,
    15, 0x33B7, 0x006D, 0x0056, 0,
    15, 0x33B8, 0x006B, 0x0056, 0,
    15, 0x33B9, 0x004D, 0x0056, 0,
    15, 0x33BA, 0x0070, 0x0057, 0,
    15, 0x33BB, 0x006E, 0x0057, 0,
    15, 0x33BC, 0x03BC, 0x0057, 0,
    15, 0x33BD, 0x006D, 0x0057, 0,
    15, 0x33BE, 0x006B, 0x0057, 0,
    15, 0x33BF, 0x004D, 0x0057, 0,
    15, 0x33C0, 0x006B, 0x03A9, 0,
    15, 0x33C1, 0x004D, 0x03A9, 0,
    15, 0x33C2, 0x0061, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33C3, 0x0042, 0x0071, 0,
    15, 0x33C4, 0x0063, 0x0063, 0,
    15, 0x33C5, 0x0063, 0x0064, 0,
    15, 0x33C6, 0x0043, 0x2215, 0x006B, 0x0067, 0,
    15, 0x33C7, 0x0043, 0x006F, 0x002E, 0,
    15, 0x33C8, 0x0064, 0x0042, 0,
    15, 0x33C9, 0x0047, 0x0079, 0,
    15, 0x33CA, 0x0068, 0x0061, 0,
    15, 0x33CB, 0x0048, 0x0050, 0,
    15, 0x33CC, 0x0069, 0x006E, 0,
    15, 0x33CD, 0x004B, 0x004B, 0,
    15, 0x33CE, 0x004B, 0x004D, 0,
    15, 0x33CF, 0x006B, 0x0074, 0,
    15, 0x33D0, 0x006C, 0x006D, 0,
    15, 0x33D1, 0x006C, 0x006E, 0,
    15, 0x33D2, 0x006C, 0x006F, 0x0067, 0,
    15, 0x33D3, 0x006C, 0x0078, 0,
    15, 0x33D4, 0x006D, 0x0062, 0,
    15, 0x33D5, 0x006D, 0x0069, 0x006C, 0,
    15, 0x33D6, 0x006D, 0x006F, 0x006C, 0,
    15, 0x33D7, 0x0050, 0x0048, 0,
    15, 0x33D8, 0x0070, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33D9, 0x0050, 0x0050, 0x004D, 0,
    15, 0x33DA, 0x0050, 0x0052, 0,
    15, 0x33DB, 0x0073, 0x0072, 0,
    15, 0x33DC, 0x0053, 0x0076, 0,
    15, 0x33DD, 0x0057, 0x0062, 0,
    16, 0x33E0, 0x0031, 0x65E5, 0,
    16, 0x33E1, 0x0032, 0x65E5, 0,
    16, 0x33E2, 0x0033, 0x65E5, 0,
    16, 0x33E3, 0x0034, 0x65E5, 0,
    16, 0x33E4, 0x0035, 0x65E5, 0,
    16, 0x33E5, 0x0036, 0x65E5, 0,
    16, 0x33E6, 0x0037, 0x65E5, 0,
    16, 0x33E7, 0x0038, 0x65E5, 0,
    16, 0x33E8, 0x0039, 0x65E5, 0,
    16, 0x33E9, 0x0031, 0x0030, 0x65E5, 0,
    16, 0x33EA, 0x0031, 0x0031, 0x65E5, 0,
    16, 0x33EB, 0x0031, 0x0032, 0x65E5, 0,
    16, 0x33EC, 0x0031, 0x0033, 0x65E5, 0,
    16, 0x33ED, 0x0031, 0x0034, 0x65E5, 0,
    16, 0x33EE, 0x0031, 0x0035, 0x65E5, 0,
    16, 0x33EF, 0x0031, 0x0036, 0x65E5, 0,
    16, 0x33F0, 0x0031, 0x0037, 0x65E5, 0,
    16, 0x33F1, 0x0031, 0x0038, 0x65E5, 0,
    16, 0x33F2, 0x0031, 0x0039, 0x65E5, 0,
    16, 0x33F3, 0x0032, 0x0030, 0x65E5, 0,
    16, 0x33F4, 0x0032, 0x0031, 0x65E5, 0,
    16, 0x33F5, 0x0032, 0x0032, 0x65E5, 0,
    16, 0x33F6, 0x0032, 0x0033, 0x65E5, 0,
    16, 0x33F7, 0x0032, 0x0034, 0x65E5, 0,
    16, 0x33F8, 0x0032, 0x0035, 0x65E5, 0,
    16, 0x33F9, 0x0032, 0x0036, 0x65E5, 0,
    16, 0x33FA, 0x0032, 0x0037, 0x65E5, 0,
    16, 0x33FB, 0x0032, 0x0038, 0x65E5, 0,
    16, 0x33FC, 0x0032, 0x0039, 0x65E5, 0,
    16, 0x33FD, 0x0033, 0x0030, 0x65E5, 0,
    16, 0x33FE, 0x0033, 0x0031, 0x65E5, 0,
    1, 0xF900, 0x8C48, 0,
    1, 0xF901, 0x66F4, 0,
    1, 0xF902, 0x8ECA, 0,
    1, 0xF903, 0x8CC8, 0,
    1, 0xF904, 0x6ED1, 0,
    1, 0xF905, 0x4E32, 0,
    1, 0xF906, 0x53E5, 0,
    1, 0xF907, 0x9F9C, 0,
    1, 0xF908, 0x9F9C, 0,
    1, 0xF909, 0x5951, 0,
    1, 0xF90A, 0x91D1, 0,
    1, 0xF90B, 0x5587, 0,
    1, 0xF90C, 0x5948, 0,
    1, 0xF90D, 0x61F6, 0,
    1, 0xF90E, 0x7669, 0,
    1, 0xF90F, 0x7F85, 0,
    1, 0xF910, 0x863F, 0,
    1, 0xF911, 0x87BA, 0,
    1, 0xF912, 0x88F8, 0,
    1, 0xF913, 0x908F, 0,
    1, 0xF914, 0x6A02, 0,
    1, 0xF915, 0x6D1B, 0,
    1, 0xF916, 0x70D9, 0,
    1, 0xF917, 0x73DE, 0,
    1, 0xF918, 0x843D, 0,
    1, 0xF919, 0x916A, 0,
    1, 0xF91A, 0x99F1, 0,
    1, 0xF91B, 0x4E82, 0,
    1, 0xF91C, 0x5375, 0,
    1, 0xF91D, 0x6B04, 0,
    1, 0xF91E, 0x721B, 0,
    1, 0xF91F, 0x862D, 0,
    1, 0xF920, 0x9E1E, 0,
    1, 0xF921, 0x5D50, 0,
    1, 0xF922, 0x6FEB, 0,
    1, 0xF923, 0x85CD, 0,
    1, 0xF924, 0x8964, 0,
    1, 0xF925, 0x62C9, 0,
    1, 0xF926, 0x81D8, 0,
    1, 0xF927, 0x881F, 0,
    1, 0xF928, 0x5ECA, 0,
    1, 0xF929, 0x6717, 0,
    1, 0xF92A, 0x6D6A, 0,
    1, 0xF92B, 0x72FC, 0,
    1, 0xF92C, 0x90CE, 0,
    1, 0xF92D, 0x4F86, 0,
    1, 0xF92E, 0x51B7, 0,
    1, 0xF92F, 0x52DE, 0,
    1, 0xF930, 0x64C4, 0,
    1, 0xF931, 0x6AD3, 0,
    1, 0xF932, 0x7210, 0,
    1, 0xF933, 0x76E7, 0,
    1, 0xF934, 0x8001, 0,
    1, 0xF935, 0x8606, 0,
    1, 0xF936, 0x865C, 0,
    1, 0xF937, 0x8DEF, 0,
    1, 0xF938, 0x9732, 0,
    1, 0xF939, 0x9B6F, 0,
    1, 0xF93A, 0x9DFA, 0,
    1, 0xF93B, 0x788C, 0,
    1, 0xF93C, 0x797F, 0,
    1, 0xF93D, 0x7DA0, 0,
    1, 0xF93E, 0x83C9, 0,
    1, 0xF93F, 0x9304, 0,
    1, 0xF940, 0x9E7F, 0,
    1, 0xF941, 0x8AD6, 0,
    1, 0xF942, 0x58DF, 0,
    1, 0xF943, 0x5F04, 0,
    1, 0xF944, 0x7C60, 0,
    1, 0xF945, 0x807E, 0,
    1, 0xF946, 0x7262, 0,
    1, 0xF947, 0x78CA, 0,
    1, 0xF948, 0x8CC2, 0,
    1, 0xF949, 0x96F7, 0,
    1, 0xF94A, 0x58D8, 0,
    1, 0xF94B, 0x5C62, 0,
    1, 0xF94C, 0x6A13, 0,
    1, 0xF94D, 0x6DDA, 0,
    1, 0xF94E, 0x6F0F, 0,
    1, 0xF94F, 0x7D2F, 0,
    1, 0xF950, 0x7E37, 0,
    1, 0xF951, 0x964B, 0,
    1, 0xF952, 0x52D2, 0,
    1, 0xF953, 0x808B, 0,
    1, 0xF954, 0x51DC, 0,
    1, 0xF955, 0x51CC, 0,
    1, 0xF956, 0x7A1C, 0,
    1, 0xF957, 0x7DBE, 0,
    1, 0xF958, 0x83F1, 0,
    1, 0xF959, 0x9675, 0,
    1, 0xF95A, 0x8B80, 0,
    1, 0xF95B, 0x62CF, 0,
    1, 0xF95C, 0x6A02, 0,
    1, 0xF95D, 0x8AFE, 0,
    1, 0xF95E, 0x4E39, 0,
    1, 0xF95F, 0x5BE7, 0,
    1, 0xF960, 0x6012, 0,
    1, 0xF961, 0x7387, 0,
    1, 0xF962, 0x7570, 0,
    1, 0xF963, 0x5317, 0,
    1, 0xF964, 0x78FB, 0,
    1, 0xF965, 0x4FBF, 0,
    1, 0xF966, 0x5FA9, 0,
    1, 0xF967, 0x4E0D, 0,
    1, 0xF968, 0x6CCC, 0,
    1, 0xF969, 0x6578, 0,
    1, 0xF96A, 0x7D22, 0,
    1, 0xF96B, 0x53C3, 0,
    1, 0xF96C, 0x585E, 0,
    1, 0xF96D, 0x7701, 0,
    1, 0xF96E, 0x8449, 0,
    1, 0xF96F, 0x8AAA, 0,
    1, 0xF970, 0x6BBA, 0,
    1, 0xF971, 0x8FB0, 0,
    1, 0xF972, 0x6C88, 0,
    1, 0xF973, 0x62FE, 0,
    1, 0xF974, 0x82E5, 0,
    1, 0xF975, 0x63A0, 0,
    1, 0xF976, 0x7565, 0,
    1, 0xF977, 0x4EAE, 0,
    1, 0xF978, 0x5169, 0,
    1, 0xF979, 0x51C9, 0,
    1, 0xF97A, 0x6881, 0,
    1, 0xF97B, 0x7CE7, 0,
    1, 0xF97C, 0x826F, 0,
    1, 0xF97D, 0x8AD2, 0,
    1, 0xF97E, 0x91CF, 0,
    1, 0xF97F, 0x52F5, 0,
    1, 0xF980, 0x5442, 0,
    1, 0xF981, 0x5973, 0,
    1, 0xF982, 0x5EEC, 0,
    1, 0xF983, 0x65C5, 0,
    1, 0xF984, 0x6FFE, 0,
    1, 0xF985, 0x792A, 0,
    1, 0xF986, 0x95AD, 0,
    1, 0xF987, 0x9A6A, 0,
    1, 0xF988, 0x9E97, 0,
    1, 0xF989, 0x9ECE, 0,
    1, 0xF98A, 0x529B, 0,
    1, 0xF98B, 0x66C6, 0,
    1, 0xF98C, 0x6B77, 0,
    1, 0xF98D, 0x8F62, 0,
    1, 0xF98E, 0x5E74, 0,
    1, 0xF98F, 0x6190, 0,
    1, 0xF990, 0x6200, 0,
    1, 0xF991, 0x649A, 0,
    1, 0xF992, 0x6F23, 0,
    1, 0xF993, 0x7149, 0,
    1, 0xF994, 0x7489, 0,
    1, 0xF995, 0x79CA, 0,
    1, 0xF996, 0x7DF4, 0,
    1, 0xF997, 0x806F, 0,
    1, 0xF998, 0x8F26, 0,
    1, 0xF999, 0x84EE, 0,
    1, 0xF99A, 0x9023, 0,
    1, 0xF99B, 0x934A, 0,
    1, 0xF99C, 0x5217, 0,
    1, 0xF99D, 0x52A3, 0,
    1, 0xF99E, 0x54BD, 0,
    1, 0xF99F, 0x70C8, 0,
    1, 0xF9A0, 0x88C2, 0,
    1, 0xF9A1, 0x8AAA, 0,
    1, 0xF9A2, 0x5EC9, 0,
    1, 0xF9A3, 0x5FF5, 0,
    1, 0xF9A4, 0x637B, 0,
    1, 0xF9A5, 0x6BAE, 0,
    1, 0xF9A6, 0x7C3E, 0,
    1, 0xF9A7, 0x7375, 0,
    1, 0xF9A8, 0x4EE4, 0,
    1, 0xF9A9, 0x56F9, 0,
    1, 0xF9AA, 0x5BE7, 0,
    1, 0xF9AB, 0x5DBA, 0,
    1, 0xF9AC, 0x601C, 0,
    1, 0xF9AD, 0x73B2, 0,
    1, 0xF9AE, 0x7469, 0,
    1, 0xF9AF, 0x7F9A, 0,
    1, 0xF9B0, 0x8046, 0,
    1, 0xF9B1, 0x9234, 0,
    1, 0xF9B2, 0x96F6, 0,
    1, 0xF9B3, 0x9748, 0,
    1, 0xF9B4, 0x9818, 0,
    1, 0xF9B5, 0x4F8B, 0,
    1, 0xF9B6, 0x79AE, 0,
    1, 0xF9B7, 0x91B4, 0,
    1, 0xF9B8, 0x96B8, 0,
    1, 0xF9B9, 0x60E1, 0,
    1, 0xF9BA, 0x4E86, 0,
    1, 0xF9BB, 0x50DA, 0,
    1, 0xF9BC, 0x5BEE, 0,
    1, 0xF9BD, 0x5C3F, 0,
    1, 0xF9BE, 0x6599, 0,
    1, 0xF9BF, 0x6A02, 0,
    1, 0xF9C0, 0x71CE, 0,
    1, 0xF9C1, 0x7642, 0,
    1, 0xF9C2, 0x84FC, 0,
    1, 0xF9C3, 0x907C, 0,
    1, 0xF9C4, 0x9F8D, 0,
    1, 0xF9C5, 0x6688, 0,
    1, 0xF9C6, 0x962E, 0,
    1, 0xF9C7, 0x5289, 0,
    1, 0xF9C8, 0x677B, 0,
    1, 0xF9C9, 0x67F3, 0,
    1, 0xF9CA, 0x6D41, 0,
    1, 0xF9CB, 0x6E9C, 0,
    1, 0xF9CC, 0x7409, 0,
    1, 0xF9CD, 0x7559, 0,
    1, 0xF9CE, 0x786B, 0,
    1, 0xF9CF, 0x7D10, 0,
    1, 0xF9D0, 0x985E, 0,
    1, 0xF9D1, 0x516D, 0,
    1, 0xF9D2, 0x622E, 0,
    1, 0xF9D3, 0x9678, 0,
    1, 0xF9D4, 0x502B, 0,
    1, 0xF9D5, 0x5D19, 0,
    1, 0xF9D6, 0x6DEA, 0,
    1, 0xF9D7, 0x8F2A, 0,
    1, 0xF9D8, 0x5F8B, 0,
    1, 0xF9D9, 0x6144, 0,
    1, 0xF9DA, 0x6817, 0,
    1, 0xF9DB, 0x7387, 0,
    1, 0xF9DC, 0x9686, 0,
    1, 0xF9DD, 0x5229, 0,
    1, 0xF9DE, 0x540F, 0,
    1, 0xF9DF, 0x5C65, 0,
    1, 0xF9E0, 0x6613, 0,
    1, 0xF9E1, 0x674E, 0,
    1, 0xF9E2, 0x68A8, 0,
    1, 0xF9E3, 0x6CE5, 0,
    1, 0xF9E4, 0x7406, 0,
    1, 0xF9E5, 0x75E2, 0,
    1, 0xF9E6, 0x7F79, 0,
    1, 0xF9E7, 0x88CF, 0,
    1, 0xF9E8, 0x88E1, 0,
    1, 0xF9E9, 0x91CC, 0,
    1, 0xF9EA, 0x96E2, 0,
    1, 0xF9EB, 0x533F, 0,
    1, 0xF9EC, 0x6EBA, 0,
    1, 0xF9ED, 0x541D, 0,
    1, 0xF9EE, 0x71D0, 0,
    1, 0xF9EF, 0x7498, 0,
    1, 0xF9F0, 0x85FA, 0,
    1, 0xF9F1, 0x96A3, 0,
    1, 0xF9F2, 0x9C57, 0,
    1, 0xF9F3, 0x9E9F, 0,
    1, 0xF9F4, 0x6797, 0,
    1, 0xF9F5, 0x6DCB, 0,
    1, 0xF9F6, 0x81E8, 0,
    1, 0xF9F7, 0x7ACB, 0,
    1, 0xF9F8, 0x7B20, 0,
    1, 0xF9F9, 0x7C92, 0,
    1, 0xF9FA, 0x72C0, 0,
    1, 0xF9FB, 0x7099, 0,
    1, 0xF9FC, 0x8B58, 0,
    1, 0xF9FD, 0x4EC0, 0,
    1, 0xF9FE, 0x8336, 0,
    1, 0xF9FF, 0x523A, 0,
    1, 0xFA00, 0x5207, 0,
    1, 0xFA01, 0x5EA6, 0,
    1, 0xFA02, 0x62D3, 0,
    1, 0xFA03, 0x7CD6, 0,
    1, 0xFA04, 0x5B85, 0,
    1, 0xFA05, 0x6D1E, 0,
    1, 0xFA06, 0x66B4, 0,
    1, 0xFA07, 0x8F3B, 0,
    1, 0xFA08, 0x884C, 0,
    1, 0xFA09, 0x964D, 0,
    1, 0xFA0A, 0x898B, 0,
    1, 0xFA0B, 0x5ED3, 0,
    1, 0xFA0C, 0x5140, 0,
    1, 0xFA0D, 0x55C0, 0,
    1, 0xFA10, 0x585A, 0,
    1, 0xFA12, 0x6674, 0,
    1, 0xFA15, 0x51DE, 0,
    1, 0xFA16, 0x732A, 0,
    1, 0xFA17, 0x76CA, 0,
    1, 0xFA18, 0x793C, 0,
    1, 0xFA19, 0x795E, 0,
    1, 0xFA1A, 0x7965, 0,
    1, 0xFA1B, 0x798F, 0,
    1, 0xFA1C, 0x9756, 0,
    1, 0xFA1D, 0x7CBE, 0,
    1, 0xFA1E, 0x7FBD, 0,
    1, 0xFA20, 0x8612, 0,
    1, 0xFA22, 0x8AF8, 0,
    1, 0xFA25, 0x9038, 0,
    1, 0xFA26, 0x90FD, 0,
    1, 0xFA2A, 0x98EF, 0,
    1, 0xFA2B, 0x98FC, 0,
    1, 0xFA2C, 0x9928, 0,
    1, 0xFA2D, 0x9DB4, 0,
    1, 0xFA30, 0x4FAE, 0,
    1, 0xFA31, 0x50E7, 0,
    1, 0xFA32, 0x514D, 0,
    1, 0xFA33, 0x52C9, 0,
    1, 0xFA34, 0x52E4, 0,
    1, 0xFA35, 0x5351, 0,
    1, 0xFA36, 0x559D, 0,
    1, 0xFA37, 0x5606, 0,
    1, 0xFA38, 0x5668, 0,
    1, 0xFA39, 0x5840, 0,
    1, 0xFA3A, 0x58A8, 0,
    1, 0xFA3B, 0x5C64, 0,
    1, 0xFA3C, 0x5C6E, 0,
    1, 0xFA3D, 0x6094, 0,
    1, 0xFA3E, 0x6168, 0,
    1, 0xFA3F, 0x618E, 0,
    1, 0xFA40, 0x61F2, 0,
    1, 0xFA41, 0x654F, 0,
    1, 0xFA42, 0x65E2, 0,
    1, 0xFA43, 0x6691, 0,
    1, 0xFA44, 0x6885, 0,
    1, 0xFA45, 0x6D77, 0,
    1, 0xFA46, 0x6E1A, 0,
    1, 0xFA47, 0x6F22, 0,
    1, 0xFA48, 0x716E, 0,
    1, 0xFA49, 0x722B, 0,
    1, 0xFA4A, 0x7422, 0,
    1, 0xFA4B, 0x7891, 0,
    1, 0xFA4C, 0x793E, 0,
    1, 0xFA4D, 0x7949, 0,
    1, 0xFA4E, 0x7948, 0,
    1, 0xFA4F, 0x7950, 0,
    1, 0xFA50, 0x7956, 0,
    1, 0xFA51, 0x795D, 0,
    1, 0xFA52, 0x798D, 0,
    1, 0xFA53, 0x798E, 0,
    1, 0xFA54, 0x7A40, 0,
    1, 0xFA55, 0x7A81, 0,
    1, 0xFA56, 0x7BC0, 0,
    1, 0xFA57, 0x7DF4, 0,
    1, 0xFA58, 0x7E09, 0,
    1, 0xFA59, 0x7E41, 0,
    1, 0xFA5A, 0x7F72, 0,
    1, 0xFA5B, 0x8005, 0,
    1, 0xFA5C, 0x81ED, 0,
    1, 0xFA5D, 0x8279, 0,
    1, 0xFA5E, 0x8279, 0,
    1, 0xFA5F, 0x8457, 0,
    1, 0xFA60, 0x8910, 0,
    1, 0xFA61, 0x8996, 0,
    1, 0xFA62, 0x8B01, 0,
    1, 0xFA63, 0x8B39, 0,
    1, 0xFA64, 0x8CD3, 0,
    1, 0xFA65, 0x8D08, 0,
    1, 0xFA66, 0x8FB6, 0,
    1, 0xFA67, 0x9038, 0,
    1, 0xFA68, 0x96E3, 0,
    1, 0xFA69, 0x97FF, 0,
    1, 0xFA6A, 0x983B, 0,
    16, 0xFB00, 0x0066, 0x0066, 0,
    16, 0xFB01, 0x0066, 0x0069, 0,
    16, 0xFB02, 0x0066, 0x006C, 0,
    16, 0xFB03, 0x0066, 0x0066, 0x0069, 0,
    16, 0xFB04, 0x0066, 0x0066, 0x006C, 0,
    16, 0xFB05, 0x017F, 0x0074, 0,
    16, 0xFB06, 0x0073, 0x0074, 0,
    16, 0xFB13, 0x0574, 0x0576, 0,
    16, 0xFB14, 0x0574, 0x0565, 0,
    16, 0xFB15, 0x0574, 0x056B, 0,
    16, 0xFB16, 0x057E, 0x0576, 0,
    16, 0xFB17, 0x0574, 0x056D, 0,
    1, 0xFB1D, 0x05D9, 0x05B4, 0,
    1, 0xFB1F, 0x05F2, 0x05B7, 0,
    2, 0xFB20, 0x05E2, 0,
    2, 0xFB21, 0x05D0, 0,
    2, 0xFB22, 0x05D3, 0,
    2, 0xFB23, 0x05D4, 0,
    2, 0xFB24, 0x05DB, 0,
    2, 0xFB25, 0x05DC, 0,
    2, 0xFB26, 0x05DD, 0,
    2, 0xFB27, 0x05E8, 0,
    2, 0xFB28, 0x05EA, 0,
    2, 0xFB29, 0x002B, 0,
    1, 0xFB2A, 0x05E9, 0x05C1, 0,
    1, 0xFB2B, 0x05E9, 0x05C2, 0,
    1, 0xFB2C, 0xFB49, 0x05C1, 0,
    1, 0xFB2D, 0xFB49, 0x05C2, 0,
    1, 0xFB2E, 0x05D0, 0x05B7, 0,
    1, 0xFB2F, 0x05D0, 0x05B8, 0,
    1, 0xFB30, 0x05D0, 0x05BC, 0,
    1, 0xFB31, 0x05D1, 0x05BC, 0,
    1, 0xFB32, 0x05D2, 0x05BC, 0,
    1, 0xFB33, 0x05D3, 0x05BC, 0,
    1, 0xFB34, 0x05D4, 0x05BC, 0,
    1, 0xFB35, 0x05D5, 0x05BC, 0,
    1, 0xFB36, 0x05D6, 0x05BC, 0,
    1, 0xFB38, 0x05D8, 0x05BC, 0,
    1, 0xFB39, 0x05D9, 0x05BC, 0,
    1, 0xFB3A, 0x05DA, 0x05BC, 0,
    1, 0xFB3B, 0x05DB, 0x05BC, 0,
    1, 0xFB3C, 0x05DC, 0x05BC, 0,
    1, 0xFB3E, 0x05DE, 0x05BC, 0,
    1, 0xFB40, 0x05E0, 0x05BC, 0,
    1, 0xFB41, 0x05E1, 0x05BC, 0,
    1, 0xFB43, 0x05E3, 0x05BC, 0,
    1, 0xFB44, 0x05E4, 0x05BC, 0,
    1, 0xFB46, 0x05E6, 0x05BC, 0,
    1, 0xFB47, 0x05E7, 0x05BC, 0,
    1, 0xFB48, 0x05E8, 0x05BC, 0,
    1, 0xFB49, 0x05E9, 0x05BC, 0,
    1, 0xFB4A, 0x05EA, 0x05BC, 0,
    1, 0xFB4B, 0x05D5, 0x05B9, 0,
    1, 0xFB4C, 0x05D1, 0x05BF, 0,
    1, 0xFB4D, 0x05DB, 0x05BF, 0,
    1, 0xFB4E, 0x05E4, 0x05BF, 0,
    16, 0xFB4F, 0x05D0, 0x05DC, 0,
    7, 0xFB50, 0x0671, 0,
    6, 0xFB51, 0x0671, 0,
    7, 0xFB52, 0x067B, 0,
    6, 0xFB53, 0x067B, 0,
    4, 0xFB54, 0x067B, 0,
    5, 0xFB55, 0x067B, 0,
    7, 0xFB56, 0x067E, 0,
    6, 0xFB57, 0x067E, 0,
    4, 0xFB58, 0x067E, 0,
    5, 0xFB59, 0x067E, 0,
    7, 0xFB5A, 0x0680, 0,
    6, 0xFB5B, 0x0680, 0,
    4, 0xFB5C, 0x0680, 0,
    5, 0xFB5D, 0x0680, 0,
    7, 0xFB5E, 0x067A, 0,
    6, 0xFB5F, 0x067A, 0,
    4, 0xFB60, 0x067A, 0,
    5, 0xFB61, 0x067A, 0,
    7, 0xFB62, 0x067F, 0,
    6, 0xFB63, 0x067F, 0,
    4, 0xFB64, 0x067F, 0,
    5, 0xFB65, 0x067F, 0,
    7, 0xFB66, 0x0679, 0,
    6, 0xFB67, 0x0679, 0,
    4, 0xFB68, 0x0679, 0,
    5, 0xFB69, 0x0679, 0,
    7, 0xFB6A, 0x06A4, 0,
    6, 0xFB6B, 0x06A4, 0,
    4, 0xFB6C, 0x06A4, 0,
    5, 0xFB6D, 0x06A4, 0,
    7, 0xFB6E, 0x06A6, 0,
    6, 0xFB6F, 0x06A6, 0,
    4, 0xFB70, 0x06A6, 0,
    5, 0xFB71, 0x06A6, 0,
    7, 0xFB72, 0x0684, 0,
    6, 0xFB73, 0x0684, 0,
    4, 0xFB74, 0x0684, 0,
    5, 0xFB75, 0x0684, 0,
    7, 0xFB76, 0x0683, 0,
    6, 0xFB77, 0x0683, 0,
    4, 0xFB78, 0x0683, 0,
    5, 0xFB79, 0x0683, 0,
    7, 0xFB7A, 0x0686, 0,
    6, 0xFB7B, 0x0686, 0,
    4, 0xFB7C, 0x0686, 0,
    5, 0xFB7D, 0x0686, 0,
    7, 0xFB7E, 0x0687, 0,
    6, 0xFB7F, 0x0687, 0,
    4, 0xFB80, 0x0687, 0,
    5, 0xFB81, 0x0687, 0,
    7, 0xFB82, 0x068D, 0,
    6, 0xFB83, 0x068D, 0,
    7, 0xFB84, 0x068C, 0,
    6, 0xFB85, 0x068C, 0,
    7, 0xFB86, 0x068E, 0,
    6, 0xFB87, 0x068E, 0,
    7, 0xFB88, 0x0688, 0,
    6, 0xFB89, 0x0688, 0,
    7, 0xFB8A, 0x0698, 0,
    6, 0xFB8B, 0x0698, 0,
    7, 0xFB8C, 0x0691, 0,
    6, 0xFB8D, 0x0691, 0,
    7, 0xFB8E, 0x06A9, 0,
    6, 0xFB8F, 0x06A9, 0,
    4, 0xFB90, 0x06A9, 0,
    5, 0xFB91, 0x06A9, 0,
    7, 0xFB92, 0x06AF, 0,
    6, 0xFB93, 0x06AF, 0,
    4, 0xFB94, 0x06AF, 0,
    5, 0xFB95, 0x06AF, 0,
    7, 0xFB96, 0x06B3, 0,
    6, 0xFB97, 0x06B3, 0,
    4, 0xFB98, 0x06B3, 0,
    5, 0xFB99, 0x06B3, 0,
    7, 0xFB9A, 0x06B1, 0,
    6, 0xFB9B, 0x06B1, 0,
    4, 0xFB9C, 0x06B1, 0,
    5, 0xFB9D, 0x06B1, 0,
    7, 0xFB9E, 0x06BA, 0,
    6, 0xFB9F, 0x06BA, 0,
    7, 0xFBA0, 0x06BB, 0,
    6, 0xFBA1, 0x06BB, 0,
    4, 0xFBA2, 0x06BB, 0,
    5, 0xFBA3, 0x06BB, 0,
    7, 0xFBA4, 0x06C0, 0,
    6, 0xFBA5, 0x06C0, 0,
    7, 0xFBA6, 0x06C1, 0,
    6, 0xFBA7, 0x06C1, 0,
    4, 0xFBA8, 0x06C1, 0,
    5, 0xFBA9, 0x06C1, 0,
    7, 0xFBAA, 0x06BE, 0,
    6, 0xFBAB, 0x06BE, 0,
    4, 0xFBAC, 0x06BE, 0,
    5, 0xFBAD, 0x06BE, 0,
    7, 0xFBAE, 0x06D2, 0,
    6, 0xFBAF, 0x06D2, 0,
    7, 0xFBB0, 0x06D3, 0,
    6, 0xFBB1, 0x06D3, 0,
    7, 0xFBD3, 0x06AD, 0,
    6, 0xFBD4, 0x06AD, 0,
    4, 0xFBD5, 0x06AD, 0,
    5, 0xFBD6, 0x06AD, 0,
    7, 0xFBD7, 0x06C7, 0,
    6, 0xFBD8, 0x06C7, 0,
    7, 0xFBD9, 0x06C6, 0,
    6, 0xFBDA, 0x06C6, 0,
    7, 0xFBDB, 0x06C8, 0,
    6, 0xFBDC, 0x06C8, 0,
    7, 0xFBDD, 0x0677, 0,
    7, 0xFBDE, 0x06CB, 0,
    6, 0xFBDF, 0x06CB, 0,
    7, 0xFBE0, 0x06C5, 0,
    6, 0xFBE1, 0x06C5, 0,
    7, 0xFBE2, 0x06C9, 0,
    6, 0xFBE3, 0x06C9, 0,
    7, 0xFBE4, 0x06D0, 0,
    6, 0xFBE5, 0x06D0, 0,
    4, 0xFBE6, 0x06D0, 0,
    5, 0xFBE7, 0x06D0, 0,
    4, 0xFBE8, 0x0649, 0,
    5, 0xFBE9, 0x0649, 0,
    7, 0xFBEA, 0x0626, 0x0627, 0,
    6, 0xFBEB, 0x0626, 0x0627, 0,
    7, 0xFBEC, 0x0626, 0x06D5, 0,
    6, 0xFBED, 0x0626, 0x06D5, 0,
    7, 0xFBEE, 0x0626, 0x0648, 0,
    6, 0xFBEF, 0x0626, 0x0648, 0,
    7, 0xFBF0, 0x0626, 0x06C7, 0,
    6, 0xFBF1, 0x0626, 0x06C7, 0,
    7, 0xFBF2, 0x0626, 0x06C6, 0,
    6, 0xFBF3, 0x0626, 0x06C6, 0,
    7, 0xFBF4, 0x0626, 0x06C8, 0,
    6, 0xFBF5, 0x0626, 0x06C8, 0,
    7, 0xFBF6, 0x0626, 0x06D0, 0,
    6, 0xFBF7, 0x0626, 0x06D0, 0,
    4, 0xFBF8, 0x0626, 0x06D0, 0,
    7, 0xFBF9, 0x0626, 0x0649, 0,
    6, 0xFBFA, 0x0626, 0x0649, 0,
    4, 0xFBFB, 0x0626, 0x0649, 0,
    7, 0xFBFC, 0x06CC, 0,
    6, 0xFBFD, 0x06CC, 0,
    4, 0xFBFE, 0x06CC, 0,
    5, 0xFBFF, 0x06CC, 0,
    7, 0xFC00, 0x0626, 0x062C, 0,
    7, 0xFC01, 0x0626, 0x062D, 0,
    7, 0xFC02, 0x0626, 0x0645, 0,
    7, 0xFC03, 0x0626, 0x0649, 0,
    7, 0xFC04, 0x0626, 0x064A, 0,
    7, 0xFC05, 0x0628, 0x062C, 0,
    7, 0xFC06, 0x0628, 0x062D, 0,
    7, 0xFC07, 0x0628, 0x062E, 0,
    7, 0xFC08, 0x0628, 0x0645, 0,
    7, 0xFC09, 0x0628, 0x0649, 0,
    7, 0xFC0A, 0x0628, 0x064A, 0,
    7, 0xFC0B, 0x062A, 0x062C, 0,
    7, 0xFC0C, 0x062A, 0x062D, 0,
    7, 0xFC0D, 0x062A, 0x062E, 0,
    7, 0xFC0E, 0x062A, 0x0645, 0,
    7, 0xFC0F, 0x062A, 0x0649, 0,
    7, 0xFC10, 0x062A, 0x064A, 0,
    7, 0xFC11, 0x062B, 0x062C, 0,
    7, 0xFC12, 0x062B, 0x0645, 0,
    7, 0xFC13, 0x062B, 0x0649, 0,
    7, 0xFC14, 0x062B, 0x064A, 0,
    7, 0xFC15, 0x062C, 0x062D, 0,
    7, 0xFC16, 0x062C, 0x0645, 0,
    7, 0xFC17, 0x062D, 0x062C, 0,
    7, 0xFC18, 0x062D, 0x0645, 0,
    7, 0xFC19, 0x062E, 0x062C, 0,
    7, 0xFC1A, 0x062E, 0x062D, 0,
    7, 0xFC1B, 0x062E, 0x0645, 0,
    7, 0xFC1C, 0x0633, 0x062C, 0,
    7, 0xFC1D, 0x0633, 0x062D, 0,
    7, 0xFC1E, 0x0633, 0x062E, 0,
    7, 0xFC1F, 0x0633, 0x0645, 0,
    7, 0xFC20, 0x0635, 0x062D, 0,
    7, 0xFC21, 0x0635, 0x0645, 0,
    7, 0xFC22, 0x0636, 0x062C, 0,
    7, 0xFC23, 0x0636, 0x062D, 0,
    7, 0xFC24, 0x0636, 0x062E, 0,
    7, 0xFC25, 0x0636, 0x0645, 0,
    7, 0xFC26, 0x0637, 0x062D, 0,
    7, 0xFC27, 0x0637, 0x0645, 0,
    7, 0xFC28, 0x0638, 0x0645, 0,
    7, 0xFC29, 0x0639, 0x062C, 0,
    7, 0xFC2A, 0x0639, 0x0645, 0,
    7, 0xFC2B, 0x063A, 0x062C, 0,
    7, 0xFC2C, 0x063A, 0x0645, 0,
    7, 0xFC2D, 0x0641, 0x062C, 0,
    7, 0xFC2E, 0x0641, 0x062D, 0,
    7, 0xFC2F, 0x0641, 0x062E, 0,
    7, 0xFC30, 0x0641, 0x0645, 0,
    7, 0xFC31, 0x0641, 0x0649, 0,
    7, 0xFC32, 0x0641, 0x064A, 0,
    7, 0xFC33, 0x0642, 0x062D, 0,
    7, 0xFC34, 0x0642, 0x0645, 0,
    7, 0xFC35, 0x0642, 0x0649, 0,
    7, 0xFC36, 0x0642, 0x064A, 0,
    7, 0xFC37, 0x0643, 0x0627, 0,
    7, 0xFC38, 0x0643, 0x062C, 0,
    7, 0xFC39, 0x0643, 0x062D, 0,
    7, 0xFC3A, 0x0643, 0x062E, 0,
    7, 0xFC3B, 0x0643, 0x0644, 0,
    7, 0xFC3C, 0x0643, 0x0645, 0,
    7, 0xFC3D, 0x0643, 0x0649, 0,
    7, 0xFC3E, 0x0643, 0x064A, 0,
    7, 0xFC3F, 0x0644, 0x062C, 0,
    7, 0xFC40, 0x0644, 0x062D, 0,
    7, 0xFC41, 0x0644, 0x062E, 0,
    7, 0xFC42, 0x0644, 0x0645, 0,
    7, 0xFC43, 0x0644, 0x0649, 0,
    7, 0xFC44, 0x0644, 0x064A, 0,
    7, 0xFC45, 0x0645, 0x062C, 0,
    7, 0xFC46, 0x0645, 0x062D, 0,
    7, 0xFC47, 0x0645, 0x062E, 0,
    7, 0xFC48, 0x0645, 0x0645, 0,
    7, 0xFC49, 0x0645, 0x0649, 0,
    7, 0xFC4A, 0x0645, 0x064A, 0,
    7, 0xFC4B, 0x0646, 0x062C, 0,
    7, 0xFC4C, 0x0646, 0x062D, 0,
    7, 0xFC4D, 0x0646, 0x062E, 0,
    7, 0xFC4E, 0x0646, 0x0645, 0,
    7, 0xFC4F, 0x0646, 0x0649, 0,
    7, 0xFC50, 0x0646, 0x064A, 0,
    7, 0xFC51, 0x0647, 0x062C, 0,
    7, 0xFC52, 0x0647, 0x0645, 0,
    7, 0xFC53, 0x0647, 0x0649, 0,
    7, 0xFC54, 0x0647, 0x064A, 0,
    7, 0xFC55, 0x064A, 0x062C, 0,
    7, 0xFC56, 0x064A, 0x062D, 0,
    7, 0xFC57, 0x064A, 0x062E, 0,
    7, 0xFC58, 0x064A, 0x0645, 0,
    7, 0xFC59, 0x064A, 0x0649, 0,
    7, 0xFC5A, 0x064A, 0x064A, 0,
    7, 0xFC5B, 0x0630, 0x0670, 0,
    7, 0xFC5C, 0x0631, 0x0670, 0,
    7, 0xFC5D, 0x0649, 0x0670, 0,
    7, 0xFC5E, 0x0020, 0x064C, 0x0651, 0,
    7, 0xFC5F, 0x0020, 0x064D, 0x0651, 0,
    7, 0xFC60, 0x0020, 0x064E, 0x0651, 0,
    7, 0xFC61, 0x0020, 0x064F, 0x0651, 0,
    7, 0xFC62, 0x0020, 0x0650, 0x0651, 0,
    7, 0xFC63, 0x0020, 0x0651, 0x0670, 0,
    6, 0xFC64, 0x0626, 0x0631, 0,
    6, 0xFC65, 0x0626, 0x0632, 0,
    6, 0xFC66, 0x0626, 0x0645, 0,
    6, 0xFC67, 0x0626, 0x0646, 0,
    6, 0xFC68, 0x0626, 0x0649, 0,
    6, 0xFC69, 0x0626, 0x064A, 0,
    6, 0xFC6A, 0x0628, 0x0631, 0,
    6, 0xFC6B, 0x0628, 0x0632, 0,
    6, 0xFC6C, 0x0628, 0x0645, 0,
    6, 0xFC6D, 0x0628, 0x0646, 0,
    6, 0xFC6E, 0x0628, 0x0649, 0,
    6, 0xFC6F, 0x0628, 0x064A, 0,
    6, 0xFC70, 0x062A, 0x0631, 0,
    6, 0xFC71, 0x062A, 0x0632, 0,
    6, 0xFC72, 0x062A, 0x0645, 0,
    6, 0xFC73, 0x062A, 0x0646, 0,
    6, 0xFC74, 0x062A, 0x0649, 0,
    6, 0xFC75, 0x062A, 0x064A, 0,
    6, 0xFC76, 0x062B, 0x0631, 0,
    6, 0xFC77, 0x062B, 0x0632, 0,
    6, 0xFC78, 0x062B, 0x0645, 0,
    6, 0xFC79, 0x062B, 0x0646, 0,
    6, 0xFC7A, 0x062B, 0x0649, 0,
    6, 0xFC7B, 0x062B, 0x064A, 0,
    6, 0xFC7C, 0x0641, 0x0649, 0,
    6, 0xFC7D, 0x0641, 0x064A, 0,
    6, 0xFC7E, 0x0642, 0x0649, 0,
    6, 0xFC7F, 0x0642, 0x064A, 0,
    6, 0xFC80, 0x0643, 0x0627, 0,
    6, 0xFC81, 0x0643, 0x0644, 0,
    6, 0xFC82, 0x0643, 0x0645, 0,
    6, 0xFC83, 0x0643, 0x0649, 0,
    6, 0xFC84, 0x0643, 0x064A, 0,
    6, 0xFC85, 0x0644, 0x0645, 0,
    6, 0xFC86, 0x0644, 0x0649, 0,
    6, 0xFC87, 0x0644, 0x064A, 0,
    6, 0xFC88, 0x0645, 0x0627, 0,
    6, 0xFC89, 0x0645, 0x0645, 0,
    6, 0xFC8A, 0x0646, 0x0631, 0,
    6, 0xFC8B, 0x0646, 0x0632, 0,
    6, 0xFC8C, 0x0646, 0x0645, 0,
    6, 0xFC8D, 0x0646, 0x0646, 0,
    6, 0xFC8E, 0x0646, 0x0649, 0,
    6, 0xFC8F, 0x0646, 0x064A, 0,
    6, 0xFC90, 0x0649, 0x0670, 0,
    6, 0xFC91, 0x064A, 0x0631, 0,
    6, 0xFC92, 0x064A, 0x0632, 0,
    6, 0xFC93, 0x064A, 0x0645, 0,
    6, 0xFC94, 0x064A, 0x0646, 0,
    6, 0xFC95, 0x064A, 0x0649, 0,
    6, 0xFC96, 0x064A, 0x064A, 0,
    4, 0xFC97, 0x0626, 0x062C, 0,
    4, 0xFC98, 0x0626, 0x062D, 0,
    4, 0xFC99, 0x0626, 0x062E, 0,
    4, 0xFC9A, 0x0626, 0x0645, 0,
    4, 0xFC9B, 0x0626, 0x0647, 0,
    4, 0xFC9C, 0x0628, 0x062C, 0,
    4, 0xFC9D, 0x0628, 0x062D, 0,
    4, 0xFC9E, 0x0628, 0x062E, 0,
    4, 0xFC9F, 0x0628, 0x0645, 0,
    4, 0xFCA0, 0x0628, 0x0647, 0,
    4, 0xFCA1, 0x062A, 0x062C, 0,
    4, 0xFCA2, 0x062A, 0x062D, 0,
    4, 0xFCA3, 0x062A, 0x062E, 0,
    4, 0xFCA4, 0x062A, 0x0645, 0,
    4, 0xFCA5, 0x062A, 0x0647, 0,
    4, 0xFCA6, 0x062B, 0x0645, 0,
    4, 0xFCA7, 0x062C, 0x062D, 0,
    4, 0xFCA8, 0x062C, 0x0645, 0,
    4, 0xFCA9, 0x062D, 0x062C, 0,
    4, 0xFCAA, 0x062D, 0x0645, 0,
    4, 0xFCAB, 0x062E, 0x062C, 0,
    4, 0xFCAC, 0x062E, 0x0645, 0,
    4, 0xFCAD, 0x0633, 0x062C, 0,
    4, 0xFCAE, 0x0633, 0x062D, 0,
    4, 0xFCAF, 0x0633, 0x062E, 0,
    4, 0xFCB0, 0x0633, 0x0645, 0,
    4, 0xFCB1, 0x0635, 0x062D, 0,
    4, 0xFCB2, 0x0635, 0x062E, 0,
    4, 0xFCB3, 0x0635, 0x0645, 0,
    4, 0xFCB4, 0x0636, 0x062C, 0,
    4, 0xFCB5, 0x0636, 0x062D, 0,
    4, 0xFCB6, 0x0636, 0x062E, 0,
    4, 0xFCB7, 0x0636, 0x0645, 0,
    4, 0xFCB8, 0x0637, 0x062D, 0,
    4, 0xFCB9, 0x0638, 0x0645, 0,
    4, 0xFCBA, 0x0639, 0x062C, 0,
    4, 0xFCBB, 0x0639, 0x0645, 0,
    4, 0xFCBC, 0x063A, 0x062C, 0,
    4, 0xFCBD, 0x063A, 0x0645, 0,
    4, 0xFCBE, 0x0641, 0x062C, 0,
    4, 0xFCBF, 0x0641, 0x062D, 0,
    4, 0xFCC0, 0x0641, 0x062E, 0,
    4, 0xFCC1, 0x0641, 0x0645, 0,
    4, 0xFCC2, 0x0642, 0x062D, 0,
    4, 0xFCC3, 0x0642, 0x0645, 0,
    4, 0xFCC4, 0x0643, 0x062C, 0,
    4, 0xFCC5, 0x0643, 0x062D, 0,
    4, 0xFCC6, 0x0643, 0x062E, 0,
    4, 0xFCC7, 0x0643, 0x0644, 0,
    4, 0xFCC8, 0x0643, 0x0645, 0,
    4, 0xFCC9, 0x0644, 0x062C, 0,
    4, 0xFCCA, 0x0644, 0x062D, 0,
    4, 0xFCCB, 0x0644, 0x062E, 0,
    4, 0xFCCC, 0x0644, 0x0645, 0,
    4, 0xFCCD, 0x0644, 0x0647, 0,
    4, 0xFCCE, 0x0645, 0x062C, 0,
    4, 0xFCCF, 0x0645, 0x062D, 0,
    4, 0xFCD0, 0x0645, 0x062E, 0,
    4, 0xFCD1, 0x0645, 0x0645, 0,
    4, 0xFCD2, 0x0646, 0x062C, 0,
    4, 0xFCD3, 0x0646, 0x062D, 0,
    4, 0xFCD4, 0x0646, 0x062E, 0,
    4, 0xFCD5, 0x0646, 0x0645, 0,
    4, 0xFCD6, 0x0646, 0x0647, 0,
    4, 0xFCD7, 0x0647, 0x062C, 0,
    4, 0xFCD8, 0x0647, 0x0645, 0,
    4, 0xFCD9, 0x0647, 0x0670, 0,
    4, 0xFCDA, 0x064A, 0x062C, 0,
    4, 0xFCDB, 0x064A, 0x062D, 0,
    4, 0xFCDC, 0x064A, 0x062E, 0,
    4, 0xFCDD, 0x064A, 0x0645, 0,
    4, 0xFCDE, 0x064A, 0x0647, 0,
    5, 0xFCDF, 0x0626, 0x0645, 0,
    5, 0xFCE0, 0x0626, 0x0647, 0,
    5, 0xFCE1, 0x0628, 0x0645, 0,
    5, 0xFCE2, 0x0628, 0x0647, 0,
    5, 0xFCE3, 0x062A, 0x0645, 0,
    5, 0xFCE4, 0x062A, 0x0647, 0,
    5, 0xFCE5, 0x062B, 0x0645, 0,
    5, 0xFCE6, 0x062B, 0x0647, 0,
    5, 0xFCE7, 0x0633, 0x0645, 0,
    5, 0xFCE8, 0x0633, 0x0647, 0,
    5, 0xFCE9, 0x0634, 0x0645, 0,
    5, 0xFCEA, 0x0634, 0x0647, 0,
    5, 0xFCEB, 0x0643, 0x0644, 0,
    5, 0xFCEC, 0x0643, 0x0645, 0,
    5, 0xFCED, 0x0644, 0x0645, 0,
    5, 0xFCEE, 0x0646, 0x0645, 0,
    5, 0xFCEF, 0x0646, 0x0647, 0,
    5, 0xFCF0, 0x064A, 0x0645, 0,
    5, 0xFCF1, 0x064A, 0x0647, 0,
    5, 0xFCF2, 0x0640, 0x064E, 0x0651, 0,
    5, 0xFCF3, 0x0640, 0x064F, 0x0651, 0,
    5, 0xFCF4, 0x0640, 0x0650, 0x0651, 0,
    7, 0xFCF5, 0x0637, 0x0649, 0,
    7, 0xFCF6, 0x0637, 0x064A, 0,
    7, 0xFCF7, 0x0639, 0x0649, 0,
    7, 0xFCF8, 0x0639, 0x064A, 0,
    7, 0xFCF9, 0x063A, 0x0649, 0,
    7, 0xFCFA, 0x063A, 0x064A, 0,
    7, 0xFCFB, 0x0633, 0x0649, 0,
    7, 0xFCFC, 0x0633, 0x064A, 0,
    7, 0xFCFD, 0x0634, 0x0649, 0,
    7, 0xFCFE, 0x0634, 0x064A, 0,
    7, 0xFCFF, 0x062D, 0x0649, 0,
    7, 0xFD00, 0x062D, 0x064A, 0,
    7, 0xFD01, 0x062C, 0x0649, 0,
    7, 0xFD02, 0x062C, 0x064A, 0,
    7, 0xFD03, 0x062E, 0x0649, 0,
    7, 0xFD04, 0x062E, 0x064A, 0,
    7, 0xFD05, 0x0635, 0x0649, 0,
    7, 0xFD06, 0x0635, 0x064A, 0,
    7, 0xFD07, 0x0636, 0x0649, 0,
    7, 0xFD08, 0x0636, 0x064A, 0,
    7, 0xFD09, 0x0634, 0x062C, 0,
    7, 0xFD0A, 0x0634, 0x062D, 0,
    7, 0xFD0B, 0x0634, 0x062E, 0,
    7, 0xFD0C, 0x0634, 0x0645, 0,
    7, 0xFD0D, 0x0634, 0x0631, 0,
    7, 0xFD0E, 0x0633, 0x0631, 0,
    7, 0xFD0F, 0x0635, 0x0631, 0,
    7, 0xFD10, 0x0636, 0x0631, 0,
    6, 0xFD11, 0x0637, 0x0649, 0,
    6, 0xFD12, 0x0637, 0x064A, 0,
    6, 0xFD13, 0x0639, 0x0649, 0,
    6, 0xFD14, 0x0639, 0x064A, 0,
    6, 0xFD15, 0x063A, 0x0649, 0,
    6, 0xFD16, 0x063A, 0x064A, 0,
    6, 0xFD17, 0x0633, 0x0649, 0,
    6, 0xFD18, 0x0633, 0x064A, 0,
    6, 0xFD19, 0x0634, 0x0649, 0,
    6, 0xFD1A, 0x0634, 0x064A, 0,
    6, 0xFD1B, 0x062D, 0x0649, 0,
    6, 0xFD1C, 0x062D, 0x064A, 0,
    6, 0xFD1D, 0x062C, 0x0649, 0,
    6, 0xFD1E, 0x062C, 0x064A, 0,
    6, 0xFD1F, 0x062E, 0x0649, 0,
    6, 0xFD20, 0x062E, 0x064A, 0,
    6, 0xFD21, 0x0635, 0x0649, 0,
    6, 0xFD22, 0x0635, 0x064A, 0,
    6, 0xFD23, 0x0636, 0x0649, 0,
    6, 0xFD24, 0x0636, 0x064A, 0,
    6, 0xFD25, 0x0634, 0x062C, 0,
    6, 0xFD26, 0x0634, 0x062D, 0,
    6, 0xFD27, 0x0634, 0x062E, 0,
    6, 0xFD28, 0x0634, 0x0645, 0,
    6, 0xFD29, 0x0634, 0x0631, 0,
    6, 0xFD2A, 0x0633, 0x0631, 0,
    6, 0xFD2B, 0x0635, 0x0631, 0,
    6, 0xFD2C, 0x0636, 0x0631, 0,
    4, 0xFD2D, 0x0634, 0x062C, 0,
    4, 0xFD2E, 0x0634, 0x062D, 0,
    4, 0xFD2F, 0x0634, 0x062E, 0,
    4, 0xFD30, 0x0634, 0x0645, 0,
    4, 0xFD31, 0x0633, 0x0647, 0,
    4, 0xFD32, 0x0634, 0x0647, 0,
    4, 0xFD33, 0x0637, 0x0645, 0,
    5, 0xFD34, 0x0633, 0x062C, 0,
    5, 0xFD35, 0x0633, 0x062D, 0,
    5, 0xFD36, 0x0633, 0x062E, 0,
    5, 0xFD37, 0x0634, 0x062C, 0,
    5, 0xFD38, 0x0634, 0x062D, 0,
    5, 0xFD39, 0x0634, 0x062E, 0,
    5, 0xFD3A, 0x0637, 0x0645, 0,
    5, 0xFD3B, 0x0638, 0x0645, 0,
    6, 0xFD3C, 0x0627, 0x064B, 0,
    7, 0xFD3D, 0x0627, 0x064B, 0,
    4, 0xFD50, 0x062A, 0x062C, 0x0645, 0,
    6, 0xFD51, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD52, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD53, 0x062A, 0x062D, 0x0645, 0,
    4, 0xFD54, 0x062A, 0x062E, 0x0645, 0,
    4, 0xFD55, 0x062A, 0x0645, 0x062C, 0,
    4, 0xFD56, 0x062A, 0x0645, 0x062D, 0,
    4, 0xFD57, 0x062A, 0x0645, 0x062E, 0,
    6, 0xFD58, 0x062C, 0x0645, 0x062D, 0,
    4, 0xFD59, 0x062C, 0x0645, 0x062D, 0,
    6, 0xFD5A, 0x062D, 0x0645, 0x064A, 0,
    6, 0xFD5B, 0x062D, 0x0645, 0x0649, 0,
    4, 0xFD5C, 0x0633, 0x062D, 0x062C, 0,
    4, 0xFD5D, 0x0633, 0x062C, 0x062D, 0,
    6, 0xFD5E, 0x0633, 0x062C, 0x0649, 0,
    6, 0xFD5F, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD60, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD61, 0x0633, 0x0645, 0x062C, 0,
    6, 0xFD62, 0x0633, 0x0645, 0x0645, 0,
    4, 0xFD63, 0x0633, 0x0645, 0x0645, 0,
    6, 0xFD64, 0x0635, 0x062D, 0x062D, 0,
    4, 0xFD65, 0x0635, 0x062D, 0x062D, 0,
    6, 0xFD66, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFD67, 0x0634, 0x062D, 0x0645, 0,
    4, 0xFD68, 0x0634, 0x062D, 0x0645, 0,
    6, 0xFD69, 0x0634, 0x062C, 0x064A, 0,
    6, 0xFD6A, 0x0634, 0x0645, 0x062E, 0,
    4, 0xFD6B, 0x0634, 0x0645, 0x062E, 0,
    6, 0xFD6C, 0x0634, 0x0645, 0x0645, 0,
    4, 0xFD6D, 0x0634, 0x0645, 0x0645, 0,
    6, 0xFD6E, 0x0636, 0x062D, 0x0649, 0,
    6, 0xFD6F, 0x0636, 0x062E, 0x0645, 0,
    4, 0xFD70, 0x0636, 0x062E, 0x0645, 0,
    6, 0xFD71, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD72, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD73, 0x0637, 0x0645, 0x0645, 0,
    6, 0xFD74, 0x0637, 0x0645, 0x064A, 0,
    6, 0xFD75, 0x0639, 0x062C, 0x0645, 0,
    6, 0xFD76, 0x0639, 0x0645, 0x0645, 0,
    4, 0xFD77, 0x0639, 0x0645, 0x0645, 0,
    6, 0xFD78, 0x0639, 0x0645, 0x0649, 0,
    6, 0xFD79, 0x063A, 0x0645, 0x0645, 0,
    6, 0xFD7A, 0x063A, 0x0645, 0x064A, 0,
    6, 0xFD7B, 0x063A, 0x0645, 0x0649, 0,
    6, 0xFD7C, 0x0641, 0x062E, 0x0645, 0,
    4, 0xFD7D, 0x0641, 0x062E, 0x0645, 0,
    6, 0xFD7E, 0x0642, 0x0645, 0x062D, 0,
    6, 0xFD7F, 0x0642, 0x0645, 0x0645, 0,
    6, 0xFD80, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFD81, 0x0644, 0x062D, 0x064A, 0,
    6, 0xFD82, 0x0644, 0x062D, 0x0649, 0,
    4, 0xFD83, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD84, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD85, 0x0644, 0x062E, 0x0645, 0,
    4, 0xFD86, 0x0644, 0x062E, 0x0645, 0,
    6, 0xFD87, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD88, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD89, 0x0645, 0x062D, 0x062C, 0,
    4, 0xFD8A, 0x0645, 0x062D, 0x0645, 0,
    6, 0xFD8B, 0x0645, 0x062D, 0x064A, 0,
    4, 0xFD8C, 0x0645, 0x062C, 0x062D, 0,
    4, 0xFD8D, 0x0645, 0x062C, 0x0645, 0,
    4, 0xFD8E, 0x0645, 0x062E, 0x062C, 0,
    4, 0xFD8F, 0x0645, 0x062E, 0x0645, 0,
    4, 0xFD92, 0x0645, 0x062C, 0x062E, 0,
    4, 0xFD93, 0x0647, 0x0645, 0x062C, 0,
    4, 0xFD94, 0x0647, 0x0645, 0x0645, 0,
    4, 0xFD95, 0x0646, 0x062D, 0x0645, 0,
    6, 0xFD96, 0x0646, 0x062D, 0x0649, 0,
    6, 0xFD97, 0x0646, 0x062C, 0x0645, 0,
    4, 0xFD98, 0x0646, 0x062C, 0x0645, 0,
    6, 0xFD99, 0x0646, 0x062C, 0x0649, 0,
    6, 0xFD9A, 0x0646, 0x0645, 0x064A, 0,
    6, 0xFD9B, 0x0646, 0x0645, 0x0649, 0,
    6, 0xFD9C, 0x064A, 0x0645, 0x0645, 0,
    4, 0xFD9D, 0x064A, 0x0645, 0x0645, 0,
    6, 0xFD9E, 0x0628, 0x062E, 0x064A, 0,
    6, 0xFD9F, 0x062A, 0x062C, 0x064A, 0,
    6, 0xFDA0, 0x062A, 0x062C, 0x0649, 0,
    6, 0xFDA1, 0x062A, 0x062E, 0x064A, 0,
    6, 0xFDA2, 0x062A, 0x062E, 0x0649, 0,
    6, 0xFDA3, 0x062A, 0x0645, 0x064A, 0,
    6, 0xFDA4, 0x062A, 0x0645, 0x0649, 0,
    6, 0xFDA5, 0x062C, 0x0645, 0x064A, 0,
    6, 0xFDA6, 0x062C, 0x062D, 0x0649, 0,
    6, 0xFDA7, 0x062C, 0x0645, 0x0649, 0,
    6, 0xFDA8, 0x0633, 0x062E, 0x0649, 0,
    6, 0xFDA9, 0x0635, 0x062D, 0x064A, 0,
    6, 0xFDAA, 0x0634, 0x062D, 0x064A, 0,
    6, 0xFDAB, 0x0636, 0x062D, 0x064A, 0,
    6, 0xFDAC, 0x0644, 0x062C, 0x064A, 0,
    6, 0xFDAD, 0x0644, 0x0645, 0x064A, 0,
    6, 0xFDAE, 0x064A, 0x062D, 0x064A, 0,
    6, 0xFDAF, 0x064A, 0x062C, 0x064A, 0,
    6, 0xFDB0, 0x064A, 0x0645, 0x064A, 0,
    6, 0xFDB1, 0x0645, 0x0645, 0x064A, 0,
    6, 0xFDB2, 0x0642, 0x0645, 0x064A, 0,
    6, 0xFDB3, 0x0646, 0x062D, 0x064A, 0,
    4, 0xFDB4, 0x0642, 0x0645, 0x062D, 0,
    4, 0xFDB5, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFDB6, 0x0639, 0x0645, 0x064A, 0,
    6, 0xFDB7, 0x0643, 0x0645, 0x064A, 0,
    4, 0xFDB8, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDB9, 0x0645, 0x062E, 0x064A, 0,
    4, 0xFDBA, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBB, 0x0643, 0x0645, 0x0645, 0,
    6, 0xFDBC, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBD, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDBE, 0x062C, 0x062D, 0x064A, 0,
    6, 0xFDBF, 0x062D, 0x062C, 0x064A, 0,
    6, 0xFDC0, 0x0645, 0x062C, 0x064A, 0,
    6, 0xFDC1, 0x0641, 0x0645, 0x064A, 0,
    6, 0xFDC2, 0x0628, 0x062D, 0x064A, 0,
    4, 0xFDC3, 0x0643, 0x0645, 0x0645, 0,
    4, 0xFDC4, 0x0639, 0x062C, 0x0645, 0,
    4, 0xFDC5, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFDC6, 0x0633, 0x062E, 0x064A, 0,
    6, 0xFDC7, 0x0646, 0x062C, 0x064A, 0,
    7, 0xFDF0, 0x0635, 0x0644, 0x06D2, 0,
    7, 0xFDF1, 0x0642, 0x0644, 0x06D2, 0,
    7, 0xFDF2, 0x0627, 0x0644, 0x0644, 0x0647, 0,
    7, 0xFDF3, 0x0627, 0x0643, 0x0628, 0x0631, 0,
    7, 0xFDF4, 0x0645, 0x062D, 0x0645, 0x062F, 0,
    7, 0xFDF5, 0x0635, 0x0644, 0x0639, 0x0645, 0,
    7, 0xFDF6, 0x0631, 0x0633, 0x0648, 0x0644, 0,
    7, 0xFDF7, 0x0639, 0x0644, 0x064A, 0x0647, 0,
    7, 0xFDF8, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDF9, 0x0635, 0x0644, 0x0649, 0,
    7, 0xFDFA, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDFB, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0,
    7, 0xFDFC, 0x0631, 0x06CC, 0x0627, 0x0644, 0,
    11, 0xFE30, 0x2025, 0,
    11, 0xFE31, 0x2014, 0,
    11, 0xFE32, 0x2013, 0,
    11, 0xFE33, 0x005F, 0,
    11, 0xFE34, 0x005F, 0,
    11, 0xFE35, 0x0028, 0,
    11, 0xFE36, 0x0029, 0,
    11, 0xFE37, 0x007B, 0,
    11, 0xFE38, 0x007D, 0,
    11, 0xFE39, 0x3014, 0,
    11, 0xFE3A, 0x3015, 0,
    11, 0xFE3B, 0x3010, 0,
    11, 0xFE3C, 0x3011, 0,
    11, 0xFE3D, 0x300A, 0,
    11, 0xFE3E, 0x300B, 0,
    11, 0xFE3F, 0x3008, 0,
    11, 0xFE40, 0x3009, 0,
    11, 0xFE41, 0x300C, 0,
    11, 0xFE42, 0x300D, 0,
    11, 0xFE43, 0x300E, 0,
    11, 0xFE44, 0x300F, 0,
    16, 0xFE49, 0x203E, 0,
    16, 0xFE4A, 0x203E, 0,
    16, 0xFE4B, 0x203E, 0,
    16, 0xFE4C, 0x203E, 0,
    16, 0xFE4D, 0x005F, 0,
    16, 0xFE4E, 0x005F, 0,
    16, 0xFE4F, 0x005F, 0,
    14, 0xFE50, 0x002C, 0,
    14, 0xFE51, 0x3001, 0,
    14, 0xFE52, 0x002E, 0,
    14, 0xFE54, 0x003B, 0,
    14, 0xFE55, 0x003A, 0,
    14, 0xFE56, 0x003F, 0,
    14, 0xFE57, 0x0021, 0,
    14, 0xFE58, 0x2014, 0,
    14, 0xFE59, 0x0028, 0,
    14, 0xFE5A, 0x0029, 0,
    14, 0xFE5B, 0x007B, 0,
    14, 0xFE5C, 0x007D, 0,
    14, 0xFE5D, 0x3014, 0,
    14, 0xFE5E, 0x3015, 0,
    14, 0xFE5F, 0x0023, 0,
    14, 0xFE60, 0x0026, 0,
    14, 0xFE61, 0x002A, 0,
    14, 0xFE62, 0x002B, 0,
    14, 0xFE63, 0x002D, 0,
    14, 0xFE64, 0x003C, 0,
    14, 0xFE65, 0x003E, 0,
    14, 0xFE66, 0x003D, 0,
    14, 0xFE68, 0x005C, 0,
    14, 0xFE69, 0x0024, 0,
    14, 0xFE6A, 0x0025, 0,
    14, 0xFE6B, 0x0040, 0,
    7, 0xFE70, 0x0020, 0x064B, 0,
    5, 0xFE71, 0x0640, 0x064B, 0,
    7, 0xFE72, 0x0020, 0x064C, 0,
    7, 0xFE74, 0x0020, 0x064D, 0,
    7, 0xFE76, 0x0020, 0x064E, 0,
    5, 0xFE77, 0x0640, 0x064E, 0,
    7, 0xFE78, 0x0020, 0x064F, 0,
    5, 0xFE79, 0x0640, 0x064F, 0,
    7, 0xFE7A, 0x0020, 0x0650, 0,
    5, 0xFE7B, 0x0640, 0x0650, 0,
    7, 0xFE7C, 0x0020, 0x0651, 0,
    5, 0xFE7D, 0x0640, 0x0651, 0,
    7, 0xFE7E, 0x0020, 0x0652, 0,
    5, 0xFE7F, 0x0640, 0x0652, 0,
    7, 0xFE80, 0x0621, 0,
    7, 0xFE81, 0x0622, 0,
    6, 0xFE82, 0x0622, 0,
    7, 0xFE83, 0x0623, 0,
    6, 0xFE84, 0x0623, 0,
    7, 0xFE85, 0x0624, 0,
    6, 0xFE86, 0x0624, 0,
    7, 0xFE87, 0x0625, 0,
    6, 0xFE88, 0x0625, 0,
    7, 0xFE89, 0x0626, 0,
    6, 0xFE8A, 0x0626, 0,
    4, 0xFE8B, 0x0626, 0,
    5, 0xFE8C, 0x0626, 0,
    7, 0xFE8D, 0x0627, 0,
    6, 0xFE8E, 0x0627, 0,
    7, 0xFE8F, 0x0628, 0,
    6, 0xFE90, 0x0628, 0,
    4, 0xFE91, 0x0628, 0,
    5, 0xFE92, 0x0628, 0,
    7, 0xFE93, 0x0629, 0,
    6, 0xFE94, 0x0629, 0,
    7, 0xFE95, 0x062A, 0,
    6, 0xFE96, 0x062A, 0,
    4, 0xFE97, 0x062A, 0,
    5, 0xFE98, 0x062A, 0,
    7, 0xFE99, 0x062B, 0,
    6, 0xFE9A, 0x062B, 0,
    4, 0xFE9B, 0x062B, 0,
    5, 0xFE9C, 0x062B, 0,
    7, 0xFE9D, 0x062C, 0,
    6, 0xFE9E, 0x062C, 0,
    4, 0xFE9F, 0x062C, 0,
    5, 0xFEA0, 0x062C, 0,
    7, 0xFEA1, 0x062D, 0,
    6, 0xFEA2, 0x062D, 0,
    4, 0xFEA3, 0x062D, 0,
    5, 0xFEA4, 0x062D, 0,
    7, 0xFEA5, 0x062E, 0,
    6, 0xFEA6, 0x062E, 0,
    4, 0xFEA7, 0x062E, 0,
    5, 0xFEA8, 0x062E, 0,
    7, 0xFEA9, 0x062F, 0,
    6, 0xFEAA, 0x062F, 0,
    7, 0xFEAB, 0x0630, 0,
    6, 0xFEAC, 0x0630, 0,
    7, 0xFEAD, 0x0631, 0,
    6, 0xFEAE, 0x0631, 0,
    7, 0xFEAF, 0x0632, 0,
    6, 0xFEB0, 0x0632, 0,
    7, 0xFEB1, 0x0633, 0,
    6, 0xFEB2, 0x0633, 0,
    4, 0xFEB3, 0x0633, 0,
    5, 0xFEB4, 0x0633, 0,
    7, 0xFEB5, 0x0634, 0,
    6, 0xFEB6, 0x0634, 0,
    4, 0xFEB7, 0x0634, 0,
    5, 0xFEB8, 0x0634, 0,
    7, 0xFEB9, 0x0635, 0,
    6, 0xFEBA, 0x0635, 0,
    4, 0xFEBB, 0x0635, 0,
    5, 0xFEBC, 0x0635, 0,
    7, 0xFEBD, 0x0636, 0,
    6, 0xFEBE, 0x0636, 0,
    4, 0xFEBF, 0x0636, 0,
    5, 0xFEC0, 0x0636, 0,
    7, 0xFEC1, 0x0637, 0,
    6, 0xFEC2, 0x0637, 0,
    4, 0xFEC3, 0x0637, 0,
    5, 0xFEC4, 0x0637, 0,
    7, 0xFEC5, 0x0638, 0,
    6, 0xFEC6, 0x0638, 0,
    4, 0xFEC7, 0x0638, 0,
    5, 0xFEC8, 0x0638, 0,
    7, 0xFEC9, 0x0639, 0,
    6, 0xFECA, 0x0639, 0,
    4, 0xFECB, 0x0639, 0,
    5, 0xFECC, 0x0639, 0,
    7, 0xFECD, 0x063A, 0,
    6, 0xFECE, 0x063A, 0,
    4, 0xFECF, 0x063A, 0,
    5, 0xFED0, 0x063A, 0,
    7, 0xFED1, 0x0641, 0,
    6, 0xFED2, 0x0641, 0,
    4, 0xFED3, 0x0641, 0,
    5, 0xFED4, 0x0641, 0,
    7, 0xFED5, 0x0642, 0,
    6, 0xFED6, 0x0642, 0,
    4, 0xFED7, 0x0642, 0,
    5, 0xFED8, 0x0642, 0,
    7, 0xFED9, 0x0643, 0,
    6, 0xFEDA, 0x0643, 0,
    4, 0xFEDB, 0x0643, 0,
    5, 0xFEDC, 0x0643, 0,
    7, 0xFEDD, 0x0644, 0,
    6, 0xFEDE, 0x0644, 0,
    4, 0xFEDF, 0x0644, 0,
    5, 0xFEE0, 0x0644, 0,
    7, 0xFEE1, 0x0645, 0,
    6, 0xFEE2, 0x0645, 0,
    4, 0xFEE3, 0x0645, 0,
    5, 0xFEE4, 0x0645, 0,
    7, 0xFEE5, 0x0646, 0,
    6, 0xFEE6, 0x0646, 0,
    4, 0xFEE7, 0x0646, 0,
    5, 0xFEE8, 0x0646, 0,
    7, 0xFEE9, 0x0647, 0,
    6, 0xFEEA, 0x0647, 0,
    4, 0xFEEB, 0x0647, 0,
    5, 0xFEEC, 0x0647, 0,
    7, 0xFEED, 0x0648, 0,
    6, 0xFEEE, 0x0648, 0,
    7, 0xFEEF, 0x0649, 0,
    6, 0xFEF0, 0x0649, 0,
    7, 0xFEF1, 0x064A, 0,
    6, 0xFEF2, 0x064A, 0,
    4, 0xFEF3, 0x064A, 0,
    5, 0xFEF4, 0x064A, 0,
    7, 0xFEF5, 0x0644, 0x0622, 0,
    6, 0xFEF6, 0x0644, 0x0622, 0,
    7, 0xFEF7, 0x0644, 0x0623, 0,
    6, 0xFEF8, 0x0644, 0x0623, 0,
    7, 0xFEF9, 0x0644, 0x0625, 0,
    6, 0xFEFA, 0x0644, 0x0625, 0,
    7, 0xFEFB, 0x0644, 0x0627, 0,
    6, 0xFEFC, 0x0644, 0x0627, 0,
    12, 0xFF01, 0x0021, 0,
    12, 0xFF02, 0x0022, 0,
    12, 0xFF03, 0x0023, 0,
    12, 0xFF04, 0x0024, 0,
    12, 0xFF05, 0x0025, 0,
    12, 0xFF06, 0x0026, 0,
    12, 0xFF07, 0x0027, 0,
    12, 0xFF08, 0x0028, 0,
    12, 0xFF09, 0x0029, 0,
    12, 0xFF0A, 0x002A, 0,
    12, 0xFF0B, 0x002B, 0,
    12, 0xFF0C, 0x002C, 0,
    12, 0xFF0D, 0x002D, 0,
    12, 0xFF0E, 0x002E, 0,
    12, 0xFF0F, 0x002F, 0,
    12, 0xFF10, 0x0030, 0,
    12, 0xFF11, 0x0031, 0,
    12, 0xFF12, 0x0032, 0,
    12, 0xFF13, 0x0033, 0,
    12, 0xFF14, 0x0034, 0,
    12, 0xFF15, 0x0035, 0,
    12, 0xFF16, 0x0036, 0,
    12, 0xFF17, 0x0037, 0,
    12, 0xFF18, 0x0038, 0,
    12, 0xFF19, 0x0039, 0,
    12, 0xFF1A, 0x003A, 0,
    12, 0xFF1B, 0x003B, 0,
    12, 0xFF1C, 0x003C, 0,
    12, 0xFF1D, 0x003D, 0,
    12, 0xFF1E, 0x003E, 0,
    12, 0xFF1F, 0x003F, 0,
    12, 0xFF20, 0x0040, 0,
    12, 0xFF21, 0x0041, 0,
    12, 0xFF22, 0x0042, 0,
    12, 0xFF23, 0x0043, 0,
    12, 0xFF24, 0x0044, 0,
    12, 0xFF25, 0x0045, 0,
    12, 0xFF26, 0x0046, 0,
    12, 0xFF27, 0x0047, 0,
    12, 0xFF28, 0x0048, 0,
    12, 0xFF29, 0x0049, 0,
    12, 0xFF2A, 0x004A, 0,
    12, 0xFF2B, 0x004B, 0,
    12, 0xFF2C, 0x004C, 0,
    12, 0xFF2D, 0x004D, 0,
    12, 0xFF2E, 0x004E, 0,
    12, 0xFF2F, 0x004F, 0,
    12, 0xFF30, 0x0050, 0,
    12, 0xFF31, 0x0051, 0,
    12, 0xFF32, 0x0052, 0,
    12, 0xFF33, 0x0053, 0,
    12, 0xFF34, 0x0054, 0,
    12, 0xFF35, 0x0055, 0,
    12, 0xFF36, 0x0056, 0,
    12, 0xFF37, 0x0057, 0,
    12, 0xFF38, 0x0058, 0,
    12, 0xFF39, 0x0059, 0,
    12, 0xFF3A, 0x005A, 0,
    12, 0xFF3B, 0x005B, 0,
    12, 0xFF3C, 0x005C, 0,
    12, 0xFF3D, 0x005D, 0,
    12, 0xFF3E, 0x005E, 0,
    12, 0xFF3F, 0x005F, 0,
    12, 0xFF40, 0x0060, 0,
    12, 0xFF41, 0x0061, 0,
    12, 0xFF42, 0x0062, 0,
    12, 0xFF43, 0x0063, 0,
    12, 0xFF44, 0x0064, 0,
    12, 0xFF45, 0x0065, 0,
    12, 0xFF46, 0x0066, 0,
    12, 0xFF47, 0x0067, 0,
    12, 0xFF48, 0x0068, 0,
    12, 0xFF49, 0x0069, 0,
    12, 0xFF4A, 0x006A, 0,
    12, 0xFF4B, 0x006B, 0,
    12, 0xFF4C, 0x006C, 0,
    12, 0xFF4D, 0x006D, 0,
    12, 0xFF4E, 0x006E, 0,
    12, 0xFF4F, 0x006F, 0,
    12, 0xFF50, 0x0070, 0,
    12, 0xFF51, 0x0071, 0,
    12, 0xFF52, 0x0072, 0,
    12, 0xFF53, 0x0073, 0,
    12, 0xFF54, 0x0074, 0,
    12, 0xFF55, 0x0075, 0,
    12, 0xFF56, 0x0076, 0,
    12, 0xFF57, 0x0077, 0,
    12, 0xFF58, 0x0078, 0,
    12, 0xFF59, 0x0079, 0,
    12, 0xFF5A, 0x007A, 0,
    12, 0xFF5B, 0x007B, 0,
    12, 0xFF5C, 0x007C, 0,
    12, 0xFF5D, 0x007D, 0,
    12, 0xFF5E, 0x007E, 0,
    12, 0xFF5F, 0x2985, 0,
    12, 0xFF60, 0x2986, 0,
    13, 0xFF61, 0x3002, 0,
    13, 0xFF62, 0x300C, 0,
    13, 0xFF63, 0x300D, 0,
    13, 0xFF64, 0x3001, 0,
    13, 0xFF65, 0x30FB, 0,
    13, 0xFF66, 0x30F2, 0,
    13, 0xFF67, 0x30A1, 0,
    13, 0xFF68, 0x30A3, 0,
    13, 0xFF69, 0x30A5, 0,
    13, 0xFF6A, 0x30A7, 0,
    13, 0xFF6B, 0x30A9, 0,
    13, 0xFF6C, 0x30E3, 0,
    13, 0xFF6D, 0x30E5, 0,
    13, 0xFF6E, 0x30E7, 0,
    13, 0xFF6F, 0x30C3, 0,
    13, 0xFF70, 0x30FC, 0,
    13, 0xFF71, 0x30A2, 0,
    13, 0xFF72, 0x30A4, 0,
    13, 0xFF73, 0x30A6, 0,
    13, 0xFF74, 0x30A8, 0,
    13, 0xFF75, 0x30AA, 0,
    13, 0xFF76, 0x30AB, 0,
    13, 0xFF77, 0x30AD, 0,
    13, 0xFF78, 0x30AF, 0,
    13, 0xFF79, 0x30B1, 0,
    13, 0xFF7A, 0x30B3, 0,
    13, 0xFF7B, 0x30B5, 0,
    13, 0xFF7C, 0x30B7, 0,
    13, 0xFF7D, 0x30B9, 0,
    13, 0xFF7E, 0x30BB, 0,
    13, 0xFF7F, 0x30BD, 0,
    13, 0xFF80, 0x30BF, 0,
    13, 0xFF81, 0x30C1, 0,
    13, 0xFF82, 0x30C4, 0,
    13, 0xFF83, 0x30C6, 0,
    13, 0xFF84, 0x30C8, 0,
    13, 0xFF85, 0x30CA, 0,
    13, 0xFF86, 0x30CB, 0,
    13, 0xFF87, 0x30CC, 0,
    13, 0xFF88, 0x30CD, 0,
    13, 0xFF89, 0x30CE, 0,
    13, 0xFF8A, 0x30CF, 0,
    13, 0xFF8B, 0x30D2, 0,
    13, 0xFF8C, 0x30D5, 0,
    13, 0xFF8D, 0x30D8, 0,
    13, 0xFF8E, 0x30DB, 0,
    13, 0xFF8F, 0x30DE, 0,
    13, 0xFF90, 0x30DF, 0,
    13, 0xFF91, 0x30E0, 0,
    13, 0xFF92, 0x30E1, 0,
    13, 0xFF93, 0x30E2, 0,
    13, 0xFF94, 0x30E4, 0,
    13, 0xFF95, 0x30E6, 0,
    13, 0xFF96, 0x30E8, 0,
    13, 0xFF97, 0x30E9, 0,
    13, 0xFF98, 0x30EA, 0,
    13, 0xFF99, 0x30EB, 0,
    13, 0xFF9A, 0x30EC, 0,
    13, 0xFF9B, 0x30ED, 0,
    13, 0xFF9C, 0x30EF, 0,
    13, 0xFF9D, 0x30F3, 0,
    13, 0xFF9E, 0x3099, 0,
    13, 0xFF9F, 0x309A, 0,
    13, 0xFFA0, 0x3164, 0,
    13, 0xFFA1, 0x3131, 0,
    13, 0xFFA2, 0x3132, 0,
    13, 0xFFA3, 0x3133, 0,
    13, 0xFFA4, 0x3134, 0,
    13, 0xFFA5, 0x3135, 0,
    13, 0xFFA6, 0x3136, 0,
    13, 0xFFA7, 0x3137, 0,
    13, 0xFFA8, 0x3138, 0,
    13, 0xFFA9, 0x3139, 0,
    13, 0xFFAA, 0x313A, 0,
    13, 0xFFAB, 0x313B, 0,
    13, 0xFFAC, 0x313C, 0,
    13, 0xFFAD, 0x313D, 0,
    13, 0xFFAE, 0x313E, 0,
    13, 0xFFAF, 0x313F, 0,
    13, 0xFFB0, 0x3140, 0,
    13, 0xFFB1, 0x3141, 0,
    13, 0xFFB2, 0x3142, 0,
    13, 0xFFB3, 0x3143, 0,
    13, 0xFFB4, 0x3144, 0,
    13, 0xFFB5, 0x3145, 0,
    13, 0xFFB6, 0x3146, 0,
    13, 0xFFB7, 0x3147, 0,
    13, 0xFFB8, 0x3148, 0,
    13, 0xFFB9, 0x3149, 0,
    13, 0xFFBA, 0x314A, 0,
    13, 0xFFBB, 0x314B, 0,
    13, 0xFFBC, 0x314C, 0,
    13, 0xFFBD, 0x314D, 0,
    13, 0xFFBE, 0x314E, 0,
    13, 0xFFC2, 0x314F, 0,
    13, 0xFFC3, 0x3150, 0,
    13, 0xFFC4, 0x3151, 0,
    13, 0xFFC5, 0x3152, 0,
    13, 0xFFC6, 0x3153, 0,
    13, 0xFFC7, 0x3154, 0,
    13, 0xFFCA, 0x3155, 0,
    13, 0xFFCB, 0x3156, 0,
    13, 0xFFCC, 0x3157, 0,
    13, 0xFFCD, 0x3158, 0,
    13, 0xFFCE, 0x3159, 0,
    13, 0xFFCF, 0x315A, 0,
    13, 0xFFD2, 0x315B, 0,
    13, 0xFFD3, 0x315C, 0,
    13, 0xFFD4, 0x315D, 0,
    13, 0xFFD5, 0x315E, 0,
    13, 0xFFD6, 0x315F, 0,
    13, 0xFFD7, 0x3160, 0,
    13, 0xFFDA, 0x3161, 0,
    13, 0xFFDB, 0x3162, 0,
    13, 0xFFDC, 0x3163, 0,
    12, 0xFFE0, 0x00A2, 0,
    12, 0xFFE1, 0x00A3, 0,
    12, 0xFFE2, 0x00AC, 0,
    12, 0xFFE3, 0x00AF, 0,
    12, 0xFFE4, 0x00A6, 0,
    12, 0xFFE5, 0x00A5, 0,
    12, 0xFFE6, 0x20A9, 0,
    13, 0xFFE8, 0x2502, 0,
    13, 0xFFE9, 0x2190, 0,
    13, 0xFFEA, 0x2191, 0,
    13, 0xFFEB, 0x2192, 0,
    13, 0xFFEC, 0x2193, 0,
    13, 0xFFED, 0x25A0, 0,
    13, 0xFFEE, 0x25CB, 0,

};

const TQ_UINT16 TQUnicodeTables::decomposition_info[] = {
    1, 2, 3, 4, 5, 6, 7, 8,
    8, 9, 10, 11, 12, 13, 14, 15,
    16, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 17, 18,
    19, 20, 21, 22, 23, 8, 8, 8,
    8, 8, 24, 8, 8, 8, 25, 26,
    27, 28, 29, 30, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 31, 32, 33, 34, 35, 36, 37,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 10, 0, 0, 0, 0, 14,
    0, 0, 19, 23, 27, 32, 0, 0,
    36, 41, 45, 0, 49, 55, 61, 0,
    67, 72, 77, 82, 87, 92, 0, 97,
    102, 107, 112, 117, 122, 127, 132, 137,
    0, 142, 147, 152, 157, 162, 167, 0,
    0, 172, 177, 182, 187, 192, 0, 0,
    197, 202, 207, 212, 217, 222, 0, 227,
    232, 237, 242, 247, 252, 257, 262, 267,
    0, 272, 277, 282, 287, 292, 297, 0,
    0, 302, 307, 312, 317, 322, 0, 327,

    332, 337, 342, 347, 352, 357, 362, 367,
    372, 377, 382, 387, 392, 397, 402, 407,
    0, 0, 412, 417, 422, 427, 432, 437,
    442, 447, 452, 457, 462, 467, 472, 477,
    482, 487, 492, 497, 502, 507, 0, 0,
    512, 517, 522, 527, 532, 537, 542, 547,
    552, 0, 557, 562, 567, 572, 577, 582,
    0, 587, 592, 597, 602, 607, 612, 617,
    622, 0, 0, 627, 632, 637, 642, 647,
    652, 657, 0, 0, 662, 667, 672, 677,
    682, 687, 0, 0, 692, 697, 702, 707,
    712, 717, 722, 727, 732, 737, 742, 747,
    752, 757, 762, 767, 772, 777, 0, 0,
    782, 787, 792, 797, 802, 807, 812, 817,
    822, 827, 832, 837, 842, 847, 852, 857,
    862, 867, 872, 877, 882, 887, 892, 897,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    901, 906, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 911,
    916, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 921, 926, 931, 936,
    941, 946, 951, 956, 961, 966, 971, 976,
    981, 986, 991, 996, 1001, 1006, 1011, 1016,
    1021, 1026, 1031, 1036, 1041, 0, 1046, 1051,
    1056, 1061, 1066, 1071, 0, 0, 1076, 1081,
    1086, 1091, 1096, 1101, 1106, 1111, 1116, 1121,
    1126, 1131, 1136, 1141, 1146, 1151, 0, 0,
    1156, 1161, 1166, 1171, 1176, 1181, 1186, 1191,

    1196, 1201, 1206, 1211, 1216, 1221, 1226, 1231,
    1236, 1241, 1246, 1251, 1256, 1261, 1266, 1271,
    1276, 1281, 1286, 1291, 1296, 1301, 1306, 1311,
    1316, 1321, 1326, 1331, 0, 0, 1336, 1341,
    0, 0, 0, 0, 0, 0, 1346, 1351,
    1356, 1361, 1366, 1371, 1376, 1381, 1386, 1391,
    1396, 1401, 1406, 1411, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1416, 1420, 1424, 1428, 1432, 1436, 1440, 1444,
    1448, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1452, 1457, 1462, 1467, 1472, 1477, 0, 0,
    1482, 1486, 1490, 1494, 1498, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1502, 1506, 0, 1510, 1514, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1519, 0, 0, 0,
    0, 0, 1523, 0, 0, 0, 1528, 0,
    0, 0, 0, 0, 1532, 1537, 1542, 1547,
    1551, 1556, 1561, 0, 1566, 0, 1571, 1576,
    1581, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1586, 1591, 1596, 1601, 1606, 1611,
    1616, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1621, 1626, 1631, 1636, 1641, 0,
    1646, 1650, 1654, 1658, 1663, 1668, 1672, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1676, 1680, 0, 0, 1684, 1688, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    1692, 1697, 0, 1702, 0, 0, 0, 1707,
    0, 0, 0, 0, 1712, 1717, 1722, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1727, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1732, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1737, 1742, 0, 1747, 0, 0, 0, 1752,
    0, 0, 0, 0, 1757, 1762, 1767, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1772, 1777,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1782, 1787, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1792, 1797, 1802, 1807, 0, 0, 1812, 1817,
    0, 0, 1822, 1827, 1832, 1837, 1842, 1847,
    0, 0, 1852, 1857, 1862, 1867, 1872, 1877,
    0, 0, 1882, 1887, 1892, 1897, 1902, 1907,
    1912, 1917, 1922, 1927, 1932, 1937, 0, 0,
    1942, 1947, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1952,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1957, 1962, 1967, 1972, 1977, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1982, 1987, 1992,
    1997, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2002, 0, 2007, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2012, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2017, 0, 0, 0, 0, 0, 0,
    0, 2022, 0, 0, 2027, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2032, 2037, 2042, 2047, 2052, 2057, 2062, 2067,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2072, 2077, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2082, 2087, 0, 2092,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2097, 0, 0, 2102, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2107, 2112, 2117, 0, 0, 2122, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2127, 0, 0, 2132, 2137, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2142, 2147, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2152, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2157, 2162, 2167, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2172, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2177, 0, 0, 0, 0, 0, 0, 2182,
    2187, 0, 2192, 2197, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2202, 2207, 2212, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2217, 0, 2222, 2227, 2232, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2237, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2242, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2247, 2252, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2257, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2261, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2266, 0, 0,
    0, 0, 2271, 0, 0, 0, 0, 2276,
    0, 0, 0, 0, 2281, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2286, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2291, 0, 2296, 2301, 2306,
    2311, 2316, 0, 0, 0, 0, 0, 0,
    0, 2321, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2326, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2331, 0, 0,
    0, 0, 2336, 0, 0, 0, 0, 2341,
    0, 0, 0, 0, 2346, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2351, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2356, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    2361, 2366, 2371, 2376, 2381, 2386, 2391, 2396,
    2401, 2406, 2411, 2416, 2421, 2426, 2431, 2436,
    2441, 2446, 2451, 2456, 2461, 2466, 2471, 2476,
    2481, 2486, 2491, 2496, 2501, 2506, 2511, 2516,
    2521, 2526, 2531, 2536, 2541, 2546, 2551, 2556,
    2561, 2566, 2571, 2576, 2581, 2586, 2591, 2596,
    2601, 2606, 2611, 2616, 2621, 2626, 2631, 2636,
    2641, 2646, 2651, 2656, 2661, 2666, 2671, 2676,
    2681, 2686, 2691, 2696, 2701, 2706, 2711, 2716,
    2721, 2726, 2731, 2736, 2741, 2746, 2751, 2756,
    2761, 2766, 2771, 2776, 2781, 2786, 2791, 2796,
    2801, 2806, 2811, 2816, 2821, 2826, 2831, 2836,
    2841, 2846, 2851, 2856, 2861, 2866, 2871, 2876,
    2881, 2886, 2891, 2896, 2901, 2906, 2911, 2916,
    2921, 2926, 2931, 2936, 2941, 2946, 2951, 2956,
    2961, 2966, 2971, 2976, 2981, 2986, 2991, 2996,
    3001, 3006, 3011, 3016, 3021, 3026, 3031, 3036,
    3041, 3046, 3051, 3056, 3061, 3066, 3071, 3076,
    3081, 3086, 3091, 3096, 3101, 3106, 3111, 3116,
    3121, 3126, 3131, 3136, 0, 0, 0, 0,
    3141, 3146, 3151, 3156, 3161, 3166, 3171, 3176,
    3181, 3186, 3191, 3196, 3201, 3206, 3211, 3216,
    3221, 3226, 3231, 3236, 3241, 3246, 3251, 3256,
    3261, 3266, 3271, 3276, 3281, 3286, 3291, 3296,
    3301, 3306, 3311, 3316, 3321, 3326, 3331, 3336,
    3341, 3346, 3351, 3356, 3361, 3366, 3371, 3376,
    3381, 3386, 3391, 3396, 3401, 3406, 3411, 3416,
    3421, 3426, 3431, 3436, 3441, 3446, 3451, 3456,
    3461, 3466, 3471, 3476, 3481, 3486, 3491, 3496,
    3501, 3506, 3511, 3516, 3521, 3526, 3531, 3536,
    3541, 3546, 3551, 3556, 3561, 3566, 3571, 3576,
    3581, 3586, 0, 0, 0, 0, 0, 0,

    3591, 3596, 3601, 3606, 3611, 3616, 3621, 3626,
    3631, 3636, 3641, 3646, 3651, 3656, 3661, 3666,
    3671, 3676, 3681, 3686, 3691, 3696, 0, 0,
    3701, 3706, 3711, 3716, 3721, 3726, 0, 0,
    3731, 3736, 3741, 3746, 3751, 3756, 3761, 3766,
    3771, 3776, 3781, 3786, 3791, 3796, 3801, 3806,
    3811, 3816, 3821, 3826, 3831, 3836, 3841, 3846,
    3851, 3856, 3861, 3866, 3871, 3876, 3881, 3886,
    3891, 3896, 3901, 3906, 3911, 3916, 0, 0,
    3921, 3926, 3931, 3936, 3941, 3946, 0, 0,
    3951, 3956, 3961, 3966, 3971, 3976, 3981, 3986,
    0, 3991, 0, 3996, 0, 4001, 0, 4006,
    4011, 4016, 4021, 4026, 4031, 4036, 4041, 4046,
    4051, 4056, 4061, 4066, 4071, 4076, 4081, 4086,
    4091, 4096, 4100, 4105, 4109, 4114, 4118, 4123,
    4127, 4132, 4136, 4141, 4145, 4150, 0, 0,
    4154, 4159, 4164, 4169, 4174, 4179, 4184, 4189,
    4194, 4199, 4204, 4209, 4214, 4219, 4224, 4229,
    4234, 4239, 4244, 4249, 4254, 4259, 4264, 4269,
    4274, 4279, 4284, 4289, 4294, 4299, 4304, 4309,
    4314, 4319, 4324, 4329, 4334, 4339, 4344, 4349,
    4354, 4359, 4364, 4369, 4374, 4379, 4384, 4389,
    4394, 4399, 4404, 4409, 4414, 0, 4419, 4424,
    4429, 4434, 4439, 4444, 4448, 4453, 4458, 4462,
    4467, 4472, 4477, 4482, 4487, 0, 4492, 4497,
    4502, 4507, 4511, 4516, 4520, 4525, 4530, 4535,
    4540, 4545, 4550, 4555, 0, 0, 4559, 4564,
    4569, 4574, 4579, 4584, 0, 4588, 4593, 4598,
    4603, 4608, 4613, 4618, 4622, 4627, 4632, 4637,
    4642, 4647, 4652, 4657, 4661, 4666, 4671, 4675,
    0, 0, 4679, 4684, 4689, 0, 4694, 4699,
    4704, 4709, 4713, 4718, 4722, 4727, 4731, 0,

    4736, 4740, 4744, 4748, 4752, 4756, 4760, 4764,
    4768, 4772, 4776, 0, 0, 0, 0, 0,
    0, 4780, 0, 0, 0, 0, 0, 4784,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4789, 4793, 4798, 0,
    0, 0, 0, 0, 0, 0, 0, 4804,
    0, 0, 0, 4808, 4813, 0, 4819, 4824,
    0, 0, 0, 0, 4830, 0, 4835, 0,
    0, 0, 0, 0, 0, 0, 0, 4840,
    4845, 4850, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4855,
    0, 0, 0, 0, 0, 0, 0, 4862,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4866, 4870, 0, 0, 4874, 4878, 4882, 4886,
    4890, 4894, 4898, 4902, 4906, 4910, 4914, 4918,
    4922, 4926, 4930, 4934, 4938, 4942, 4946, 4950,
    4954, 4958, 4962, 4966, 4970, 4974, 4978, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4982, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    4987, 4993, 4999, 5003, 0, 5008, 5014, 5020,
    0, 5024, 5029, 5033, 5037, 5041, 5045, 5049,
    5053, 5057, 5061, 5065, 0, 5069, 5073, 0,
    0, 5078, 5082, 5086, 5090, 5094, 0, 0,
    5098, 5103, 5109, 0, 5114, 0, 5118, 0,
    5122, 0, 5126, 5130, 5134, 5138, 0, 5142,
    5146, 5150, 0, 5154, 5158, 5162, 5166, 5170,
    5174, 5178, 0, 0, 0, 5182, 5186, 5190,
    5194, 0, 0, 0, 0, 5198, 5202, 5206,
    5210, 5214, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5218, 5224, 5230, 5236, 5242,
    5248, 5254, 5260, 5266, 5272, 5278, 5284, 5290,
    5295, 5299, 5304, 5310, 5315, 5319, 5324, 5330,
    5337, 5342, 5346, 5351, 5357, 5361, 5365, 5369,
    5373, 5377, 5382, 5388, 5393, 5397, 5402, 5408,
    5415, 5420, 5424, 5429, 5435, 5439, 5443, 5447,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5451, 5456, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5461, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5466, 5471, 5476,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 5481, 0, 0, 0,
    0, 5486, 0, 0, 5491, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5496, 0, 5501, 0,
    0, 0, 0, 0, 5506, 5511, 0, 5517,
    5522, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5528, 0, 0, 5533, 0, 0, 5538,
    0, 5543, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5548, 0, 5553, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5558, 5563, 5568,
    5573, 5578, 0, 0, 5583, 5588, 0, 0,
    5593, 5598, 0, 0, 0, 0, 0, 0,
    5603, 5608, 0, 0, 5613, 5618, 0, 0,
    5623, 5628, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5633, 5638, 5643, 5648,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5653, 5658, 5663, 5668, 0, 0, 0, 0,
    0, 0, 5673, 5678, 5683, 5688, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5693, 5697, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5701, 5705, 5709, 5713, 5717, 5721, 5725, 5729,
    5733, 5737, 5742, 5747, 5752, 5757, 5762, 5767,
    5772, 5777, 5782, 5787, 5792, 5798, 5804, 5810,
    5816, 5822, 5828, 5834, 5840, 5846, 5853, 5860,
    5867, 5874, 5881, 5888, 5895, 5902, 5909, 5916,
    5923, 5928, 5933, 5938, 5943, 5948, 5953, 5958,
    5963, 5968, 5974, 5980, 5986, 5992, 5998, 6004,
    6010, 6016, 6022, 6028, 6034, 6040, 6046, 6052,
    6058, 6064, 6070, 6076, 6082, 6088, 6094, 6100,
    6106, 6112, 6118, 6124, 6130, 6136, 6142, 6148,
    6154, 6160, 6166, 6172, 6178, 6184, 6190, 6194,
    6198, 6202, 6206, 6210, 6214, 6218, 6222, 6226,
    6230, 6234, 6238, 6242, 6246, 6250, 6254, 6258,
    6262, 6266, 6270, 6274, 6278, 6282, 6286, 6290,
    6294, 6298, 6302, 6306, 6310, 6314, 6318, 6322,
    6326, 6330, 6334, 6338, 6342, 6346, 6350, 6354,
    6358, 6362, 6366, 6370, 6374, 6378, 6382, 6386,
    6390, 6394, 6398, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6402, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6409, 6415, 6420, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6426, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6431,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6435, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    6439, 6443, 6447, 6451, 6455, 6459, 6463, 6467,
    6471, 6475, 6479, 6483, 6487, 6491, 6495, 6499,
    6503, 6507, 6511, 6515, 6519, 6523, 6527, 6531,
    6535, 6539, 6543, 6547, 6551, 6555, 6559, 6563,
    6567, 6571, 6575, 6579, 6583, 6587, 6591, 6595,
    6599, 6603, 6607, 6611, 6615, 6619, 6623, 6627,
    6631, 6635, 6639, 6643, 6647, 6651, 6655, 6659,
    6663, 6667, 6671, 6675, 6679, 6683, 6687, 6691,
    6695, 6699, 6703, 6707, 6711, 6715, 6719, 6723,
    6727, 6731, 6735, 6739, 6743, 6747, 6751, 6755,
    6759, 6763, 6767, 6771, 6775, 6779, 6783, 6787,
    6791, 6795, 6799, 6803, 6807, 6811, 6815, 6819,
    6823, 6827, 6831, 6835, 6839, 6843, 6847, 6851,
    6855, 6859, 6863, 6867, 6871, 6875, 6879, 6883,
    6887, 6891, 6895, 6899, 6903, 6907, 6911, 6915,
    6919, 6923, 6927, 6931, 6935, 6939, 6943, 6947,
    6951, 6955, 6959, 6963, 6967, 6971, 6975, 6979,
    6983, 6987, 6991, 6995, 6999, 7003, 7007, 7011,
    7015, 7019, 7023, 7027, 7031, 7035, 7039, 7043,
    7047, 7051, 7055, 7059, 7063, 7067, 7071, 7075,
    7079, 7083, 7087, 7091, 7095, 7099, 7103, 7107,
    7111, 7115, 7119, 7123, 7127, 7131, 7135, 7139,
    7143, 7147, 7151, 7155, 7159, 7163, 7167, 7171,
    7175, 7179, 7183, 7187, 7191, 7195, 7199, 7203,
    7207, 7211, 7215, 7219, 7223, 7227, 7231, 7235,
    7239, 7243, 7247, 7251, 7255, 7259, 7263, 7267,
    7271, 7275, 7279, 7283, 7287, 7291, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    7295, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7299, 0,
    7303, 7307, 7311, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7315, 0, 7320, 0,
    7325, 0, 7330, 0, 7335, 0, 7340, 0,
    7345, 0, 7350, 0, 7355, 0, 7360, 0,
    7365, 0, 7370, 0, 0, 7375, 0, 7380,
    0, 7385, 0, 0, 0, 0, 0, 0,
    7390, 7395, 0, 7400, 7405, 0, 7410, 7415,
    0, 7420, 7425, 0, 7430, 7435, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7440, 0, 0, 0,
    0, 0, 0, 7445, 7450, 0, 7455, 7460,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7465, 0, 7470, 0,
    7475, 0, 7480, 0, 7485, 0, 7490, 0,
    7495, 0, 7500, 0, 7505, 0, 7510, 0,
    7515, 0, 7520, 0, 0, 7525, 0, 7530,
    0, 7535, 0, 0, 0, 0, 0, 0,
    7540, 7545, 0, 7550, 7555, 0, 7560, 7565,
    0, 7570, 7575, 0, 7580, 7585, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7590, 0, 0, 7595,
    7600, 7605, 7610, 0, 0, 0, 7615, 7620,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7625, 7629, 7633, 7637, 7641, 7645, 7649,
    7653, 7657, 7661, 7665, 7669, 7673, 7677, 7681,
    7685, 7689, 7693, 7697, 7701, 7705, 7709, 7713,
    7717, 7721, 7725, 7729, 7733, 7737, 7741, 7745,
    7749, 7753, 7757, 7761, 7765, 7769, 7773, 7777,
    7781, 7785, 7789, 7793, 7797, 7801, 7805, 7809,
    7813, 7817, 7821, 7825, 7829, 7833, 7837, 7841,
    7845, 7849, 7853, 7857, 7861, 7865, 7869, 7873,
    7877, 7881, 7885, 7889, 7893, 7897, 7901, 7905,
    7909, 7913, 7917, 7921, 7925, 7929, 7933, 7937,
    7941, 7945, 7949, 7953, 7957, 7961, 7965, 7969,
    7973, 7977, 7981, 7985, 7989, 7993, 7997, 0,
    0, 0, 8001, 8005, 8009, 8013, 8017, 8021,
    8025, 8029, 8033, 8037, 8041, 8045, 8049, 8053,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    8057, 8063, 8069, 8075, 8081, 8087, 8093, 8099,
    8105, 8111, 8117, 8123, 8129, 8135, 8141, 8148,
    8155, 8162, 8169, 8176, 8183, 8190, 8197, 8204,
    8211, 8218, 8225, 8232, 8239, 0, 0, 0,
    8246, 8252, 8258, 8264, 8270, 8276, 8282, 8288,
    8294, 8300, 8306, 8312, 8318, 8324, 8330, 8336,
    8342, 8348, 8354, 8360, 8366, 8372, 8378, 8384,
    8390, 8396, 8402, 8408, 8414, 8420, 8426, 8432,
    8438, 8444, 8450, 8456, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8462, 8467, 8472, 8477, 8482, 8487, 8492,
    8497, 8502, 8507, 8512, 8517, 8522, 8527, 8532,
    8537, 8541, 8545, 8549, 8553, 8557, 8561, 8565,
    8569, 8573, 8577, 8581, 8585, 8589, 8593, 8598,
    8603, 8608, 8613, 8618, 8623, 8628, 8633, 8638,
    8643, 8648, 8653, 8658, 0, 0, 0, 0,
    8663, 8667, 8671, 8675, 8679, 8683, 8687, 8691,
    8695, 8699, 8703, 8707, 8711, 8715, 8719, 8723,
    8727, 8731, 8735, 8739, 8743, 8747, 8751, 8755,
    8759, 8763, 8767, 8771, 8775, 8779, 8783, 8787,
    8791, 8795, 8799, 8803, 8807, 8811, 8815, 8819,
    8823, 8827, 8831, 8835, 8839, 8843, 8847, 8851,
    8855, 8859, 8864, 8869, 8874, 8879, 8884, 8889,
    8894, 8899, 8904, 8909, 8914, 8919, 8924, 8929,
    8934, 8939, 8944, 8949, 8954, 8959, 8964, 8969,
    8974, 8979, 8985, 8991, 0, 0, 0, 0,
    8997, 9001, 9005, 9009, 9013, 9017, 9021, 9025,
    9029, 9033, 9037, 9041, 9045, 9049, 9053, 9057,
    9061, 9065, 9069, 9073, 9077, 9081, 9085, 9089,
    9093, 9097, 9101, 9105, 9109, 9113, 9117, 9121,
    9125, 9129, 9133, 9137, 9141, 9145, 9149, 9153,
    9157, 9161, 9165, 9169, 9173, 9177, 9181, 0,

    9185, 9192, 9199, 9206, 9212, 9219, 9225, 9231,
    9239, 9246, 9252, 9258, 9264, 9271, 9278, 9284,
    9290, 9295, 9301, 9308, 9315, 9320, 9328, 9337,
    9345, 9351, 9359, 9367, 9374, 9380, 9386, 9392,
    9399, 9407, 9414, 9420, 9426, 9432, 9437, 9442,
    9447, 9452, 9458, 9464, 9472, 9478, 9485, 9493,
    9499, 9504, 9509, 9517, 9524, 9532, 9538, 9546,
    9551, 9557, 9563, 9569, 9575, 9581, 9588, 9594,
    9599, 9605, 9611, 9617, 9624, 9630, 9636, 9642,
    9650, 9657, 9662, 9670, 9675, 9682, 9689, 9695,
    9701, 9707, 9714, 9719, 9725, 9732, 9737, 9745,
    9751, 9756, 9761, 9766, 9771, 9776, 9781, 9786,
    9791, 9796, 9801, 9807, 9813, 9819, 9825, 9831,
    9837, 9843, 9849, 9855, 9861, 9867, 9873, 9879,
    9885, 9891, 9897, 9902, 9907, 9913, 9918, 0,
    0, 0, 0, 9923, 9928, 9933, 9938, 9943,
    9950, 9955, 9960, 9965, 9970, 9975, 9980, 9985,
    9990, 9996, 10003, 10008, 10013, 10018, 10023, 10028,
    10033, 10038, 10044, 10050, 10056, 10062, 10067, 10072,
    10077, 10082, 10087, 10092, 10097, 10102, 10107, 10112,
    10118, 10124, 10129, 10135, 10141, 10147, 10152, 10158,
    10164, 10171, 10176, 10182, 10188, 10194, 10200, 10208,
    10217, 10222, 10227, 10232, 10237, 10242, 10247, 10252,
    10257, 10262, 10267, 10272, 10277, 10282, 10287, 10292,
    10297, 10302, 10307, 10314, 10319, 10324, 10329, 10336,
    10342, 10347, 10352, 10357, 10362, 10367, 10372, 10377,
    10382, 10387, 10392, 10398, 10403, 10408, 10414, 10420,
    10425, 10432, 10438, 10443, 10448, 10453, 0, 0,
    10458, 10463, 10468, 10473, 10478, 10483, 10488, 10493,
    10498, 10503, 10509, 10515, 10521, 10527, 10533, 10539,
    10545, 10551, 10557, 10563, 10569, 10575, 10581, 10587,
    10593, 10599, 10605, 10611, 10617, 10623, 10629, 0,

    10635, 10639, 10643, 10647, 10651, 10655, 10659, 10663,
    10667, 10671, 10675, 10679, 10683, 10687, 10691, 10695,
    10699, 10703, 10707, 10711, 10715, 10719, 10723, 10727,
    10731, 10735, 10739, 10743, 10747, 10751, 10755, 10759,
    10763, 10767, 10771, 10775, 10779, 10783, 10787, 10791,
    10795, 10799, 10803, 10807, 10811, 10815, 10819, 10823,
    10827, 10831, 10835, 10839, 10843, 10847, 10851, 10855,
    10859, 10863, 10867, 10871, 10875, 10879, 10883, 10887,
    10891, 10895, 10899, 10903, 10907, 10911, 10915, 10919,
    10923, 10927, 10931, 10935, 10939, 10943, 10947, 10951,
    10955, 10959, 10963, 10967, 10971, 10975, 10979, 10983,
    10987, 10991, 10995, 10999, 11003, 11007, 11011, 11015,
    11019, 11023, 11027, 11031, 11035, 11039, 11043, 11047,
    11051, 11055, 11059, 11063, 11067, 11071, 11075, 11079,
    11083, 11087, 11091, 11095, 11099, 11103, 11107, 11111,
    11115, 11119, 11123, 11127, 11131, 11135, 11139, 11143,
    11147, 11151, 11155, 11159, 11163, 11167, 11171, 11175,
    11179, 11183, 11187, 11191, 11195, 11199, 11203, 11207,
    11211, 11215, 11219, 11223, 11227, 11231, 11235, 11239,
    11243, 11247, 11251, 11255, 11259, 11263, 11267, 11271,
    11275, 11279, 11283, 11287, 11291, 11295, 11299, 11303,
    11307, 11311, 11315, 11319, 11323, 11327, 11331, 11335,
    11339, 11343, 11347, 11351, 11355, 11359, 11363, 11367,
    11371, 11375, 11379, 11383, 11387, 11391, 11395, 11399,
    11403, 11407, 11411, 11415, 11419, 11423, 11427, 11431,
    11435, 11439, 11443, 11447, 11451, 11455, 11459, 11463,
    11467, 11471, 11475, 11479, 11483, 11487, 11491, 11495,
    11499, 11503, 11507, 11511, 11515, 11519, 11523, 11527,
    11531, 11535, 11539, 11543, 11547, 11551, 11555, 11559,
    11563, 11567, 11571, 11575, 11579, 11583, 11587, 11591,
    11595, 11599, 11603, 11607, 11611, 11615, 11619, 11623,
    11627, 11631, 11635, 11639, 11643, 11647, 11651, 11655,

    11659, 11663, 11667, 11671, 11675, 11679, 11683, 11687,
    11691, 11695, 11699, 11703, 11707, 11711, 0, 0,
    11715, 0, 11719, 0, 0, 11723, 11727, 11731,
    11735, 11739, 11743, 11747, 11751, 11755, 11759, 0,
    11763, 0, 11767, 0, 0, 11771, 11775, 0,
    0, 0, 11779, 11783, 11787, 11791, 0, 0,
    11795, 11799, 11803, 11807, 11811, 11815, 11819, 11823,
    11827, 11831, 11835, 11839, 11843, 11847, 11851, 11855,
    11859, 11863, 11867, 11871, 11875, 11879, 11883, 11887,
    11891, 11895, 11899, 11903, 11907, 11911, 11915, 11919,
    11923, 11927, 11931, 11935, 11939, 11943, 11947, 11951,
    11955, 11959, 11963, 11967, 11971, 11975, 11979, 11983,
    11987, 11991, 11995, 11999, 12003, 12007, 12011, 12015,
    12019, 12023, 12027, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    12031, 12036, 12041, 12046, 12052, 12058, 12063, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12068, 12073, 12078, 12083, 12088,
    0, 0, 0, 0, 0, 12093, 0, 12098,
    12103, 12107, 12111, 12115, 12119, 12123, 12127, 12131,
    12135, 12139, 12143, 12148, 12153, 12158, 12163, 12168,
    12173, 12178, 12183, 12188, 12193, 12198, 12203, 0,
    12208, 12213, 12218, 12223, 12228, 0, 12233, 0,
    12238, 12243, 0, 12248, 12253, 0, 12258, 12263,
    12268, 12273, 12278, 12283, 12288, 12293, 12298, 12303,
    12308, 12312, 12316, 12320, 12324, 12328, 12332, 12336,
    12340, 12344, 12348, 12352, 12356, 12360, 12364, 12368,
    12372, 12376, 12380, 12384, 12388, 12392, 12396, 12400,
    12404, 12408, 12412, 12416, 12420, 12424, 12428, 12432,
    12436, 12440, 12444, 12448, 12452, 12456, 12460, 12464,
    12468, 12472, 12476, 12480, 12484, 12488, 12492, 12496,
    12500, 12504, 12508, 12512, 12516, 12520, 12524, 12528,
    12532, 12536, 12540, 12544, 12548, 12552, 12556, 12560,
    12564, 12568, 12572, 12576, 12580, 12584, 12588, 12592,
    12596, 12600, 12604, 12608, 12612, 12616, 12620, 12624,
    12628, 12632, 12636, 12640, 12644, 12648, 12652, 12656,
    12660, 12664, 12668, 12672, 12676, 12680, 12684, 12688,
    12692, 12696, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12700, 12704, 12708, 12712, 12716,
    12720, 12724, 12728, 12732, 12736, 12740, 12744, 12748,
    12752, 12756, 12760, 12764, 12768, 12772, 12776, 12780,
    12784, 12788, 12792, 12797, 12802, 12807, 12812, 12817,
    12822, 12827, 12832, 12837, 12842, 12847, 12852, 12857,
    12862, 12867, 12872, 12877, 12882, 12886, 12890, 12894,

    12898, 12903, 12908, 12913, 12918, 12923, 12928, 12933,
    12938, 12943, 12948, 12953, 12958, 12963, 12968, 12973,
    12978, 12983, 12988, 12993, 12998, 13003, 13008, 13013,
    13018, 13023, 13028, 13033, 13038, 13043, 13048, 13053,
    13058, 13063, 13068, 13073, 13078, 13083, 13088, 13093,
    13098, 13103, 13108, 13113, 13118, 13123, 13128, 13133,
    13138, 13143, 13148, 13153, 13158, 13163, 13168, 13173,
    13178, 13183, 13188, 13193, 13198, 13203, 13208, 13213,
    13218, 13223, 13228, 13233, 13238, 13243, 13248, 13253,
    13258, 13263, 13268, 13273, 13278, 13283, 13288, 13293,
    13298, 13303, 13308, 13313, 13318, 13323, 13328, 13333,
    13338, 13343, 13348, 13353, 13358, 13363, 13368, 13374,
    13380, 13386, 13392, 13398, 13404, 13409, 13414, 13419,
    13424, 13429, 13434, 13439, 13444, 13449, 13454, 13459,
    13464, 13469, 13474, 13479, 13484, 13489, 13494, 13499,
    13504, 13509, 13514, 13519, 13524, 13529, 13534, 13539,
    13544, 13549, 13554, 13559, 13564, 13569, 13574, 13579,
    13584, 13589, 13594, 13599, 13604, 13609, 13614, 13619,
    13624, 13629, 13634, 13639, 13644, 13649, 13654, 13659,
    13664, 13669, 13674, 13679, 13684, 13689, 13694, 13699,
    13704, 13709, 13714, 13719, 13724, 13729, 13734, 13739,
    13744, 13749, 13754, 13759, 13764, 13769, 13774, 13779,
    13784, 13789, 13794, 13799, 13804, 13809, 13814, 13819,
    13824, 13829, 13834, 13839, 13844, 13849, 13854, 13859,
    13864, 13869, 13874, 13879, 13884, 13889, 13894, 13899,
    13904, 13909, 13914, 13919, 13924, 13929, 13934, 13939,
    13944, 13949, 13954, 13959, 13964, 13969, 13974, 13979,
    13984, 13989, 13994, 13999, 14004, 14009, 14014, 14019,
    14024, 14029, 14034, 14039, 14044, 14049, 14054, 14059,
    14064, 14069, 14074, 14079, 14084, 14089, 14094, 14099,
    14104, 14109, 14114, 14120, 14126, 14132, 14137, 14142,
    14147, 14152, 14157, 14162, 14167, 14172, 14177, 14182,

    14187, 14192, 14197, 14202, 14207, 14212, 14217, 14222,
    14227, 14232, 14237, 14242, 14247, 14252, 14257, 14262,
    14267, 14272, 14277, 14282, 14287, 14292, 14297, 14302,
    14307, 14312, 14317, 14322, 14327, 14332, 14337, 14342,
    14347, 14352, 14357, 14362, 14367, 14372, 14377, 14382,
    14387, 14392, 14397, 14402, 14407, 14412, 14417, 14422,
    14427, 14432, 14437, 14442, 14447, 14452, 14457, 14462,
    14467, 14472, 14477, 14482, 14487, 14492, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14497, 14503, 14509, 14515, 14521, 14527, 14533, 14539,
    14545, 14551, 14557, 14563, 14569, 14575, 14581, 14587,
    14593, 14599, 14605, 14611, 14617, 14623, 14629, 14635,
    14641, 14647, 14653, 14659, 14665, 14671, 14677, 14683,
    14689, 14695, 14701, 14707, 14713, 14719, 14725, 14731,
    14737, 14743, 14749, 14755, 14761, 14767, 14773, 14779,
    14785, 14791, 14797, 14803, 14809, 14815, 14821, 14827,
    14833, 14839, 14845, 14851, 14857, 14863, 14869, 14875,
    0, 0, 14881, 14887, 14893, 14899, 14905, 14911,
    14917, 14923, 14929, 14935, 14941, 14947, 14953, 14959,
    14965, 14971, 14977, 14983, 14989, 14995, 15001, 15007,
    15013, 15019, 15025, 15031, 15037, 15043, 15049, 15055,
    15061, 15067, 15073, 15079, 15085, 15091, 15097, 15103,
    15109, 15115, 15121, 15127, 15133, 15139, 15145, 15151,
    15157, 15163, 15169, 15175, 15181, 15187, 15193, 15199,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15205, 15211, 15217, 15224, 15231, 15238, 15245, 15252,
    15259, 15266, 15272, 15293, 15304, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15311, 15315, 15319, 15323, 15327, 15331, 15335, 15339,
    15343, 15347, 15351, 15355, 15359, 15363, 15367, 15371,
    15375, 15379, 15383, 15387, 15391, 0, 0, 0,
    0, 15395, 15399, 15403, 15407, 15411, 15415, 15419,
    15423, 15427, 15431, 0, 15435, 15439, 15443, 15447,
    15451, 15455, 15459, 15463, 15467, 15471, 15475, 15479,
    15483, 15487, 15491, 15495, 15499, 15503, 15507, 0,
    15511, 15515, 15519, 15523, 0, 0, 0, 0,
    15527, 15532, 15537, 0, 15542, 0, 15547, 15552,
    15557, 15562, 15567, 15572, 15577, 15582, 15587, 15592,
    15597, 15601, 15605, 15609, 15613, 15617, 15621, 15625,
    15629, 15633, 15637, 15641, 15645, 15649, 15653, 15657,
    15661, 15665, 15669, 15673, 15677, 15681, 15685, 15689,
    15693, 15697, 15701, 15705, 15709, 15713, 15717, 15721,
    15725, 15729, 15733, 15737, 15741, 15745, 15749, 15753,
    15757, 15761, 15765, 15769, 15773, 15777, 15781, 15785,
    15789, 15793, 15797, 15801, 15805, 15809, 15813, 15817,
    15821, 15825, 15829, 15833, 15837, 15841, 15845, 15849,
    15853, 15857, 15861, 15865, 15869, 15873, 15877, 15881,
    15885, 15889, 15893, 15897, 15901, 15905, 15909, 15913,
    15917, 15921, 15925, 15929, 15933, 15937, 15941, 15945,
    15949, 15953, 15957, 15961, 15965, 15969, 15973, 15977,
    15981, 15985, 15989, 15993, 15997, 16001, 16005, 16009,
    16013, 16017, 16021, 16025, 16029, 16033, 16037, 16041,
    16045, 16049, 16053, 16057, 16061, 16065, 16070, 16075,
    16080, 16085, 16090, 16095, 16100, 0, 0, 0,

    0, 16105, 16109, 16113, 16117, 16121, 16125, 16129,
    16133, 16137, 16141, 16145, 16149, 16153, 16157, 16161,
    16165, 16169, 16173, 16177, 16181, 16185, 16189, 16193,
    16197, 16201, 16205, 16209, 16213, 16217, 16221, 16225,
    16229, 16233, 16237, 16241, 16245, 16249, 16253, 16257,
    16261, 16265, 16269, 16273, 16277, 16281, 16285, 16289,
    16293, 16297, 16301, 16305, 16309, 16313, 16317, 16321,
    16325, 16329, 16333, 16337, 16341, 16345, 16349, 16353,
    16357, 16361, 16365, 16369, 16373, 16377, 16381, 16385,
    16389, 16393, 16397, 16401, 16405, 16409, 16413, 16417,
    16421, 16425, 16429, 16433, 16437, 16441, 16445, 16449,
    16453, 16457, 16461, 16465, 16469, 16473, 16477, 16481,
    16485, 16489, 16493, 16497, 16501, 16505, 16509, 16513,
    16517, 16521, 16525, 16529, 16533, 16537, 16541, 16545,
    16549, 16553, 16557, 16561, 16565, 16569, 16573, 16577,
    16581, 16585, 16589, 16593, 16597, 16601, 16605, 16609,
    16613, 16617, 16621, 16625, 16629, 16633, 16637, 16641,
    16645, 16649, 16653, 16657, 16661, 16665, 16669, 16673,
    16677, 16681, 16685, 16689, 16693, 16697, 16701, 16705,
    16709, 16713, 16717, 16721, 16725, 16729, 16733, 16737,
    16741, 16745, 16749, 16753, 16757, 16761, 16765, 16769,
    16773, 16777, 16781, 16785, 16789, 16793, 16797, 16801,
    16805, 16809, 16813, 16817, 16821, 16825, 16829, 16833,
    16837, 16841, 16845, 16849, 16853, 16857, 16861, 0,
    0, 0, 16865, 16869, 16873, 16877, 16881, 16885,
    0, 0, 16889, 16893, 16897, 16901, 16905, 16909,
    0, 0, 16913, 16917, 16921, 16925, 16929, 16933,
    0, 0, 16937, 16941, 16945, 0, 0, 0,
    16949, 16953, 16957, 16961, 16965, 16969, 16973, 0,
    16977, 16981, 16985, 16989, 16993, 16997, 17001, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

// 67544 bytes

const TQ_UINT16 TQUnicodeTables::ligature_map[] = {
    0,
    5563, 0,
    5548, 0,
    5568, 0,
    67, 72, 77, 82, 87, 92, 332, 342, 352, 966, 1196, 1206, 1346, 2361, 3141, 3151, 0,
    2371, 2381, 2391, 0,
    97, 362, 372, 382, 392, 0,
    402, 2411, 2421, 2431, 2441, 2451, 0,
    102, 107, 112, 117, 412, 422, 432, 442, 452, 1216, 1226, 1356, 2481, 2491, 3261, 3271, 3281, 0,
    2511, 0,
    462, 472, 482, 492, 1076, 1146, 2521, 0,
    502, 1336, 2531, 2541, 2551, 2561, 2571, 0,
    122, 127, 132, 137, 512, 522, 532, 542, 552, 976, 1236, 1246, 2581, 3341, 3351, 0,
    567, 0,
    577, 1086, 2601, 2611, 2621, 0,
    587, 597, 607, 2631, 2651, 2661, 0,
    2671, 2681, 2691, 0,
    142, 627, 637, 647, 1156, 2701, 2711, 2721, 2731, 0,
    147, 152, 157, 162, 167, 662, 672, 682, 901, 986, 1096, 1256, 1266, 1386, 3361, 3371, 0,
    2781, 2791, 0,
    692, 702, 712, 1276, 1286, 2801, 2811, 2831, 0,
    722, 732, 742, 752, 1316, 2841, 2851, 0,
    762, 772, 1326, 2891, 2901, 2911, 2921, 0,
    172, 177, 182, 187, 782, 792, 802, 812, 822, 832, 911, 996, 1296, 1306, 2931, 2941, 2951, 3481, 3491, 0,
    2981, 2991, 0,
    842, 3001, 3011, 3021, 3031, 3041, 0,
    3051, 3061, 0,
    192, 852, 862, 1406, 3071, 3551, 3561, 3571, 3581, 0,
    867, 877, 887, 3081, 3091, 3101, 0,
    197, 202, 207, 212, 217, 222, 337, 347, 357, 971, 1201, 1211, 1351, 2366, 3146, 3156, 0,
    2376, 2386, 2396, 0,
    227, 367, 377, 387, 397, 0,
    407, 2416, 2426, 2436, 2446, 2456, 0,
    232, 237, 242, 247, 417, 427, 437, 447, 457, 1221, 1231, 1361, 2486, 2496, 3266, 3276, 3286, 0,
    2516, 0,
    467, 477, 487, 497, 1081, 1151, 2526, 0,
    507, 1341, 2536, 2546, 2556, 2566, 2576, 3111, 0,
    252, 257, 262, 267, 517, 527, 537, 547, 981, 1241, 1251, 2586, 3346, 3356, 0,
    572, 1126, 0,
    582, 1091, 2606, 2616, 2626, 0,
    592, 602, 612, 2636, 2656, 2666, 0,
    2676, 2686, 2696, 0,
    272, 632, 642, 652, 1161, 2706, 2716, 2726, 2736, 0,
    277, 282, 287, 292, 297, 667, 677, 687, 906, 991, 1101, 1261, 1271, 1391, 3366, 3376, 0,
    2786, 2796, 0,
    697, 707, 717, 1281, 1291, 2806, 2816, 2836, 0,
    727, 737, 747, 757, 1321, 2846, 2856, 0,
    767, 777, 1331, 2896, 2906, 2916, 2926, 3116, 0,
    302, 307, 312, 317, 787, 797, 807, 817, 827, 837, 916, 1001, 1301, 1311, 2936, 2946, 2956, 3486, 3496, 0,
    2986, 2996, 0,
    847, 3006, 3016, 3026, 3036, 3046, 3121, 0,
    3056, 3066, 0,
    322, 327, 857, 1411, 3076, 3126, 3556, 3566, 3576, 3586, 0,
    872, 882, 892, 3086, 3096, 3106, 0,
    1537, 4472, 4666, 0,
    3161, 3171, 3181, 3191, 0,
    1046, 0,
    1166, 0,
    1066, 1176, 0,
    2401, 0,
    3291, 3301, 3311, 3321, 0,
    2591, 0,
    3381, 3391, 3401, 3411, 0,
    1376, 2741, 2751, 0,
    1366, 0,
    1186, 0,
    1006, 1016, 1026, 1036, 0,
    3166, 3176, 3186, 3196, 0,
    1051, 0,
    1171, 0,
    1071, 1181, 0,
    2406, 0,
    3296, 3306, 3316, 3326, 0,
    2596, 0,
    3386, 3396, 3406, 3416, 0,
    1381, 2746, 2756, 0,
    1371, 0,
    1191, 0,
    1011, 1021, 1031, 1041, 0,
    3211, 3221, 3231, 3241, 0,
    3216, 3226, 3236, 3246, 0,
    2461, 2471, 0,
    2466, 2476, 0,
    2761, 2771, 0,
    2766, 2776, 0,
    2861, 0,
    2866, 0,
    2871, 0,
    2876, 0,
    2961, 0,
    2966, 0,
    2971, 0,
    2976, 0,
    3136, 0,
    3431, 3441, 3451, 3461, 3471, 0,
    3436, 3446, 3456, 3466, 3476, 0,
    3501, 3511, 3521, 3531, 3541, 0,
    3506, 3516, 3526, 3536, 3546, 0,
    1116, 0,
    1106, 0,
    1111, 0,
    1056, 0,
    1061, 0,
    2501, 0,
    2506, 0,
    1396, 0,
    1401, 0,
    1121, 0,
    1514, 0,
    1542, 3631, 3636, 4429, 4434, 4439, 4448, 0,
    1551, 3701, 3706, 4502, 0,
    1556, 3771, 3776, 4511, 4520, 0,
    1561, 1586, 3851, 3856, 4569, 4574, 4579, 0,
    1566, 3921, 3926, 4704, 0,
    4661, 0,
    1571, 1591, 3991, 4642, 4647, 4652, 0,
    1576, 4051, 4056, 4713, 4722, 0,
    4414, 0,
    4487, 0,
    1596, 3591, 3596, 4091, 4394, 4399, 4409, 4419, 0,
    1601, 3671, 3676, 4100, 0,
    1606, 3731, 3736, 4109, 4482, 4492, 0,
    1611, 1621, 3811, 3816, 4118, 4540, 4545, 4559, 0,
    1631, 3891, 3896, 4127, 0,
    4622, 4627, 0,
    1626, 1636, 3951, 3956, 4136, 4603, 4608, 4632, 0,
    1641, 4011, 4016, 4145, 4684, 4694, 0,
    1581, 4550, 4564, 0,
    1616, 4613, 4637, 0,
    4689, 0,
    1658, 1663, 0,
    1707, 0,
    1792, 1802, 0,
    1702, 0,
    1692, 1697, 1812, 0,
    1782, 1832, 0,
    1842, 0,
    1717, 1727, 1852, 1862, 0,
    1712, 0,
    1872, 0,
    1722, 1902, 1912, 1922, 0,
    1932, 0,
    1942, 0,
    1892, 0,
    1797, 1807, 0,
    1747, 0,
    1737, 1742, 1817, 0,
    1787, 1837, 0,
    1847, 0,
    1732, 1762, 1857, 1867, 0,
    1757, 0,
    1877, 0,
    1767, 1907, 1917, 1927, 0,
    1937, 0,
    1947, 0,
    1897, 0,
    1752, 0,
    1772, 0,
    1777, 0,
    1822, 0,
    1827, 0,
    1882, 0,
    1887, 0,
    12163, 12168, 12173, 0,
    12178, 12288, 0,
    12183, 0,
    12188, 0,
    12193, 0,
    12198, 12283, 0,
    12203, 0,
    12208, 0,
    12093, 12213, 0,
    12218, 0,
    12223, 12293, 0,
    12228, 0,
    12233, 0,
    12238, 0,
    12243, 0,
    12248, 0,
    12253, 12298, 0,
    12258, 0,
    12263, 0,
    12268, 0,
    12143, 12148, 12273, 0,
    12278, 0,
    12098, 0,
    1957, 1962, 1972, 0,
    1967, 0,
    1977, 0,
    2007, 0,
    2012, 0,
    2002, 0,
    2032, 0,
    2037, 0,
    2042, 0,
    2047, 0,
    2052, 0,
    2057, 0,
    2017, 0,
    2062, 0,
    2067, 0,
    2022, 0,
    2027, 0,
    2082, 0,
    2087, 0,
    2092, 0,
    2072, 2077, 0,
    2107, 0,
    2112, 0,
    2117, 0,
    2122, 0,
    2097, 0,
    2102, 0,
    2142, 0,
    2147, 0,
    2127, 2132, 2137, 0,
    2152, 0,
    2157, 2167, 0,
    2162, 0,
    2172, 0,
    2177, 0,
    2182, 2187, 2192, 0,
    2197, 0,
    2202, 2212, 0,
    2207, 0,
    2217, 2222, 2232, 0,
    2227, 0,
    2286, 0,
    2261, 0,
    2266, 0,
    2271, 0,
    2276, 0,
    2281, 0,
    2291, 2296, 2321, 0,
    2351, 0,
    2326, 0,
    2331, 0,
    2336, 0,
    2341, 0,
    2346, 0,
    2301, 0,
    2311, 0,
    2356, 0,
    2641, 0,
    2646, 0,
    2821, 0,
    2826, 0,
    2881, 0,
    2886, 0,
    3201, 3251, 0,
    3206, 3256, 0,
    3331, 0,
    3336, 0,
    3421, 0,
    3426, 0,
    3601, 3611, 3621, 4154, 0,
    3606, 3616, 3626, 4159, 0,
    4164, 0,
    4169, 0,
    4174, 0,
    4179, 0,
    4184, 0,
    4189, 0,
    3641, 3651, 3661, 4194, 0,
    3646, 3656, 3666, 4199, 0,
    4204, 0,
    4209, 0,
    4214, 0,
    4219, 0,
    4224, 0,
    4229, 0,
    3681, 3691, 0,
    3686, 3696, 0,
    3711, 3721, 0,
    3716, 3726, 0,
    3741, 3751, 3761, 4234, 0,
    3746, 3756, 3766, 4239, 0,
    4244, 0,
    4249, 0,
    4254, 0,
    4259, 0,
    4264, 0,
    4269, 0,
    3781, 3791, 3801, 4274, 0,
    3786, 3796, 3806, 4279, 0,
    4284, 0,
    4289, 0,
    4294, 0,
    4299, 0,
    4304, 0,
    4309, 0,
    3821, 3831, 3841, 0,
    3826, 3836, 3846, 0,
    3861, 3871, 3881, 0,
    3866, 3876, 3886, 0,
    3901, 3911, 0,
    3906, 3916, 0,
    3931, 3941, 0,
    3936, 3946, 0,
    3961, 3971, 3981, 0,
    3966, 3976, 3986, 0,
    3996, 4001, 4006, 0,
    4021, 4031, 4041, 4314, 0,
    4026, 4036, 4046, 4319, 0,
    4324, 0,
    4329, 0,
    4334, 0,
    4339, 0,
    4344, 0,
    4349, 0,
    4061, 4071, 4081, 4354, 0,
    4066, 4076, 4086, 4359, 0,
    4364, 0,
    4369, 0,
    4374, 0,
    4379, 0,
    4384, 0,
    4389, 0,
    4404, 0,
    4477, 0,
    4679, 0,
    4424, 0,
    4525, 4530, 4535, 0,
    4497, 0,
    4699, 0,
    4588, 4593, 4598, 0,
    5451, 0,
    5456, 0,
    5461, 0,
    5466, 0,
    5476, 0,
    5471, 0,
    5481, 0,
    5486, 0,
    5491, 0,
    5496, 0,
    5501, 0,
    5528, 0,
    5533, 0,
    5538, 0,
    5543, 0,
    5558, 0,
    5553, 0,
    5573, 0,
    5578, 0,
    5583, 0,
    5588, 0,
    5593, 0,
    5598, 0,
    5603, 0,
    5608, 0,
    5653, 0,
    5658, 0,
    5613, 0,
    5618, 0,
    5623, 0,
    5628, 0,
    5663, 0,
    5668, 0,
    5633, 0,
    5638, 0,
    5643, 0,
    5648, 0,
    5673, 0,
    5678, 0,
    5683, 0,
    5688, 0,
    6426, 0,
    7440, 0,
    7315, 0,
    7320, 0,
    7325, 0,
    7330, 0,
    7335, 0,
    7340, 0,
    7345, 0,
    7350, 0,
    7355, 0,
    7360, 0,
    7365, 0,
    7370, 0,
    7375, 0,
    7380, 0,
    7385, 0,
    7390, 7395, 0,
    7400, 7405, 0,
    7410, 7415, 0,
    7420, 7425, 0,
    7430, 7435, 0,
    7455, 0,
    7590, 0,
    7465, 0,
    7470, 0,
    7475, 0,
    7480, 0,
    7485, 0,
    7490, 0,
    7495, 0,
    7500, 0,
    7505, 0,
    7510, 0,
    7515, 0,
    7520, 0,
    7525, 0,
    7530, 0,
    7535, 0,
    7540, 7545, 0,
    7550, 7555, 0,
    7560, 7565, 0,
    7570, 7575, 0,
    7580, 7585, 0,
    7595, 0,
    7600, 0,
    7605, 0,
    7610, 0,
    7615, 0,
    12153, 12158, 0,

};

const TQ_UINT16 TQUnicodeTables::ligature_info[] = {
    1, 2, 3, 4, 5, 6, 7, 8,
    8, 9, 10, 11, 12, 13, 8, 14,
    15, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 16, 17,
    8, 18, 19, 8, 8, 8, 8, 8,
    8, 8, 20, 8, 8, 8, 8, 8,
    21, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 22, 8, 8, 8, 8,


    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 3, 5, 0,
    0, 7, 24, 28, 34, 41, 59, 61,
    69, 77, 93, 95, 101, 108, 112, 122,
    139, 0, 142, 151, 159, 167, 187, 190,
    197, 200, 210, 0, 0, 0, 0, 0,
    0, 217, 234, 238, 244, 251, 269, 271,
    279, 288, 303, 306, 312, 319, 323, 333,
    350, 0, 353, 362, 370, 379, 399, 402,
    410, 413, 424, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    431, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 435, 0, 440, 442, 444, 447,
    0, 0, 449, 0, 0, 0, 0, 454,
    0, 0, 0, 0, 456, 461, 465, 0,
    467, 0, 0, 0, 469, 0, 0, 0,
    0, 0, 474, 0, 479, 481, 483, 486,
    0, 0, 488, 0, 0, 0, 0, 493,
    0, 0, 0, 0, 495, 500, 504, 0,
    506, 0, 0, 0, 508, 0, 0, 0,

    0, 0, 513, 518, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 523, 526, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 529, 532, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 535, 537, 0, 0, 0, 0,
    539, 541, 0, 0, 0, 0, 0, 0,
    543, 545, 547, 549, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 551,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    553, 559, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 565,
    571, 0, 0, 0, 0, 0, 0, 577,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 579, 581, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 583, 585,
    587, 589, 0, 0, 0, 0, 591, 593,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 595, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    597, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 599, 0, 0, 0, 607, 0, 612,
    0, 618, 0, 0, 0, 0, 0, 626,
    0, 631, 0, 0, 0, 633, 0, 0,
    0, 640, 0, 0, 646, 0, 648, 0,
    0, 650, 0, 0, 0, 659, 0, 664,
    0, 671, 0, 0, 0, 0, 0, 680,
    0, 685, 0, 0, 0, 688, 0, 0,
    0, 697, 704, 708, 0, 0, 712, 0,
    0, 0, 714, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 717, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    719, 0, 0, 722, 0, 724, 728, 731,
    733, 0, 738, 0, 0, 0, 740, 0,
    0, 0, 0, 742, 0, 0, 0, 747,
    0, 0, 0, 749, 0, 751, 0, 0,
    753, 0, 0, 756, 0, 758, 762, 765,
    767, 0, 772, 0, 0, 0, 774, 0,
    0, 0, 0, 776, 0, 0, 0, 781,
    0, 0, 0, 783, 0, 785, 0, 0,
    0, 0, 0, 0, 0, 0, 787, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 789, 791, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    793, 795, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    797, 799, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    801, 805, 808, 810, 812, 814, 817, 0,
    819, 821, 824, 826, 829, 0, 831, 0,
    833, 835, 0, 837, 839, 0, 842, 844,
    846, 848, 852, 0, 0, 0, 0, 0,
    0, 0, 854, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 856,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    860, 0, 862, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 864, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 866, 0, 0, 868, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 870, 872, 874,
    0, 0, 0, 0, 876, 0, 0, 0,
    0, 878, 880, 0, 0, 0, 0, 0,
    882, 0, 0, 884, 0, 0, 0, 886,
    888, 0, 0, 890, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 892, 894, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 896,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 898,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 901, 903,
    0, 0, 0, 0, 905, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 907, 0, 0, 0, 0,
    0, 0, 909, 0, 0, 0, 0, 0,
    911, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 913, 915, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 917,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 921, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 923, 926,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 928, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 930,
    0, 0, 0, 0, 0, 0, 932, 0,
    0, 0, 936, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 938, 941,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 943, 0, 0, 947, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    949, 0, 951, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 953, 0, 0, 0,
    0, 955, 0, 0, 0, 0, 957, 0,
    0, 0, 0, 959, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 961, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    965, 0, 967, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 969, 0, 0, 0,
    0, 971, 0, 0, 0, 0, 973, 0,
    0, 0, 0, 975, 0, 0, 0, 0,
    0, 0, 977, 979, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 981, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 983, 985,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 987, 989, 0, 0, 0, 0,
    0, 0, 991, 993, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    995, 998, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1001, 1003, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1005, 1007, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    1009, 1014, 1019, 1021, 1023, 1025, 1027, 1029,
    1031, 1036, 1041, 1043, 1045, 1047, 1049, 1051,
    1053, 1056, 0, 0, 0, 0, 0, 0,
    1059, 1062, 0, 0, 0, 0, 0, 0,
    1065, 1070, 1075, 1077, 1079, 1081, 1083, 1085,
    1087, 1092, 1097, 1099, 1101, 1103, 1105, 1107,
    1109, 1113, 0, 0, 0, 0, 0, 0,
    1117, 1121, 0, 0, 0, 0, 0, 0,
    1125, 1128, 0, 0, 0, 0, 0, 0,
    1131, 1134, 0, 0, 0, 0, 0, 0,
    1137, 1141, 0, 0, 0, 0, 0, 0,
    0, 1145, 0, 0, 0, 0, 0, 0,
    1149, 1154, 1159, 1161, 1163, 1165, 1167, 1169,
    1171, 1176, 1181, 1183, 1185, 1187, 1189, 1191,
    1193, 0, 0, 0, 1195, 0, 0, 0,
    0, 0, 0, 0, 1197, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1199, 0,
    0, 0, 0, 0, 0, 0, 0, 1201,
    0, 0, 0, 0, 0, 0, 1205, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1207, 0,
    0, 0, 0, 0, 0, 0, 1209, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1213, 0, 1215, 0, 1217, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1219, 0, 1221, 0, 1223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 1225, 0, 0, 0, 0,
    1227, 0, 0, 1229, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1231, 0, 1233, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1235, 0, 0, 0,
    0, 0, 0, 1237, 0, 1239, 0, 0,
    1241, 0, 0, 0, 0, 1243, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1245, 0, 0, 1247, 1249, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1251, 1253, 0, 0, 1255, 1257,
    0, 0, 1259, 1261, 1263, 1265, 0, 0,
    0, 0, 1267, 1269, 0, 0, 1271, 1273,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1275, 1277, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1279, 0, 0, 0, 0, 0,
    1281, 1283, 0, 1285, 0, 0, 0, 0,
    0, 0, 1287, 1289, 1291, 1293, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1295, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1297, 0,
    0, 0, 0, 1299, 0, 1301, 0, 1303,
    0, 1305, 0, 1307, 0, 1309, 0, 1311,
    0, 1313, 0, 1315, 0, 1317, 0, 1319,
    0, 1321, 0, 0, 1323, 0, 1325, 0,
    1327, 0, 0, 0, 0, 0, 0, 1329,
    0, 0, 1332, 0, 0, 1335, 0, 0,
    1338, 0, 0, 1341, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1344, 0, 0,
    0, 0, 0, 0, 0, 0, 1346, 0,
    0, 0, 0, 1348, 0, 1350, 0, 1352,
    0, 1354, 0, 1356, 0, 1358, 0, 1360,
    0, 1362, 0, 1364, 0, 1366, 0, 1368,
    0, 1370, 0, 0, 1372, 0, 1374, 0,
    1376, 0, 0, 0, 0, 0, 0, 1378,
    0, 0, 1381, 0, 0, 1384, 0, 0,
    1387, 0, 0, 1390, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1393,
    1395, 1397, 1399, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1401, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1403, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

// 14586 bytes

const TQ_UINT8 TQUnicodeTables::direction_info[] = {
    1, 2, 3, 4, 5, 6, 7, 8,
    2, 9, 10, 11, 12, 13, 14, 15,
    16, 2, 2, 2, 2, 2, 17, 18,
    19, 2, 2, 2, 2, 2, 2, 20,
    21, 22, 23, 24, 25, 26, 27, 28,
    26, 29, 30, 2, 2, 2, 31, 32,
    33, 2, 34, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 35, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 36, 37, 38, 39, 40,


    18, 18, 18, 18, 18, 18, 18, 18,
    18, 8, 7, 8, 9, 7, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 7, 7, 7, 8,
    9, 10, 10, 4, 4, 4, 10, 10,
    138, 138, 10, 4, 6, 4, 6, 3,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 138, 10, 138, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 18,
    18, 18, 18, 18, 18, 7, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    6, 10, 4, 4, 4, 4, 10, 10,
    10, 10, 0, 138, 10, 10, 10, 10,
    4, 4, 2, 2, 10, 0, 10, 10,
    10, 2, 0, 138, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 10, 10, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 17, 17, 17, 17, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 17, 1, 17,
    1, 17, 17, 1, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 13, 0, 0, 0, 13,
    0, 13, 77, 77, 77, 77, 45, 77,
    45, 77, 45, 45, 45, 45, 45, 77,
    77, 77, 77, 45, 45, 45, 45, 45,
    45, 45, 45, 0, 0, 0, 0, 0,
    109, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 45, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 4, 5, 5, 13, 45, 45,
    17, 77, 77, 77, 13, 77, 77, 77,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 45, 77, 45, 77,
    45, 45, 77, 77, 13, 77, 17, 17,
    17, 17, 17, 17, 17, 13, 17, 17,
    17, 17, 17, 17, 17, 13, 13, 17,
    17, 10, 17, 17, 17, 17, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 45, 45, 45, 13, 13, 0,

    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 0, 18,
    77, 17, 45, 45, 45, 77, 77, 77,
    77, 77, 45, 45, 45, 45, 77, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 77, 45, 77, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 0, 0, 0, 0, 17, 0, 0,
    0, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 0, 0, 0, 0, 17,
    17, 0, 0, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 0, 17,
    17, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 17,
    0, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 17,
    17, 0, 0, 0, 0, 0, 17, 17,
    17, 0, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 17,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 4,
    0, 0, 0, 0, 0, 0, 0, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 17,
    0, 17, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    17, 17, 17, 17, 17, 0, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 17, 17,
    17, 0, 17, 0, 0, 0, 17, 17,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 17,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 17, 17, 17, 18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 0,

    9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 18, 18, 114, 0, 1,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    9, 7, 11, 14, 16, 12, 15, 9,
    4, 4, 4, 4, 4, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 138, 138, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 9,
    18, 18, 18, 18, 0, 0, 0, 0,
    0, 0, 18, 18, 18, 18, 18, 18,
    2, 0, 0, 0, 2, 2, 2, 2,
    2, 2, 4, 4, 10, 138, 138, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 4, 4, 10, 138, 138, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    10, 10, 0, 10, 10, 10, 10, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 10, 10,
    10, 0, 0, 0, 0, 0, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    0, 10, 0, 0, 0, 0, 4, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    138, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,

    10, 138, 138, 138, 138, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 138, 4, 4, 10, 138, 138, 10,
    10, 10, 138, 138, 138, 138, 10, 138,
    138, 138, 138, 10, 138, 10, 138, 10,
    10, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 138, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 10,
    10, 10, 138, 138, 138, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 138,
    138, 10, 138, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 138,
    138, 138, 138, 10, 10, 10, 10, 10,
    138, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 10, 10, 10, 10, 10, 138, 138,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 10, 10, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,

    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    10, 10, 10, 0, 0, 0, 10, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 138, 138, 10,
    10, 10, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 138, 10, 10, 10, 10, 138, 138,
    138, 138, 138, 10, 138, 138, 10, 10,
    138, 138, 138, 138, 138, 10, 10, 10,
    10, 138, 10, 138, 138, 138, 10, 10,
    138, 138, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 138, 138, 138, 138,
    138, 138, 10, 10, 138, 138, 10, 10,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 138, 138,
    138, 138, 10, 10, 138, 10, 138, 10,
    10, 138, 10, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 138, 10, 10,
    10, 10, 10, 10, 138, 138, 138, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 138,
    138, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 138, 138, 10, 10,
    10, 10, 138, 138, 138, 138, 10, 138,
    138, 10, 10, 138, 138, 10, 10, 10,
    10, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 10, 138, 10,
    10, 10, 138, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 138, 138, 10,
    10, 10, 10, 138, 10, 10, 10, 138,
    138, 138, 138, 138, 10, 138, 10, 10,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,

    9, 10, 10, 10, 10, 0, 0, 0,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 10, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 17, 17, 17,
    10, 0, 0, 0, 0, 0, 10, 10,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 10, 10, 0, 0, 0,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 17, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 4, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,

    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,

    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    0, 0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 0, 0, 0,

    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    6, 10, 6, 0, 10, 6, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 4,
    10, 10, 4, 4, 10, 10, 10, 0,
    10, 4, 4, 10, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 0, 0, 18,

    0, 10, 10, 4, 4, 4, 10, 10,
    138, 138, 10, 4, 6, 4, 6, 3,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 138, 10, 138, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 138,
    138, 10, 138, 138, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 10, 10, 10, 4, 4, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 18, 18, 18, 10, 10, 0, 0,
};

// 25082 bytes

const TQ_UINT8 TQUnicodeTables::combining_info[] = {
    1, 1, 1, 2, 3, 4, 5, 6,
    1, 7, 8, 9, 10, 11, 12, 13,
    14, 1, 1, 1, 1, 1, 1, 15,
    16, 1, 1, 1, 1, 1, 1, 1,
    17, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    18, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 19, 1, 1, 20, 1,


    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    230, 230, 230, 230, 230, 230, 230, 230,
    230, 230, 230, 230, 230, 230, 230, 230,
    230, 230, 230, 230, 230, 232, 220, 220,
    220, 220, 232, 216, 220, 220, 220, 220,
    220, 202, 202, 220, 220, 220, 220, 202,
    202, 220, 220, 220, 220, 220, 220, 220,
    220, 220, 220, 220, 1, 1, 1, 1,
    1, 220, 220, 220, 220, 230, 230, 230,
    230, 230, 230, 230, 230, 240, 230, 220,
    220, 220, 230, 230, 230, 220, 220, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    234, 234, 233, 230, 230, 230, 230, 230,
    230, 230, 230, 230, 230, 230, 230, 230,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 230, 230, 230, 230, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 220, 230, 230, 230, 230, 220, 230,
    230, 230, 222, 220, 230, 230, 230, 230,
    230, 230, 0, 220, 220, 220, 220, 220,
    230, 230, 220, 230, 230, 222, 228, 230,
    10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 0, 20, 21, 22, 0, 23,
    0, 24, 25, 0, 230, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 27, 28, 29, 30, 31,
    32, 33, 34, 230, 230, 220, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    35, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 230, 230,
    230, 230, 230, 230, 230, 0, 0, 230,
    230, 230, 230, 220, 230, 0, 0, 230,
    230, 0, 220, 230, 230, 220, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 36, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    230, 220, 230, 230, 220, 230, 230, 220,
    220, 220, 230, 220, 220, 230, 220, 230,
    230, 230, 220, 230, 220, 230, 220, 230,
    220, 230, 230, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 230, 220, 230, 230, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 84, 91, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    103, 103, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    107, 107, 107, 107, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    118, 118, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    122, 122, 122, 122, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    220, 220, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 220, 0, 220,
    0, 216, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 129, 130, 0, 132, 0, 0, 0,
    0, 0, 130, 130, 130, 130, 0, 0,
    130, 0, 230, 230, 9, 0, 230, 230,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 220, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 228, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    230, 230, 1, 1, 230, 230, 230, 230,
    1, 1, 1, 230, 230, 0, 0, 0,
    0, 230, 0, 0, 0, 1, 1, 230,
    220, 230, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 218, 228, 232, 222, 224, 224,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    230, 230, 230, 230, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

// 30458 bytes

const TQ_UINT16 TQUnicodeTables::case_info[] = {
    1, 2, 3, 4, 5, 6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 8,
    0, 9, 0, 0, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 11,


    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0, 0, 0, 0, 0,
    0, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x39c, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x1e9e,
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0x178,

    0x101, 0x100, 0x103, 0x102, 0x105, 0x104, 0x107, 0x106,
    0x109, 0x108, 0x10b, 0x10a, 0x10d, 0x10c, 0x10f, 0x10e,
    0x111, 0x110, 0x113, 0x112, 0x115, 0x114, 0x117, 0x116,
    0x119, 0x118, 0x11b, 0x11a, 0x11d, 0x11c, 0x11f, 0x11e,
    0x121, 0x120, 0x123, 0x122, 0x125, 0x124, 0x127, 0x126,
    0x129, 0x128, 0x12b, 0x12a, 0x12d, 0x12c, 0x12f, 0x12e,
    0x69, 0x49, 0x133, 0x132, 0x135, 0x134, 0x137, 0x136,
    0, 0x13a, 0x139, 0x13c, 0x13b, 0x13e, 0x13d, 0x140,
    0x13f, 0x142, 0x141, 0x144, 0x143, 0x146, 0x145, 0x148,
    0x147, 0, 0x14b, 0x14a, 0x14d, 0x14c, 0x14f, 0x14e,
    0x151, 0x150, 0x153, 0x152, 0x155, 0x154, 0x157, 0x156,
    0x159, 0x158, 0x15b, 0x15a, 0x15d, 0x15c, 0x15f, 0x15e,
    0x161, 0x160, 0x163, 0x162, 0x165, 0x164, 0x167, 0x166,
    0x169, 0x168, 0x16b, 0x16a, 0x16d, 0x16c, 0x16f, 0x16e,
    0x171, 0x170, 0x173, 0x172, 0x175, 0x174, 0x177, 0x176,
    0xff, 0x17a, 0x179, 0x17c, 0x17b, 0x17e, 0x17d, 0x53,
    0, 0x253, 0x183, 0x182, 0x185, 0x184, 0x254, 0x188,
    0x187, 0x256, 0x257, 0x18c, 0x18b, 0, 0x1dd, 0x259,
    0x25b, 0x192, 0x191, 0x260, 0x263, 0x1f6, 0x269, 0x268,
    0x199, 0x198, 0, 0, 0x26f, 0x272, 0x220, 0x275,
    0x1a1, 0x1a0, 0x1a3, 0x1a2, 0x1a5, 0x1a4, 0x280, 0x1a8,
    0x1a7, 0x283, 0, 0, 0x1ad, 0x1ac, 0x288, 0x1b0,
    0x1af, 0x28a, 0x28b, 0x1b4, 0x1b3, 0x1b6, 0x1b5, 0x292,
    0x1b9, 0x1b8, 0, 0, 0x1bd, 0x1bc, 0, 0x1f7,
    0, 0, 0, 0, 0x1c6, 0x1c4, 0x1c4, 0x1c9,
    0x1c7, 0x1c7, 0x1cc, 0x1ca, 0x1ca, 0x1ce, 0x1cd, 0x1d0,
    0x1cf, 0x1d2, 0x1d1, 0x1d4, 0x1d3, 0x1d6, 0x1d5, 0x1d8,
    0x1d7, 0x1da, 0x1d9, 0x1dc, 0x1db, 0x18e, 0x1df, 0x1de,
    0x1e1, 0x1e0, 0x1e3, 0x1e2, 0x1e5, 0x1e4, 0x1e7, 0x1e6,
    0x1e9, 0x1e8, 0x1eb, 0x1ea, 0x1ed, 0x1ec, 0x1ef, 0x1ee,
    0, 0x1f3, 0x1f1, 0x1f1, 0x1f5, 0x1f4, 0x195, 0x1bf,
    0x1f9, 0x1f8, 0x1fb, 0x1fa, 0x1fd, 0x1fc, 0x1ff, 0x1fe,

    0x201, 0x200, 0x203, 0x202, 0x205, 0x204, 0x207, 0x206,
    0x209, 0x208, 0x20b, 0x20a, 0x20d, 0x20c, 0x20f, 0x20e,
    0x211, 0x210, 0x213, 0x212, 0x215, 0x214, 0x217, 0x216,
    0x219, 0x218, 0x21b, 0x21a, 0x21d, 0x21c, 0x21f, 0x21e,
    0x19e, 0, 0x223, 0x222, 0x225, 0x224, 0x227, 0x226,
    0x229, 0x228, 0x22b, 0x22a, 0x22d, 0x22c, 0x22f, 0x22e,
    0x231, 0x230, 0x233, 0x232, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x242, 0x241, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x181, 0x186, 0, 0x189, 0x18a,
    0, 0x18f, 0, 0x190, 0, 0, 0, 0,
    0x193, 0, 0, 0x194, 0, 0, 0, 0,
    0x197, 0x196, 0, 0, 0, 0, 0, 0x19c,
    0, 0, 0x19d, 0, 0, 0x19f, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x1a6, 0, 0, 0x1a9, 0, 0, 0, 0,
    0x1ae, 0, 0x1b1, 0x1b2, 0, 0, 0, 0,
    0, 0, 0x1b7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x399, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x3ac, 0,
    0x3ad, 0x3ae, 0x3af, 0, 0x3cc, 0, 0x3cd, 0x3ce,
    0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
    0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
    0x3c0, 0x3c1, 0, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
    0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x386, 0x388, 0x389, 0x38a,
    0, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
    0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
    0x3a0, 0x3a1, 0x3a3, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
    0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x38c, 0x38e, 0x38f, 0,
    0x392, 0x398, 0, 0, 0, 0x3a6, 0x3a0, 0,
    0x3d9, 0x3d8, 0x3db, 0x3da, 0x3dd, 0x3dc, 0x3df, 0x3de,
    0x3e1, 0x3e0, 0x3e3, 0x3e2, 0x3e5, 0x3e4, 0x3e7, 0x3e6,
    0x3e9, 0x3e8, 0x3eb, 0x3ea, 0x3ed, 0x3ec, 0x3ef, 0x3ee,
    0x39a, 0x3a1, 0x3f9, 0, 0x3b8, 0x395, 0, 0,
    0, 0x3f2, 0x3fb, 0x3fa, 0, 0, 0, 0,

    0x450, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
    0x458, 0x459, 0x45a, 0x45b, 0x45c, 0x45d, 0x45e, 0x45f,
    0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
    0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
    0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
    0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
    0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
    0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
    0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
    0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
    0x400, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407,
    0x408, 0x409, 0x40a, 0x40b, 0x40c, 0x40d, 0x40e, 0x40f,
    0x461, 0x460, 0x463, 0x462, 0x465, 0x464, 0x467, 0x466,
    0x469, 0x468, 0x46b, 0x46a, 0x46d, 0x46c, 0x46f, 0x46e,
    0x471, 0x470, 0x473, 0x472, 0x475, 0x474, 0x477, 0x476,
    0x479, 0x478, 0x47b, 0x47a, 0x47d, 0x47c, 0x47f, 0x47e,
    0x481, 0x480, 0, 0, 0, 0, 0, 0,
    0, 0, 0x48b, 0x48a, 0x48d, 0x48c, 0x48f, 0x48e,
    0x491, 0x490, 0x493, 0x492, 0x495, 0x494, 0x497, 0x496,
    0x499, 0x498, 0x49b, 0x49a, 0x49d, 0x49c, 0x49f, 0x49e,
    0x4a1, 0x4a0, 0x4a3, 0x4a2, 0x4a5, 0x4a4, 0x4a7, 0x4a6,
    0x4a9, 0x4a8, 0x4ab, 0x4aa, 0x4ad, 0x4ac, 0x4af, 0x4ae,
    0x4b1, 0x4b0, 0x4b3, 0x4b2, 0x4b5, 0x4b4, 0x4b7, 0x4b6,
    0x4b9, 0x4b8, 0x4bb, 0x4ba, 0x4bd, 0x4bc, 0x4bf, 0x4be,
    0, 0x4c2, 0x4c1, 0x4c4, 0x4c3, 0x4c6, 0x4c5, 0x4c8,
    0x4c7, 0x4ca, 0x4c9, 0x4cc, 0x4cb, 0x4ce, 0x4cd, 0,
    0x4d1, 0x4d0, 0x4d3, 0x4d2, 0x4d5, 0x4d4, 0x4d7, 0x4d6,
    0x4d9, 0x4d8, 0x4db, 0x4da, 0x4dd, 0x4dc, 0x4df, 0x4de,
    0x4e1, 0x4e0, 0x4e3, 0x4e2, 0x4e5, 0x4e4, 0x4e7, 0x4e6,
    0x4e9, 0x4e8, 0x4eb, 0x4ea, 0x4ed, 0x4ec, 0x4ef, 0x4ee,
    0x4f1, 0x4f0, 0x4f3, 0x4f2, 0x4f5, 0x4f4, 0, 0,
    0x4f9, 0x4f8, 0, 0, 0, 0, 0, 0,

    0x501, 0x500, 0x503, 0x502, 0x505, 0x504, 0x507, 0x506,
    0x509, 0x508, 0x50b, 0x50a, 0x50d, 0x50c, 0x50f, 0x50e,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x561, 0x562, 0x563, 0x564, 0x565, 0x566, 0x567,
    0x568, 0x569, 0x56a, 0x56b, 0x56c, 0x56d, 0x56e, 0x56f,
    0x570, 0x571, 0x572, 0x573, 0x574, 0x575, 0x576, 0x577,
    0x578, 0x579, 0x57a, 0x57b, 0x57c, 0x57d, 0x57e, 0x57f,
    0x580, 0x581, 0x582, 0x583, 0x584, 0x585, 0x586, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x531, 0x532, 0x533, 0x534, 0x535, 0x536, 0x537,
    0x538, 0x539, 0x53a, 0x53b, 0x53c, 0x53d, 0x53e, 0x53f,
    0x540, 0x541, 0x542, 0x543, 0x544, 0x545, 0x546, 0x547,
    0x548, 0x549, 0x54a, 0x54b, 0x54c, 0x54d, 0x54e, 0x54f,
    0x550, 0x551, 0x552, 0x553, 0x554, 0x555, 0x556, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0x1e01, 0x1e00, 0x1e03, 0x1e02, 0x1e05, 0x1e04, 0x1e07, 0x1e06,
    0x1e09, 0x1e08, 0x1e0b, 0x1e0a, 0x1e0d, 0x1e0c, 0x1e0f, 0x1e0e,
    0x1e11, 0x1e10, 0x1e13, 0x1e12, 0x1e15, 0x1e14, 0x1e17, 0x1e16,
    0x1e19, 0x1e18, 0x1e1b, 0x1e1a, 0x1e1d, 0x1e1c, 0x1e1f, 0x1e1e,
    0x1e21, 0x1e20, 0x1e23, 0x1e22, 0x1e25, 0x1e24, 0x1e27, 0x1e26,
    0x1e29, 0x1e28, 0x1e2b, 0x1e2a, 0x1e2d, 0x1e2c, 0x1e2f, 0x1e2e,
    0x1e31, 0x1e30, 0x1e33, 0x1e32, 0x1e35, 0x1e34, 0x1e37, 0x1e36,
    0x1e39, 0x1e38, 0x1e3b, 0x1e3a, 0x1e3d, 0x1e3c, 0x1e3f, 0x1e3e,
    0x1e41, 0x1e40, 0x1e43, 0x1e42, 0x1e45, 0x1e44, 0x1e47, 0x1e46,
    0x1e49, 0x1e48, 0x1e4b, 0x1e4a, 0x1e4d, 0x1e4c, 0x1e4f, 0x1e4e,
    0x1e51, 0x1e50, 0x1e53, 0x1e52, 0x1e55, 0x1e54, 0x1e57, 0x1e56,
    0x1e59, 0x1e58, 0x1e5b, 0x1e5a, 0x1e5d, 0x1e5c, 0x1e5f, 0x1e5e,
    0x1e61, 0x1e60, 0x1e63, 0x1e62, 0x1e65, 0x1e64, 0x1e67, 0x1e66,
    0x1e69, 0x1e68, 0x1e6b, 0x1e6a, 0x1e6d, 0x1e6c, 0x1e6f, 0x1e6e,
    0x1e71, 0x1e70, 0x1e73, 0x1e72, 0x1e75, 0x1e74, 0x1e77, 0x1e76,
    0x1e79, 0x1e78, 0x1e7b, 0x1e7a, 0x1e7d, 0x1e7c, 0x1e7f, 0x1e7e,
    0x1e81, 0x1e80, 0x1e83, 0x1e82, 0x1e85, 0x1e84, 0x1e87, 0x1e86,
    0x1e89, 0x1e88, 0x1e8b, 0x1e8a, 0x1e8d, 0x1e8c, 0x1e8f, 0x1e8e,
    0x1e91, 0x1e90, 0x1e93, 0x1e92, 0x1e95, 0x1e94, 0, 0,
    0, 0, 0, 0x1e60, 0, 0, 0xdf, 0,
    0x1ea1, 0x1ea0, 0x1ea3, 0x1ea2, 0x1ea5, 0x1ea4, 0x1ea7, 0x1ea6,
    0x1ea9, 0x1ea8, 0x1eab, 0x1eaa, 0x1ead, 0x1eac, 0x1eaf, 0x1eae,
    0x1eb1, 0x1eb0, 0x1eb3, 0x1eb2, 0x1eb5, 0x1eb4, 0x1eb7, 0x1eb6,
    0x1eb9, 0x1eb8, 0x1ebb, 0x1eba, 0x1ebd, 0x1ebc, 0x1ebf, 0x1ebe,
    0x1ec1, 0x1ec0, 0x1ec3, 0x1ec2, 0x1ec5, 0x1ec4, 0x1ec7, 0x1ec6,
    0x1ec9, 0x1ec8, 0x1ecb, 0x1eca, 0x1ecd, 0x1ecc, 0x1ecf, 0x1ece,
    0x1ed1, 0x1ed0, 0x1ed3, 0x1ed2, 0x1ed5, 0x1ed4, 0x1ed7, 0x1ed6,
    0x1ed9, 0x1ed8, 0x1edb, 0x1eda, 0x1edd, 0x1edc, 0x1edf, 0x1ede,
    0x1ee1, 0x1ee0, 0x1ee3, 0x1ee2, 0x1ee5, 0x1ee4, 0x1ee7, 0x1ee6,
    0x1ee9, 0x1ee8, 0x1eeb, 0x1eea, 0x1eed, 0x1eec, 0x1eef, 0x1eee,
    0x1ef1, 0x1ef0, 0x1ef3, 0x1ef2, 0x1ef5, 0x1ef4, 0x1ef7, 0x1ef6,
    0x1ef9, 0x1ef8, 0, 0, 0, 0, 0, 0,

    0x1f08, 0x1f09, 0x1f0a, 0x1f0b, 0x1f0c, 0x1f0d, 0x1f0e, 0x1f0f,
    0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07,
    0x1f18, 0x1f19, 0x1f1a, 0x1f1b, 0x1f1c, 0x1f1d, 0, 0,
    0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0, 0,
    0x1f28, 0x1f29, 0x1f2a, 0x1f2b, 0x1f2c, 0x1f2d, 0x1f2e, 0x1f2f,
    0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27,
    0x1f38, 0x1f39, 0x1f3a, 0x1f3b, 0x1f3c, 0x1f3d, 0x1f3e, 0x1f3f,
    0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37,
    0x1f48, 0x1f49, 0x1f4a, 0x1f4b, 0x1f4c, 0x1f4d, 0, 0,
    0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0, 0,
    0, 0x1f59, 0, 0x1f5b, 0, 0x1f5d, 0, 0x1f5f,
    0, 0x1f51, 0, 0x1f53, 0, 0x1f55, 0, 0x1f57,
    0x1f68, 0x1f69, 0x1f6a, 0x1f6b, 0x1f6c, 0x1f6d, 0x1f6e, 0x1f6f,
    0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67,
    0x1fba, 0x1fbb, 0x1fc8, 0x1fc9, 0x1fca, 0x1fcb, 0x1fda, 0x1fdb,
    0x1ff8, 0x1ff9, 0x1fea, 0x1feb, 0x1ffa, 0x1ffb, 0, 0,
    0x1f88, 0x1f89, 0x1f8a, 0x1f8b, 0x1f8c, 0x1f8d, 0x1f8e, 0x1f8f,
    0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87,
    0x1f98, 0x1f99, 0x1f9a, 0x1f9b, 0x1f9c, 0x1f9d, 0x1f9e, 0x1f9f,
    0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97,
    0x1fa8, 0x1fa9, 0x1faa, 0x1fab, 0x1fac, 0x1fad, 0x1fae, 0x1faf,
    0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7,
    0x1fb8, 0x1fb9, 0, 0x1fbc, 0, 0, 0, 0,
    0x1fb0, 0x1fb1, 0x1f70, 0x1f71, 0x1fb3, 0, 0x399, 0,
    0, 0, 0, 0x1fcc, 0, 0, 0, 0,
    0x1f72, 0x1f73, 0x1f74, 0x1f75, 0x1fc3, 0, 0, 0,
    0x1fd8, 0x1fd9, 0, 0, 0, 0, 0, 0,
    0x1fd0, 0x1fd1, 0x1f76, 0x1f77, 0, 0, 0, 0,
    0x1fe8, 0x1fe9, 0, 0, 0, 0x1fec, 0, 0,
    0x1fe0, 0x1fe1, 0x1f7a, 0x1f7b, 0x1fe5, 0, 0, 0,
    0, 0, 0, 0x1ffc, 0, 0, 0, 0,
    0x1f78, 0x1f79, 0x1f7c, 0x1f7d, 0x1ff3, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x3c9, 0,
    0, 0, 0x6b, 0xe5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
    0x2178, 0x2179, 0x217a, 0x217b, 0x217c, 0x217d, 0x217e, 0x217f,
    0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167,
    0x2168, 0x2169, 0x216a, 0x216b, 0x216c, 0x216d, 0x216e, 0x216f,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x24d0, 0x24d1,
    0x24d2, 0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 0x24d9,
    0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1,
    0x24e2, 0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9,
    0x24b6, 0x24b7, 0x24b8, 0x24b9, 0x24ba, 0x24bb, 0x24bc, 0x24bd,
    0x24be, 0x24bf, 0x24c0, 0x24c1, 0x24c2, 0x24c3, 0x24c4, 0x24c5,
    0x24c6, 0x24c7, 0x24c8, 0x24c9, 0x24ca, 0x24cb, 0x24cc, 0x24cd,
    0x24ce, 0x24cf, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
    0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
    0xff58, 0xff59, 0xff5a, 0, 0, 0, 0, 0,
    0, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27,
    0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f,
    0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37,
    0xff38, 0xff39, 0xff3a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};
// 36602 bytes

const TQ_INT8 TQUnicodeTables::decimal_info[] = {
    1, 0, 0, 0, 0, 0, 2, 0,
    0, 3, 3, 4, 3, 5, 6, 7,
    8, 0, 0, 9, 0, 0, 0, 10,
    11, 0, 0, 0, 0, 0, 0, 0,
    12, 0, 0, 0, 13, 0, 0, 14,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 11,


    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 2, 3, -1, -1, -1, -1,
    -1, 1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, -1, -1, -1, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 1, 2, 3,
    4, 5, 6, 7, 8, 9, -1, -1,

    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 1, 2,
    3, 4, 5, 6, 7, 8, 9, -1,
    1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};
// 40698 bytes

#endif

#ifdef TQT_NO_UNICODETABLES

const TQ_UINT8 TQUnicodeTables::latin1_line_break_info[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 15, 23, 19, 21, 22, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    26, 5, 2, 11, 8, 9, 11, 2,
    0, 1, 11, 8, 7, 14, 7, 6,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 7, 7, 11, 11, 11, 5,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 0, 8, 1, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 0, 15, 1, 11, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    3, 11, 9, 8, 8, 8, 11, 11,
    11, 11, 11, 2, 11, 15, 11, 11,
    9, 8, 11, 11, 16, 11, 11, 11,
    11, 11, 11, 2, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
};

#else

const TQ_UINT8 TQUnicodeTables::line_break_info[] = {
    1, 2, 3, 4, 5, 6, 7, 8,
    2, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 2, 18, 2, 2, 19, 20,
    21, 2, 2, 2, 2, 2, 2, 2,
    22, 23, 24, 25, 2, 2, 2, 26,
    2, 27, 2, 2, 2, 2, 28, 29,
    30, 31, 32, 33, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 35, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 36,
    34, 34, 34, 34, 37, 2, 2, 2,
    2, 2, 2, 2, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 38,
    39, 39, 39, 39, 39, 39, 39, 39,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 34, 40, 41, 2, 42, 43, 44,


    19, 19, 19, 19, 19, 19, 19, 19,
    19, 15, 23, 19, 21, 22, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    26, 5, 2, 11, 8, 9, 11, 2,
    0, 1, 11, 8, 7, 14, 7, 6,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 7, 7, 11, 11, 11, 5,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 0, 8, 1, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 0, 15, 1, 11, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    3, 11, 9, 8, 8, 8, 11, 11,
    11, 11, 11, 2, 11, 15, 11, 11,
    9, 8, 11, 11, 16, 11, 11, 11,
    11, 11, 11, 2, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    16, 11, 11, 11, 16, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 19, 19, 19, 19, 11,
    19, 19, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 7, 15, 11, 11, 11, 11, 11,
    11, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 11, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 11, 19, 19, 19, 11, 19,
    11, 19, 19, 11, 19, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,
    19, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 11, 11, 19,
    19, 11, 19, 19, 19, 19, 11, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 19,
    11, 19, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 19, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 19, 11, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 11, 11,
    11, 19, 19, 19, 19, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 19, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 19, 11, 19, 19,
    19, 19, 19, 19, 19, 11, 11, 19,
    19, 11, 11, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 8, 8, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 19, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 19, 11, 19, 19,
    19, 19, 19, 11, 11, 11, 11, 19,
    19, 11, 11, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    19, 19, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 19, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 19, 11, 19, 19,
    19, 19, 19, 19, 19, 19, 11, 19,
    19, 19, 11, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 19, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 19, 11, 19, 19,
    19, 19, 19, 19, 11, 11, 11, 19,
    19, 11, 11, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    19, 19, 19, 11, 11, 11, 19, 19,
    19, 11, 19, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 19, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    19, 19, 19, 19, 19, 11, 19, 19,
    19, 11, 19, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 19, 19, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    19, 19, 19, 19, 19, 11, 19, 19,
    19, 11, 19, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 19, 19, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 19,
    19, 19, 19, 19, 11, 11, 19, 19,
    19, 11, 19, 19, 19, 19, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 11, 11, 11, 11, 19,
    19, 19, 19, 19, 19, 11, 19, 11,
    19, 19, 19, 19, 19, 19, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 19, 20, 20, 19, 19, 19, 19,
    19, 19, 19, 11, 11, 11, 11, 8,
    20, 20, 20, 20, 20, 20, 20, 19,
    19, 19, 19, 19, 19, 19, 19, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 4, 4, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 20, 20, 11, 20, 11, 11, 20,
    20, 11, 20, 11, 11, 20, 11, 11,
    11, 11, 11, 11, 20, 20, 20, 20,
    11, 20, 20, 20, 20, 20, 20, 20,
    11, 20, 20, 20, 11, 20, 11, 20,
    11, 11, 20, 20, 11, 20, 20, 20,
    20, 19, 20, 20, 19, 19, 19, 19,
    19, 19, 11, 19, 19, 20, 11, 11,
    20, 20, 20, 20, 20, 11, 20, 11,
    19, 19, 19, 19, 19, 19, 11, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 20, 20, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 15, 3, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    19, 19, 11, 11, 11, 11, 11, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 19, 11, 19,
    11, 19, 0, 1, 0, 1, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 11, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    19, 19, 19, 19, 19, 19, 19, 19,
    11, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 11, 20, 20, 20, 20, 20,
    11, 20, 20, 11, 19, 19, 19, 19,
    19, 19, 19, 11, 11, 11, 19, 19,
    19, 19, 11, 11, 11, 11, 11, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,
    20, 20, 20, 20, 20, 20, 19, 19,
    19, 19, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 11, 11, 11, 11, 11, 12,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 11, 11, 11, 11, 11,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 15, 11, 11, 11, 11, 11, 11,
    11, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    15, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 0, 1, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 19, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 19, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 4, 15, 4, 4,
    4, 4, 4, 8, 11, 11, 11, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 16, 11,
    11, 11, 11, 19, 19, 19, 19, 11,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 19, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    15, 15, 15, 15, 15, 15, 15, 3,
    15, 15, 15, 18, 19, 19, 19, 19,
    15, 3, 15, 15, 17, 11, 11, 11,
    2, 2, 0, 2, 2, 2, 0, 2,
    11, 11, 11, 11, 13, 13, 13, 15,
    21, 21, 19, 19, 19, 19, 19, 3,
    9, 9, 9, 9, 9, 9, 9, 9,
    11, 2, 2, 11, 4, 11, 11, 11,
    11, 11, 11, 11, 4, 0, 1, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 15,
    3, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 19, 19, 19, 19, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 0, 1, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 0, 1, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    8, 8, 8, 8, 8, 8, 8, 9,
    8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 9, 11, 11, 11, 11,
    11, 9, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 8, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 9, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 8, 8, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 0, 1, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 0, 1, 2, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 2, 2, 2, 2, 11,
    11, 11, 5, 5, 11, 11, 11, 11,
    0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 0, 1,
    0, 1, 0, 1, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 0, 1, 0, 1, 0,
    1, 0, 1, 0, 1, 0, 1, 0,
    1, 0, 1, 0, 1, 0, 1, 0,
    1, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    0, 1, 0, 1, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 0, 1, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 11, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 11,

    12, 1, 1, 12, 12, 4, 12, 12,
    0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 12, 12, 0, 1, 0, 1,
    0, 1, 0, 1, 4, 0, 1, 1,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 19, 19, 19, 19, 19, 19,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 4, 4, 12, 12, 12,
    11, 4, 12, 4, 12, 4, 12, 4,
    12, 4, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 4, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 4, 12, 4, 12, 4,
    12, 12, 12, 12, 12, 12, 4, 12,
    12, 12, 12, 12, 12, 4, 4, 11,
    11, 19, 19, 4, 4, 4, 4, 12,
    4, 4, 12, 4, 12, 4, 12, 4,
    12, 4, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 4, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 4, 12, 4, 12, 4,
    12, 12, 12, 12, 12, 12, 4, 12,
    12, 12, 12, 12, 12, 4, 4, 12,
    12, 12, 12, 4, 12, 4, 12, 12,

    11, 11, 11, 11, 11, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 11, 11, 11,
    11, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 11,
    11, 11, 11, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24,

    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 19, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,

    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 0, 1,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 9, 11, 11, 11,

    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    19, 19, 19, 19, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 0, 1, 0,
    1, 0, 1, 0, 1, 0, 1, 0,
    1, 0, 1, 0, 1, 12, 12, 11,
    11, 12, 12, 12, 12, 12, 12, 12,
    1, 12, 1, 11, 4, 4, 5, 5,
    12, 0, 1, 0, 1, 0, 1, 12,
    12, 12, 12, 12, 12, 12, 12, 11,
    12, 8, 9, 12, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 3,

    11, 5, 12, 12, 8, 9, 12, 12,
    0, 1, 12, 12, 1, 12, 1, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 4, 4, 12, 12, 12, 5,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 0, 12, 1, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 0, 12, 1, 12, 0,
    1, 1, 0, 1, 1, 4, 11, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 4, 4,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    9, 8, 12, 12, 12, 8, 8, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11,
    11, 19, 19, 19, 25, 11, 11, 11,
};
// 52474 bytes

#endif

// END OF GENERATED DATA



#ifndef TQT_NO_UNICODETABLES
const TQ_UINT16 TQUnicodeTables::symmetricPairs[] = {
    0x0028, 0x0029, 0x003C, 0x003E, 0x005B, 0x005D, 0x007B, 0x007D,
    0x00AB, 0x00BB, 0x2039, 0x203A, 0x2045, 0x2046, 0x207D, 0x207E,
    0x208D, 0x208E, 0x2208, 0x220B, 0x2209, 0x220C, 0x220A, 0x220D,
    0x2215, 0x29F5, 0x223C, 0x223D, 0x2243, 0x22CD, 0x2252, 0x2253,
    0x2254, 0x2255, 0x2264, 0x2265, 0x2266, 0x2267, 0x2268, 0x2269,
    0x226A, 0x226B, 0x226E, 0x226F, 0x2270, 0x2271, 0x2272, 0x2273,
    0x2274, 0x2275, 0x2276, 0x2277, 0x2278, 0x2279, 0x227A, 0x227B,
    0x227C, 0x227D, 0x227E, 0x227F, 0x2280, 0x2281, 0x2282, 0x2283,
    0x2284, 0x2285, 0x2286, 0x2287, 0x2288, 0x2289, 0x228A, 0x228B,
    0x228F, 0x2290, 0x2291, 0x2292, 0x2298, 0x29B8, 0x22A2, 0x22A3,
    0x22A6, 0x2ADE, 0x22A8, 0x2AE4, 0x22A9, 0x2AE3, 0x22AB, 0x2AE5,
    0x22B0, 0x22B1, 0x22B2, 0x22B3, 0x22B4, 0x22B5, 0x22B6, 0x22B7,
    0x22C9, 0x22CA, 0x22CB, 0x22CC, 0x22D0, 0x22D1, 0x22D6, 0x22D7,
    0x22D8, 0x22D9, 0x22DA, 0x22DB, 0x22DC, 0x22DD, 0x22DE, 0x22DF,
    0x22E0, 0x22E1, 0x22E2, 0x22E3, 0x22E4, 0x22E5, 0x22E6, 0x22E7,
    0x22E8, 0x22E9, 0x22EA, 0x22EB, 0x22EC, 0x22ED, 0x22F0, 0x22F1,
    0x22F2, 0x22FA, 0x22F3, 0x22FB, 0x22F4, 0x22FC, 0x22F6, 0x22FD,
    0x22F7, 0x22FE, 0x2308, 0x2309, 0x230A, 0x230B, 0x2329, 0x232A,
    0x2768, 0x2769, 0x276A, 0x276B, 0x276C, 0x276D, 0x276E, 0x276F,
    0x2770, 0x2771, 0x2772, 0x2773, 0x2774, 0x2775, 0x27D5, 0x27D6,
    0x27DD, 0x27DE, 0x27E2, 0x27E3, 0x27E4, 0x27E5, 0x27E6, 0x27E7,
    0x27E8, 0x27E9, 0x27EA, 0x27EB, 0x2983, 0x2984, 0x2985, 0x2986,
    0x2987, 0x2988, 0x2989, 0x298A, 0x298B, 0x298C, 0x298D, 0x2990,
    0x298E, 0x298F, 0x2991, 0x2992, 0x2993, 0x2994, 0x2995, 0x2996,
    0x2997, 0x2998, 0x29C0, 0x29C1, 0x29C4, 0x29C5, 0x29CF, 0x29D0,
    0x29D1, 0x29D2, 0x29D4, 0x29D5, 0x29D8, 0x29D9, 0x29DA, 0x29DB,
    0x29F8, 0x29F9, 0x29FC, 0x29FD, 0x2A2B, 0x2A2C, 0x2A34, 0x2A35,
    0x2A3C, 0x2A3D, 0x2A64, 0x2A65, 0x2A79, 0x2A7A, 0x2A7D, 0x2A7E,
    0x2A7F, 0x2A80, 0x2A81, 0x2A82, 0x2A83, 0x2A84, 0x2A8B, 0x2A8C,
    0x2A91, 0x2A92, 0x2A93, 0x2A94, 0x2A95, 0x2A96, 0x2A97, 0x2A98,
    0x2A99, 0x2A9A, 0x2A9B, 0x2A9C, 0x2AA1, 0x2AA2, 0x2AA6, 0x2AA7,
    0x2AA8, 0x2AA9, 0x2AAA, 0x2AAB, 0x2AAC, 0x2AAD, 0x2AAF, 0x2AB0,
    0x2AB3, 0x2AB4, 0x2ABB, 0x2ABC, 0x2ABD, 0x2ABE, 0x2ABF, 0x2AC0,
    0x2AC1, 0x2AC2, 0x2AC3, 0x2AC4, 0x2AC5, 0x2AC6, 0x2ACD, 0x2ACE,
    0x2ACF, 0x2AD0, 0x2AD1, 0x2AD2, 0x2AD3, 0x2AD4, 0x2AD5, 0x2AD6,
    0x2AEC, 0x2AED, 0x2AF7, 0x2AF8, 0x2AF9, 0x2AFA, 0x3008, 0x3009,
    0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 0x300F, 0x3010, 0x3011,
    0x3014, 0x3015, 0x3016, 0x3017, 0x3018, 0x3019, 0x301A, 0x301B,
    0xFF08, 0xFF09, 0xFF1C, 0xFF1E, 0xFF3B, 0xFF3D, 0xFF5B, 0xFF5D,
    0xFF5F, 0xFF60, 0xFF62, 0xFF63,
};

// ### shouldn't this be const?
const int TQUnicodeTables::symmetricPairsSize =
   sizeof(symmetricPairs)/sizeof(symmetricPairs[0]);

#else

/*
  only include info for the first unicode range (latin1) when building
  without unicode tables.
*/
const TQ_UINT8 TQUnicodeTables::unicode_info[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 28, 28, 28, 28, 30, 30,
    29, 30, 16, 24, 27, 21, 30, 29,
    30, 27, 6, 6, 29, 16, 30, 26,
    29, 6, 16, 25, 6, 6, 6, 26,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 27,
    15, 15, 15, 15, 15, 15, 15, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 27,
    16, 16, 16, 16, 16, 16, 16, 16
};

#endif

/*
 * ----------------------------------------------------------------------
 * End of unicode tables
 * ----------------------------------------------------------------------
 */

enum Script {
    // European Alphabetic Scripts
    Latin,
    Greek,
    Cyrillic,
    Armenian,
    Georgian,
    Runic,
    Ogham,
    SpacingModifiers,
    CombiningMarks,

    // Middle Eastern Scripts
    Hebrew,
    Arabic,
    Syriac,
    Thaana,

    // South and Southeast Asian Scripts
    Devanagari,
    Bengali,
    Gurmukhi,
    Gujarati,
    Oriya,
    Tamil,
    Telugu,
    Kannada,
    Malayalam,
    Sinhala,
    Thai,
    Lao,
    Tibetan,
    Myanmar,
    Khmer,

    // East Asian Scripts
    Han,
    Hiragana,
    Katakana,
    Hangul,
    Bopomofo,
    Yi,

    // Additional Scripts
    Ethiopic,
    Cherokee,
    CanadianAboriginal,
    Mongolian,

    // Symbols
    CurrencySymbols,
    LetterlikeSymbols,
    NumberForms,
    MathematicalOperators,
    TechnicalSymbols,
    GeometricSymbols,
    MiscellaneousSymbols,
    EnclosedAndSquare,
    Braille,

    Unicode,

    // some scripts added in Unicode 3.2
    Tagalog,
    Hanunoo,
    Buhid,
    Tagbanwa,

    KatakanaHalfWidth,		// from JIS X 0201

    // from Unicode 4.0
    Limbu,
    TaiLe,

    // End
    NScripts,
    UnknownScript = NScripts
};

// copied form tqfont.h, as we can't include it in tools. Do not modify without
// changing the script enum in tqfont.h aswell.
const unsigned char TQUnicodeTables::otherScripts [128] = {
#define SCRIPTS_02 0
    0xaf, Latin, 0xff, SpacingModifiers, 			// row 0x02, index 0
#define SCRIPTS_03 4
    0x6f, CombiningMarks, 0xff, Greek, 			// row 0x03, index 4
#define SCRIPTS_05 8
    0x2f, Cyrillic, 0x8f, Armenian, 0xff, Hebrew,	// row 0x05, index 8
#define SCRIPTS_07 14
    0x4f, Syriac, 0x7f, Unicode, 0xbf, Thaana,
    0xff, Unicode, 						// row 0x07, index 14
#define SCRIPTS_10 22
    0x9f, Myanmar, 0xff, Georgian,			// row 0x10, index 20
#define SCRIPTS_13 26
    0x7f, Ethiopic, 0x9f, Unicode, 0xff, Cherokee,	// row 0x13, index 24
#define SCRIPTS_16 32
    0x7f, CanadianAboriginal, 0x9f, Ogham,
    0xff, Runic, 						// row 0x16 index 30
#define SCRIPTS_17 38
    0x1f, Tagalog, 0x3f, Hanunoo, 0x5f, Buhid,
    0x7f, Tagbanwa, 0xff, Khmer,				// row 0x17, index 36
#define SCRIPTS_18 48
    0xaf, Mongolian, 0xff, Unicode,		       	// row 0x18, index 46
#define SCRIPTS_19 52
    0x4f, Limbu, 0x7f, TaiLe, 0xdf, Unicode, 0xff, Khmer,
#define SCRIPTS_20 60
    0x0a, Unicode, 0x0d, UnknownScript, 0x6f, Unicode, 0x9f, NumberForms,
    0xab, CurrencySymbols, 0xac, Latin,
    0xcf, CurrencySymbols, 0xff, CombiningMarks,		// row 0x20, index 50
#define SCRIPTS_21 76
    0x4f, LetterlikeSymbols, 0x8f, NumberForms,
    0xff, MathematicalOperators,					// row 0x21, index 62
#define SCRIPTS_24 82
    0x5f, TechnicalSymbols, 0xff, EnclosedAndSquare,	// row 0x24, index 68
#define SCRIPTS_2e 86
    0x7f, Unicode, 0xff, Han,				// row 0x2e, index 72
#define SCRIPTS_30 90
    0x3f, Han, 0x9f, Hiragana, 0xff, Katakana,	// row 0x30, index 76
#define SCRIPTS_31 96
    0x2f, Bopomofo, 0x8f, Hangul, 0x9f, Han,
    0xff, Unicode,						// row 0x31, index 82
#define SCRIPTS_fb 104
    0x06, Latin, 0x1c, Unicode, 0x4f, Hebrew,
    0xff, Arabic,						// row 0xfb, index 90
#define SCRIPTS_fe 112
    0x1f, Unicode, 0x2f, CombiningMarks, 0x6f, Han,
    0xff, Arabic,						// row 0xfe, index 98
#define SCRIPTS_ff 120
    0x60, Han,        		// row 0xff, index 106
    0x9f, KatakanaHalfWidth, 0xef, Han, 0xff, Unicode
};

// (uc-0x0900)>>7
const unsigned char TQUnicodeTables::indicScripts [] =
{
    Devanagari, Bengali,
    Gurmukhi, Gujarati,
    Oriya, Tamil,
    Telugu, Kannada,
    Malayalam, Sinhala,
    Thai, Lao
};


// 0x80 + x: x is the offset into the otherScripts table
const unsigned char TQUnicodeTables::scriptTable[256] =
{
    Latin, Latin, 0x80+SCRIPTS_02, 0x80+SCRIPTS_03,
    Cyrillic, 0x80+SCRIPTS_05, Arabic, 0x80+SCRIPTS_07,
    Unicode, SCRIPTS_INDIC, SCRIPTS_INDIC, SCRIPTS_INDIC,
    SCRIPTS_INDIC, SCRIPTS_INDIC, SCRIPTS_INDIC, Tibetan,

    0x80+SCRIPTS_10, Hangul, Ethiopic, 0x80+SCRIPTS_13,
    CanadianAboriginal, CanadianAboriginal, 0x80+SCRIPTS_16, 0x80+SCRIPTS_17,
    0x80+SCRIPTS_18, 0x80+SCRIPTS_19, Unicode, Unicode,
    Unicode, Unicode, Latin, Greek,

    0x80+SCRIPTS_20, 0x80+SCRIPTS_21, MathematicalOperators, TechnicalSymbols,
    0x80+SCRIPTS_24, GeometricSymbols, MiscellaneousSymbols, MiscellaneousSymbols,
    Braille, Unicode, Unicode, Unicode,
    Unicode, Unicode, 0x80+SCRIPTS_2e, Han,

    0x80+SCRIPTS_30, 0x80+SCRIPTS_31, EnclosedAndSquare, EnclosedAndSquare,
    Han, Han, Han, Han,
    Han, Han, Han, Han,
    Han, Han, Han, Han,

    Han, Han, Han, Han, Han, Han, Han, Han,
    Han, Han, Han, Han, Han, Han, Han, Han,

    Han, Han, Han, Han, Han, Han, Han, Han,
    Han, Han, Han, Han, Han, Han, Han, Han,

    Han, Han, Han, Han, Han, Han, Han, Han,
    Han, Han, Han, Han, Han, Han, Han, Han,

    Han, Han, Han, Han, Han, Han, Han, Han,
    Han, Han, Han, Han, Han, Han, Han, Han,


    Han, Han, Han, Han, Han, Han, Han, Han,
    Han, Han, Han, Han, Han, Han, Han, Han,

    Han, Han, Han, Han, Han, Han, Han, Han,
    Han, Han, Han, Han, Han, Han, Han, Han,

    Yi, Yi, Yi, Yi, Yi, Unicode, Unicode, Unicode,
    Unicode, Unicode, Unicode, Unicode, Hangul, Hangul, Hangul, Hangul,

    Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul,
    Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul,

    Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul,
    Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul,

    Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul, Hangul,
    Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode,

    Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode,
    Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode,

    Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode, Unicode,
    Unicode, Han, Han, 0x80+SCRIPTS_fb, Arabic, Arabic, 0x80+SCRIPTS_fe, 0x80+SCRIPTS_ff
};

