/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "fieldcompletion.h"
#include "field.h"

using Tellico::FieldCompletion;

FieldCompletion::FieldCompletion(bool multiple_) : TDECompletion(), m_multiple(multiple_) {
}

TQString FieldCompletion::makeCompletion(const TQString& string_) {
  if(completionMode() == TDEGlobalSettings::CompletionNone) {
    m_beginText.truncate(0);
    return TQString();
  }

  if(!m_multiple) {
    return TDECompletion::makeCompletion(string_);
  }

  static TQRegExp rx = Data::Field::delimiter();
  int pos = rx.searchRev(string_);
  if(pos == -1) {
    m_beginText.truncate(0);
    return TDECompletion::makeCompletion(string_);
  }

  pos += rx.matchedLength();
  TQString final = string_.mid(pos);
  m_beginText = string_.mid(0, pos);
  return m_beginText + TDECompletion::makeCompletion(final);
}

void FieldCompletion::clear() {
  m_beginText.truncate(0);
  TDECompletion::clear();
}

void FieldCompletion::postProcessMatch(TQString* match_) const {
  if(m_multiple) {
    match_->prepend(m_beginText);
  }
}

void FieldCompletion::postProcessMatches(TQStringList* matches_) const {
  if(m_multiple) {
    for(TQStringList::Iterator it = matches_->begin(); it != matches_->end(); ++it) {
      (*it).prepend(m_beginText);
    }
  }
}

void FieldCompletion::postProcessMatches(TDECompletionMatches* matches_) const {
  if(m_multiple) {
    for(TDECompletionMatches::Iterator it = matches_->begin(); it != matches_->end(); ++it) {
      (*it).value().prepend(m_beginText);
    }
  }
}


#include "fieldcompletion.moc"
