/***************************************************************************
                    expression.h - Expression parser
                             -------------------
    copyright          : (C) 2004      Michal Rudolf <mrudolf@kdewebdwev.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HAVE_EXPRESSION_H_
#define _HAVE_EXPRESSION_H_

#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqvariant.h>

class Expression
{
public:
  Expression();
  Expression(const TQString& expr);
  /* set string to parse */
  Expression& operator=(const TQString& s);
  /* calculate value */
  TQVariant value(bool* valid = 0);
  /* equivalent of setString(s) and value(valid) */
  TQVariant value(const TQString& s, bool* valid = 0);
  /* equivalent of setString(s) and checking if value(valid) is true */
  bool isTrue(const TQString& s, bool* valid = 0);
private:
  enum Type {TypeInt, TypeDouble, TypeString};
  /* parsing function - top-down approach */
  /* parse terminal (number or string) */
  TQVariant parseNumber();
  /* parse -x expression */
  TQVariant parseMinus();
  /* parse (x) expression */
  TQVariant parseBracket();
  /* parse x*y, x/y and x%y expressions */
  TQVariant parseMultiply();
  /* parse x+y and x-y expressions */
  TQVariant parseAdd();
  /* parse !x and (equivalent) not x expressions */
  TQVariant parseNot();
  /* parse x==y, x<=y, x>=y, x<y and x>y expressions */
  TQVariant parseComparison();
  /* parse x && y, (equivalent) x and y expressions */
  TQVariant parseAnd();
  /* parse x || y and  (equivalent) x or y expressions */
  TQVariant parseOr();
  /* starting point of parsing - just call first function above */
  TQVariant parse();

  /* check if we still have next argument */
  bool validate();
  /* return next argument to parse or null if there is none */
  TQString next() const;
  /* set error position for future error reporting */
  void setError(int pos = -1);
  /* compare various types of TQVariant (strings, floats, ints */
  int compare(const TQVariant v1, const TQVariant v2) const; 
  /* return common type for binary operations */
  Type commonType(const TQVariant v1, const TQVariant v2) const; 

  TQValueList<TQVariant> m_parts;
  uint m_start;
  bool m_error;
  uint m_errorPosition;

};

#endif

