/***************************************************************************
 *   Copyright (C) 1999, 2000 by Bernd Gehrmann                            *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqtextedit.h>
#include <tqpushbutton.h>

#include <tdeapplication.h>
#include <kbuttonbox.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <klineedit.h>

#include "commitdlg.h"

///////////////////////////////////////////////////////////////////////////////
// class CommitDialog
///////////////////////////////////////////////////////////////////////////////


CommitDialog::CommitDialog( const TQString &changeLogfileNamePath,  TQWidget *parent )
    : CommitDialogBase( parent, "commitdialog", true )
{
    connect( buttonOk, TQ_SIGNAL(clicked()), TQ_SLOT(accept()) );
    connect( buttonCancel, TQ_SIGNAL(clicked()), TQ_SLOT(reject()) );

    setChangeLogFileName( changeLogfileNamePath );
}

///////////////////////////////////////////////////////////////////////////////

TQStringList CommitDialog::logMessage() const
{
    TQStringList textLines;
    for (int i=0; i<textEdit->paragraphs(); ++i)
    {
        textLines << textEdit->text( i );
    }
    return textLines;
}

///////////////////////////////////////////////////////////////////////////////

bool CommitDialog::mustAddToChangeLog() const
{
    return checkAddToChangelog->isChecked();
}

///////////////////////////////////////////////////////////////////////////////

void CommitDialog::accept()
{
    if (textEdit->text().isNull() || textEdit->text().isEmpty()) {
        int s = KMessageBox::warningContinueCancel( this,
            i18n("You are committing your changes without any comment. This is not a good practice. Continue anyway?"),
            i18n("CVS Commit Warning"),
            KStdGuiItem::cont(),
            i18n("askWhenCommittingEmptyLogs") );
        if ( s != KMessageBox::Continue ) {
            return;
        }
    }
    TQDialog::accept();
}

///////////////////////////////////////////////////////////////////////////////

void CommitDialog::setChangeLogFileName( const TQString &fileName )
{
    changeLogNameEdit->setText( fileName );
}

///////////////////////////////////////////////////////////////////////////////

TQString CommitDialog::changeLogFileName() const
{
    return changeLogNameEdit->text();
}

#include "commitdlg.moc"
