/***************************************************************************
 *   Copyright (C) 1999-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _MAKEVIEWPART_H_
#define _MAKEVIEWPART_H_

#include <tqguardedptr.h>

#include "kdevmakefrontend.h"
#include "KDevMakeFrontendIface.h"


class MakeWidget;

class MakeViewPart : public KDevMakeFrontend
{
    TQ_OBJECT
  

public:
    MakeViewPart( TQObject *parent, const char *name, const TQStringList & );
    ~MakeViewPart();
    virtual TQWidget* widget();
    virtual void updateSettingsFromConfig();

private slots:
    void slotStopButtonClicked(KDevPlugin*);
    
protected:
    virtual void queueCommand(const TQString &dir, const TQString &command);
    virtual bool isRunning();

private:
    TQGuardedPtr<MakeWidget> m_widget;
    KDevMakeFrontendIface *m_dcop;
    friend class MakeWidget;
};

#endif
