/***************************************************************************
                          perlparser.h  -  description
                             -------------------
    begin                : Sun Nov 2 2003
    copyright            : (C) 2003 by luc
    email                : luc@lieve
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PERLPARSER_H
#define PERLPARSER_H

#include "kdevlanguagesupport.h"
#include <codemodel.h>


/**perl source to classview parser
  *@author luc
  */

class perlparser {
  public: 
  perlparser(KDevCore* core,CodeModel* model, TQString interpreter);
  perlparser();
  ~perlparser();

  void initialParse();
  void parse(const TQString &fileName);
  void parseLines(TQStringList* lines,const TQString& fileName);
  const TQStringList UseFiles();
  TQString findLib( const TQString& lib);

  private:
  //global functions to add to ClassStore
  void addPackage(const TQString& fileName ,int lineNr , const TQString& name);
  void addAttributetoScript(const TQString& fileName ,int lineNr ,const TQString& name);
  void addAttributetoPackage(const TQString& fileName ,int lineNr ,const TQString& name);
  void addClass(const TQString& fileName ,int lineNr );
  void addConstructor(const TQString& fileName ,int lineNr ,const TQString& methodname);
  void addGlobalSub(const TQString& fileName ,int lineNr , const TQString& name, bool privatesub);
  void addScriptSub(const TQString& fileName ,int lineNr , const TQString& name, bool privatesub);
  void addClassMethod(const TQString& fileName ,int lineNr , const TQString& name , bool privatesub);
  void addPackageSub(const TQString& fileName ,int lineNr , const TQString& name, bool privatesub);
  void addParentClass(const TQString& parent);
  void addScript(const TQString& fileName ,int lineNr , const TQString& name);
  void addUseLib(const TQString& lib);
  void getPerlINC();

  bool    m_inpackage;
  bool    m_inscript;
  bool    m_inclass;

  TQString m_lastsub;
  TQString m_lastparentclass;
  TQString m_lastattr;
  TQString m_lastpackagename;
  TQString m_lastscriptname;

  NamespaceDom m_lastscript;
  NamespaceDom m_lastpackage;
  ClassDom m_lastclass;

  //CodeModel
  CodeModel* m_model;
  KDevCore* m_core;
  FileDom m_file;

  //this willhav a list of INC paths
  TQStringList m_INClist;
  //this will get a list off all files "use" in the perl files
  //and need additional parsing to include the classes in the classview
  TQStringList m_usefiles;

  TQString m_interpreter;
  
  
};

#endif
