/***************************************************************************
*   Copyright (C) 2004 by Alexander Dymo                                  *
*   adymo@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Library General Public License as       *
*   published by the Free Software Foundation; either version 2 of the    *
*   License, or (at your option) any later version.                       *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU Library General Public     *
*   License along with this program; if not, write to the                 *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/
#include "cppimplementationwidget.h"

#include <tqfileinfo.h>
#include <tqtextstream.h>
#include <tqfile.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <tqdom.h>

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdelistview.h>
#include <klineedit.h>

#include <kdevlanguagesupport.h>
#include <kdevproject.h>
#include <domutil.h>
#include <filetemplate.h>

CppImplementationWidget::CppImplementationWidget( KDevLanguageSupport *part,
        TQWidget *parent, const char *name, bool modal )
		: ImplementationWidget( part, parent, name, modal )
{}

TQStringList CppImplementationWidget::createClassFiles()
{
	TQString template_h = "#ifndef $DEFTEXT$_H\n#define $DEFTEXT$_H\n\n#include \"$BASEINCLUDE$\"\n\nclass $CLASSNAME$: public $BASECLASSNAME$ {\nTQ_OBJECT\n\npublic:\n    $CLASSNAME$(TQWidget *parent = 0, const char *name = 0);\n};\n\n#endif\n";
	TQString template_cpp = "#include \"$CLASSINCLUDE$\"\n\n$CLASSNAME$::$CLASSNAME$(TQWidget *parent, const char *name)\n    :$BASECLASSNAME$(parent, name)\n{\n}\n";
	if ( m_part->project() ->options() == KDevProject::UsesAutotoolsBuildSystem )
		template_cpp += "\n#include \"$MOCINCLUDE$\"\n";

	TQFileInfo formInfo( m_formName );
	template_h.replace( TQRegExp( "\\$BASEINCLUDE\\$" ), formInfo.baseName() + ".h" );
	template_h.replace( TQRegExp( "\\$CLASSNAME\\$" ), classNameEdit->text() );
	template_h.replace( TQRegExp( "\\$BASECLASSNAME\\$" ), m_baseClassName );
	template_h.replace( TQRegExp( "\\$DEFTEXT\\$" ), fileNameEdit->text().upper() );

	template_cpp.replace( TQRegExp( "\\$CLASSINCLUDE\\$" ), fileNameEdit->text() + ".h" );
	template_cpp.replace( TQRegExp( "\\$CLASSNAME\\$" ), classNameEdit->text() );
	template_cpp.replace( TQRegExp( "\\$BASECLASSNAME\\$" ), m_baseClassName );
	template_cpp.replace( TQRegExp( "\\$MOCINCLUDE\\$" ), fileNameEdit->text() + ".moc" );

	template_h = FileTemplate::read( m_part, "h" ) + template_h;
	template_cpp = FileTemplate::read( m_part, "cpp" ) + template_cpp;

	TQString file_h = fileNameEdit->text() + ".h";
	TQString file_cpp = fileNameEdit->text() + ".cpp";
	if ( !m_part->project() ->activeDirectory().isEmpty() )
	{
		file_h = m_part->project() ->activeDirectory() + "/" + file_h;
		file_cpp = m_part->project() ->activeDirectory() + "/" + file_cpp;
	}

	TQFile ifile( TQDir::cleanDirPath( m_part->project() ->projectDirectory() + "/" + file_cpp ) );
	if ( !ifile.open( IO_WriteOnly ) )
	{
		KMessageBox::error( this, i18n( "Cannot write to implementation file" ) );
		return TQStringList();
	}
	TQTextStream istream( &ifile );
	istream << template_cpp;
	ifile.close();

	TQFile hfile( TQDir::cleanDirPath( m_part->project() ->projectDirectory() + "/" + file_h ) );
	if ( !hfile.open( IO_WriteOnly ) )
	{
		KMessageBox::error( this, i18n( "Cannot write to header file" ) );
		return TQStringList();
	}
	TQTextStream hstream( &hfile );
	hstream << template_h;
	hfile.close();

	TQStringList fileList;
	fileList.append( file_h );
	fileList.append( file_cpp );

	return fileList;
}

#include "cppimplementationwidget.moc"
