/**********************************************************************
** Copyright (C) 2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "propertyobject.h"
#include "metadatabase.h"
#include <tqptrvector.h>
#include <tqptrlist.h>
#include <tqmetaobject.h>
#include <tqvariant.h>

PropertyObject::PropertyObject( const TQWidgetList &objs )
    : TQObject(), objects( objs ), mobj( 0 )
{
    TQPtrVector<TQPtrList<TQMetaObject> > v;
    v.resize( objects.count() );
    v.setAutoDelete( true );

    for ( TQObject *o = objects.first(); o; o = objects.next() ) {
	const TQMetaObject *m = o->metaObject();
	TQPtrList<TQMetaObject> *mol = new TQPtrList<TQMetaObject>;
	while ( m ) {
	    mol->insert( 0, m );
	    m = m->superClass();
	}
	v.insert( v.count(), mol );
    }

    int numObjects = objects.count();
    int minDepth = v[0]->count();
    int depth = minDepth;

    for ( int i = 0; i < numObjects; ++i ) {
	depth = (int)v[i]->count();
	if ( depth < minDepth )
	    minDepth = depth;
    }

    const TQMetaObject *m = v[0]->at( --minDepth );
    
    for ( int j = 0; j < numObjects; ++j ) {
	if ( v[j]->at( minDepth ) != m ) {
	    m = v[0]->at( --minDepth );
	    j = 0;
	}
    }

    mobj = m;
    
    Q_ASSERT( mobj );
}

bool PropertyObject::setProperty( const char *name, const TQVariant& value )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() )
	o->setProperty( name, value );

    return true;
}

TQVariant PropertyObject::property( const char *name ) const
{
    return ( (PropertyObject*)this )->objects.first()->property( name );
}

void PropertyObject::mdPropertyChanged( const TQString &property, bool changed )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() )
	MetaDataBase::setPropertyChanged( o, property, changed );
}

bool PropertyObject::mdIsPropertyChanged( const TQString &property )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() ) {
	if ( MetaDataBase::isPropertyChanged( o, property ) )
	    return true;
    }
    return false;
}

void PropertyObject::mdSetPropertyComment( const TQString &property, const TQString &comment )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() )
	MetaDataBase::setPropertyComment( o, property, comment );
}

TQString PropertyObject::mdPropertyComment( const TQString &property )
{
    return MetaDataBase::propertyComment( objects.first(), property );
}

void PropertyObject::mdSetFakeProperty( const TQString &property, const TQVariant &value )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() )
	MetaDataBase::setFakeProperty( o, property, value );
}

TQVariant PropertyObject::mdFakeProperty( const TQString &property )
{
    return MetaDataBase::fakeProperty( objects.first(), property );
}

void PropertyObject::mdSetCursor( const TQCursor &c )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() ) {
	if ( o->isWidgetType() )
	    MetaDataBase::setCursor( (TQWidget*)o, c );
    }
}

TQCursor PropertyObject::mdCursor()
{
    return MetaDataBase::cursor( objects.first() );
}

void PropertyObject::mdSetPixmapKey( int pixmap, const TQString &arg )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() )
	MetaDataBase::setPixmapKey( o, pixmap, arg );
}

TQString PropertyObject::mdPixmapKey( int pixmap )
{
    return MetaDataBase::pixmapKey( objects.first(), pixmap );
}

void PropertyObject::mdSetExportMacro( const TQString &macro )
{
    for ( TQObject *o = objects.first(); o; o = objects.next() )
	MetaDataBase::setExportMacro( o, macro );
}

TQString PropertyObject::mdExportMacro()
{
    return MetaDataBase::exportMacro( objects.first() );
}
