/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _SCRIPTPROJECTPART_H_
#define _SCRIPTPROJECTPART_H_

#include <tqdict.h>
#include <tqguardedptr.h>

#include "kdevbuildtool.h"

class TQListViewItem;
class TQStringList;
class KDialogBase;
class ScriptProjectWidget;

class ScriptProjectPart : public KDevBuildTool
{
    TQ_OBJECT
  

public:
    ScriptProjectPart( TQObject *parent, const char *name, const TQStringList &args );
    ~ScriptProjectPart();
    TQStringList distFiles() const;

protected:
    virtual void openProject(const TQString &dirName, const TQString &projectName);
    virtual void closeProject();

    virtual TQString projectDirectory() const;
    virtual TQString projectName() const;
    virtual TQString mainProgram() const;
    virtual TQString activeDirectory() const;
    virtual TQStringList allFiles() const;
    virtual void addFile(const TQString &fileName);
	virtual void addFiles ( const TQStringList& fileList );
    virtual void removeFile(const TQString &fileName);
    virtual void removeFiles ( const TQStringList& fileList );
    virtual TQString buildDirectory() const;
    virtual TQString runDirectory() const;
    virtual TQString debugArguments() const;
    virtual TQString runArguments() const;
    virtual DomUtil::PairList runEnvironmentVars() const;

    bool canAddToProject(const TQString &path);
    bool canAddDirectoryToProject(const TQString &path);

private slots:
    void projectConfigWidget(KDialogBase *dlg);
    void slotNewFile();
    void rescan();

private:
    TQString m_projectDirectory;
    TQString m_projectName;
    TQStringList m_sourceFiles;

    friend class ScriptNewFileDialog;
};

#endif
