/* This file is part of the KDE project
   Copyright (C) 2007 Jens Dagerbo <jens.dagerbo@swipnet.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <unistd.h>
#include <tdelistview.h>
#include <tqstringlist.h>

#include "environmentdisplaydialog.h"

#if !defined(__OpenBSD__) && !defined(__FreeBSD__)
extern char **environ;
#endif

EnvironmentDisplayDialog::EnvironmentDisplayDialog(TQWidget* parent, const char* name, bool modal, WFlags fl)
: EnvironmentDisplayDialogBase(parent,name, modal,fl)
{
	TQStringList environment;
#if !defined(__OpenBSD__) && !defined(__FreeBSD__)
	char ** e = ::environ;
	
	while ( *e ) 
	{
		environment << *e;
		e++;
	}
#endif

	TQStringList::ConstIterator it = environment.begin();
	while( it !=environment.end() )
	{
		TQStringList pair = TQStringList::split( TQChar('='), *it );
		if ( pair.count() == 2 )
		{
			new TQListViewItem( environmentListView, pair.first(), pair.last() );
		}
		++it;
	}
}


#include "environmentdisplaydialog.moc"

