/***************************************************************************
                          configurationclasses.h  -  description
                             -------------------
    begin                : Sat Apr 17 2004
    copyright            : (C) 2004 Emiliano Gulmini
    email                : <emi_barbarossa@yahoo.it>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CONFIGURATIONCLASSES_H
#define CONFIGURATIONCLASSES_H

// QT
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqdatetime.h>
#include <tqmap.h>
#include <tqregexp.h>

typedef TQMap<TQString,TQString> KeyValueMap;
// entry strings in the tdefilereplacerc file
const TQString rcSearchStringsList = "Search strings list";
const TQString rcReplaceStringsList = "Replace strings list";
const TQString rcDirectoriesList = "Directories list";
const TQString rcFiltersList = "Filters list";
const TQString rcAllStringsMustBeFound = "All strings must be found";
const TQString rcEncoding = "Encoding";
const TQString rcCaseSensitive = "Case sensitive";
const TQString rcConfirmStrings = "Confirm strings";
const TQString rcConfirmFiles = "Confirm files";
const TQString rcConfirmDirs = "Confirm directories";
const TQString rcFollowSymLinks = "Follow symbolic links";
const TQString rcHaltOnFirstOccur = "Halt on first occurrence";
const TQString rcIgnoreHidden = "Ignore hidden files";
const TQString rcRecursive = "Search/replace in sub folders";
const TQString rcLimitDepth = "Limit search to sub folder level";
const TQString rcMaxDepth = "Max depth level value";
const TQString rcVariables = "Enable variables";
const TQString rcRegularExpressions = "Enable regular expressions";
const TQString rcMinFileSize = "Minimum file size";
const TQString rcMaxFileSize = "Maximum file size";
const TQString rcValidAccessDate = "Access mode";
const TQString rcMinDate = "Minimum access date";
const TQString rcMaxDate = "Maximum access date";
const TQString rcOwnerUser = "Owner user filters";
const TQString rcOwnerGroup = "Owner group filters";
const TQString rcSearchMode = "Search only mode";
const TQString rcBackupExtension = "Backup file extension";
const TQString rcIgnoreFiles = "Ignore files if there is no match";
const TQString rcNotifyOnErrors = "NotifyOnErrors";
const TQString rcAskConfirmReplace = "Ask confirmation on replace";
const TQString rcDontAskAgain = "Dont ask again";
// Default configuration options
const TQString EncodingOption = "utf8";
const bool RecursiveOption = true;
const bool CaseSensitiveOption = false;
const bool FollowSymbolicLinksOption = false;
const bool RegularExpressionsOption = false;
const bool VariablesOption = false;
const bool StopWhenFirstOccurenceOption = false;
const bool IgnoreHiddenOption = false;
const bool LimitDepthOption = false;
const int MaxDepthOption = 0;
const int FileSizeOption = -1;
const TQString AccessDateOption="unknown";
const TQString ValidAccessDateOption="unknown";
const TQString OwnerOption="false,Name,Equals To";
const bool SearchModeOption=true;
const TQString BackupExtensionOption="false,~";
const bool IgnoreFilesOption = true;
const bool NotifyOnErrorsOption = false;
const bool AskConfirmReplaceOption = false;

// This class store configuration informations
class RCOptions
{
  public:
    bool m_callResetActions;

    bool m_askConfirmReplace,
         m_dontAskAgain;

    TQStringList m_searchStrings;
    TQStringList m_replaceStrings;
    TQStringList m_directories;
    TQStringList m_filters;
    TQString m_currentDirectory;

    int m_minSize,
        m_maxSize;
        
    bool m_limitDepth;    
    int m_maxDepth;

    TQString m_dateAccess,
            m_minDate,
            m_maxDate;
            
    TQString m_encoding;

    bool m_caseSensitive,
         m_recursive,
         m_followSymLinks,
         m_allStringsMustBeFound,
         m_backup,
         m_regularExpressions;

    bool m_variables,
         m_haltOnFirstOccur,
         m_ignoreHidden,
         m_simulation,
         m_searchingOnlyMode;

    bool m_ownerUserIsChecked,
         m_ownerGroupIsChecked;

    TQString m_ownerUserType,
            m_ownerGroupType,
            m_ownerUserValue,
            m_ownerGroupValue,
            m_ownerUserBool,
            m_ownerGroupBool;

    TQString m_backupExtension;

    bool m_ignoreFiles;

    KeyValueMap m_mapStringsView;

    TQString m_quickSearchString,
            m_quickReplaceString;

    bool m_notifyOnErrors;

  public:
    RCOptions();
    RCOptions& operator=(const RCOptions& ci);
};

class ResultViewEntry
{
  private:
    TQString m_key;
    TQString m_data;
    TQRegExp m_rxKey;
    bool m_regexp;
    bool m_caseSensitive;
    int m_pos;
    int m_matchedStringsOccurrence;

  public:
    ResultViewEntry(TQString nkey, TQString ndata, bool regexp, bool caseSensitive);
    int lineNumber(const TQString& line) const ;
    int columnNumber(const TQString& line) const ;
    void incOccurrences();
    int occurrences() const ;
    bool regexp()const ;
    int pos(const TQString& line) ;
    void incPos();
    TQString capturedText(const TQString& line)  ;
    TQString message(const TQString& capturedText, int x, int y) const;
    int keyLength() const;
    int dataLength() const;
    void updateLine(TQString& line);
};
#endif
