/***************************************************************************
                          docking.h  -  description
                             -------------------
    begin                : Mon Jan 14 2002
    copyright            : (C) 2001, 2002 by Frank Schwanz, Ernst Martin Witte
    email                : schwanz@fh-brandenburg.de, witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_DOCKING_H
#define KRADIO_DOCKING_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ksystemtray.h>
#include <tqpixmap.h>
#include <tqptrdict.h>

#include "../../src/include/timecontrol_interfaces.h"
#include "../../src/include/radio_interfaces.h"
#include "../../src/include/radiodevicepool_interfaces.h"
#include "../../src/include/stationselection_interfaces.h"
#include "../../src/include/plugins.h"
#include "../../src/include/soundstreamclient_interfaces.h"

enum LeftClickAction { lcaShowHide = 0, lcaPowerOnOff = 1 };

class RadioDocking : public KSystemTray,
                     public PluginBase,
                     public IRadioClient,
                     public ITimeControlClient,
                     public IRadioDevicePoolClient,
                     public IStationSelection,
                     public ISoundStreamClient
{
TQ_OBJECT
  
public:
    RadioDocking (const TQString &name);
    virtual ~RadioDocking();

    virtual bool connectI (Interface *);
    virtual bool disconnectI (Interface *);

    virtual TQString pluginClassName() const { return "RadioDocking"; }

    virtual const TQString &name() const { return PluginBase::name(); }
    virtual       TQString &name()       { return PluginBase::name(); }


    // PluginBase

public:
    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();


    // IStationSelection

RECEIVERS:
    bool setStationSelection(const TQStringList &sl);

ANSWERS:
    const TQStringList & getStationSelection () const { return m_stationIDs; }


    // IRadioDevicePoolClient

RECEIVERS:
    bool noticeActiveDeviceChanged(IRadioDevice *)  { return false; }
    bool noticeDevicesChanged(const TQPtrList<IRadioDevice> &)  { return false; }
    bool noticeDeviceDescriptionChanged(const TQString &) { return false; }

    // ITimeControlClient

RECEIVERS:
    bool noticeAlarmsChanged(const AlarmVector &)   { return false; }
    bool noticeAlarm(const Alarm &)                 { return false; }
    bool noticeNextAlarmChanged(const Alarm *);
    bool noticeCountdownStarted(const TQDateTime &/*end*/);
    bool noticeCountdownStopped();
    bool noticeCountdownZero();
    bool noticeCountdownSecondsChanged(int n);


    // IRadioClient

RECEIVERS:
    bool noticePowerChanged(bool on);
    bool noticeStationChanged (const RadioStation &, int idx);
    bool noticeStationsChanged(const StationList &sl);
    bool noticePresetFileChanged(const TQString &/*f*/)           { return false; }

    bool noticeCurrentSoundStreamIDChanged(SoundStreamID /*id*/) { return false; }

    // ISoundStreamClient

RECEIVERS:
    void noticeConnectedI (ISoundStreamServer *s, bool pointer_valid);

    bool startRecordingWithFormat(SoundStreamID /*id*/,
                      const SoundFormat &/*proposed_format*/,
                      SoundFormat       &/*real_format*/);
    bool stopRecording(SoundStreamID /*id*/);

    bool noticeSoundStreamChanged(SoundStreamID id);


protected slots:

    void slotSeekFwd();
    void slotSeekBkwd();

    void slotPower();
    void slotPause();
    void slotSleepCountdown();
    void slotShowAbout();

    void slotMenuItemActivated(int id);
    void slotRecordingMenu(int i);

protected:
    void mousePressEvent( TQMouseEvent *e );

    void buildContextMenu();
    void buildRecordingMenu();
    void buildStationList();

    void noticeWidgetPluginShown(WidgetPluginBase *, bool shown);
    void noticePluginsChanged(const PluginList &);

    void showEvent(TQShowEvent *) {}  // do nothing, original implementation adds "Quit" menu item

    void ShowHideWidgetPlugins();

    void dragEnterEvent(TQDragEnterEvent* event);
    void dropEvent(TQDropEvent* event);

public:

    LeftClickAction getLeftClickAction() const { return m_leftClickAction; }
    void            setLeftClickAction(LeftClickAction action);

signals:
    void sigLeftClickActionChanged(LeftClickAction action);

protected:

    TDEPopupMenu  *m_menu;
    TDEPopupMenu  *m_pluginMenu;
    TDEPopupMenu  *m_recordingMenu;
    TQStringList  m_stationIDs;

    // menu Item IDs
    int             m_titleID;
    int             m_alarmID;
    int             m_recordingID;
    int             m_powerID;
    int             m_pauseID;
    int             m_sleepID;
    int             m_seekfwID;
    int             m_seekbwID;
    TQValueList<int> m_stationMenuIDs;

    TQMap<WidgetPluginBase *, int>  m_widgetPluginIDs;

    int                            m_NextRecordingMenuID;
    TQMap<int, SoundStreamID>       m_MenuID2StreamID;
    TQMap<SoundStreamID, int>       m_StreamID2MenuID;

    LeftClickAction                m_leftClickAction;

    TQMap<TQString, bool>            m_widgetsShownCache;
};


#endif
