/*
 *   This file is part of ScalixAdmin.
 *
 *   Copyright (C) 2007 Trolltech ASA. All rights reserved.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tdeconfig.h>
#include <tdeio/scheduler.h>
#include <kstringhandler.h>

#include "settings.h"

Settings* Settings::mSelf = 0;

Settings::Settings()
{
  mSlave = TDEIO::Scheduler::getConnectedSlave( accountUrl(),
                                              accountData() );
}

Settings::~Settings()
{
}

Settings* Settings::self()
{
  if ( !mSelf )
    mSelf = new Settings;

  return mSelf;
}

TDEIO::MetaData Settings::accountData() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "Account" );

  TDEIO::MetaData data;
  data.insert( "auth", group.readEntry( "auth" ) );
  data.insert( "tls", group.readBoolEntry( "use-tls" ) ? "on" : "off" );

  return data;
}

KURL Settings::accountUrl() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "Account" );

  KURL url;
  url.setProtocol( group.readBoolEntry( "use-ssl" ) ? "imaps" : "imap" );
  url.setUser( group.readEntry( "user" ) );
  url.setPass( KStringHandler::obscure( group.readEntry( "pass" ) ) );
  url.setHost( group.readEntry( "host" ) );
  url.setPort( group.readNumEntry( "port" ) );

  return url;
}

TQString Settings::accountPassword() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "Account" );

  return KStringHandler::obscure( group.readEntry( "pass" ) );
}

TDEIO::Slave* Settings::globalSlave() const
{
  return mSlave;
}

TQString Settings::rulesWizardUrl() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "Misc" );

  TQString url = group.readEntry( "rulesWizardUrl" );
  if ( url.isEmpty() ) {
    TDEConfigGroup group( &config, "Account" );
    url = TQString( "http://%1/Scalix/rw/?username=%2" ).arg( group.readEntry( "host" ) )
                                                       .arg( group.readEntry( "user" ) );
  }

  return url;
}

TQString Settings::ldapHost() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "LDAP" );
  return group.readEntry( "host" );
}

TQString Settings::ldapPort() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "LDAP" );
  return group.readEntry( "port" );
}

TQString Settings::ldapBase() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "LDAP" );
  return group.readEntry( "base" );
}

TQString Settings::ldapBindDn() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "LDAP" );
  return group.readEntry( "bindDn" );
}

TQString Settings::ldapPassword() const
{
  TDEConfig config( "scalixadminrc" );
  TDEConfigGroup group( &config, "LDAP" );
  return group.readEntry( "password" );
}

