 /*
    This file is part of tdepim.

    Copyright (c) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef API_BLOGGER_H
#define API_BLOGGER_H

#include "API_Blog.h"

#include <tqstring.h>
#include <tqvariant.h>
#include <tqvaluelist.h>

namespace KBlog {

class APIBlogger : public APIBlog
{
  public:
    APIBlogger( const KURL &server, TQObject *parent = 0L, const char *name = 0L ) : APIBlog( server, parent, name ) {}
    TQString getFunctionName( blogFunctions type );
    TQString interfaceName() const { return "Blogger API 1.0"; }


    TDEIO::Job *createUserInfoJob();
    TDEIO::Job *createListFoldersJob();
    TDEIO::TransferJob *createListItemsJob( const KURL &url );
    TDEIO::TransferJob *createDownloadJob( const KURL &url );
    TDEIO::TransferJob *createUploadJob( const KURL &url, KBlog::BlogPosting *posting );
    TDEIO::TransferJob *createUploadNewJob( KBlog::BlogPosting *posting );
    TDEIO::Job *createRemoveJob( const KURL &url, const TQString &postid );

    bool interpretUserInfoJob( TDEIO::Job *job );
    void interpretListFoldersJob( TDEIO::Job *job );
    bool interpretListItemsJob( TDEIO::Job *job );
    bool interpretDownloadItemsJob( TDEIO::Job *job );
  protected:
    bool readPostingFromMap( BlogPosting *post, const TQStringVariantMap &postInfo );
};

}
#endif
