/*
    This file is part of libkcal.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_TQTOPIAFORMAT_H
#define KCAL_TQTOPIAFORMAT_H

#include <tqstring.h>

#include "scheduler.h"

#include "libkcal_export.h"
#include "calformat.h"

namespace KCal {

/**
  This class implements the calendar format used by TQtopia.
*/
class LIBKCAL_EXPORT TQtopiaFormat : public CalFormat
{
  public:
    TQtopiaFormat();
    virtual ~TQtopiaFormat();

    bool load( Calendar *, const TQString &fileName );
    bool save( Calendar *, const TQString &fileName );

    bool fromString( Calendar *, const TQString & );  
    TQString toString( Calendar * );

  private:
    class Private;
    Private *d;
};

}

#endif
