/*
    This file is part of KAddressBook.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef IMAGEWIDGET_H
#define IMAGEWIDGET_H

#include <tqlabel.h>
#include <tqpushbutton.h>

#include <tdeabc/picture.h>
#include <kdialogbase.h>

#include "contacteditorwidget.h"

/**
  Small helper class
 */
class ImageLoader : public TQObject
{
  TQ_OBJECT
  

  public:
    ImageLoader( TQWidget *parent );

    TDEABC::Picture loadPicture( const KURL &url, bool *ok );

  private:
    TDEABC::Picture mPicture;
    TQWidget *mParent;
};

/**
  Small helper class
 */
class ImageButton : public TQPushButton
{
  TQ_OBJECT
  

  public:
    ImageButton( const TQString &title, TQWidget *parent );

    void setReadOnly( bool readOnly );

    void setPicture( const TDEABC::Picture &picture );
    TDEABC::Picture picture() const;

    void setImageLoader( ImageLoader *loader );

  signals:
    void changed();
    void urlDropped( const KURL& );

  protected:
    virtual void dragEnterEvent( TQDragEnterEvent *event );
    virtual void dropEvent( TQDropEvent *event );
    virtual void mouseMoveEvent( TQMouseEvent *event );
    virtual void mousePressEvent( TQMouseEvent *event );
    virtual void contextMenuEvent( TQContextMenuEvent *event );

  private slots:
    void load();
    void clear();

  private:
    void startDrag();
    void updateGUI();

    bool mReadOnly;
    TQPoint mDragStartPos;
    TDEABC::Picture mPicture;

    ImageLoader *mImageLoader;
};


class ImageBaseWidget : public TQWidget
{
  TQ_OBJECT
  

  public:
    ImageBaseWidget( const TQString &title, TQWidget *parent, const char *name = 0 );
    ~ImageBaseWidget();

    /**
      Sets the photo object.
     */
    void setImage( const TDEABC::Picture &photo );

    /**
      Returns a photo object.
     */
    TDEABC::Picture image() const;

    void setReadOnly( bool readOnly );

  signals:
    void changed();

  private:
    ImageButton *mImageButton;
    ImageLoader *mImageLoader;

    bool mReadOnly;
};

class ImageWidget : public KAB::ContactEditorWidget
{
  public:
    ImageWidget( TDEABC::AddressBook *ab, TQWidget *parent, const char *name = 0 );

    void loadContact( TDEABC::Addressee *addr );
    void storeContact( TDEABC::Addressee *addr );
    void setReadOnly( bool readOnly );

    int logicalWidth() const { return 2; }

  private:
    ImageBaseWidget *mPhotoWidget;
    ImageBaseWidget *mLogoWidget;
};

class ImageWidgetFactory : public KAB::ContactEditorWidgetFactory
{
  public:
    KAB::ContactEditorWidget *createWidget( TDEABC::AddressBook *ab, TQWidget *parent, const char *name )
    {
      return new ImageWidget( ab, parent, name );
    }

    TQString pageIdentifier() const { return "misc"; }
};

#endif
