#ifndef BITFONT_H
#define BITFONT_H

#include <tqstring.h>
#include <tqbitmap.h>
#include <tqpixmap.h>
#include <tqrect.h>

#include "colors.h"

class Bitfont
{
public:
    Bitfont(TQString fontname, uchar firstChar, uchar lastChar);

    TQPixmap text(TQString str, TQColor fg = BLACK, TQColor bg = TQColor());
    TQRect rect(TQString str);
    int width();
    int height();
    uchar firstChar();
    uchar lastChar();
private:
    TQBitmap font;
    int fontWidth;
    int fontHeight;
    uchar fontFirstChar;
    uchar fontLastChar;
};

#endif // BITFONT_H
