/*
   This file is part of the TDE games library
   Copyright (C) 2003 Nicolas Hadacek <hadacek@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _TDECONFIGRAWBACKEND_H
#define _TDECONFIGRAWBACKEND_H

#include <tqfile.h>

#include <tdeconfigbackend.h>
#include <tdesimpleconfig.h>


class TDEConfigRawBackEnd : public TDEConfigINIBackEnd
{
public:
    TDEConfigRawBackEnd(TDEConfigBase *_config, int fd);
    ~TDEConfigRawBackEnd();

    bool parseConfigFiles();

    void sync(bool bMerge = true);

private:
    int   _fd;
    FILE *_stream;
    TQFile _file;

    class TDEConfigRawBackEndPrivate;
    TDEConfigRawBackEndPrivate *d;
};

class KRawConfig : public TDESimpleConfig
{
    TQ_OBJECT
  
public:
    KRawConfig(int fd, bool readOnly)
        : TDESimpleConfig(new TDEConfigRawBackEnd(this, fd), readOnly) {}
};


#endif
