/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef __PokerWindow__
#define __PokerWindow__


#include <tdemainwindow.h>


class TQLabel;
class TDEToggleAction;
class kpok;


class PokerWindow : public TDEMainWindow
{
  TQ_OBJECT
  

  public:
    PokerWindow();
    ~PokerWindow();

  protected:
    virtual bool queryClose();
    bool  eventFilter(TQObject*, TQEvent*);
    void  initTDEAction();
    void  readOptions();

  protected slots:
    //     void saveProperties(TDEConfig*);
    //     void readProperties(TDEConfig*);
    void  setHand(const TQString &newHand, bool lastHand = true);
    void  showClickToHold(bool show);
    void  statusBarMessage(TQString);
    void  clearStatusBar();
    void  saveOptions();
    void  toggleMenubar();
    void  toggleStatusbar();

  private:
    kpok           *m_kpok;

    TDEToggleAction  *soundAction;
    TDEToggleAction  *blinkingAction;
    TDEToggleAction  *adjustAction;
    TDEToggleAction  *showMenubarAction;
    TDEToggleAction  *showStatusbarAction;

    // statusbar elements:
    TQLabel         *LHLabel;

    bool            clickToHoldIsShown;
};

#endif
