/*
 *
 *  PIN Dialog dialog for tdebluez authentication
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluezauth.
 *
 *  tdebluezauth is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluezauth is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "pindialog.h"
#include "pindefdialog.h"

PinDialog::PinDialog(const TQString &addr, const TQString &devName) :
        KDialogBase(NULL, "pinrequest", true, "Pin Request", (Ok | Cancel))
{

    pinDlg = new PinDefaultDialog(this);
    pinDlg->messageLabel->setText(pinDlg->messageLabel->text().arg(devName).arg(addr));

    pinDlg->pinEdit->setFocus();

    connect(this, TQ_SIGNAL(okClicked()), TQ_SLOT(setPin()));

    setMainWidget(pinDlg);
}

PinDialog::~PinDialog()
{
    delete pinDlg;
}

void PinDialog::setPin()
{
    pin = pinDlg->pinEdit->text();
}

const TQString PinDialog::getPin()
{
    return pin;
}

#include "pindialog.moc"
